/****************************************************
	Header file for class cScreen
	by
	Marek Biskup
	marbis@kki.net.pl
*****************************************************/

#if !defined(SCREEN_H)
#define SCREEN_H

#include <windows.h>
#include <ddraw.h>
#include <d3d.h>

class cScreen {
public:
	cScreen(void);
	~cScreen(void);

	int init(HWND hMainWindow,int w = 320, int h = 200, int d = 8);
	int SetMode(int newwidth, int newheight, int newbpp);

	void print(char* cz,int x, int y);
	void TextColor(int r, int g, int b);
	void Background(int r, int g, int b);
	void SetPalette(void* f);

	void clear(void);
	int Flip(void);
	void* GetPointer(void);
	int FreePointer(void);
	int Pitch(void);
	BOOL Restore(void);

private:
	int lPitch;
	int width;
	int height;
	int bpp;			// bits per pixel
	int FillColor;
	int textcolor;

	IDirectDraw            *dd;
	IDirectDrawSurface     *FrontBuffer;
	IDirectDrawSurface     *BackBuffer;
	IDirectDrawPalette     *Palette;

	HFONT      				  AppFont;
};



#endif




