/***************************************************************************
*	NAME:  PLAY3D.C
**	COPYRIGHT:
**	"Copyright (c) 1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 11/18/92
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	05/01/93		Original
***************************************************************************/


#include <string.h>
#include <math.h>
#include <alloc.h>

#include "forte.h"
#include "gf1proto.h"
#include "extern.h"
#include "ultraerr.h"

#include "threed.h"

#define BSIZE 1024
// #define POLHEMUS		/* Don't define this. Its for info only ... */
#define BASEPORT	0xf38		/* COM1 */

int enable_dummy = FALSE;
int enable_tracker = FALSE;
int enable_joy = FALSE;
int disable_distance= FALSE;

/* Joystick stuff */
int center_x=0;
int right_x=0;
int left_x=1000;
int center_z=0;
int fwrd_z=1000;
int back_z=0;

void
usage()
{
	printf("\nUsage: play3d [-t] [-j] [-d] filename\n");
	printf("            -t - Enable Polhemus tracker\n");
	printf("            -d - Enable dummy tracker\n");
	printf("            -j - Enable joystick tracking\n");
	printf("            -m - Disable distance for joystick\n");
}

void
main(argc,argv)
int argc;
char *argv[];
{
int i;
int 			key_char;
int				done;
ULTRA_CFG 		config;
SOUND_3D		sound_3d;
void far 		*buffer;
int val;
int new_xpos,new_zpos;
int last_x,last_z;
unsigned int temp_it;
char	filename[80];
int 	x_pos,z_pos,x_pos2,z_pos2,buttons;

for( i=1; i < argc; i++ )
	{
	if( argv[i][0] == '-' )
		{
		argv[i] = strupr( argv[i] );
	
		switch( argv[i][1] )
			{
			case 'T':	/* enable tracker */
				enable_tracker = TRUE;
				break;
			case 'J':	/* enable joystick */
				enable_joy = TRUE;
				break;
			case 'D':	/* enable dummy tracker */
				enable_dummy = TRUE;
				break;
			case 'M':
				disable_distance = TRUE;
				break;
			default:
				usage();
				printf("\nBad option (%s)\n",argv[i]);
				exit(98);
			}
		}
	}

if (argc < 2)
	{
	usage();
	printf("\nYou need to specify a file to play.\n");
	exit(-1);
	}

if (!enable_tracker && !enable_joy && !enable_dummy)
	{
	usage();
	printf("\nError: Must specify either -t, -d, or -j !!!\n\n");
	exit(99);
	}

strcpy(filename,argv[argc-1]);

/* Get the ULTRASND environment string parameters */
UltraGetCfg(&config);

if (UltraProbe(config.base_port) == NO_ULTRA)
	{
	printf("No card found\n");
	exit(-1);
	}

if (UltraOpen(&config,28) == NO_ULTRA)
	{
	printf("No card found\n");
	exit(-1);
	}

/* allocate memory in PC AND UltraSound */
buffer = malloc((unsigned int)BSIZE);
if (buffer == NULL)
	{
	printf("Unable to get PC memory\n");
	goto done;
	}

val = UltraLoad3dEffect(&sound_3d,filename,buffer,BSIZE);
if (val != ULTRA_OK)
	{
	printf("Couldn't load 3d sound file. Err code %d\n",val);
	goto failure;
	}

UltraEnableOutput();

done = FALSE;

if (enable_tracker)
	{
#ifdef POLHEMUS
	init_port(BASEPORT);	/* init COM1 */

	OutChar(BASEPORT,'B'); // boresight
	OutChar(BASEPORT,'1');
	OutChar(BASEPORT,13);

	sleep(1);

	OutChar(BASEPORT,'O');  //set  roll-pitch-yaw only
	OutChar(BASEPORT,'4');
	OutChar(BASEPORT,13);

	OutChar(BASEPORT,'f');
#endif
	}

if (enable_joy)
	{
	read_joystick(&x_pos,&z_pos,&x_pos2,&z_pos2,&buttons);
	last_x = left_x = right_x = center_x = x_pos;
	last_z = fwrd_z = back_z = center_z = z_pos;
	}

/* This would only be used to calibrate the joystick before going into */
/* loop */
#ifdef NEVER
if (enable_joy)
	{
	printf("Please calibrate joystick now.\n");
	printf("Center joystick and press [ENTER] .... ");
	key_char = getch();
	printf("\n");
	read_joystick(&x_pos,&z_pos,&x_pos2,&z_pos2,&buttons);
	center_x = x_pos;
	center_z = z_pos;
	printf("Now move joystick around in a circle a few times.\n");
	printf("Press any key to stop ...\n");
	while (!kbhit())
		{
		read_joystick(&x_pos,&z_pos,&x_pos2,&z_pos2,&buttons);
		printf("%3d %3d\r",x_pos,z_pos);
		if (x_pos < center_x )
			{
			if (x_pos < left_x)
				left_x = x_pos;
			}
		else
			{
			if (x_pos > right_x)
				right_x = x_pos;
			}
		if (z_pos < center_z )
			{
			if (z_pos < fwrd_z)
				fwrd_z = z_pos;
			}
		else
			{
			if (z_pos > back_z)
				back_z = z_pos;
			}
		}
	key_char = getch();		/* read the character */
	printf("\nleft = %d right = %d fwrd = %d back = %d\n",left_x,right_x,
				fwrd_z,back_z);
	}
#endif


UltraStart3d(&sound_3d);

while (!done)
	{
	if( fast_kbhit() )	/* Exit when a key is hit */
		{
		key_char = getch();		/* read the character */
		done = TRUE;
		break;
		}

	if (enable_tracker)
		{
#ifdef POLHEMUS
		OutChar(BASEPORT,'P');
		for(i=0;i<9;i++) 
			IsotrakBuffer[i] = InChar(BASEPORT);

		twochtoi.charsin[0] = IsotrakBuffer[3];
		twochtoi.charsin[1] = IsotrakBuffer[4];
		polYaw = (double) -twochtoi.intout/YAWDIV;
		//printf("%4d\r",(int) polYaw);
		azimuth -= polYaw;
#endif
		}

	if (enable_joy)
		{
		read_joystick(&x_pos,&z_pos,&x_pos2,&z_pos2,&buttons);
// printf("%03d %03d ",x_pos,z_pos);
		if (x_pos < center_x )
			{
			if (x_pos < left_x)
				left_x = x_pos;
			}
		else
			{
			if (x_pos > right_x)
				right_x = x_pos;
			}
		if (z_pos < center_z )
			{
			if (z_pos < fwrd_z)
				fwrd_z = z_pos;
			}
		else
			{
			if (z_pos > back_z)
				back_z = z_pos;
			}

		new_xpos = 0;
		new_zpos = 0;
		temp_it = abs((x_pos - center_x))<<8;
		if (x_pos > center_x)
			{
			new_xpos = temp_it/(right_x-center_x+1);
			}
		else
			{
			new_xpos = -1*(temp_it/(center_x-left_x+1));
			}
		temp_it = abs(z_pos - center_z)<<8;
		if (z_pos > center_z)
			{
			new_zpos = -1*(temp_it/(back_z-center_z+1));
			}
		else
			{
			new_zpos = temp_it/(center_z-fwrd_z+1);
			}

//		printf("%03d %03d       \r",new_xpos,new_zpos);

		if ((abs(new_xpos-last_x) > 3) || (abs(new_zpos-last_z) > 3))
			UltraAbsPosition3d(&sound_3d,new_xpos,0,new_zpos);
		last_x = new_xpos;
		last_z = new_zpos;

		if (!(buttons & 0x10))
			{
			UltraStart3d(&sound_3d);
			}
		}

	if (enable_dummy)
		{
/* Just loop sound around your head ... */
		for (new_xpos=-180;new_xpos<180;new_xpos+=1)
			{
			UltraAngPosition3d(&sound_3d,new_xpos,0,510);
			delay(100);
			if (fast_kbhit())
				{
				key_char = getch();
				done = TRUE;
				break;
				}
			}
		}
	}

/* Stop the sound */
UltraStop3d(&sound_3d,FALSE);

/* Free up resources */
UltraUnLoad3dEffect(&sound_3d);

failure:
	free(buffer);

done:
	/* Shut sound down & re-init hardware ... */
	UltraClose();

}

