title ASMUTILS.ASM 
;=========================================================================;
;MICROSOFT (V3,V4) COMPILER MODELS:
;	Tiny:		LPROG = 0, LDATA = 0
;	Small:		LPROG = 0, LDATA = 0
;	Medium: 	LPROG = 1, LDATA = 0
;	Compact:	LPROG = 0, LDATA = 1
;	Large:		LPROG = 1, LDATA = 1
;	Huge:		LPROG = 1, LDATA = 1
;=========================================================================;
; LARGE model
IFDEF MSIZE0
LPROG	 equ	1	; = 1 for Long (FAR) programs
LDATA	 equ	1	; = 1 for Long (FAR) data
endif

;Medium model
IFDEF MSIZE1
LPROG	 equ	1	; = 1 for Long (FAR) programs
LDATA	 equ	0	; = 1 for Near data
endif

;Small model
IFDEF MSIZE2
LPROG	 equ	0	; = 1 for Near programs
LDATA	 equ	0	; = 1 for Near data
endif

;Tiny model
IFDEF MSIZE3
LPROG	 equ	0	; = 1 for Near programs
LDATA	 equ	0	; = 1 for Near data
endif

if	(LPROG EQ 0)
ADDOFF	equ		0
endif
if	(LPROG EQ 1)
ADDOFF	equ		2
endif
;
;=========================================================================;
;
;	Alter the above equate values according to your compiler/model
;		requirements, and re-assemble it with
;
;		masm gf1asms
;
;	(The following code is required because of unique group and segment
;	 requirements of each compiler and model.)

_text	segment WORD	public	'code'  ; Microsoft (all models)
assume	cs:_text,ds:_text

;
	public  _UltraPeekData,_UltraPokeData
;
;****************************************************************
; UltraPeekData and UltraPokeData were done in assembler only for speed
; purposes.
;****************************************************************
;
;	Routine to peek a byte from ultra dram
;
;	unsigned char
;	UltraPeekData(port,address)
;	int port;		base port for card
;	long address;	dram location to look at ... 
;
; Equivalent 'C' Code:
;
;unsigned char
;UltraPeekData(port,address)
;int port;
;unsigned long address;
;{
; outportb(port+GF1_REG_SELECT,SET_DRAM_LOW);
; outport (port+GF1_DATA_LOW,LSW(address));	/* 16 bits */
; outportb(port+GF1_REG_SELECT,SET_DRAM_HIGH);
; outportb(port+GF1_DATA_HI,LSB(MSW(address)));	/* 8 bits */
; return(inportb(port+GF1_DRAM));
;}
;
;
;*************************************************************
if	(LPROG EQ 0)
_UltraPeekData proc	near
endif
if	(LPROG EQ 1)
_UltraPeekData proc	far
endif
	push	bp
	mov	bp,sp

	pushf
	cli

	mov	dx,[bp+4+ADDOFF]	; get port
	add dx,102H		; point to dram port

	inc	dx			; point to register select
	mov	al,043H
	out dx,al		; point to dram low register
	inc dx			; point to data low
	mov	ax,[bp+6+ADDOFF]	; get lsw part of addr
	out	dx,ax		; send low part of address

	dec	dx			; back to register select
	mov	al,044H
	out	dx,al		; point to dram high register
	inc dx
	inc dx			; point to data high register
	mov	ax,[bp+8+ADDOFF]	; get msw part of addr 
	out	dx,al		; send low byte off address
	
	inc dx
	inc dx			; point to dram data

	in	al,dx		; read data

	popf

	mov	sp,bp
	pop	bp
	ret
_UltraPeekData endp

;************************************************************
;
;	Routine to poke a byte into ultra dram
;
;	void
;	UltraPokeData(port,address,data)
;	int port;	 		base port for card
;	long address;	 	dram location to write to ... 
;	unsigned char data;	byte to write
;
;void
;UltraPokeData(port,address,data)
;int port;
;long address;
;unsigned char data;
;{
; outportb(port+GF1_REG_SELECT,SET_DRAM_LOW);
; outport (port+GF1_DATA_LOW,LSW(address));	/* 16 bits */
; outportb(port+GF1_REG_SELECT,SET_DRAM_HIGH);
; outportb(port+GF1_DATA_HI,LSB(MSW(address)));	/* 8 bits */
; outportb(port+GF1_DRAM,data);
;}
;
;*************************************************************
if	(LPROG EQ 0)
_UltraPokeData proc	near
endif
if	(LPROG EQ 1)
_UltraPokeData proc	far
endif
	push	bp
	mov	bp,sp

	pushf
	cli

	mov	dx,[bp+4+ADDOFF]	; get port
	add dx,102H		; point to dram port

	mov	cx,[bp+6+ADDOFF]	; get lsw part of addr
	mov	bx,[bp+8+ADDOFF]	; get msw part of addr 

	inc	dx			; point to register select
	mov	al,043H
	out dx,al		; point to dram low register
	inc dx			; point to data low
	mov	ax,cx
	out	dx,ax		; send low part of address

	dec	dx			; bak to register select
	mov	al,044H
	out	dx,al		; point to dram high register
	inc dx
	inc dx			; point to data high register
	mov	al,bl
	out	dx,al		; send low byte off address
	
	inc dx
	inc dx			; point to dram data

	mov	ax,[bp+10+ADDOFF]	; Get value to send
	out	dx,al		; write value

	popf

	mov	sp,bp
	pop	bp
	ret
_UltraPokeData endp

_text	ends
	END

