/***************************************************************************
*	NAME:  MEMINIT.C
**	COPYRIGHT:
**	"Copyright (c) 1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 11/18/92
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	11/18/92		Original
***************************************************************************/
#include "forte.h"
#include "gf1proto.h"
#include "osproto.h"
#include "gf1hware.h"
#include "gf1os.h"
#include "ultraerr.h"

extern ULTRA_DATA _gf1_data;

unsigned long _ultra_free_mem;

#define POOL_SIZE (unsigned long)((256L*1024L)-32L)

unsigned long _ultra_reserved_dram=32L;

void
UltraPokeLong(location,value)
unsigned long location;
unsigned long value;
{
unsigned char *ptr;
unsigned int port;
int i;

port = _gf1_data.base_port;

ptr = (unsigned char *)&value;

for (i=0;i<4;i++)
	UltraPokeData(port,location++,*ptr++);
}

unsigned long
UltraPeekLong(location)
unsigned long location;
{
unsigned long ret;
unsigned char *ptr;
unsigned int port;
int i;

port = _gf1_data.base_port;

ptr = (unsigned char *)&ret;

for (i=0;i<4;i++)
	*ptr++ = UltraPeekData(port,location++);

return(ret);
}

int
UltraMemInit()
{
unsigned long pool_len;
unsigned long location;
int size;

if (_ultra_reserved_dram > (unsigned long)(256L*1024L))
	_ultra_reserved_dram = 32;

/* size of DRAM in bytes ... */
size = UltraSizeDram();

pool_len = (((unsigned long)size*1024L)-32L)-_ultra_reserved_dram;

_ultra_free_mem = _ultra_reserved_dram;

UltraPokeLong(_ultra_reserved_dram+NEXT_OFFSET,0L);
UltraPokeLong(_ultra_reserved_dram+PREV_OFFSET,0L);
UltraPokeLong(_ultra_reserved_dram+SIZE_OFFSET,pool_len);

/* This section is necessary to split the DRAM into pools that */
/* do not cross 256K boundaries. the GF1 cannot play 16 bit data */
/* across 256K boundaries */

if (pool_len > (unsigned long)(256L*1024L))
	{
	UltraMemAlloc(pool_len,&location);
	if (pool_len > (unsigned long)(256L*3L*1024L))
		{
		UltraMemFree(POOL_SIZE,(unsigned long)(256L*3L*1024L)+32L);
		}
	if (pool_len > (unsigned long)(256L*2L*1024L))
		{
		UltraMemFree(POOL_SIZE,(unsigned long)(256L*2L*1024L)+32L);
		}
	UltraMemFree(POOL_SIZE,(unsigned long)(256L*1L*1024L)+32L);
	UltraMemFree((unsigned long)(256L*1024L)-_ultra_reserved_dram,_ultra_reserved_dram);
	}
return(size);
}

