
/***************************************************************************
*	NAME:  MIDI.C
**	COPYRIGHT:
**	"Copyright (c) 1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 11/18/92
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	11/18/92		Original
***************************************************************************/

#include <dos.h>

#include "forte.h"
#include "gf1proto.h"
#include "osproto.h"
#include "gf1hware.h"
#include "gf1os.h"

extern ULTRA_DATA _gf1_data;

unsigned char image_midi = 0;

void
UltraMidiXmit(data)
unsigned char data;
{
outportb(_gf1_data.midi_data,data);
}

unsigned char
UltraMidiRecv()
{
return(inportb(_gf1_data.midi_data));
}

unsigned char
UltraMidiStatus()
{
return(inportb(_gf1_data.midi_control));
}

void
UltraMidiEnableRecv()
{
image_midi |= MIDI_ENABLE_XMIT;
outportb(_gf1_data.midi_control,image_midi);
}

void
UltraMidiEnableXmit()
{
image_midi |= MIDI_ENABLE_RCV;
outportb(_gf1_data.midi_control,image_midi);
}

void
UltraMidiDisableRecv()
{
image_midi &= ~MIDI_ENABLE_XMIT;
outportb(_gf1_data.midi_control,image_midi);
}

void
UltraMidiDisableXmit()
{
image_midi &= ~MIDI_ENABLE_RCV;
outportb(_gf1_data.midi_control,image_midi);
}

void
UltraMidiReset()
{
image_midi = 0;
outportb(_gf1_data.midi_control,MIDI_RESET);
gf1_delay();
outportb(_gf1_data.midi_control,0x00);
}

