#include <dos.h>

#include "forte.h"
#include "gf1proto.h"
#include "gf1hware.h"

unsigned char
UltraPeekData (port, address)
unsigned int port;
unsigned long address;
{
    unsigned char	ret;

    PUSH_IRQ_STATE ();

    outportb(port+GF1_REG_SELECT,SET_DRAM_LOW);
    outportw(port+GF1_DATA_LOW,LSW(address));	/* 16 bits */
    outportb(port+GF1_REG_SELECT,SET_DRAM_HIGH);
    outportb(port+GF1_DATA_HI,LSB(MSW(address)));	/* 8 bits */
    ret = inportb(port+GF1_DRAM);

    POP_IRQ_STATE ();
    return (ret);
}

void
UltraPokeData (port, address, data)
unsigned int port;
unsigned long address;
unsigned char data;
{
    PUSH_IRQ_STATE ();

    outportb(port+GF1_REG_SELECT,SET_DRAM_LOW);
    outportw(port+GF1_DATA_LOW,LSW(address));	/* 16 bits */
    outportb(port+GF1_REG_SELECT,SET_DRAM_HIGH);
    outportb(port+GF1_DATA_HI,LSB(MSW(address)));	/* 8 bits */
    outportb(port+GF1_DRAM,data);

    POP_IRQ_STATE ();
}
