/***************************************************************************
*	NAME:  RESET.C
**	COPYRIGHT:
**	"Copyright (c) 1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 11/18/92
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	11/18/92		Original
***************************************************************************/
#include <dos.h>

#include "forte.h"
#include "gf1proto.h"
#include "osproto.h"
#include "gf1hware.h"
#include "gf1os.h"

#include "ultraerr.h"

extern ULTRA_DATA _gf1_data;

/***************************************************************
 * This function performs a full reset & initialization on the 
 * UltraSound card.
 ***************************************************************/
int
UltraReset(voices)
int voices;
{
register int	v;
register int select,data_low,data_hi;

if ((voices < 14) || (voices > 32))
	return(BAD_NUM_OF_VOICES);

_gf1_data.voices = voices;
_gf1_data.timer_ctrl = 0;
_gf1_data.timer_mask = 0;

select = _gf1_data.reg_select;
data_low = _gf1_data.data_low;
data_hi = _gf1_data.data_hi;

/* Set these to zero so the they don't get summed in for voices that are */
/* not running. If their volumes are not at zero, whatever value they */
/* are pointing at, will get summed into the output. By setting that */
/* location to 0, that voice will have no contribution to the output */
/* (2 locations are done in case voice is set to 16 bits ... ) */
UltraPokeData(_gf1_data.base_port,0L,0);
UltraPokeData(_gf1_data.base_port,1L,0);

PUSH_IRQ_STATE ();

/* Pull a reset on the GF1 */
	outportb(select,MASTER_RESET);
	outportb(data_hi,0x00);

/* Wait a little while ... */
	for (v=0;v<10;v++)
		gf1_delay();

/* Release Reset */
	outportb(select,MASTER_RESET);
	outportb(data_hi,GF1_MASTER_RESET);

/* Wait a little while ... */
	for (v=0;v<10;v++)
		gf1_delay();

/* Reset the MIDI port also */
	outportb(_gf1_data.midi_control,MIDI_RESET);
	for (v=0;v<10;v++)
		gf1_delay();
	outportb(_gf1_data.midi_control,0x00);

/* Clear all interrupts. */
	outportb(select,DMA_CONTROL);
	outportb(data_hi,0x00);
	outportb(select,TIMER_CONTROL);
	outportb(data_hi,0x00);
	outportb(select,SAMPLE_CONTROL);
	outportb(data_hi,0x00);

/* Set the number of active voices */
	outportb(select,SET_VOICES);	
	outportb(data_hi,(char)((voices-1) | 0xC0));

/* Clear interrupts on voices. */
/* Reading the status ports will clear the irqs. */
	(void)inportb (_gf1_data.irq_status);	
	outportb(select,DMA_CONTROL);
	(void)inportb (data_hi);
	outportb(select,SAMPLE_CONTROL);
	(void)inportb (data_hi);
	outportb(select,GET_IRQV);
	(void)inportb (data_hi);
	
	for (v=0;v<voices;v++)
		{
		/* Select the proper voice */
		outportb(_gf1_data.voice_select,v);

		/* Stop the voice and volume */
		outportb(select,SET_CONTROL);
		outportb(data_hi,VOICE_STOPPED|STOP_VOICE);
		outportb(select,SET_VOLUME_CONTROL);
		outportb(data_hi,VOLUME_STOPPED|STOP_VOLUME);
		
		gf1_delay( ); /* Wait 4.8 micos. or more. */

		/* Initialize each voice specific registers. This is not */
		/* really necessary, but is nice for completeness sake .. */
		/* Each application will set up these to whatever values */
		/* it needs. */
		outportb(select,SET_FREQUENCY);
		outportw(data_low,0x0400);
		outportb(select,SET_START_HIGH);
		outportw(data_low,0);
		outportb(select,SET_START_LOW);
 		outportw(data_low,0);
		outportb(select,SET_END_HIGH);
		outportw(data_low,0);
		outportb(select,SET_END_LOW);
		outportw(data_low,0);
		outportb(select,SET_VOLUME_RATE);
		outportb(data_hi,0x01);
		outportb(select,SET_VOLUME_START);
		outportb(data_hi,0x10);
		outportb(select,SET_VOLUME_END);
		outportb(data_hi,0xe0);
		outportb(select,SET_VOLUME);
		outportw(data_low,0x0000);

		outportb(select,SET_ACC_HIGH);
		outportw(data_low,0);
		outportb(select,SET_ACC_LOW);
		outportw(data_low,0);
		outportb(select,SET_BALANCE);
		outportb(data_hi,0x07);
		}

	(void)inportb (_gf1_data.irq_status);	
	outportb(select,DMA_CONTROL);
	(void)inportb (data_hi);
	outportb(select,SAMPLE_CONTROL);
	(void)inportb (data_hi);
	outportb(select,GET_IRQV);
	(void)inportb (data_hi);
	
	/* Set up GF1 Chip for interrupts & enable DACs. */
	outportb(select,MASTER_RESET);
	outportb(data_hi,GF1_MASTER_RESET|GF1_OUTPUT_ENABLE|GF1_MASTER_IRQ);

POP_IRQ_STATE ();

return(ULTRA_OK);
}


