/***************************************************************************
*	NAME:  SAMPLE.C
**	COPYRIGHT:
**	"Copyright (c) 1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 11/18/92
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	11/18/92		Original
***************************************************************************/

#include <stdio.h>
#include <dos.h>

#include "forte.h"
#include "gf1proto.h"
#include "osproto.h"
#include "gf1hware.h"
#include "gf1os.h"
#include "ultraerr.h"
#include "dma.h"	/* Hardware defs for PC's dma controllers */

extern DMA_ENTRY _gf1_dma[]; /* Structure that holds data on PC's dma chan */
extern ULTRA_DATA _gf1_data;

int
UltraRecordDmaBusy()
{
return(_gf1_dma[_gf1_data.adc_dma_chan-1].flags & DMA_PENDING);
}

void
UltraWaitRecordDma()
{
	_gf1_data.flags &= ~ADC_DMA_NOWAIT;

	PUSH_IRQ_STATE ();

	while (_gf1_data.flags & ADC_DMA_BUSY)	/* wait for irq to clear this */
		{
		}

	POP_IRQ_STATE ();
}

void
UltraSetRecordFrequency(rate)
unsigned long rate;
{
unsigned char adsr;

		/* First calculate as if its for a record */
		/* Use the formula:
			rate = CLOCK_RATE / (16*(ADRS+2))
		*/
		adsr = ((CLOCK_RATE>>4)/rate)-2;

PUSH_IRQ_STATE ();

		outportb(_gf1_data.reg_select,SET_SAMPLE_RATE);
		outportb(_gf1_data.data_hi,(unsigned char)adsr);
POP_IRQ_STATE ();

}

int
UltraPrimeRecord(pc_ptr,size,repeat)
void far *pc_ptr;
unsigned int size;
int repeat;
{
int mode;

if (repeat)
	mode = INDEF_READ;
else
	mode = READ_DMA;

/* Make sure the channel is not busy (recording or playback ... )*/
return(PrimeDma(pc_ptr,mode,size,_gf1_data.adc_dma_chan));
}

int
UltraGoRecord(control)
unsigned char control;
{
DMA_ENTRY *tdma;

tdma  = &_gf1_dma[_gf1_data.adc_dma_chan-1];		/* point to this dma data */

/* Set flag that irq handler clears when the xfer is complete */
_gf1_data.flags |= ADC_DMA_BUSY;

/* Now tell GF1 to start xfer ... */
tdma->cur_control = control;

UltraStartRecordDma(control);

return(ULTRA_OK);
}

int
UltraRecordData(pc_ptr,control,size,wait,repeat)
void far *pc_ptr;
unsigned char control;
unsigned int size;
int wait;
int repeat;
{
int ret;

if ((ret=UltraPrimeRecord(pc_ptr,size,repeat)) != ULTRA_OK)
	return(ret);

UltraGoRecord(control);

/* if required, wait till dma is done ... */
if (wait)
	UltraWaitRecordDma();
else
	_gf1_data.flags |= ADC_DMA_NOWAIT;

return(ULTRA_OK);
}

static unsigned int
GetRecordDmaPos()
{
DMA_ENTRY *tdma;
unsigned int val1,val2;
unsigned int low1,low2;
unsigned int high1,high2;

	tdma  = &_gf1_dma[_gf1_data.adc_dma_chan-1]; /* point to this dma data */

	PUSH_IRQ_STATE ();

	while (TRUE)
		{
		outportb(tdma->clear_ff,0);						/* clear f/f */
		low1  = (unsigned int)inportb( tdma->count );
		high1 = (unsigned int)inportb( tdma->count );

		outportb(tdma->clear_ff,0);						/* clear f/f */
		low2  = (unsigned int)inportb( tdma->count );
		high2 = (unsigned int)inportb( tdma->count );

		val1 = (high1<<8) + low1;
		val2 = (high2<<8) + low2;

		if( val1 < val2 )
			val1 = val2 - val1;
		else
			val1 = val1 - val2;
		if( val1 < 10 )
			break;
		}

	POP_IRQ_STATE ();

	return(val2);
}

unsigned int
UltraReadRecordPosition()
{
DMA_ENTRY *tdma;
unsigned int actual_dma;
unsigned int this_size;
unsigned int total_size;

	tdma  = &_gf1_dma[_gf1_data.adc_dma_chan-1]; /* point to this dma data */

	actual_dma = GetRecordDmaPos();

	/* Since it counts backwards, subtract this from size of transfer */
	this_size = tdma->cur_size - actual_dma;

	/* Now add in the amount sent (in case it crosses page) */
	total_size = tdma->amnt_sent + this_size;

	if ( _gf1_data.adc_dma_chan >= 4)
		total_size <<= 1;

return(total_size);
}

