/***************************************************************************
*	NAME:  SIZE.C
**	COPYRIGHT:
**	"Copyright (c) 1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 11/18/92
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	11/18/92		Original
***************************************************************************/
#include <dos.h>

#include "forte.h"
#include "gf1proto.h"
#include "gf1hware.h"
#include "gf1os.h"

extern ULTRA_DATA _gf1_data;

/***************************************************************
 * This function returns the # of K found on the card
 ***************************************************************/
int
UltraSizeDram()
{
unsigned long i;
unsigned long loc;
unsigned char val;
unsigned char save0;
unsigned char save1;

unsigned int base_port;

	base_port = _gf1_data.base_port;

	/* save first location ... */
	save0 = UltraPeekData(base_port,0L);

	/* See if there is first block there.... */
	UltraPokeData(base_port,0L,(unsigned char)0xaa);
	if (UltraPeekData(base_port,0L) != (unsigned char)0xaa)
		return(0);

	/* Now zero it out so that I can check for mirroring .. */
	UltraPokeData(base_port,0L,(unsigned char)0x00);

	for (i=1L;i<1024L;i++)
		{
		/* check for mirroring ... */
		val = UltraPeekData(base_port,0L);
		if (val != 0)
			break;
		loc = i<<10;

		/* save location so its a non-destructive sizing */
		save1 = UltraPeekData(base_port,loc);

		UltraPokeData(base_port,loc,(unsigned char)0xaa);
		if (UltraPeekData(base_port,loc) != (unsigned char)0xaa)
			break;
		UltraPokeData(base_port,loc,save1);
		}

/* Now restore location zero ... */
UltraPokeData(base_port,0L,save0);

return((int)i);
}

