/***************************************************************************
*	NAME:  TIMER.C
**	COPYRIGHT:
**	"Copyright (c) 1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 11/18/92
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	11/18/92		Original
***************************************************************************/

#include <dos.h>

#include "forte.h"
#include "gf1proto.h"
#include "osproto.h"
#include "gf1hware.h"
#include "gf1os.h"

extern ULTRA_DATA _gf1_data;

void
UltraStartTimer(timer,time)
int timer;
unsigned char time;
{
unsigned char temp;

	if (timer == 1)
		{
		_gf1_data.timer_ctrl |= 0x04;
		_gf1_data.timer_mask |= 0x01;
		temp = TIMER1;
		}
	else
		{
		_gf1_data.timer_ctrl |= 0x08;
		_gf1_data.timer_mask |= 0x02;
		temp = TIMER2;
		}

	PUSH_IRQ_STATE ();

	time = 256 - time;
	outportb(_gf1_data.reg_select,temp);
	outportb(_gf1_data.data_hi,time);


	outportb( _gf1_data.reg_select, TIMER_CONTROL );
	outportb( _gf1_data.data_hi, _gf1_data.timer_ctrl );

	/* is this necessary ??? */
	outportb( _gf1_data.timer_control, 0x04 );		
	outportb( _gf1_data.timer_data, _gf1_data.timer_mask );		

	POP_IRQ_STATE ();
}

void
UltraStopTimer(timer)
int timer;
{

	if (timer == 1)
		{
		_gf1_data.timer_ctrl &= ~0x04;
		_gf1_data.timer_mask &= ~0x01;
		}
	else
		{
		_gf1_data.timer_ctrl &= ~0x08;
		_gf1_data.timer_mask &= ~0x02;
		}

	PUSH_IRQ_STATE ();

	outportb( _gf1_data.reg_select, TIMER_CONTROL );
	outportb( _gf1_data.data_hi, _gf1_data.timer_ctrl);

	outportb( _gf1_data.timer_control, 0x04 );		
	outportb( _gf1_data.timer_data, _gf1_data.timer_mask  | 0x80 );		

	POP_IRQ_STATE ();
}

int
UltraTimerStopped(timer)
int timer;
{
unsigned char value;
unsigned char temp;

	if (timer == 1)
		temp = 0x40;
	else
		temp = 0x20;

	value = (inportb(_gf1_data.timer_control)) & temp;

	return(value);
}


