/***************************************************************************
*	NAME:  VOCEND.C
**	COPYRIGHT:
**	"Copyright (c) 1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 11/18/92
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	11/18/92		Original
***************************************************************************/

#include <dos.h>

#include "forte.h"
#include "gf1proto.h"
#include "osproto.h"
#include "gf1hware.h"
#include "gf1os.h"

extern ULTRA_DATA _gf1_data;

void
UltraSetVoiceEnd(voice,end)
int voice;					/* voice to start */
unsigned long end;			/* end location in ultra DRAM */
{
unsigned long phys_end;
unsigned char data;

	PUSH_IRQ_STATE ();

	outportb(_gf1_data.voice_select,voice);

	outportb(_gf1_data.reg_select,GET_CONTROL);
	data = inportb(_gf1_data.data_hi);

	if (data & VC_DATA_TYPE)
		{
		phys_end   = convert_to_16bit(end);
		}
	else
		{
		phys_end = end;
		}

	/* Make sure was are talking to proper voice */
	outportb(_gf1_data.voice_select,voice);

	/* Set end address of buffer */
	outportb(_gf1_data.reg_select,SET_END_HIGH);
	outportw(_gf1_data.data_low,ADDR_HIGH(phys_end));
	outportb(_gf1_data.reg_select,SET_END_LOW);
	outportw(_gf1_data.data_low,ADDR_LOW(phys_end));
	
	data &= ~(VOICE_STOPPED|STOP_VOICE);/* turn 'stop' bits off (prob are) */

	outportb(_gf1_data.reg_select,SET_CONTROL);
	outportb(_gf1_data.data_hi,data);
	gf1_delay();
	outportb(_gf1_data.reg_select,SET_CONTROL);
	outportb(_gf1_data.data_hi,data);

	POP_IRQ_STATE ();
}

