/***************************************************************************
*	NAME:  VOCFREQ.C
**	COPYRIGHT:
**	"Copyright (c) 1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 11/18/92
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	11/18/92		Original
***************************************************************************/

#include <dos.h>

#include "forte.h"
#include "gf1proto.h"
#include "osproto.h"
#include "gf1hware.h"
#include "gf1os.h"

extern ULTRA_DATA _gf1_data;

/* The formula for this table is:
	1,000,000 / (1.619695497 * # of active voices)

	The 1.619695497 is calculated by knowing that 14 voices
		gives exactly 44.1 Khz. Therefore, 
		1,000,000 / (X * 14) = 44100
		X = 1.619695497
*/

static unsigned int freq_divisor[19] = {
	44100,		/* 14 active voices */
	41160,		/* 15 active voices */
	38587,		/* 16 active voices */
	36317,		/* 17 active voices */
	34300,		/* 18 active voices */
	32494,		/* 19 active voices */
	30870,		/* 20 active voices */
	29400,		/* 21 active voices */
	28063,		/* 22 active voices */
	26843,		/* 23 active voices */
	25725,		/* 24 active voices */
	24696,		/* 25 active voices */
	23746,		/* 26 active voices */
	22866,		/* 27 active voices */
	22050,		/* 28 active voices */
	21289,		/* 29 active voices */
	20580,		/* 30 active voices */
	19916,		/* 31 active voices */
	19293}		/* 32 active voices */
;

void	
UltraSetFrequency(voice,speed_khz)
int voice;
unsigned long speed_khz;
{
unsigned int fc;
unsigned long temp;

	/* FC is calculated based on the # of active voices ... */
	temp = (unsigned long)freq_divisor[_gf1_data.voices-14];

	fc = (unsigned int)(((speed_khz<<9L)+(temp>>1L))/temp);
	fc = fc << 1;

	PUSH_IRQ_STATE ();

	outportb(_gf1_data.voice_select,voice);
	outportb(_gf1_data.reg_select,SET_FREQUENCY);
	outportw(_gf1_data.data_low,fc);

	POP_IRQ_STATE ();
}

