/***************************************************************************
*	NAME:  VOCLOOP.C
**	COPYRIGHT:
**	"Copyright (c) 1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 11/18/92
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	11/18/92		Original
***************************************************************************/

#include <dos.h>

#include "forte.h"
#include "gf1proto.h"
#include "osproto.h"
#include "gf1hware.h"
#include "gf1os.h"

extern ULTRA_DATA _gf1_data;

void
UltraSetLoopMode(voice,mode)
int voice;
unsigned char mode;
{
unsigned char data;

	PUSH_IRQ_STATE ();

	outportb(_gf1_data.voice_select,voice);

	outportb(_gf1_data.reg_select,GET_CONTROL);
	data = inportb(_gf1_data.data_hi);

	data &= ~(VC_BI_LOOP|VC_LOOP_ENABLE);	/* isolate the loop bits */
	mode &= VC_BI_LOOP|VC_LOOP_ENABLE;	/* make sure no bad bits passed in */
	data |= mode;		/* turn on proper bits ... */

	outportb(_gf1_data.reg_select,SET_CONTROL);
	outportb(_gf1_data.data_hi,data);
	gf1_delay();
	outportb(_gf1_data.reg_select,SET_CONTROL);
	outportb(_gf1_data.data_hi,data);

	POP_IRQ_STATE ();
}

