/***************************************************************************
*	NAME:  VOCSET.C
**	COPYRIGHT:
**	"Copyright (c) 1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 11/18/92
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	11/18/92		Original
***************************************************************************/

#include <dos.h>

#include "forte.h"
#include "gf1proto.h"
#include "osproto.h"
#include "gf1hware.h"
#include "gf1os.h"

extern ULTRA_DATA _gf1_data;

void
UltraSetVoice(voice,location)
int voice;					/* voice to start */
unsigned long location;		/* start location in ultra DRAM */
{
unsigned long phys_loc;
unsigned char data;

	PUSH_IRQ_STATE ();

	/* Make sure was are talking to proper voice */
	outportb(_gf1_data.voice_select,voice);

	outportb(_gf1_data.reg_select,GET_CONTROL);
	data = inportb(_gf1_data.data_hi);

	if (data & VC_DATA_TYPE)
		{
		phys_loc   = convert_to_16bit(location);
		}
	else
		{
		phys_loc = location;
		}

	/* First set accumulator to beginning of data */
	outportb(_gf1_data.reg_select,SET_ACC_HIGH);
	outportw(_gf1_data.data_low,ADDR_HIGH(phys_loc));
	outportb(_gf1_data.reg_select,SET_ACC_LOW);
	outportw(_gf1_data.data_low,ADDR_LOW(phys_loc));

	POP_IRQ_STATE ();
}

