/***************************************************************************
*	NAME:  VOCSTOP.C
**	COPYRIGHT:
**	"Copyright (c) 1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 11/18/92
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	11/18/92		Original
***************************************************************************/

#include <dos.h>

#include "forte.h"
#include "gf1proto.h"
#include "osproto.h"
#include "gf1hware.h"
#include "gf1os.h"

extern ULTRA_DATA _gf1_data;

/***************************************************************
 * This function will stop a given voices output. Note that a delay
 * is necessary after the stop is issued to ensure the self-
 * modifying bits aren't a problem.
 ***************************************************************/

void
UltraStopVoice(voice)
int voice;
{
unsigned char data;

PUSH_IRQ_STATE ();

outportb(_gf1_data.voice_select,voice);	/* select the proper voice */
outportb(_gf1_data.reg_select,GET_CONTROL);
data = inportb (_gf1_data.data_hi);

data &= ~VC_WAVE_IRQ;		/* disable irq's & stop voice .. */
data |= VOICE_STOPPED|STOP_VOICE;

outportb(_gf1_data.reg_select,SET_CONTROL);
outportb(_gf1_data.data_hi,data);			/* turn it off */

gf1_delay();

outportb(_gf1_data.reg_select,SET_CONTROL);
outportb(_gf1_data.data_hi,data);			/* turn it off */

POP_IRQ_STATE ();
}

