#ifndef _IWTYPES_H_
#define _IWTYPES_H_
#include "iwcc.h"
#ifdef __PHARL__
#include <pltypes.h>
#include <pldos32.h>
#include <pharlap.h>
#endif
//#######################################################################
//
//       Generic Types
//
//#######################################################################
typedef unsigned char  BYTE;
typedef unsigned short WORD;
typedef unsigned short PORT;
typedef unsigned long  DWORD;
typedef unsigned long  ADDRESS;
typedef int BOOL;
typedef int FLAG;
//#######################################################################
// Pointer Types to Functions that return void or integer values
// PVI is a pointer to an interrupt function.
//#######################################################################
typedef void (*PFV)();
typedef int  (*PFI)();
typedef void (*PFA)(int,...);
#ifdef __HIGHC__
typedef  _Far _INTERRPT void(*PVI)();
#endif
#ifdef __SC__
typedef int (*PVI)(struct INT_DATA *);
#endif
#ifdef __BORLANDC__
#ifdef __MSDOS__
typedef void interrupt (*PVI)();
#else
//typedef struct { DWORD Off; WORD sel; } PVI; // Phar Lap support
#define PVI FARPTR
#endif
#endif
#ifdef __WATCOMC__
typedef void (__interrupt __far *PVI)();
#endif
#ifdef MSOFTC
typedef void (interrupt far *PVI)();
#endif
//#######################################################################
//
//   IRQ Data Structure Type. This type holds information
//   relevant to each IRQ channel in the PICs.
//
//#######################################################################
typedef struct
  {
		  BYTE mask;       // Mask for particular channel
		  BYTE spec_eoi;   // Specific End of Interrupt
		  BYTE ocr;        // Operation Cmd Register Address
		  BYTE imr;        // 0x21 for master, 0xA1 for slave
  } IRQ;
//#######################################################################
//   DMA Data Structure Type. This type holds data relevant to
//   DMA transfers between the InterWave and the PC. 
//#######################################################################
typedef struct
 {
	volatile WORD     flags; // status pending DMA requests
	PORT     page;           // page port location
	PORT     addr;           // addr port location
	PORT     count;          // count port location
	PORT     single;         // single mode port location
	PORT     mode;           // mode port location
	PORT     clear_ff;       // clear flip-flop port location
	BYTE     disable;        // bits to disable dma channel
	BYTE     enable;         // bits to enable dma channel
	BYTE     write;          // bits for write transfer
	BYTE     read;           // bits for read transfer
	BYTE     cur_mode;       // current mode
	WORD     cur_page;       // current page of transfer
	WORD     cur_addr;       // current transfer address
	WORD     amnt_sent;      // current amnt sent
	WORD     cur_size;       // size of current transfer
	WORD     nxt_page;       // next page
	WORD     nxt_addr;       // next address
	WORD     nxt_size;       // size of next buffer
	BYTE     cur_control;    // applies to InterWave's DMA Ctrl Reg
	BYTE     channel;        // DMA channel number
   BYTE     type;           // Type of DMA transfer
#ifdef FLAT_MODEL
	void *pc_ram;            // Address of Data in PC RAM
#else
	void far *pc_ram;        // Address of Data in PC RAM
#endif
   ADDRESS  local;          // Address of Data in LM 
} DMA;
//
//#######################################################################
//
//       IWAVE Type. This type holds information about the configuration
//       and operation modes of the InterWave hardware.
//
//#######################################################################
//
typedef struct
 {
	volatile WORD flags;              // InterWave stat flags
	PORT pcodar;                      // Base Port for Codec
	PORT pcdrar;                      // Base Port for Ext Device
	PORT p2xr;                        // Compatibility Base Port
	PORT p3xr;                        // MIDI and Synth Base Port
	PORT p401ar;                      // Gen Purpose Reg. 1 address
	PORT p201ar;                      // Game Ctrl normally at 0x201
	PORT pataar;                      // Base Address for ATAPI I/O Space
	PORT p388ar;                      // Base Port for AdLib. It should be 388h
	PORT pnprdp;                      // PNP read data port
	PORT igidxr;                      // Gen Index Reg at P3XR+0x03
	PORT i16dp;                       // 16-bit data port at P3XR+0x04 
	PORT i8dp;                        // 8-bit data port at P3XR+0x05
	PORT svsr;                        // Synth Voice Select at P3XR+0x02
	PORT cdatap;                      // Codec Indexed Data Port at PCODAR+0x01
	PORT csr1r;                       // Codec Stat Reg 1 at PCODAR+0x02
	PORT cxdr;                        // Play or Record Data Reg at PCODAR+0x03
	PORT gmxr;                        // GMCR or GMSR at P3XR+0x00
	PORT gmxdr;                       // GMTDR or GMRDR at P3XR+0x01
	PORT lmbdr;                       // LMBDR at P3XR+0x07
	BYTE csn;                         // Card Select Number
	BYTE cmode;                       // Codec Operation Mode
	int dma1_chan;                    // DMA channel 1 (local DMA & codec rec)
	int dma2_chan;                    // DMA channel 2 (codec play)
	int ext_chan;                     // Ext Dev DMA channel
	BYTE voices;                      // Number of active voices
	DWORD vendor;                     // Vendor ID and Product Identifier
	DMA  *dma1;                       // Chan 1 DMA structure
	DMA  *dma2;                       // Chan 2 DMA structure 
	DMA  *ext_dma;                    // Pointer to Ext Dev Chan DMA structure
	int synth_irq;                    // Synth IRQ number
	int midi_irq;                     // MIDI IRQ number
	int ext_irq;                      // Ext Dev IRQ 
	int mpu_irq;                      // MPU401 Dev IRQ
	int emul_irq;                     // Sound Blaster/AdLib Dev IRQ
	IRQ  *synth;                      // Pointer to Synth IRQ structure
	IRQ  *midi;                       // Pointer to MIDI IRQ structure
	IRQ  *ext;                        // Pointer to Ext Dev IRQ structure
	ADDRESS  free_mem;                // Address of First Free LM Block
	DWORD reserved_mem;               // Amount of LM reserved by app.
	BYTE smode;                       // Synth Mode
	WORD  size_mem;                   // Total LM in Kbytes
#ifdef __HIGHC__
	_real_int_handler_t old_synth_rvec;
	_real_int_handler_t old_midi_rvec;
#endif
#ifdef __PHARL__
	REALPTR old_synth_rvec;
	REALPTR old_midi_rvec;
#endif
	PVI old_synth_vec;                // Old Synth Interrupt Address
	PVI old_midi_vec;                 // Old MIDI Interrupt Vector
#ifndef __SC__
	PFV midi_xmit_func;
	PFV midi_rcv_func;
	PFV timer1_func;
	PFV timer2_func;
   PFV wavetable_func;
   PFV volume_func;
	PFV play_dma_func;
	PFV rec_dma_func;
	PFV ext_dma_func;
	PFV codec_timer_func;
	PFV codec_play_func;
	PFV codec_rec_func;
#else
	PFA midi_xmit_func;
	PFA midi_rcv_func;
	PFA timer1_func;
	PFA timer2_func;
   PFA wavetable_func;
   PFA volume_func;
	PFA play_dma_func;
	PFA rec_dma_func;
	PFA ext_dma_func;
	PFA codec_timer_func;
	PFA codec_play_func;
	PFA codec_rec_func;
#endif
 } IWAVE;
//#######################################################################
//
// Define a type to deal with play and record
// sample frequencies. To be used by IwaveSetFreq.
//
//#######################################################################
typedef struct 
 {
	BYTE freq;
	BYTE bits;
 } CODEC_FREQ;
//#######################################################################
//
// Define a type to deal with data stored in .WAV file header.
//
//#######################################################################
typedef struct 
 {
	BYTE stereo;          // set to STEREO for stereo data
	BYTE sixteen;         // set to 1 for 16-bit data
	unsigned long freq;   // sample frequency
	DWORD begin_fpos;     // where sound data begins in file
	DWORD end_fpos;       // where sound data ends in file
	DWORD data_size;      // size of data chunk
	BYTE compress;        // Compression format
 } WAV;
#endif
