/*
   C converter main loops for the HERMES library
   Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
   This source code is licensed under the GNU LGPL
  
   Please refer to the file COPYING.LIB contained in the distribution for
   licensing conditions
*/


#include "HermConf.h"
#include "Convert.h"
#include "Types.h"
#include "HeadC.h"



void ConvertC(HermesConverterInterface *iface)
{
  /* Simply loop through all scanlines */

  while (iface->d_height--) {
    iface->func(iface->s_pixels,iface->d_pixels,iface->d_width,1);

    iface->s_pixels+=iface->s_pitch;
    iface->d_pixels+=iface->d_pitch;
  }
}



void ConvertCStretch(HermesConverterInterface *iface)
{ int y=0,numlines;
  int dy=(iface->s_height<<16)/iface->d_height;
  int dx=(iface->s_width<<16)/iface->d_width;

  /* We have the increment of y and x on the source surface now let's start */

  while (iface->d_height--) {
    iface->func(iface->s_pixels,iface->d_pixels,iface->d_width,dx);

    iface->d_pixels+=iface->d_pitch;

    
    numlines=y;
    y+=dy;
    
    /* Check how many lines we need to step forward */

    numlines=(y>>16)-(numlines>>16);
    
    iface->s_pixels+=numlines*iface->s_pitch;
  }
}
