/*
   Factory methods header for the HERMES library
   Copyright (c) 1998 Christian Nentwich (brn@eleet.mcb.at)
   This source code is licensed under the GNU LGPL
  
   Please refer to the file COPYING.LIB contained in the distribution for
   licensing conditions
*/

#ifndef __HERMES_FACTORY__
#define __HERMES_FACTORY__

#include "Types.h"
#include "H_Format.h"
#include "Clear.h"
#include "Convert.h"


/* Initialise factory */
void Hermes_Factory_Init();


/* Get a clearer function for bits / pixel */
HermesClearer *Hermes_Factory_getClearer(int32 bits);


/* Get a converter for conversion from source to dest */
HermesConverter *Hermes_Factory_getConverter(HermesFormat *source, 
					     HermesFormat *dest);

/* Get a converter for equal formats with source format bits / dest format
   bits */
HermesConverter *Hermes_Factory_getEqualConverter(int bits);


/* Generate lookup tables for x86 converters */
void Hermes_Factory_x86_Gentables();


typedef struct {
  int s_bits,s_idx;
  int32 s_r,s_g,s_b;
  int d_bits,d_idx;
  int32 d_r,d_g,d_b;

  HermesConverterLoopPtr loopnormal,loopstretch;
  HermesConverterPtr normal,stretch;
  HermesConverterLoopPtr dither,ditherstretch;

  int processor;
} HermesFactoryStruct;


#define PROC_GENERIC 1
#define PROC_X86_PENTIUM 2
#define PROC_MMX_PENTIUM 4

/* c++ does not complain about those, c does when you use them in initialisers :((
const int PROC_GENERIC = 1;
const int PROC_X86_PENTIUM = 2;
const int PROC_MMX_PENTIUM = 4;
*/

extern HermesFactoryStruct Factory_Converters[];
extern int Factory_NumConverters;

#endif




