//
// Keyboard conversion table PTC 2.0 C++ API
// Copyright (c) 1999 Robbin Bonthond (elemental@chaos.concepts.nl)
// The PTC 2.0 C++ API is (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_key_conversion
#define __PTC_key_conversion

#include "Types.h"

char8 keyConversionTable[256] = {
  0x00, // 0x00                    UNDEFINED
  0x1b, // 0x01 KEY_ESC            ESCAPE
  0x31, // 0x02 KEY_1              ONE
  0x32, // 0x03 KEY_2              TWO
  0x33, // 0x04 KEY_3              THREE
  0x34, // 0x05 KEY_4              FOUR
  0x35, // 0x06 KEY_5              FIVE
  0x36, // 0x07 KEY_6              SIX
  0x37, // 0x08 KEY_7              SEVEN
  0x38, // 0x09 KEY_8              EIGHT
  0x39, // 0x0a KEY_9              NINE
  0x30, // 0x0b KEY_0              ZERO
  0x6d, // 0x0c KEY_MINUS          SUBSTRACT
  0X3d, // 0x0d KEY_EQUAL          EQUALS
  '\b', // 0x0e KEY_BACKSPACE      BACKSPACE
  '\t', // 0x0f KEY_TAB            TAB
  0x51, // 0x10 KEY_Q              Q
  0x57, // 0x11 KEY_W              W
  0x45, // 0x12 KEY_E              E
  0x52, // 0x13 KEY_R              R
  0x54, // 0x14 KEY_T              T
  0x59, // 0x15 KEY_Y              Y
  0x55, // 0x16 KEY_U              U
  0x49, // 0x17 KEY_I              I
  0x4f, // 0x18 KEY_O              O
  0x50, // 0x19 KEY_P              P
  0x5b, // 0x1a KEY_LEFTBRACKET    OPENBRACKET
  0x5c, // 0x1b KEY_RIGHTBRACKET   CLOSEBRACKET
  '\n', // 0x1c KEY_ENTER          ENTER
  0x11, // 0x1d KEY_LEFTCTRL       CONTROL
  0x41, // 0x1e KEY_A              A
  0x53, // 0x1f KEY_S              S
  0x44, // 0x20 KEY_D              D
  0x46, // 0x21 KEY_F              F
  0x47, // 0x22 KEY_G              G
  0x48, // 0x23 KEY_H              H
  0x4a, // 0x24 KEY_J              J
  0x4b, // 0x25 KEY_K              K
  0x4c, // 0x26 KEY_L              L
  0x3b, // 0x27 KEY_SEMICOLON      SEMICOLON
  0x00, // 0x28 KEY_APOSTROPHE
  0x00, // 0x29 KEY_TICK
  0x10, // 0x2a KEY_LEFTSHIFT      SHIFT
  0x5c, // 0x2b KEY_BACKSLASH      BACKSLASH
  0x5a, // 0x2c KEY_Z              Z
  0x58, // 0x2d KEY_X              X
  0x43, // 0x2e KEY_C              C
  0x56, // 0x2f KEY_V              V
  0x42, // 0x30 KEY_B              B
  0x4e, // 0x31 KEY_N              N
  0x4d, // 0x32 KEY_M              M
  0x2c, // 0x33 KEY_COMMA          COMMA
  0x2e, // 0x34 KEY_PERIOD         PERIOD
  0x2f, // 0x35 KEY_SLASH          SLASH
  0x10, // 0x36 KEY_RIGHTSHIFT     SHIFT
  0x6a, // 0x37 KEY_PADSTAR        MULTIPLY
  0x12, // 0x38 KEY_LEFTALT        ALT
  0x20, // 0x39 KEY_SPACE          SPACE
  0x14, // 0x3a KEY_CAPSLOCK       CAPSLOCK
  0x70, // 0x3b KEY_F1             F1
  0x71, // 0x3c KEY_F2             F2
  0x72, // 0x3d KEY_F3             F3
  0x73, // 0x3e KEY_F4             F4
  0x74, // 0x3f KEY_F5             F5
  0x75, // 0x40 KEY_F6             F6
  0x76, // 0x41 KEY_F7             F7
  0x77, // 0x42 KEY_F8             F8
  0x78, // 0x43 KEY_F9             F9
  0x79, // 0x44 KEY_F10            F10
  0x90, // 0x45 KEY_NUMLOCK        NUMLOCK
  0x91, // 0x46 KEY_SCROLLLOCK     SCROLLLOCK
  0x67, // 0x47 KEY_PAD7           NUMPAD7
  0x68, // 0x48 KEY_PAD8           NUMPAD8
  0x69, // 0x49 KEY_PAD9           NUMPAD9
  0x6d, // 0x4a KEY_PADMINUS       SUBSTRACT
  0x64, // 0x4b KEY_PAD4           NUMPAD4
  0x65, // 0x4c KEY_PAD5           NUMPAD5
  0x66, // 0x4d KEY_PAD6           NUMPAD6
  0x6b, // 0x4e KEY_PADPLUS        ADD
  0x61, // 0x4f KEY_PAD1           NUMPAD1
  0x62, // 0x50 KEY_PAD2           NUMPAD2
  0x63, // 0x51 KEY_PAD3           NUMPAD3
  0x60, // 0x52 KEY_PAD0           NUMPAD0
  0x2e, // 0x53 KEY_PADPERIOD      PERIOD
  0x00, // 0x54                    UNDEFINED
  0x00, // 0x55                    UNDEFINED
  0x00, // 0x56                    UNDEFINED
  0x7a, // 0x57 KEY_F11            F11
  0x7b, // 0x58 KEY_F12            F12
  0x00, // 0x59                    UNDEFINED
  0x00, // 0x5a                    UNDEFINED
  0x00, // 0x5b                    UNDEFINED
  0x00, // 0x5c                    UNDEFINED
  0x00, // 0x5d                    UNDEFINED
  0x00, // 0x5e                    UNDEFINED
  0x00, // 0x5f                    UNDEFINED
  0x00, // 0x60                    UNDEFINED
  0x00, // 0x61                    UNDEFINED
  0x00, // 0x62                    UNDEFINED
  0x00, // 0x63                    UNDEFINED
  0x00, // 0x64                    UNDEFINED
  0x00, // 0x65                    UNDEFINED
  0x00, // 0x66                    UNDEFINED
  0x00, // 0x67                    UNDEFINED
  0x00, // 0x68                    UNDEFINED
  0x00, // 0x69                    UNDEFINED
  0x00, // 0x6a                    UNDEFINED
  0x00, // 0x6b                    UNDEFINED
  0x00, // 0x6c                    UNDEFINED
  0x00, // 0x6d                    UNDEFINED
  0x00, // 0x6e                    UNDEFINED
  0x00, // 0x6f                    UNDEFINED
  0x00, // 0x70                    UNDEFINED
  0x00, // 0x71                    UNDEFINED
  0x00, // 0x72                    UNDEFINED
  0x00, // 0x73                    UNDEFINED
  0x00, // 0x74                    UNDEFINED
  0x00, // 0x75                    UNDEFINED
  0x00, // 0x76                    UNDEFINED
  0x00, // 0x77                    UNDEFINED
  0x00, // 0x78                    UNDEFINED
  0x00, // 0x79                    UNDEFINED
  0x00, // 0x7a                    UNDEFINED
  0x00, // 0x7b                    UNDEFINED
  0x00, // 0x7c                    UNDEFINED
  0x00, // 0x7d                    UNDEFINED
  0x00, // 0x7e                    UNDEFINED
  0x00, // 0x7f                    UNDEFINED
  0x00, // 0x80                    UNDEFINED
  0x00, // 0x81                    UNDEFINED
  0x00, // 0x82                    UNDEFINED
  0x00, // 0x83                    UNDEFINED
  0x00, // 0x84                    UNDEFINED
  0x00, // 0x85                    UNDEFINED
  0x00, // 0x86                    UNDEFINED
  0x00, // 0x87                    UNDEFINED
  0x00, // 0x88                    UNDEFINED
  0x00, // 0x89                    UNDEFINED
  0x00, // 0x8a                    UNDEFINED
  0x00, // 0x8b                    UNDEFINED
  0x00, // 0x8c                    UNDEFINED
  0x00, // 0x8d                    UNDEFINED
  0x00, // 0x8e                    UNDEFINED
  0x00, // 0x8f                    UNDEFINED
  0x00, // 0x90                    UNDEFINED
  0x00, // 0x91                    UNDEFINED
  0x00, // 0x92                    UNDEFINED
  0x00, // 0x93                    UNDEFINED
  0x00, // 0x94                    UNDEFINED
  0x00, // 0x95                    UNDEFINED
  0x00, // 0x96                    UNDEFINED
  0x00, // 0x97                    UNDEFINED
  0x00, // 0x98                    UNDEFINED
  0x00, // 0x99                    UNDEFINED
  0x00, // 0x9a                    UNDEFINED
  0x00, // 0x9b                    UNDEFINED
  '\n', // 0x9c KEY_PADENTER       ENTER
  0x11, // 0x9d KEY_RIGHTCTRL      CONTROL
  0x00, // 0x9e                    UNDEFINED
  0x00, // 0x9f                    UNDEFINED
  0x00, // 0xa0                    UNDEFINED
  0x00, // 0xa1                    UNDEFINED
  0x00, // 0xa2                    UNDEFINED
  0x00, // 0xa3                    UNDEFINED
  0x00, // 0xa4                    UNDEFINED
  0x00, // 0xa5                    UNDEFINED
  0x00, // 0xa6                    UNDEFINED
  0x00, // 0xa7                    UNDEFINED
  0x00, // 0xa8                    UNDEFINED
  0x00, // 0xa9                    UNDEFINED
  0x00, // 0xaa                    UNDEFINED
  0x00, // 0xab                    UNDEFINED
  0x00, // 0xac                    UNDEFINED
  0x00, // 0xad                    UNDEFINED
  0x00, // 0xae                    UNDEFINED
  0x00, // 0xaf                    UNDEFINED
  0x00, // 0xb0                    UNDEFINED
  0x00, // 0xb1                    UNDEFINED
  0x00, // 0xb2                    UNDEFINED
  0x00, // 0xb3                    UNDEFINED
  0x00, // 0xb4                    UNDEFINED
  0x2f, // 0xb5 KEY_PADSLASH       SLASH
  0x00, // 0xb6                    UNDEFINED
  0x9a, // 0xb7 KEY_SYSRQ          PRINTSCREEN
  0x12, // 0xb8 KEY_RIGHTALT       ALT
  0x00, // 0xb9                    UNDEFINED
  0x00, // 0xba                    UNDEFINED
  0x00, // 0xbb                    UNDEFINED
  0x00, // 0xbc                    UNDEFINED
  0x00, // 0xbd                    UNDEFINED
  0x00, // 0xbe                    UNDEFINED
  0x00, // 0xbf                    UNDEFINED
  0x00, // 0xc0                    UNDEFINED
  0x00, // 0xc1                    UNDEFINED
  0x00, // 0xc2                    UNDEFINED
  0x00, // 0xc3                    UNDEFINED
  0x00, // 0xc4                    UNDEFINED
  0x00, // 0xc5                    UNDEFINED
  0x00, // 0xc6                    UNDEFINED
  0x24, // 0xc7 KEY_HOME           HOME
  0x26, // 0xc8 KEY_UPARROW        UP
  0x21, // 0xc9 KEY_PAGEUP         PAGEUP
  0x00, // 0xca                    UNDEFINED
  0x25, // 0xcb KEY_LEFTARROW      LEFT
  0x00, // 0xcc                    UNDEFINED
  0x27, // 0xcd KEY_RIGHTARROW     RIGHT
  0x00, // 0xce                    UNDEFINED
  0x23, // 0xcf KEY_END            END
  0x28, // 0xd0 KEY_DOWNARROW      DOWN
  0x22, // 0xd1 KEY_PAGEDOWN       PAGEDOWN
  0x9b, // 0xd2 KEY_INSERT         INSERT
  0x7f, // 0xd3 KEY_DELETE         DELETE
  0x00, // 0xd4                    UNDEFINED
  0x00, // 0xd5                    UNDEFINED
  0x00, // 0xd6                    UNDEFINED
  0x00, // 0xd7                    UNDEFINED
  0x00, // 0xd8                    UNDEFINED
  0x00, // 0xd9                    UNDEFINED
  0x00, // 0xda                    UNDEFINED
  0x00, // 0xdb KEY_LEFTWINDOW     UNDEFINED
  0x00, // 0xdc KEY_RIGHTWINDOW    UNDEFINED
  0x00, // 0xdd KEY_KEYBOARDMOUSE  UNDEFINED
  0x00, // 0xde                    UNDEFINED
  0x00, // 0xdf                    UNDEFINED
  0x00, // 0xe0                    UNDEFINED
  0x00, // 0xe1                    UNDEFINED
  0x00, // 0xe2                    UNDEFINED
  0x00, // 0xe3                    UNDEFINED
  0x00, // 0xe4                    UNDEFINED
  0x00, // 0xe5                    UNDEFINED
  0x00, // 0xe6                    UNDEFINED
  0x00, // 0xe7                    UNDEFINED
  0x00, // 0xe8                    UNDEFINED
  0x00, // 0xe9                    UNDEFINED
  0x00, // 0xea                    UNDEFINED
  0x00, // 0xeb                    UNDEFINED
  0x00, // 0xec                    UNDEFINED
  0x00, // 0xed                    UNDEFINED
  0x00, // 0xee                    UNDEFINED
  0x00, // 0xef                    UNDEFINED
  0x00, // 0xf0                    UNDEFINED
  0x00, // 0xf1                    UNDEFINED
  0x00, // 0xf2                    UNDEFINED
  0x00, // 0xf3                    UNDEFINED
  0x00, // 0xf4                    UNDEFINED
  0x00, // 0xf5                    UNDEFINED
  0x00, // 0xf6                    UNDEFINED
  0x00, // 0xf7                    UNDEFINED
  0x00, // 0xf8                    UNDEFINED
  0x00, // 0xf9                    UNDEFINED
  0x00, // 0xfa                    UNDEFINED
  0x00, // 0xfb                    UNDEFINED
  0x00, // 0xfc                    UNDEFINED
  0x00, // 0xfd                    UNDEFINED
  0x00, // 0xfe                    UNDEFINED
  0x00  // 0xff KEY_BREAK          UNDEFINED
};

#endif
