//
// Palette class for PTC 2.0 C++ API (HERMES INTERFACE PACKAGE)
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

// include files
#include <memory.h>
#include "Error.h"
#include "Palette.h"




Palette::Palette()
{
    // clear locked flag
    m_locked = false;

    // initialize hermes
    Hermes_Init();

    // create hermes palette instance
    m_handle = Hermes_PaletteInstance();

    // check hermes palette instance
    if (!m_handle) throw Error("could not create hermes palette instance");
}


Palette::Palette(const Palette &palette)
{
    // clear locked flag
    m_locked = false;

    // initialize hermes
    Hermes_Init();

    // create hermes palette instance
    m_handle = Hermes_PaletteInstance();

    // check hermes palette instance
    if (!m_handle) throw Error("could not create hermes palette instance");

    // assignment
    *this = palette;
}


Palette::~Palette()
{
    // return palette instance
    Hermes_PaletteReturn(m_handle);

    // free hermes
    Hermes_Done();
}




int32* Palette::lock()
{
    // check locked flag
    if (m_locked) throw Error("palette is already locked");

    // set locked flag
    m_locked = true;

    // return hermes palette
    return Hermes_PaletteGet(m_handle);
}


void Palette::unlock()
{
    // check locked flag
    if (!m_locked) throw Error("palette is not locked");

    // reset locked flag
    m_locked = false;
}




void Palette::load(const int32 data[])
{
    // load palette data
    memcpy(Hermes_PaletteGet(m_handle),data,1024);
}




void Palette::save(int32 data[]) const
{
    // save palette data
    memcpy(data,Hermes_PaletteGet(m_handle),1024);
}




const int32* Palette::data() const
{
    // get palette data
    return Hermes_PaletteGet(m_handle);
}




Palette& Palette::operator =(const Palette &palette)
{
    // assignment
    Hermes_PaletteSet(m_handle,Hermes_PaletteGet(palette.m_handle));
    return *this;
}


bool Palette::operator ==(const Palette &palette) const
{
    // is equal to
    if (memcmp(Hermes_PaletteGet(m_handle),Hermes_PaletteGet(palette.m_handle),1024)==0) return true;
    else return false;
}


bool Palette::operator !=(const Palette &palette) const
{
    // not equal to
    return !(*this==palette);
}
