//
// Surface class for PTC 2.0 C++ API
// Copyright (c) 1998 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
//

#ifndef __PTC_SURFACE_H
#define __PTC_SURFACE_H

// include files
#include "Base.h"
#include "Copy.h"
#include "Clear.h"
#include "Palette.h"




class Surface : public BaseSurface
{
    public:

        // setup
        Surface(int width,int height,const Format &format);
        ~Surface();

        // copy to surface
        virtual void copy(BaseSurface &surface);
        virtual void copy(BaseSurface &surface,const Area &source,const Area &destination);

        // memory access
        virtual void* lock();
        virtual void unlock();

        // load pixels to surface
        virtual void load(const void *pixels,int width,int height,const Format &format,const Palette &palette);
        virtual void load(const void *pixels,int width,int height,const Area &source,const Area &destination,const Format &format,const Palette &palette);

        // save surface pixels
        virtual void save(void *pixels,int width,int height,const Format &format,const Palette &palette);
        virtual void save(void *pixels,int width,int height,const Area &source,const Area &destination,const Format &format,const Palette &palette);

        // clear surface
        virtual void clear();
        virtual void clear(const Color &color);
        virtual void clear(const Color &color,const Area &area);

        // surface palette
        virtual void palette(const Palette &palette);
        virtual const Palette& palette() const;
   
        // data access
        virtual int width() const;
        virtual int height() const;
        virtual int pitch() const;
        virtual const Format& format() const;

        // surface option string
        virtual bool option(const char option[]);

    private:

        // disallow copy construction
        Surface(const Surface &surface);

        // disallow surface assignment
        Surface& operator =(const Surface &surface);

        // data
        int m_width;
        int m_height;
        Format m_format;
        bool m_locked;
        void *m_pixels;
        
        // objects
        Copy m_copy;
        Clear m_clear;
        Palette m_palette;
};




#endif
