#include <stdlib.h>
#include <string.h>
#include "key.h"
#include "rxm.h"


int dflags = df16bit | dfStereo;
int vol = 12*8;
int amp = 0;
int mixrate = 44100;
int iwflag = 1;
int mastervol = 0;
int maxpat = 0;
int rxmconvert = 0;

extern char mucke;


void *allocmem(int size) {
  void * mem;
  mem = (void *) malloc(size);
  if (!mem) m_err();
  return (mem);
};

void m_err() {
  printf("Out of memory!");
  exit(1);
};


int parse(char *s, int mul) {
  int r = 0;

  while (*s && (*s < '0' || *s > '9')) s++;
  while (*s >= '0' && *s <= '9') {
    r *= mul;
    r += *s - '0';
    s++;
  }
  return r;
}


int checkenv(tdinfo *dinfo) {
  int i;
  i = dinfo->base >= 0x200 && dinfo->base <= 0x290;
  i &= dinfo->irq >= 2 && dinfo->irq <= 15;
  i &= dinfo->dma1 <= 7;
  i &= dinfo->dma2 <= 7;
  return i;
}

int gusenv(tdinfo *dinfo, int flags, int iwflag) {
  char *s;

  memset(dinfo,0,sizeof(tdinfo));
  s = getenv("ULTRASND");
  dinfo->base = parse(s,16);
  s = strchr(s,',');
  if (!s) return 0;
  dinfo->dma1 = parse(s,10);
  s = strchr(s+1,',');
  if (!s) return 0;
  dinfo->dma2 = parse(s,10);
  s = strchr(s+1,',');
  if (!s) return 0;
  dinfo->irq = parse(s,10);

  if (iwflag >= 2 || (iwflag == 1 && getenv("INTERWAVE"))) dinfo->flags |= gus_iw;
  dinfo->flags |= flags;

  return checkenv(dinfo);
}

int sbenv(tdinfo *dinfo, int rate, int flags) {
  char *s;
  char *v;

  memset(dinfo,0,sizeof(tdinfo));
  s = getenv("BLASTER");
  v = strchr(s,'A');
  if (v) dinfo->base = parse(v,16);
  v = strchr(s,'I');
  if (v) dinfo->irq = parse(v,10);
  v = strchr(s,'D');
  if (!v) return 0;
  dinfo->dma1 = parse(v,10);
  v = strchr(s,'H');
  if (v) dinfo->dma2 = parse(v,10);
  dinfo->rate = rate;
  dinfo->flags = flags;
  return checkenv(dinfo);
}


int playrxm() {
  int t;
  tdinfo dinfo;
  void *drv_mem = NULL;
  int c;

  rxminit();

  t = 0;
  //gus
  if (gusenv(&dinfo,dflags,iwflag)) t = u_test(&dinfo);
  //sb
  if (!t && sbenv(&dinfo,mixrate,dflags)) {
    if (dflags & sb_awe) t = a_test(&dinfo);
    if (!t) t = sb_test(&dinfo);
  }
  //no sound
  if (!t) n_test(&dinfo);

  if (dinfo.mem) drv_mem = allocmem(dinfo.mem);
  if (dinfo.dmabuf) {
    if (!(dinfo.dmabuf = getdmabuf(dinfo.dmabuf))) {
      printf("Not enough low mem");
      exit(1);
    }
  }

  dinfo.mastervol = mastervol;

  i8_init();
  t = rxmdevinit(&dinfo,drv_mem);
  if (t) {
    if (t == 1) printf("DMA error\n");
    if (t == 2) printf("IRQ error\n");
    i8_done();
    exit(1);
  }


  rxmsetvol(vol);
  rxmplay(&mucke,0);

  do {
    c = readchar();
    switch (c) {
     case -75 : rxmskip(-1);
                break;
     case -77 : rxmskip(1);
                break;
    }
  } while (c != 27 && c != 32);
  rxmstop(xmStop);


  rxmdevdone();
  i8_done();

  if (drv_mem) free(drv_mem);
  freedmabuf();

  return c;
}

void main(int argc, char**argv) {

  playrxm();
}
