/*
 * Minimal player, plays a MOD file from the command line. Updates sound in the
 * main program. Signal handlers are setup though...
 */

#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <conio.h>
#include "judas.h"

int main(int argc, char **argv);
static void handle_int(int a);
static void error(void);

int main(int argc, char **argv)
{
        /* Set uninit function to be called at exit */
        atexit(judas_uninit);

        /* Set signal handlers */
        signal(SIGINT, handle_int);
        signal(SIGBREAK, handle_int);

        /* Config & init 16bit stereo at 44100 Hz with interpolation */
        judas_config();
        if (!judas_init(44100, SIXTEENBIT | STEREO, 1)) error();

        /* Load file */
        if (argc < 2) return 1;
        if (!judas_loadmod(argv[1])) error();

        /* Play & wait for keypress */
        judas_playmod();
        while (!kbhit())
        {
                while(inp(0x3da) & 8)
                {
                }
                while(!(inp(0x3da) & 8))
                {
                }
                judas_update();
        }
        return 0;
}

static void handle_int(int a)
{
        exit(0); /* Atexit functions will be called! */
}

static void error(void)
{
        printf("JUDAS ERROR:%s\n", judas_errortext[judas_error]);
        exit(1);
}
