;            ͻ
;                 USMPLAY.ASM       
;                                                               
;                          Useless Module Player                
;            ĺ
;               By Freddy Vtel (FreddyV/Useless)              
;                                                               
;               Code starts .................. 09/08/1996       
;               Last update .................. 10/08/1997       
;            ͼ
.386p
INCLUDE OS.INC

CODE32 SEGMENT PUBLIC PARA 'CODE' USE32
ASSUME CS:CODE32,DS:CODE32

INCLUDE SETUP.INC

INCLUDE ERR_CODE.INC
INCLUDE USMPLAY.INC

INCLUDE USS.INC
INCLUDE USSVAR.INC
INCLUDE USM.INC      ; USM File Format (USSVAR.INC must be included before)

INCLUDE MEMORY.INC   ; Used by USMP_FreeModule

INCLUDE UTILS.INC

;-----------------------------------------------------------------------------

; ** Synchro var **  (They are public)

_SynchroCount dd 0
_SynchroVal   db 0
_MusicEnd     db 0

;-----------------------------------------------------------------------------

; ** Current playing file infos **

USMOffset   dd 0 ; USM header offset
USMFlags    dw 0 ; USM file flags
USMChannels dd 0 ; File channels

;-----------------------------------------------------------------------------

; ** Global player var **

UsmPlayVarStart:

BPMVal    dd 0 ; Module Tempo ( 1193180*5/(2*BPM) )
BPMCnt    dd 0 ; Timer Ticks counter
_BPM Label byte
BPM       db 0
_Speed Label byte
Speed     db 0 ; Module Speed
SpeedCnt  db 0 ; Tempo counter
TickCnt   db 0 ; Tick counter

PatternOffset dd 0 ; Current Pattern Offset
RowOffset     dd 0 ; Current Note Offset

_Order Label word
Order   dw 0    ; Current Order Pos (Can be used for synchro)
_Pattern Label word
Pattern dw 0    ; Current Pattern   (Can be used for synchro)
_Row Label Word
Row     dw 0    ; Current Row       (Can be used for synchro)
Rows    dw 0    ; Rows in current pattern

if UsePatternDelay Eq Yes
PatternDelay db 0
endif
NextOrder    dw 0
NextRow      dw 0

CInstr  dw 0    ; Current Instrument number
CNote   dw 0    ; Current Note
CVolume dw 0    ; Current Volume
CVComm  dw 0    ; Current Volume command
CVParam dw 0    ; Current Volume command parameter
CComm   dw 0    ; Current Command
CParam  dw 0    ; Current command parameter

Do_SetSampleDef  db 0 ; Set Channel volume to sample Volume ?

;-----------------------------------------------------------------------------

; ** Channels var **

_ChInstrument label byte
ChInstrument   db MAX_PLCHANNELS DUP (0)  ;Channel Instrument
_ChNote label byte
ChNote         db MAX_PLCHANNELS DUP (0)  ;Channel Note
_ChCommand label byte
ChCommand      db MAX_PLCHANNELS DUP (0)  ;Channel Command
_ChVCommand label byte
ChVCommand     db MAX_PLCHANNELS DUP (0)  ;Channel Volume Command
_ChVolume label byte
ChVolume       db MAX_PLCHANNELS DUP (0)  ;Channel Volume
_ChPeriod label word
ChPeriod       dw MAX_PLCHANNELS DUP (0)  ;Channel Period
_ChPanning label byte
ChPanning      db MAX_PLCHANNELS DUP (0)  ;Channel Panning

ChRInstrument  db MAX_PLCHANNELS DUP (0)  ;Instrument of the current Row
ChRNote        db MAX_PLCHANNELS DUP (0)  ;Note of the current Row
ChRVolume      db MAX_PLCHANNELS DUP (0)  ;Volume of the current Row

ChBPMSlideData          db MAX_PLCHANNELS DUP (0) ; -- BPM Slide
ChArpeggioData          db MAX_PLCHANNELS DUP (0) ; 00 Arpeggio
ChArpeggioPos           db MAX_PLCHANNELS DUP (0) ; 00 Arpeggio
ChPortaUpData           db MAX_PLCHANNELS DUP (0) ; 01 Portamento Up
ChPortaDownData         db MAX_PLCHANNELS DUP (0) ; 02 Portamento Down
ChPortaToNoteData       db MAX_PLCHANNELS DUP (0) ; 03 PortaToNote
ChPortaToNotePeriode    dw MAX_PLCHANNELS DUP (0) ; 03 PortaToNote
ChVibWave               db MAX_PLCHANNELS DUP (0) ; 04 Vibrato
ChVibSpeed              db MAX_PLCHANNELS DUP (0) ; 04 Vibrato
ChVibDepth              db MAX_PLCHANNELS DUP (0) ; 04 Vibrato
ChVibPos                db MAX_PLCHANNELS DUP (0) ; 04 Vibrato
ChTremWave              db MAX_PLCHANNELS DUP (0) ; 07 Tremolo
ChTremSpeed             db MAX_PLCHANNELS DUP (0) ; 07 Tremolo
ChTremdepth             db MAX_PLCHANNELS DUP (0) ; 07 Tremolo
ChTremPos               db MAX_PLCHANNELS DUP (0) ; 07 Tremolo
ChVolumeSlideData       db MAX_PLCHANNELS DUP (0) ; 10 Volume Slide
ChChVolumeSlideData     db MAX_PLCHANNELS DUP (0) ; -- Channel Volume slide

ChGVolumeSlideData      db MAX_PLCHANNELS DUP (0) ; 17 Global VolumeSlide
ChPanningSlideData      db MAX_PLCHANNELS DUP (0) ; 25 Panning Slide
ChMRetrigSpeed          db MAX_PLCHANNELS DUP (0) ; 27 Multi Retrig
ChMRetrigParam          db MAX_PLCHANNELS DUP (0) ; 27 Multi Retrig
ChMRetrigCnt            db MAX_PLCHANNELS DUP (0) ; 27 Multi Retrig
ChTremorPos             db MAX_PLCHANNELS DUP (0) ; 29 Tremor
ChTremorLen             db MAX_PLCHANNELS DUP (0) ; 29 Tremor
ChTremorOff             db MAX_PLCHANNELS DUP (0) ; 29 Tremor
ChFVolumeSlideUpData    db MAX_PLCHANNELS DUP (0) ; 46 Fine Volume Slide Up
ChFVolumeSlideDownData  db MAX_PLCHANNELS DUP (0) ; 47 Fine Volume Slide Down
ChEFPortaUData          db MAX_PLCHANNELS DUP (0) ; 33 Extra fine Portamento
ChEFPortaDData          db MAX_PLCHANNELS DUP (0) ; 33 Extra fine Portamento

ChFPortaUpData          db MAX_PLCHANNELS DUP (0) ; 37 Fine Portamento Up
ChFPortaDownData        db MAX_PLCHANNELS DUP (0) ; 38 Fine Portamento Down
ChPatLoopRow            db MAX_PLCHANNELS DUP (0) ; 42 Pattern Loop
ChPatLoopCount          db MAX_PLCHANNELS DUP (0) ; 42 Pattern Loop

ChCommandTick           db MAX_PLCHANNELS DUP (0) ; All 'Tick based' commands

ChITPitchData           db MAX_PLCHANNELS DUP (0) ; --
ChITPitchUpData         db MAX_PLCHANNELS DUP (0) ; -- IT Portamento Up
ChITPitchDnData         db MAX_PLCHANNELS DUP (0) ; -- IT Portamento Down
ChITVolumeSlideData     db MAX_PLCHANNELS DUP (0) ; -- IT Volume Slide
ChITChVolumeSlideData   db MAX_PLCHANNELS DUP (0) ; -- IT Channel Volume Slide
ChITGVolumeSlideData    db MAX_PLCHANNELS DUP (0) ; -- IT Global VolumeSlide
ChITPanningSlideData    db MAX_PLCHANNELS DUP (0) ; -- IT Panning Slide
ChITMRetrigParam        db MAX_PLCHANNELS DUP (0) ; --

ChVolCmdData            db MAX_PLCHANNELS DUP (0) ; Volume commands

UsmPlayVarEnd:

;----------------------------------------------------------------------------


;=============================================================================

;͸
; USMP_LoadInternalModule: "Load" an internal USM file. (OBJ)             
;                                                                         
; Input: ESI USM Module Offset                                            
;                                                                         
; Output: --                                                              
;                                                                         
;

if _WATCOM
USMP_LoadInternalModule_ Proc
else
USMP_LoadInternalModule  Proc
endif

; ** Move the data pointers **

        xor ecx,ecx
        mov eax,esi
MovePointersLoop:
        cmp MPattPtr[esi+4*ecx],0
        je NotMovePointer
        add MPattPtr[esi+4*ecx],eax
NotMovePointer:

        inc cx
        cmp ecx,MAX_Patterns+MAX_Samples+MAX_Instruments
        jne MovePointersLoop

; ** "Load" samples data **

        xor ecx,ecx
LoadSamplesLoop:
        mov edi,MSamplPtr[esi+4*ecx]
        cmp edi,0
        je NotLoadSample

        test SFlag[edi],SF_Loaded    ; Is sample data in the file ?
        jz NotLoadSample
        and SFlag[edi],Not SF_Loaded ; Sample data is not in memory

        mov esi,SPointer[edi]
        add esi,eax

        pushad
        mov ecx,SLength[edi]
        xor eax,eax
_DeltaLoop:
        add al,[esi]
        mov [esi],al
        inc esi
        loop _DeltaLoop
        and SFlag[edi],Not SF_Delta
        popad

        pushad
        call USS_LoadSample
        popad
NotLoadSample:

        mov esi,eax
        inc cx
        cmp cx,MSamples[esi]
        jne LoadSamplesLoop

        ret
if _WATCOM
USMP_LoadInternalModule_ Endp
else
USMP_LoadInternalModule  Endp
endif

;͸
; USMP_FreeModule: Remove a module from memory                            
;                                                                         
; Input: ESI USM Module Offset                                            
;                                                                         
; Output: --                                                              
;                                                                         
;
if UseFreeModule eq Yes

if _WATCOM
USMP_FreeModule_ Proc
else
USMP_FreeModule  Proc
endif

        mov USMOffset,esi

; ** Free the module patterns **
        xor ecx,ecx
FreePatternsLoop:
        mov eax,MPattPtr[esi+4*ecx]
        or eax,eax
        jz FreePatternsSkip
        push ecx
        U_Free eax
        pop ecx
FreePatternsSkip:
        inc ecx
        cmp ecx,MAX_Patterns
        jne FreePatternsLoop

; ** Free the module instruments **
        mov esi,USMOffset
        xor ecx,ecx
FreeInstrumentsLoop:
        mov eax,MInstrPtr[esi+4*ecx]
        or eax,eax
        jz FreeInstrumentSkip
        push ecx
        U_Free eax
        pop ecx
FreeInstrumentSkip:
        inc ecx
        cmp ecx,MAX_Instruments
        jne FreeInstrumentsLoop

; ** Free the module samples **
        mov esi,USMOffset
        xor ecx,ecx
FreeSamplesLoop:
        mov eax,MSamplPtr[esi+4*ecx]
        or eax,eax
        jz FreeSampleSkip
        push ecx

        push eax
        mov edi,eax
        call USS_FreeSample ; ** Free Sample data **
        pop eax
        U_Free eax            ; ** Free sample definition **

        pop ecx
FreeSampleSkip:
        inc ecx
        cmp ecx,MAX_Samples
        jne FreeSamplesLoop

; ** Free the module header **
        U_Free USMOffset

        clc
        ret
if _WATCOM
USMP_FreeModule_ Endp
else
USMP_FreeModule  Endp
endif

Endif

;͸
; USMP_StartPlay                                                          
;                                                                         
; Input: ESI USM Module Offset                                            
;                                                                         
; Output: CF => Error code in EAX                                         
;         Error code in _Error_Number for WATCOM)                         
;                                                                         
;

if _WATCOM
USMP_Startplay_ proc
else
USMP_StartPlay  Proc
endif


;                       ** Module init **

; ** Check the file version. **

        mov eax,PE_NotUSM
        cmp MId[esi],'MLSU'      ;Is it a pointer do an USM Header ?
        jne USMP_StartPlayError

        mov eax,PE_WrongVersion  ;Is it the correct USM file version ?
        cmp MVersion[esi],USMVersion
        jne USMP_StartPlayError


        mov USMOffset,esi

        mov ax,MFlags[esi]
        mov USMFlags,ax

        movzx eax,MChannels[esi]
        mov USMChannels,eax

;                       ** Sound System init **

        push esi
        call USS_Init 
        pop esi

; ** Set the active channels number **
        mov eax,PE_Channels
        cmp MChannels[esi],MAX_PLCHANNELS
        ja USMP_StartPlayError

        mov eax,USMChannels
        call USS_SetActiveChannels
        jc USMP_StartPlayError

; ** Instruments and samples tables offset **
        mov eax,esi
        add eax,MSamplPtr
        mov SSSampleOffsetT,eax
        add eax,MInstrPtr-MSamplPtr
        mov SSInstrOffsetT,eax


; ** Set default channel panning/control **
        push ebp
        xor eax,eax
        xor ebp,ebp
SetStartPanningLoop:
        mov al,MChPan[esi+ebp]

; Stopped channel ?
        cmp al,128
        jb  NotStopped
        sub al,128
; Set Stopped channel
NotStopped:

; Surround channel ?
        cmp al,100
        jne NotSurround
        mov al,64               ; Surround channel -> Set to mono
; Set surround channel
NotSurround:        

; 0-40h to 0-FFh
        cmp al,40h
        jne PannR
        mov al,0FFh
        jmp PannConverted
PannR:
        shl al,2
PannConverted:
        
        mov ChPanning[ebp],al
; Set panning
        call USS_SetPanning
        inc ebp
        cmp ebp,USMChannels
        jne SetStartPanningLoop
        pop ebp


; ** Set default Channel volume **
if UseChannelVolume Eq Yes
        push ebp
        xor eax,eax
        xor ebp,ebp
SetStartChVolLoop:
        movzx eax,MChVol[esi+ebp]

; Set channel volume
        call USS_SetChannelVolume
        inc ebp
        cmp ebp,USMChannels
        jne SetStartChVolLoop
        pop ebp
endif

; ** Sample/Instrument Mode **
        mov SSInstrumentMode,0
        test MFlags[esi],F_InstrMode
        jz NoInstrumentMode
        mov SSInstrumentMode,1
NoInstrumentMode:


; ** Period limits **

        mov ax,MPeriodMin[esi]
        mov SSPeriodMin,ax
        mov ax,MPeriodMax[esi]
        mov SSPeriodMax,ax

; ** Global Volume **

        mov al,MGVolume[esi]         ; Set Initial Global Volume
        call USS_SetGlobalVolume

;                      ** USM Play init **

        push esi
        mov edi,Offset UsmPlayVarStart
        mov ecx,Offset UsmPlayVarEnd
        sub ecx,edi
        push ds
        pop es
        cld
        xor eax,eax
        rep stosb
        pop esi

; ** BPM/Tempo values **

        mov al,MBPM[esi]
        call ProcSetBPM              ; Set Initial BPM
        mov al,MTempo[esi]
        mov Speed,al                 ; Set Initial Speed
        dec al
        mov SpeedCnt,al

;                 ** Start the sound output **
        push esi
        mov esi,Offset USMP_PeriodicProc
        call USS_StartOutput            ; Start the sound output.
        pop esi
        jc USMP_StartPlayError

if _WATCOM
        mov _Error_Number,0
        ret
else
        clc
        ret
endif
USMP_StartPlayError:
if _WATCOM
        mov _Error_Number,eax
        ret
else
        stc
        ret
endif
if _WATCOM
USMP_Startplay_ endp
else
USMP_StartPlay endp
endif

;͸
; USMP_StopPlay                                                           
;                                                                         
; Input: ESI USM Module Offset                                            
;                                                                         
; Output: --                                                              
;                                                                         
;
if _WATCOM
USMP_StopPlay_ Proc
else
USMP_StopPlay  Proc
endif
        call USS_StopOutput

        ret
if _WATCOM
USMP_StopPlay_ Endp
else
USMP_StopPlay Endp
endif

;͸
; USMP_PrevOrder: Go to next music pattern.                               
;                                                                         
; Input: --                                                               
;                                                                         
; Output: --                                                              
;                                                                         
;
if Use_USMP_PrevOrder Eq Yes    ;* Use PrevOrder function ?

if _WATCOM
USMP_PrevOrder_ Proc
else
USMP_PrevOrder  Proc
endif
        mov ax,Order
        dec ax
        js SkipPrevOrder
        mov NextOrder,ax
        mov NextRow,0
        mov al,Speed
        dec al
        mov SpeedCnt,al
SkipPrevOrder:
        ret
if _WATCOM
USMP_PrevOrder_ Endp
else
USMP_PrevOrder  Endp
endif
endif

;͸
; USMP_NextOrder: Go to previous music pattern.                           
;                                                                         
; Input: --                                                               
;                                                                         
; Output: --                                                              
;                                                                         
;
if Use_USMP_NextOrder Eq Yes    ;*

if _WATCOM
USMP_NextOrder_ Proc
else
USMP_NextOrder  Proc
endif
        mov ax,Order
        inc ax

        mov esi,USMOffset
        cmp ax,MSongLen[esi]
        je SkipNextOrder
        mov NextOrder,ax
        mov NextRow,0
        mov al,Speed
        dec al
        mov SpeedCnt,al
SkipNextOrder:
        ret
if _WATCOM
USMP_NextOrder_ Endp
else
USMP_NextOrder Endp
endif
endif

;͸
; USMP_SetOrder Set the current order number.                             
;                                                                         
; Input: AX New order.                                                    
;                                                                         
; Output: --                                                              
;                                                                         
;
if Use_USMP_SetOrder Eq Yes     ;*

if _WATCOM
USMP_SetOrder_ Proc
else
USMP_SetOrder  Proc
endif
        mov esi,USMOffset
        cmp ax,MSongLen[esi]
        jae SkipSetOrder
        mov NextOrder,ax
        mov NextRow,0
        mov al,Speed
        dec al
        mov SpeedCnt,al
SkipSetOrder:
        ret
if _WATCOM
USMP_SetOrder_ endp
else
USMP_SetOrder  Endp
endif
endif

;͸
; USMP_SetPosition Set the current order and Row number.                  
;                                                                         
; Input: AX New order.                                                    
;        BX New Row.                                                      
;                                                                         
; Output: --                                                              
;                                                                         
;
if Use_USMP_SetPosition Eq Yes     ;*

if _WATCOM
USMP_SetPosition_ Proc
else
USMP_SetPosition  Proc
endif
        mov esi,USMOffset
        cmp ax,MSongLen[esi]
        jae SkipSetPosition
        mov NextOrder,ax
        cmp bx,Rows
        jae SkipSetPosition
        mov NextRow,bx
        mov al,Speed
        dec al
        mov SpeedCnt,al
SkipSetPosition:
        ret
if _WATCOM
USMP_SetPosition_ endp
else
USMP_SetPosition  Endp
endif
endif

;***************************************************************
;********************  Internal functions **********************
;***************************************************************

USMP_PeriodicProc proc
        push ebp

        add BPMCnt,eax
BPMLoop:
        mov eax,BPMVal
        cmp BPMCnt,eax
        jb  NoProcess
        sub BPMCnt,eax

        call PlayerTick      ; Process the next Row or effect.
        call USS_UpdateInstr ; Do the instruments envelopes and Auto vibrato.

        jmp BPMLoop
NoProcess:

        call USS_UpdateOutput

        pop ebp
        ret
USMP_PeriodicProc Endp

;͸
; PlayerTick: Process a pattern change, a Row or an effect.               
;                                                                         
;
PlayerTick Proc

; ** Process Speed **

	inc SpeedCnt
	mov al,Speed
	cmp SpeedCnt,al
	jne DoEffects
	mov SpeedCnt,0

	mov TickCnt,0

; ** Process Pattern delay and music order **

if UsePatternDelay Eq Yes    ;*
        cmp PatternDelay,0   ; * Pattern delay command *
	je  NoPatternDelay
	dec PatternDelay
	jmp DoEffects        ; Do not process the Row => Delay the pattern.
NoPatternDelay:
endif

	cmp NextOrder,-1     ; A pattern break or jump pattern command occurs
	jne ChangeOrder      ; => Jump to the needed order

	mov ax,Row
	cmp ax,Rows          ; If actual Row is pattern length,
	jb  NotChangeOrder

	mov NextRow,0        ; jump to the next order (with Row=0)
	movzx eax,Order
	inc eax
	mov NextOrder,ax     ; Next order is actual order+1

ChangeOrder:
	call DoChangeOrder   ; Change Order number.

NotChangeOrder:
	cmp NextRow,-1
	je  NotChangeRow
	call DoChangeRow     ; Change Row number.
NotChangeRow:

; ** Process Row **

	call ProcRow
	
; ** Go to next Row **
        inc Row
	ret

DoEffects:

	inc TickCnt

	xor ebp,ebp
DoEffectsLoop:

        movzx edx,ChVCommand[ebp]
	cmp edx,MaxVolCmd
	jae NoDoVCmd
	call DoVolTable[4*edx]
NoDoVCmd:

        movzx edx,ChCommand[ebp]
	cmp edx,MaxCmd
	jae NoDoCmd
	call DoCmdTable[4*edx]
NoDoCmd:

	inc ebp
	cmp ebp,SSActiveChannels
	jne DoEffectsLoop
	
	ret
PlayerTick Endp

;͸
; ProcRow: Process one pattern Row.                                       
;                                                                         
;

ProcRow proc
		
	mov ebp,0
ChannelLoop:

	mov esi,RowOffset

        xor eax,eax
        cmp esi,eax
        je StopEffects          ;RowOffset=0 => End of Row (Empty pattern)

; ** Check if it's the Row End (Row_End code) **
	movzx eax,byte ptr [esi]
        cmp al,Row_End
        jne DoReadChannelData

        add RowOffset,1
        jmp StopEffects          ;End of Row !

DoReadChannelData:
; ** Read Channel datas **

	add RowOffset,5         ;Go to the next channel datas

	mov CNote,ax
	mov ChRNote[ebp],al
        movzx eax,byte ptr [esi+1]
	mov CInstr,ax
        mov ChRInstrument[ebp],al
        movzx eax,byte ptr [esi+2]
	mov CVolume,ax
	
        movzx eax,byte ptr [esi+4]
	mov CParam,ax
	movzx eax,byte ptr [esi+3]

; If No Arpeggio, set CCom to 0FFh
	cmp eax,0
	jne TstArp
	cmp CParam,0
	jne TstArp
	mov al,0FFh
TstArp:
	mov CComm,ax

; ** Get Volume command value **

        mov CVComm,0FFh

        cmp CVolume,50h
	jbe No_VolCmd
        mov ax,CVolume    ; Volume>=50h => Volume command
        mov CVolume,0
        sub ax,60h
	mov bx,ax
	shr ax,4
	mov CVComm,ax
        and bx,0Fh
	mov CVParam,bx
No_VolCmd:
        mov ax,CVolume
        mov ChRVolume[ebp],al

; ** Restore the period (after an arpeggio or a vibrato)

        mov ax,CComm
        cmp ChCommand[ebp],al ; If actual command is previous command
	je  NoRestorePeriod   ; don't restore the period.

        call USS_GetPeriod
	cmp ax,ChPeriod[2*ebp]
	je  NoRestorePeriod
	mov ax,ChPeriod[2*ebp]
	call USS_SetPeriod
NoRestorePeriod:

; ** Start a new note if there is no Note Delay **

        cmp CComm,49    ; Delay Note => Do not Start sound !
	je NoStartNote

        call StartNote  ; Process Row Instrument, Note and Volume

NoStartNote:

;                  *** Process Volume command ***

	movzx edx,CVComm
        movzx eax,CVParam
        mov ChVCommand[ebp],dl
	cmp edx,MaxVolCmd
	jae  NoProcVCmd
        call ProcVolTable[4*edx] ; Call command
NoProcVCmd:

;                     *** Process Command ***

        movzx eax,CParam
	movzx edx,CComm

        or eax,eax               ; Check if Command=0 and paramater=0
        jnz NoCmdCheckOk
        or edx,edx
        jnz NoCmdCheckOk
        mov dl,0FFh              ; Comm and Param=0 => 
NoCmdCheckOk:        

        cmp edx,MaxCmd
	jae  NoProcCmd        
        push edx
        call ProcCmdTable[4*edx] ; Call Command
        pop edx
NoProcCmd:
        mov ChCommand[ebp],dl    ; Save this here so the command proc can
                                 ; check the previous command number

; ** Loop to the next channel **	
	inc ebp                  ; Next channel
        cmp ebp,USMChannels
	jne ChannelLoop          ; Loop

	ret

StopEffects:

StopEffectsLoop:
        mov ChCommand[ebp],0FFh
        mov ChVCommand[ebp],0FFh
        inc ebp                  ; Next channel
        cmp ebp,USMChannels
        jne StopEffectsLoop
        ret
ProcRow endp

;͸
; StartNote: Process Row Instrument, Note and Volume                      
;                                                                         
;

StartNote Proc
	mov Do_SetSampleDef,0

;       **** Process Instrument ****

	cmp CInstr,0
	je NoInstrument
	
        mov ax,CInstr
	mov ChInstrument[ebp],al ; Set new Instrument number.

; Now, retrig all needed  commands and values.
; (As it was not done in mxm play)

        call USS_InitInstrEnv    ; Retrig instrument envelopes.

        mov Do_SetSampleDef,1	 ; Set Volume and Panning to Sample values.

        mov ChTremorPos[ebp],0   ; Retrig Tremor

        test USMFlags,F_NoMRetrReset
        jnz NoClearRetrigCnt
        mov ChMRetrigCnt[ebp],0  ; Clear multi retrig counter.
NoClearRetrigCnt:

        cmp ChVibWave[ebp],4     ; Retrig Vibrato ? (VibWave>4)
        jae NoRetrigVib
        mov ChVibPos[ebp],0      ; Retrig Vibrato
NoRetrigVib:
        cmp ChTremWave[ebp],4    ; Retrig Tremolo ? (TremWave>4)
        jae NoRetrigTrem
        mov ChTremPos[ebp],0     ; Retrig Tremolo
NoRetrigTrem:

NoInstrument:

;       **** Process Note **** ( Start Instrument )

        cmp CNote,Key_Off
        jne No_Key_Off
        call USS_KeyOff
        jmp NoNote
No_Key_Off:
        cmp CNote,Note_Cut
        jne No_Note_Cut
        call USS_NoteCut
        jmp NoNote
No_Note_Cut:
        cmp CNote,Note_Fade
        jne No_Note_Fade
        call USS_NoteFade
        jmp NoNote
No_Note_Fade:

        cmp CNote,0
        je  NoNote
	
        cmp CComm,_PortaNote    ; Portamento to note
        je  NoNote
        cmp CComm,_ITPortaNote    ; Portamento to note
        je  NoNote
        cmp CVComm,_VPortaNote  ; 'Volume' Portamento to note
        je  NoNote

        xor ebx,ebx
        mov bx,CNote
        mov ChNote[ebp],bl

        xor eax,eax
        mov al,ChInstrument[ebp]
        call StartInstrument
;       jnc  NoNote             ;@@
;       mov ChInstrument[ebp],0
NoNote:

; ** Set Sample default values (Volume/Panning)  **
; *  It's done when an instrument number is set.  *


        cmp Do_SetSampleDef,0   ; Set Sample Default values ?
        je NoSetPanning


        call USS_GetSampleVolume ; Get channel default volume.
        jc NoSetPanning

        mov ChVolume[ebp],al    ; Channel volume is sample volume.
        call USS_SetVolume
NoSetSampleVol:

        call USS_GetSamplePanning
        jc NoSetPanning

        mov ChPanning[ebp],al   ; Channel panning is sample panning.
        call USS_SetPanning
NoSetPanning:

;       **** Process Volume ****

        cmp CVolume,0
        je  NoVolume
        sub CVolume,10h

        mov ax,CVolume
        mov ChVolume[ebp],al
        call USS_SetVolume
NoVolume:
        ret
StartNote Endp

StartInstrument Proc
	cmp eax,0
	je  StartInstrumentEnd
	dec eax
	call USS_StartInstrument
	call USS_GetPeriod
	mov ChPeriod[2*ebp],ax
StartInstrumentEnd:
	ret
StartInstrument Endp

;͸
; DoChangeOrder: Changes the current Order                                
;                                                                         
;

DoChangeOrder proc
	movzx eax,NextOrder
	mov esi,USMOffset

	cmp ax,MSongLen[esi]
	jb  SongLengthOk
	mov _MusicEnd,1
	mov ax,MRestart[esi] ;Loop the song
SongLengthOk:
	mov Order,ax

	movzx eax,MOrder[esi+eax]
        mov Pattern,ax
        mov eax,MPattPtr[esi+4*eax]
	cmp eax,0
	jne PatternNotEmpty
        mov bx,64               ; Play a 64 Rows Empty pattern.
	jmp ChangeOrderEnd
PatternNotEmpty:
	mov bx,PRow[eax]
ChangeOrderEnd:
        mov PatternOffset,eax
        mov Rows,bx
	
	mov NextOrder,-1        ; Reset order value
	ret
DoChangeOrder endp

;͸
; DoChangeRow: Changes the current Row                                    
;                                                                         
;

DoChangeRow proc
	movzx eax,NextRow
        mov edx,PatternOffset
        xor ebx,ebx
        cmp edx,ebx             
        je RowOffsetFound       ; PatternOffset=0 => RowOffset=0
        cmp PRow[edx],ax
        ja  RowNumberOk
        xor eax,eax             ; Wrong Row number ! (Row > Pattern length)
RowNumberOk:
        mov Row,ax
        add edx,USMPatternSize
        cmp ax,0
        je  RowOffsetFound

GetRowOffsetLoop:
        mov ebx,USMChannels
ChnGetRowOffsetLoop:
        cmp byte Ptr [edx],Row_End
        jne @@NextChannel
        inc edx
        Jmp @@NextRow
@@NextChannel:
        add edx,NoteSize
        dec ebx
        jnz ChnGetRowOffsetLoop
@@NextRow:
        dec eax
        jnz GetRowOffsetLoop

;dwrite 'Row!=0'
RowOffsetFound:
        mov RowOffset,edx

        mov NextRow,-1          ; Reset Row value
	ret
DoChangeRow Endp

;                     ***********************
;                     * Commands processing *
;                     ***********************
;
; PT  : ProTracker
; ST2 : Scream Tracker 2
; ST3 : Scream Tracker 3
; FT2 : Fast Tracker 2
; IT  : Impulse Tracker

;͸
;o                     Process Nothing                                    
;                                                                         
; Compatible with: FT2                                                    
;
ProcNothing proc
	ret
ProcNothing endp

;͸
;o                     Process Set Tempo command                          
;                                                                         
; Used by       : PT  ST2 ST3 FT2 IT                                      
; Compatibility : x   x   x   x   x                                       
;

ProcSetTempo proc
if UseSetTempo Eq Yes   ;*
        mov Speed,al
endif
        ret
ProcSetTempo endp

;͸
;o                     Process Set BPM command / BPM Slide                
;                                                                         
; Used by       : PT  ST3 FT2 IT                                          
; Compatibility : x   x   x   x                                           
;

if UseITSetBPM Eq Yes
ProcITSetBPM proc
        or al,al
        je UseOldBPMSlideData
        mov ChBPMSlideData[ebp],al
UseOldBPMSlideData:        
        cmp al,20h
        jbe ProcITSetBPMEnd
        call ProcSetBPM
ProcITSetBPMEnd:        
        ret
ProcITSetBPM endp
else
ProcITSetBPM Equ ProcNothing
endif

;͸
;o                     Process Set BPM command                            
;                                                                         
; Used by       : PT  ST3 FT2 IT                                          
; Compatibility : x   x   x   x                                           
;

ProcSetBPM proc
        or al,al
        jz NoProcSetBPM
        mov BPM,al
        movzx ebx,al
        shl bx,1
        xor edx,edx
        mov eax,1193180*5
        div ebx
        mov BPMVal,eax
NoProcSetBPM:
        ret
ProcSetBPM endp

;͸
;o                   Process Set Tempo/BPM command                        
;                                                                         
; Used by       : PT  ST2 ST3 FT2 IT                                      
; Compatibility : x   x   x   x   x                                       
;

ProcSetTempo_BPM proc
if UseSetBPM Eq Yes     ;*
        cmp al,20h      ; If Speed>20h, Set BPM
	jb SetTempo
	jmp ProcSetBPM
SetTempo:
endif
if UseSetTempo Eq Yes   ;*
        mov Speed,al
endif
        ret
ProcSetTempo_BPM endp

;͸
;o                     Process Arpeggio command                           
;                                                                         
; Used by       : PT  ST2 ST3 FT2 IT                                      
; Compatibility :             x                                           
;

if UseArpeggio Eq Yes   ;*
ProcArpeggio proc
	mov ChArpeggioData[ebp],al
	mov ChArpeggioPos[ebp],0
	jmp DoArpeggio
	ret
ProcArpeggio endp
else
ProcArpeggio Equ ProcNothing
endif

;͸
;o                     Process IT Portamento command                      
;                                                                         
; Used by       : ST3 IT                                                  
; Compatibility :     x                                                   
;
if (UseITPortUp Eq Yes) or (UseITPortDown Eq Yes) or (UsePortaNote)
ProcITPitch Proc
        cmp al,0
	je ProcITPitchNext
	mov ChITPitchData[ebp],al
ProcITPitchNext:
	mov al,ChITPitchData[ebp]

        cmp dl,_ITPitchDn
        jne NoProcPitchDn
        jmp ProcITPitchDn
NoProcPitchDn:
        cmp dl,_ITPitchUp
        jne NoProcPitchUp
        jmp ProcITPitchUp
NoProcPitchUp:
        cmp dl,_ITPortaNote
        jne NoProcPortaNote
        jmp ProcPortaNote
NoProcPortaNote:

        ret
ProcITPitch Endp
else
ProcITPitch Equ ProcNothing
endif

;͸
;o                   Process IT Portamento Up command                     
;                                                                         
; Used by       : ST3 IT                                                  
; Compatibility :     x                                                   
;

if UseITPortUp Eq Yes     ;*
ProcITPitchUp proc
        cmp al,0
	je ProcITPitchUpNext
	mov ChITPitchUpData[ebp],al
ProcITPitchUpNext:
	mov ChPortaUpData[ebp],0
	mov al,ChITPitchUpData[ebp]
        mov bl,al
        and bl,0F0h
        cmp bl,0F0h             ; FFx Fine portamento Up
        jne NoITFinePitchUp
        and al,0Fh
        jmp ProcFPortUp
NoITFinePitchUp:
        cmp bl,0E0h             ; FEx Extra fine portamento down
        jne NoITEFinePitchUp
        and al,0Fh
        or al,10h               ; 1, Extra fine portamento Up
        jmp ProcEFPort
NoITEFinePitchUp:        
        jmp ProcPortUp
        
ProcITPitchUp endp
else
ProcITPitchUp Equ ProcNothing
endif

;͸
;o                   Process IT Portamento Down command                   
;                                                                         
; Used by       : ST3 IT                                                  
; Compatibility :     x                                                   
;

if UseITPortDown Eq Yes   ;*
ProcITPitchDn proc
	cmp al,0
	je ProcITPitchDnNext
	mov ChITPitchDnData[ebp],al
ProcITPitchDnNext:

        mov ChPortaDownData[ebp],0
	mov al,ChITPitchDnData[ebp]
        mov bl,al
        and bl,0F0h
        cmp bl,0F0h             ; FFx Fine portamento Down
        jne NoITFinePitchDown
        and al,0Fh
        jmp ProcFPortDown
NoITFinePitchDown:
        cmp bl,0E0h             ; FEx Extra fine portamento Down
        jne NoITEFinePitchDown
        and al,0Fh
        or al,20h               ; 2, Extra fine portamento Down
        jmp ProcEFPort
NoITEFinePitchDown:
        jmp ProcPortDown
        ret
ProcITPitchDn endp
else
ProcITPitchDn Equ ProcNothing
endif

;͸
;o                     Process Portamento Up command                      
;                                                                         
; Used by       : PT  ST2 ST3 FT2 IT                                      
; Compatibility : x   x   x   x                                           
;

if (UsePortUp Eq Yes) or (UseITPortUp Eq Yes)     ;*
ProcPortUp proc
	cmp al,0
	je ProcPortUpEnd
	mov ChPortaUpData[ebp],al
ProcPortUpEnd:
	ret
ProcPortUp endp
else
ProcPortUp Equ ProcNothing
endif

;͸
;o                     Process Portamento Down command                    
;                                                                         
; Used by       : PT  ST2 ST3 FT2 IT                                      
; Compatibility : x   x   x   x                                           
;

if (UsePortDown Eq Yes) or (UseITPortDown Eq Yes)   ;*
ProcPortDown proc
	cmp al,0
	je ProcPortDownEnd
	mov ChPortaDownData[ebp],al
ProcPortDownEnd:
	ret
ProcPortDown endp
else
ProcPortDown Equ ProcNothing
endif

;͸
;o                     Process Porta To Note command                      
;                                                                         
; Used by       : PT  ST2 ST3 FT2 IT                                      
; Compatibility :             x                                           
;

if UsePortaNote Eq Yes  ;*
ProcPortaNote proc
	cmp al,0
	je ProcPortaNoteNext
	mov ChPortaToNoteData[ebp],al
ProcPortaNoteNext:
	cmp CNote,0
	je ProcPortaNoteEnd
	mov bx,CNote
	call USS_GetNotePeriod  ; Get the period from the note number
	mov ChPortaToNotePeriode[2*ebp],ax
ProcPortaNoteEnd:
	ret
ProcPortaNote endp
else
ProcPortaNote Equ ProcNothing
endif

;͸
;o               Process Vibrato-Fine vibrato commands                    
;                                                                         
; Used by       : PT  ST2 ST3 FT2 IT                                      
; Compatibility :             x   x                                       
;
; Note: Vibrato is retrig at Instrument start

if UseVibrato Eq Yes    ;*
ProcVibrato proc
        mov bl,al
	test al,0F0h
	jz NoVibSpeed
	shr bl,4
        shl bl,2
        mov ChVibSpeed[ebp],bl
NoVibSpeed:
	test al,0Fh
	jz NoVibDepth
	and al,0Fh
        cmp dl,_FineVibrato     ; Is it fine vibrato command ?
        je UseFineDepth
        shl al,2
UseFineDepth:
        test USMFlags,F_FineVibrato
        jnz FinerVibrato
        shl al,1
FinerVibrato:
        shr ChVibDepth[ebp],1
        mov ChVibDepth[ebp],al

NoVibDepth:

        test USMFlags,F_FineVibrato
        jz NoFinerVibrato
        call DoVibrato
NoFinerVibrato:
        ret
ProcVibrato endp
else
ProcVibrato Equ ProcNothing
endif

;͸
;o                     Process Tremolo command                            
;                                                                         
; Used by       : PT  ST3 FT2 IT                                          
; Compatibility :         x                                               
;
; Note: Tremolo is "Retriged" at Instrument start (in FT2).

if UseTremolo Eq Yes    ;*
ProcTremolo proc
	mov bl,al
	test al,0F0h
	jz NoTremSpeed
        shr bl,4
        shl bl,2
        mov ChTremSpeed[ebp],bl
NoTremSpeed:
	test al,0Fh
	jz NoTremDepth
	and al,0Fh
	mov ChTremdepth[ebp],al
NoTremDepth:
	ret
ProcTremolo endp
else
ProcTremolo Equ ProcNothing
Endif

;͸
;o                     Process Set Panning command                        
;                                                                         
; Used by       : PT  ST3 FT2 IT                                          
; Compatibility : x   x   x   x                                           
;

If UseSetPanning1 Eq Yes        ;*
ProcSetPanning1 proc
        mov ChPanning[ebp],al
        call USS_SetPanning
	ret
ProcSetPanning1 endp
else
ProcSetPanning1 Equ ProcNothing
endif

;͸
;o                     Process Set Panning command                        
;                                                                         
; Used by       : PT  ST3 FT2 IT                                          
; Compatibility : x   x   x   x                                           
;

If UseSetPanning2 Eq Yes        ;*
ProcSetPanning2 proc
        shl al,4
        mov ChPanning[ebp],al
        call USS_SetPanning
	ret
ProcSetPanning2 endp
else
ProcSetPanning2 Equ ProcNothing
endif

;͸
;o                     Process Sample Offset command                      
;                                                                         
; Used by       : PT  ST3 FT2 IT                                          
; Compatibility : x   x   x   x                                           
;

If UseSetOffset Eq Yes  ;*
ProcSetOffset proc
        cmp CNote,0
        je NoProcSetOffset
        shl ax,8
	call USS_SetSampleOffset
NoProcSetOffset:
        ret
ProcSetOffset Endp
else
ProcSetOffset Equ ProcNothing
endif

;͸
;o                     Process Volume Slide command                       
;                                                                         
; Used by       : PT  ST2 FT2                                             
; Compatibility : x   x   x                                               
;

if (UseVolumeSlide Eq Yes) or (UsePVolumeSlide Eq Yes) or (UseVVolumeSlide Eq Yes) ;*
ProcVolumeSlide proc
        cmp al,0
	je  ProcVSEnd
	mov ChVolumeSlideData[ebp],al
ProcVSEnd:

        test USMFlags,F_FastVS  ; Fast Volume slide ?
        jz NoCallDoVS
        call DoVolumeSlide
NoCallDoVS:

        ret
ProcVolumeSlide endp
else
ProcVolumeSlide Equ ProcNothing
Endif

;͸
;o                   Process IT Volume Slide command                      
;                                                                         
; Used by       : ST3 IT                                                  
; Compatibility : x   x                                                   
;

if (UseITVolumeSlide Eq Yes) or (UsePVolumeSlide Eq Yes) or (UseVVolumeSlide Eq Yes) ;*
ProcITVolSlide proc
        cmp al,0
	je  ProcITVSNext
        mov ChITVolumeSlideData[ebp],al
ProcITVSNext:
        mov ChVolumeSlideData[ebp],0
        mov al,ChITVolumeSlideData[ebp]

        cmp al,0Fh
        je No_DoFineVSDown      ; 0F -> Volume Slide down
        
        mov bl,al               ; xF -> Fine volume Slide up
        and bl,0Fh              
        cmp bl,0
        je No_DoFineVSDown      ; x0 -> Volume Slide up
        cmp bl,0Fh              
        jne No_DoFineVSUp
        shr al,4
        jmp ProcFVolumeUp
No_DoFineVSUp:

        mov bl,al
        shr bl,4
        cmp bl,0                ; 0x -> Volume Slide down
        je No_DoFineVSDown
        cmp bl,0Fh              ; Fx -> Fine volume Slide down
        jne No_DoFineVSDown
        and al,0Fh
        jmp ProcFVolumeDn
No_DoFineVSDown:

        mov ChVolumeSlideData[ebp],al

        test USMFlags,F_FastVS  ; Fast Volume slide ?
        jz NoCallDoITVS
        call DoVolumeSlide
NoCallDoITVS:

        ret
ProcITVolSlide endp
else
ProcITVolSlide Equ ProcNothing
Endif

;͸
;o               Process IT Channel Volume Slide command                  
;                                                                         
; Used by       : IT                                                      
; Compatibility : x                                                       
;

if (UseITChVolSlide Eq Yes) ;*
ProcITChVolSlide proc
        cmp al,0
	je  ProcITChVSNext
	mov ChITChVolumeSlideData[ebp],al
ProcITChVSNext:
        mov ChChVolumeSlideData[ebp],0
        mov al,ChITChVolumeSlideData[ebp]

        cmp al,0Fh
        je No_DoFineChVSDown    ; 0F -> Channel Volume Slide down
        
        mov bl,al               ; xF -> Channel Fine volume Slide up
        and bl,0Fh
        cmp bl,0
        je No_DoFineChVSDown    ; x0 -> Channel Volume Slide up
        cmp bl,0Fh
        jne No_DoFineChVSUp
        shr al,4
        mov bl,al
        call USS_GetChannelVolume
        add al,bl
        cmp al,40h
        jbe ChFVSlideUpOk
        mov al,40h
ChFVSlideUpOk:
        call USS_SetChannelVolume
        ret
No_DoFineChVSUp:

        mov bl,al
        shr bl,4
        cmp bl,0                ; 0x -> Channel Volume Slide down
        je No_DoFineChVSDown
        cmp bl,0Fh              ; Fx -> Channel Fine volume Slide down
        jne No_DoFineChVSDown
        and al,0Fh
        mov bl,al
        call USS_GetChannelVolume
        sub al,bl
        jnc ChFVSlideDnOk
        xor eax,eax
ChFVSlideDnOk:        
        call USS_SetChannelVolume
        ret
No_DoFineChVSDown:

        mov ChChVolumeSlideData[ebp],al
        ret
ProcITChVolSlide endp
else
ProcITChVolSlide Equ ProcNothing
Endif

;͸
;o               Process IT Global Volume Slide command                   
;                                                                         
; Used by       : IT                                                      
; Compatibility : x                                                       
;

if (UseITGVolSlide Eq Yes) ;*
ProcITGVolSlide proc
        cmp al,0
	je  ProcITGVSNext
	mov ChITGVolumeSlideData[ebp],al
ProcITGVSNext:
        mov ChGVolumeSlideData[ebp],0
        mov al,ChITGVolumeSlideData[ebp]

        cmp al,0Fh
        je ITGVSDown            ; 0F -> Global Volume Slide down
        
        mov bl,al               ; xF -> Global Fine volume Slide up
        and bl,0Fh
        cmp bl,0
        je ITGVSUp              ; x0 -> Global Volume Slide up
        cmp bl,0Fh
        jne No_DoFineGVSUp
        shr al,4
        mov bl,al

        call USS_GetGlobalVolume
        add al,bl
        call USS_SetGlobalVolume
        ret
No_DoFineGVSUp:

        mov bl,al
        shr bl,4
        cmp bl,0                ; 0x -> Global Volume Slide down
        je ITGVSDown
        cmp bl,0Fh              ; Fx -> Global Fine Volume Slide down
        jne No_DoFineGVSDown
        and al,0Fh
        mov bl,al

        call USS_GetGlobalVolume
        sub al,bl
        jnc GFVSlideDnOk
        xor eax,eax
GFVSlideDnOk:
        call USS_SetGlobalVolume
        ret
No_DoFineGVSDown:
ITGVSDown:
ITGVSUp:
        mov ChGVolumeSlideData[ebp],al
        ret
ProcITGVolSlide endp
else
ProcITGVolSlide Equ ProcNothing
Endif

;͸
;o                   Process IT Panning Slide command                     
;                                                                         
; Used by       : IT                                                      
; Compatibility : x                                                       
;

UseITPannSlide Equ No           ; Not complete...

if (UseITPannSlide Eq Yes) ;*
ProcITPannSlide proc
        cmp al,0
	je  ProcITPSNext
	mov ChITPanningSlideData[ebp],al
ProcITPSNext:
        mov ChPanningSlideData[ebp],0
        mov al,ChITPanningSlideData[ebp]

        cmp al,0Fh
        je ITPSRight            ; 0F -> Panning Slide right
        
        mov bl,al               ; xF -> Fine panning Slide left
        and bl,0Fh
        cmp bl,0
        je ITPSLeft             ; x0 -> Panning Slide left
        cmp bl,0Fh
        jne No_DoFinePSLeft
        shr al,4
        mov bl,al

        call USS_GetPanning
        shl bl,2
        sub al,bl
        jnc FPSlideLeftOk
        xor eax,eax
FPSlideLeftOk:        
        call USS_SetPanning
        ret
No_DoFinePSLeft:

        mov bl,al
        shr bl,4
        shl bl,2
        cmp bl,0                ; 0x -> Global Volume Slide down
        je ITPSRight
        cmp bl,0Fh              ; Fx -> Global Fine Volume Slide down
        jne No_DoFinePSRight
        and al,0Fh
        mov bl,al

        call USS_GetPanning
        add al,bl
        jnc FPSlideRightOk
        mov al,255
FPSlideRightOk:
        call USS_SetPanning
        ret
No_DoFinePSRight:
ITPSRight:
ITPSLeft:
        mov ChPanningSlideData[ebp],al
        ret
ProcITPannSlide endp
else
ProcITPannSlide Equ ProcNothing
Endif

;͸
;o                     Process Jump Pattern command                       
;                                                                         
; Used by       : PT  ST2 ST3 FT2 IT                                      
; Compatibility : x   x   x   x   x                                       
;

If UseJump Eq Yes       ;*
ProcJump proc
        mov NextOrder,ax  ; Jump to 'Param' Order and Row 0
	mov NextRow,0
	ret
ProcJump endp
else
ProcJump Equ ProcNothing
endif

;͸
;o                     Process Set Volume command                         
;                                                                         
; Used by       : PT  ST3 FT2 IT                                          
; Compatibility : x   x   x   x                                           
;

if UseSetVolume Eq Yes  ;*
ProcSetVolume proc
	mov ChVolume[ebp],al
	call USS_SetVolume
	ret
ProcSetVolume endp
else
ProcSetVolume Equ ProcNothing
endif

;͸
;o                     Process Pattern Break command                      
;                                                                         
; Used by       : PT  ST2 ST3 FT2 IT                                      
; Compatibility : x   x   x   x   x                                       
;

If UseBreak Eq Yes      ;*
ProcBreak proc
        mov ebx,eax
	shr eax,4
	imul eax,10
	and bl,0Fh
	add eax,ebx
ProcBreakHex:
        mov NextRow,ax
	cmp NextOrder,-1
	jne ChangeRow
	movzx ebx,Order
	inc ebx
	mov NextOrder,bx
ChangeRow:
        ret
ProcBreak endp
else
ProcBreak Equ ProcNothing
ProcBreakHex Equ ProcNothing
endif

;͸
;o                     Process Set Global Volume command                  
;                                                                         
; Used by       : ST3 FT2 IT                                              
; Compatibility : x   x   x                                               
;

If UseGVolume Eq Yes    ;*
ProcGVolume proc
	call USS_SetGlobalVolume
	ret
ProcGVolume endp
else
ProcGVolume Equ ProcNothing
endif

;͸
;o                     Process Global Volume Slide command                
;                                                                         
; Used by       : ST3 FT2 IT                                              
; Compatibility : x   x   x                                               
;

if UseGVolumeSlide Eq Yes       ;*
ProcGVolumeSlide proc
	cmp al,0
	je ProcGVolumeSlideEnd
	mov ChGVolumeSlideData[ebp],al
ProcGVolumeSlideEnd:
	ret
ProcGVolumeSlide endp
else
ProcGVolumeSlide Equ ProcNothing
endif

;͸
;o                    Process Set Channel Volume command                  
;                                                                         
; Used by       : IT                                                      
; Compatibility : x                                                       
;

If UseSetChVolume Eq Yes
ProcSetChVolume Proc
        cmp al,40h
        ja ProcSetChVolumeEnd
If UseChannelVolume eq Yes
        call USS_SetChannelVolume
endif
ProcSetChVolumeEnd:        
        ret
ProcSetChVolume Endp
else
ProcSetChVolume Equ ProcNothing
endif

;͸
;o                     Process Tick based commands                        
;                                                                         
;

ProcTick proc
        mov ChCommandTick[ebp],al
	movzx edx,CComm
	call DoCmdTable[4*edx]     ; Call for Tick 0
	ret
ProcTick endp

;͸
;x                     Process Set Envelope Pos command                   
;                                                                         
; Used by       : FT2 IT                                                  
; Compatibility :                                                         
;

If UseEnvPos Eq Yes     ;*
ProcEnvPos proc
        jmp USS_SetEnvPos
ProcEnvPos endp
else
ProcEnvPos Equ ProcNothing
endif

;͸
;o                     Process Pannig Slide command                       
;                                                                         
; Used by       : FT2 IT                                                  
; Compatibility : x   x                                                   
;
; Note: This Effect is reversed in MXM play...
;       (Slide from L to R instead of R to L)

if UsePanningSlide Eq Yes       ;*
ProcPanningSlide proc
	cmp al,0
	je ProcPanningSlideEnd
	mov ChPanningSlideData[ebp],al
ProcPanningSlideEnd:
	ret
ProcPanningSlide endp
else
ProcPanningSlide Equ ProcNothing
endif

;͸
;o                     Process Multi Retrig command                       
;                                                                         
; Used by       : ST3 FT2                                                 
; Compatibility : x   x                                                   
;
; Note: Multi Retrig counter is "Retriged" at Instrument start (in FT2)

if UseMRetrig Eq Yes       ;*
ProcMRetrig proc
        mov bl,al
	test al,0F0h
	jz NoMRetParam
	shr bl,4
	mov ChMRetrigParam[ebp],bl
NoMRetParam:
	test al,0Fh
	jz NoMRetSpeed
	and al,0Fh
	mov ChMRetrigSpeed[ebp],al
NoMRetSpeed:
        call DoMRetrig   ; Do Multi Retrig at Tick 0
	ret
ProcMRetrig endp
else
ProcMRetrig Equ ProcNothing
endif

;͸
;o                   Process IT Multi Retrig command                      
;                                                                         
; Used by       : ST3 IT                                                  
; Compatibility :                                                         
;
; It's ST3 Multi retrig because I'm using IT v2.11 and it's fully bugged :(
; (I will not implement a not working multi retrig !)

if UseITMRetrig Eq Yes       ;*
ProcITMRetrig proc
	cmp al,0
	je  UseOldITMRetrigParam
	mov ChITMRetrigParam[ebp],al
UseOldITMRetrigParam:
        mov al,ChITMRetrigParam[ebp]

        mov bl,al
	shr bl,4
	mov ChMRetrigParam[ebp],bl

        test al,0Fh
	jz NoITMRetSpeed
	and al,0Fh
	mov ChMRetrigSpeed[ebp],al
NoITMRetSpeed:
        cmp ChCommand[ebp],_ITMRetrig
        je NoITMRetrigCntClear
        mov ChMRetrigCnt[ebp],0  ; Clear multi retrig counter.
NoITMRetrigCntClear:        
        call DoITMRetrig   ; Do Multi Retrig at Tick 0
	ret
ProcITMRetrig endp
else
ProcITMRetrig Equ ProcNothing
endif

;͸
;o                     Process Tremor command                             
;                                                                         
; Used by       : ST2 ST3 FT2 IT                                          
; Compatibility :         x                                               
;
; Note: Tremor is "Retriged" at Instrument start (in FT2)
;       It's played as FT2 does, ST3 plays it differently.
;       FT2 was supposed to emulate ST Tremor, It's really strange.....
;       Anyway, it's one of the most buggy FT2 effect.

If UseTremor Eq Yes     ;*
ProcTremor proc
        cmp al,0
        je ProcTremorEnd
        shl eax,4
        shr al,4
        inc ah
        inc al
        add al,ah
        mov ChTremorLen[ebp],al
        mov ChTremorOff[ebp],ah
ProcTremorEnd:
        ret
ProcTremor endp
else
ProcTremor Equ ProcNothing
endif

;͸
;o                     Process Extra fine portamento command              
;                                                                         
; Used by       :  ST3 FT2 IT                                             
; Compatibility :      x   x                                              
;

If (UseEFPort Eq Yes) or (UseITPortDown Eq Yes) or (UseITPortUp Eq Yes) ;*
ProcEFPort proc
        shl eax,4
        shr al,4
        cmp ah,1
        je EFPortUp
        cmp ah,2
        jne ProcEFPortEnd

        cmp al,0
        je EFPortDPrevData
        mov ChEFPortaDData[ebp],al
EFPortDPrevData:
	movzx eax,ChEFPortaDData[ebp]
	add ax,ChPeriod[2*ebp]

	call USS_SetPeriod
        mov ChPeriod[2*ebp],ax
        ret

EFPortUp:
        cmp al,0
        je EFPortUPrevData
        mov ChEFPortaUData[ebp],al
EFPortUPrevData:
	movzx ebx,ChEFPortaUData[ebp]
	movzx eax,ChPeriod[2*ebp]
	sub eax,ebx
_EFTooLow:

	call USS_SetPeriod
        mov ChPeriod[2*ebp],ax
ProcEFPortEnd:
	ret
ProcEFPort endp
else
ProcEFPort Equ ProcNothing
endif

;͸
;o                     Process Fine Portamento Up command                 
;                                                                         
; Used by       : PT  ST3 FT2 IT                                          
; Compatibility : x   x   x   x                                           
;

if UseFPortUp Eq Yes    ;*
ProcFPortUp proc
        cmp al,0
	je ProcFPortUpEnd
	mov ChFPortaUpData[ebp],al
ProcFPortUpEnd:
	movzx ebx,ChFPortaUpData[ebp]
	shl ebx,2
	movzx eax,ChPeriod[2*ebp]
	sub eax,ebx
	call USS_SetPeriod
	mov ChPeriod[2*ebp],ax
        ret
ProcFPortUp endp
else
ProcFPortUp Equ ProcNothing
endif

;͸
;o                     Process Fine Portamento Down command               
;                                                                         
; Used by       : PT  ST3 FT2 IT                                          
; Compatibility : x   x   x   x                                           
;

if UseFPortDown Eq Yes  ;*
ProcFPortDown proc
	cmp al,0
	je ProcFPortDownEnd
	mov ChFPortaDownData[ebp],al
ProcFPortDownEnd:
	movzx eax,ChFPortaDownData[ebp]
	shl eax,2
	add ax,ChPeriod[2*ebp]
	call USS_SetPeriod
	mov ChPeriod[2*ebp],ax
        ret
ProcFPortDown endp
else
ProcFPortDown Equ ProcNothing
endif

;͸
;x                     Process Glissando Control command                  
;                                                                         
; Used by       : PT  ST3 FT2 IT                                          
; Compatibility :                                                         
;

if UseGliss Eq Yes      ;*
ProcGliss proc
	ret
ProcGliss endp
else
ProcGliss Equ ProcNothing
endif

;͸
;o                     Process Vibrato Type command                       
;                                                                         
; Used by       : PT  ST3 FT2 IT                                          
; Compatibility : x   x   x   x                                           
;

if UseVibType Eq Yes    ;*
ProcVibType proc
	mov ChVibWave[ebp],al   ; That's easy, I love this command. ;-)
	ret
ProcVibType endp
else
ProcVibType Equ ProcNothing
endif

;͸
;o                     Process Pattern Loop command                       
;                                                                         
; Used by       : PT  ST3 FT2 IT                                          
; Compatibility : x   x   x   x                                           
;

if UsePatLoop Eq Yes    ;*
ProcPatLoop proc
        or al,al
        jz SetLoopStart
        inc al
        cmp ChPatLoopCount[ebp],0
        jne Not_First_Loop
        mov ChPatLoopCount[ebp],al
Not_First_Loop:
        dec ChPatLoopCount[ebp]
        jz ProcPatLoopEnd
        mov al,ChPatLoopRow[ebp]
        mov NextRow,ax
        mov ax,Order
        mov NextOrder,ax
        ret
SetLoopStart:
        mov ax,Row
        mov ChPatLoopRow[ebp],al
ProcPatLoopEnd:
        ret
ProcPatLoop endp
else
ProcPatLoop Equ ProcNothing
endif

;͸
;o                     Process Tremolo Type command                       
;                                                                         
; Used by       : PT  ST3 FT2 IT                                          
; Compatibility : x   x   x   x                                           
;

if UseTremType Eq Yes   ;*
ProcTremType proc
	mov ChTremWave[ebp],al
	ret
ProcTremType endp
else
ProcTremType Equ ProcNothing
endif

;͸
;o                     ProcessFine Volume Up command                      
;                                                                         
; Used by       : PT  ST3 FT2 IT                                          
; Compatibility : x   x   x   x                                           
;

If UseFVolumeUp Eq Yes  ;* @
ProcFVolumeUp proc
	cmp al,0
	je  ProcFVSlideUpEnd
	mov ChFVolumeSlideUpData[ebp],al
ProcFVSlideUpEnd:
	mov al,ChVolume[ebp]
	mov bl,ChFVolumeSlideUpData[ebp]
	add al,bl
	cmp al,40h
	jbe DoFVSUpOk
	mov al,40h
DoFVSUpOk:
	mov ChVolume[ebp],al
	call USS_SetVolume
	ret
ProcFVolumeUp endp
else
ProcFVolumeUp Equ ProcNothing
endif

;͸
;o                     Process Fine Volume Down command                   
;                                                                         
; Used by       : PT  ST3 FT2 IT                                          
; Compatibility : x   x   x   x                                           
;

if UseFVolumeDn Eq Yes   ;*
ProcFVolumeDn proc
	cmp al,0
	je  ProcFVSlideDownEnd
	mov ChFVolumeSlideDownData[ebp],al
ProcFVSlideDownEnd:
	mov al,ChVolume[ebp]
	mov bl,ChFVolumeSlideDownData[ebp]
	sub al,bl
	jnc DoFVSDownOk
	mov al,0
DoFVSDownOk:
	mov ChVolume[ebp],al
	call USS_SetVolume
	ret
ProcFVolumeDn endp
else
ProcFVolumeDn Equ ProcNothing
endif

;͸
;o                     Process Pattern Delay command                      
;                                                                         
; Used by       : PT  ST3 FT2 IT                                          
; Compatibility : x   x   x   x                                           
;

if UsePatternDelay Eq Yes       ;*
ProcPatternDelay proc
	mov PatternDelay,al
	ret
ProcPatternDelay endp
else
ProcPatternDelay Equ ProcNothing
endif

;͸
;o                     Process Synchro command                            
;                                                                         
; Compatible with: FT2 (That's my command...)                             
;

if UseSynchro Eq Yes
ProcSynchro proc
        mov _SynchroVal,al
        inc _SynchroCount
	ret
ProcSynchro endp
else
ProcSynchro Equ ProcNothing
endif

;                  *********************************
;                  **** Command tick procedures ****
;                  *********************************

;͸
;o                     Do BPM Slide command                               
;                                                                         
; Used by       :  IT                                                     
; Compatibility :  x                                                      
;

DoBPMSlide Proc
        mov bl,ChBPMSlideData[ebp]
        cmp bl,20h
        jae DoBPMSlideEnd

        mov al,BPM
        cmp bl,10
        jb DoBPMSlideDown
                                ; 1x BPM Slide up
        and bl,0Fh
        add al,bl
        jnc BPMSlideOk
        mov al,0FFh
        jmp BPMSlideOk

DoBPMSlideDown:                 ; 0x BPM Slide down
        and bl,0Fh
        sub al,bl
        jnc BPMSlideDnTest2
        mov al,20h
BPMSlideDnTest2:
        cmp al,20h
        ja BPMSlideOk
        mov al,20h
BPMSlideOk:
        call ProcSetBPM
DoBPMSlideEnd:
        ret
DoBPMSlide Endp

;͸
;o                     Do Arpeggio command                                
;                                                                         
; Used by       : PT  ST2 ST3 FT2 IT                                      
; Compatibility :             x                                           
;

if UseArpeggio Eq Yes   ;*
DoArpeggio proc
        movzx eax,ChNote[ebp]
        movzx ecx,ChArpeggioPos[ebp]
        mov bl,ChArpeggioData[ebp]
        cmp cl,0
        je DoArpeggioSN
        cmp cl,1
        jne DoArpeggio2
        shr bl,4
        add al,bl
        jmp DoArpeggioSN
DoArpeggio2:
        and bl,0Fh
        add al,bl
DoArpeggioSN:
        inc cl
        cmp cl,3
        jne DoArpeggioEnd
        mov cl,0
DoArpeggioEnd:
        mov ChArpeggioPos[ebp],cl

        call USS_SetNote
        ret
DoArpeggio Endp
else
DoArpeggio Equ ProcNothing
endif

;͸
;o                     Do Portamento Up command                           
;                                                                         
; Used by       : PT  ST2 ST3 FT2 IT                                      
; Compatibility : x   x   x   x   x                                       
;

If UsePortUp Eq Yes     ;*
DoPortamentoUp proc
        movzx ebx,ChPortaUpData[ebp]
        shl ebx,2
        movzx eax,ChPeriod[2*ebp]
        sub eax,ebx
        call USS_SetPeriod
        mov ChPeriod[2*ebp],ax
        jc TooHighPitch
        ret
TooHighPitch:
        test USMFlags,F_CutHighPitch
        jz NoCutHighPitch
        call USS_NoteCut
NoCutHighPitch:        
        ret
DoPortamentoUp Endp
else
DoPortamentoUp Equ ProcNothing
endif

;͸
;o                     Do Portamento Down command                         
;                                                                         
; Used by       : PT  ST2 ST3 FT2 IT                                      
; Compatibility : x   x   x   x   x                                       
;

if UsePortDown Eq Yes   ;*
DoPortamentoDown proc
        movzx eax,ChPortaDownData[ebp]
        shl eax,2
        add ax,ChPeriod[2*ebp]
        call USS_SetPeriod
        mov ChPeriod[2*ebp],ax
        ret
DoPortamentoDown Endp
else
DoPortamentoDown Equ ProcNothing
endif

;͸
;o                     Do Porta to note command                           
;                                                                         
; Used by       : PT  ST2 ST3 FT2 IT                                      
; Compatibility :             x                                           
;

if UsePortaNote Eq Yes  ;*
DoPortaNote proc
        xor ecx,ecx
        xor eax,eax
        movzx bx,ChPortaToNoteData[ebp]
        shl bx,2
        mov ax,ChPeriod[2*ebp]
        mov cx,ChPortaToNotePeriode[2*ebp]

        cmp cx,0
        je DoPortaNoteEnd
        cmp ax,cx
        ja  DoPortaU
        je  DoPortaNoteEnd
        add ax,bx
        cmp ax,cx
        jbe DoPortaNoteOk
        mov ax,cx
DoPortaU:
        cmp ax,bx
        ja  DoPortaUOk
        mov ax,cx
        jmp DoPortaNoteOk
DoPortaUOk:
        sub ax,bx
        cmp ax,cx
        jae DoPortaNoteOk
        mov ax,cx
DoPortaNoteOk:
        call USS_SetPeriod
        mov ChPeriod[2*ebp],ax
DoPortaNoteEnd:
        ret
DoPortaNote Endp
else
DoPortaNote Equ ProcNothing
endif

;͸
;o                     Do Vibrato command                                 
;                                                                         
; Used by       : PT  ST2 ST3 FT2 IT                                      
; Compatibility :             x                                           
;

if (UseVibrato Eq Yes)  ;*
DoVibrato proc
        mov ch,ChVibSpeed[ebp]
        mov cl,ChVibWave[ebp]
        and cl,3
        movzx edx,ChVibDepth[ebp]
        movzx ebx,ChVibPos[ebp]
        call GetVibData            ; Get Vibrato data
        sar cx,8                   ; Not 9, because periode is 4 times bigger
        mov ChVibPos[ebp],bl
        mov ax,ChPeriod[2*ebp]

        add ax,cx
        call USS_SetPeriod
        ret
DoVibrato endp
else
DoVibrato Equ ProcNothing
endif

;͸
;o                     Do Porta To Note+Volume Slide command              
;                                                                         
; Used by       : PT  ST3 FT2 IT                                          
; Compatibility : x   x   x   x                                           
;

if UsePVolumeSlide Eq Yes       ;*
DoPortVol proc
        call DoVolumeSlide  ; Do Volume Slide
        jmp  DoPortaNote    ; Do Porta to note
DoPortVol Endp
else
DoPortVol Equ ProcNothing
endif

;͸
;o                     Do Vibrato+Volume Slide command                    
;                                                                         
; Used by       : PT  ST2 ST3 FT2 IT                                      
; Compatibility : x   x   x   x   x                                       
;

if UseVVolumeSlide Eq Yes       ;*
DoVibVol proc
;write 'vvs'
        call DoVolumeSlide
        jmp  DoVibrato
DoVibVol endp
else
DoVibVol Equ ProcNothing
endif

;͸
;o                     Do Tremolo command                                 
;                                                                         
; Used by       : PT  ST3 FT2 IT                                          
; Compatibility :         x                                               
;

if UseTremolo Eq Yes     ;*
DoTremolo proc
        mov ch,ChTremSpeed[ebp]
        mov cl,ChTremWave[ebp]
        and cl,3
        movzx dx,ChTremdepth[ebp]
        movzx ebx,ChTremPos[ebp]
        call GetVibData            ; Get Tremolo data
        sar cx,6
        mov ChTremPos[ebp],bl
        mov al,ChVolume[ebp]
        or cx,cx
        js _TDNeg
        add al,cl
        cmp al,40h
        jbe DoTremEnd
        mov al,40h
        jmp DoTremEnd
_TDNeg:
        add al,cl
        cmp al,40h
        jbe DoTremEnd
        xor eax,eax
DoTremEnd:
        call USS_SetVolume
        ret
DoTremolo Endp
else
DoTremolo Equ ProcNothing
endif

;͸
;o                     Do Volume Slide command                            
;                                                                         
; Used by       : PT  ST2 ST3 FT2 IT                                      
; Compatibility : x   x   x   x   x                                       
;

if (UseVolumeSlide Eq Yes) or (UsePVolumeSlide Eq Yes) or (UseVVolumeSlide Eq Yes) or (UseITVolumeSlide Eq Yes) ;*
DoVolumeSlide proc
        mov al,ChVolume[ebp]
        mov bl,ChVolumeSlideData[ebp]
        test bl,0F0h
        jnz VSUp
        sub al,bl
        jnc VSEnd
        xor al,al
        jmp VSEnd
VSUp:
        shr bl,4
        add al,bl
        cmp al,40h
        jbe VSEnd
        mov al,40h
VSEnd:
        mov ChVolume[ebp],al
        call USS_SetVolume
        ret
DoVolumeSlide Endp
else
DoVolumeSlide Equ ProcNothing
endif

;͸
;o                 Do Channel Volume Slide command                        
;                                                                         
; Used by       : IT                                                      
; Compatibility : x                                                       
;

if (UseITChVolSlide Eq Yes)     ;*
DoChVolumeSlide proc
        call USS_GetChannelVolume
        mov bl,ChChVolumeSlideData[ebp]
        test bl,0F0h
        jnz CVSUp
        sub al,bl
        jnc CVSEnd
        xor al,al
        jmp CVSEnd
CVSUp:
        shr bl,4
        add al,bl
        cmp al,40h
        jbe CVSEnd
        mov al,40h
CVSEnd:
        call USS_SetChannelVolume
        ret
DoChVolumeSlide Endp
else
DoChVolumeSlide Equ ProcNothing
endif

;͸
;o                     Do Global VolumeSlide command                      
;                                                                         
; Used by       : ST3 FT2 IT                                              
; Compatibility : x   x   x                                               
;

if UseGVolumeSlide Eq Yes       ;*
DoGVolumeSlide proc
        call USS_GetGlobalVolume
        mov bl,ChGVolumeSlideData[ebp]
        test bl,0F0h
        jnz GVSUp
        test USMFlags,F_BigGVolSlide
        jz NoBigGVolDn
        shl bl,1
NoBigGVolDn:    
        sub al,bl
        jnc GVSEnd
        xor al,al
        jmp GVSEnd
GVSUp:
        shr bl,4
        test USMFlags,F_BigGVolSlide
        jz NoBigGVolUp
        shl bl,1
NoBigGVolUp:        
        add al,bl       ; Do not test if volume>40h, it's done in SetGlobalVol
GVSEnd:
	call USS_SetGlobalVolume
	ret
DoGVolumeSlide endp
else
DoGVolumeSlide Equ ProcNothing
endif

;͸
;o                       Do Key Off command                               
;                                                                         
; Used by       : PT  ST3 FT2 IT                                          
; Compatibility : x   x   x   x                                           
;

if UseKeyOff Eq Yes     ;*
DoKeyOff proc
        mov al,ChCommandTick[ebp]
        cmp al,TickCnt
        jne DoKeyOffEnd
        call USS_KeyOff
DoKeyOffEnd:
        ret
DoKeyOff endp
else
DoKeyOff Equ ProcNothing
endif

;͸
;o                     Do Panning Slide command                           
;                                                                         
; Used by       : ST3 FT2 IT                                              
; Compatibility : x   x   x                                               
;

if UsePanningSlide Eq Yes       ;*
DoPanningSlide proc
        call USS_GetPanning
        mov bl,ChPanningSlideData[ebp]
        test bl,0F0h
        jnz PSRight
        sub al,bl
        jnc PSEnd
        xor al,al
        jmp PSEnd
PSRight:
        shr bl,4
        add al,bl
        jnc PSEnd
        mov al,0FFh
PSEnd:
        mov ChPanning[ebp],al
        call USS_SetPanning
        ret
DoPanningSlide Endp
else
DoPanningSlide Equ ProcNothing
endif

;͸
;o                      Do IT Multi Retrig command                        
;                                                                         
; Used by       : ST3 FT2 IT                                              
; Compatibility :     x                                                   
;

if (UseITMRetrig Eq Yes)    ;*
DoITMRetrig proc
        movzx ebx,ChMRetrigSpeed[ebp]
        movzx eax,ChMRetrigCnt[ebp]

        cmp al,bl
        jb  NotITMRetrig
        mov ChMRetrigCnt[ebp],0
        jmp DoMRetrig1
NotITMRetrig:
        inc ChMRetrigCnt[ebp]
        ret
DoITMRetrig Endp
else
DoITMRetrig Equ ProcNothing
endif

;͸
;o                      Do Multi Retrig command                           
;                                                                         
; Used by       : ST3 FT2 IT                                              
; Compatibility :     x                                                   
;

if (UseMRetrig Eq Yes) or (UseITMRetrig Eq Yes)    ;*
DoMRetrig proc
        mov bl,ChMRetrigSpeed[ebp]
        inc ChMRetrigCnt[ebp]
        cmp bl,ChMRetrigCnt[ebp]
        jne NotmRetrig
        mov ChMRetrigCnt[ebp],0
DoMRetrig1:

; Retrig the sample
        xor eax,eax
        call USS_SetSampleOffset   ; Sample Offset=0

; Now, Change the channel volume
        movzx eax,ChVolume[ebp]
        mov cl,ChMRetrigParam[ebp]

        cmp cl,8
        ja  MR_Up
        je NotmRetrig
        or cl,cl
        jz NotmRetrig

        cmp cl,6
        jae MR_Div

; Volume-(2^(cl-1))
        dec cl
        mov bl,1
        shl bl,cl
        sub al,bl
        jns mRetrigEnd
        mov al,0
        jmp mRetrigEnd

MR_Div:
        jne MR_Div2
; 6 => Volume*2/3
        shl al,1
        mov bl,3
        div bl
        jmp mRetrigEnd
MR_Div2:
; 7 => Volume*1/2
        shr al,1
        jmp mRetrigEnd
	
MR_Up:
        cmp cl,0Eh
        jae MR_Mul

; Volume+(2^(cl-9))
        sub cl,9
        mov bl,1
        shl bl,cl
        add al,bl
        jmp mRetrigCutHighVolume
MR_Mul:
        jne MR_Mul2
; E => Volume*3/2

        mov ah,al
        shl al,1
        add al,ah
        shr al,1
        jmp mRetrigCutHighVolume
MR_Mul2:
; F => Volume*2

        shl al,1

mRetrigCutHighVolume:
        cmp al,40h
        jbe mRetrigEnd
        mov al,40h
mRetrigEnd:

        mov ChVolume[ebp],al
        call USS_SetVolume
NotmRetrig:
        ret
DoMRetrig Endp
else
DoMRetrig Equ ProcNothing
endif

;͸
;o                         Do Tremor command                              
;                                                                         
; Used by       : ST2 ST3 FT2 IT                                          
; Compatibility :         x                                               
;

if UseTremor Eq Yes     ;*
DoTremor proc
        mov bl,ChTremorPos[ebp]
        mov al,ChVolume[ebp]
        cmp bl,ChTremorOff[ebp]
        jb  TremorOn
        xor al,al
TremorOn:
        inc bl
        cmp bl,ChTremorLen[ebp]
        jb  Tremor_ChangeVolume
        xor bl,bl
Tremor_ChangeVolume:
        mov ChTremorPos[ebp],bl
        call USS_SetVolume      ; Set new volume (0 or Channel volume)
        ret                     ; It only affect the sound system volume.
DoTremor Endp
else
DoTremor Equ ProcNothing
endif

;͸
;o                        Do Retrig command                               
;                                                                         
; Used by       : PT  ST3 FT2 IT                                          
; Compatibility : ?       x                                               
;

if UseRetrig Eq Yes     ;*
DoRetrig proc
        movzx ax,TickCnt
        cmp al,ChCommandTick[ebp]
        je _DoRetrig

        cmp ax,0
        je NotRetrig
        cmp ChCommandTick[ebp],0
        je NotRetrig

        div ChCommandTick[ebp]
        cmp ah,0
        jne NotRetrig
_DoRetrig:
        xor eax,eax
        call USS_SetSampleOffset
NotRetrig:
        ret
DoRetrig Endp
else
DoRetrig Equ ProcNothing
endif

;͸
;o                      Do Note Cut command                               
;                                                                         
; Used by       : PT  ST3 FT2 IT                                          
; Compatibility : ?       x                                               
;

if UseCutNote Eq Yes    ;*
DoNoteCut proc
        mov al,ChCommandTick[ebp]
        cmp al,TickCnt
        jne DoNoteCutEnd
        mov al,0             ; Set all the volumes to 0
        mov ChVolume[ebp],al
        call USS_SetVolume
DoNoteCutEnd:
        ret
DoNoteCut Endp
else
DoNoteCut Equ ProcNothing
endif

;͸
;o                      Do Note Delay command                             
;                                                                         
; Used by       : PT  ST3 FT2 IT                                          
; Compatibility : ?   x   x   x                                           
;

if UseNoteDelay Eq Yes  ;*
DoNoteDelay Proc
        mov al,ChCommandTick[ebp]
        cmp al,TickCnt             ; Is it time to start the note ?
        jne DoNoteDelayEnd

; Load the previous Row data. (Note, Instrument and Volume with no command)
        xor eax,eax
        mov al,ChRNote[ebp]
        mov CNote,ax
        mov al,ChRInstrument[ebp]
        mov CInstr,ax
        mov al,ChRVolume[ebp]
        mov CVolume,ax
        mov CComm,0FFh

; Start the note exactly as it is the tick 0.
        call StartNote

DoNoteDelayEnd:
        ret
DoNoteDelay Endp
else
DoNoteDelay Equ ProcNothing
endif

;                   **********************************
;                   * Process Volume column commands *
;                   **********************************

;͸
;o                     Set volume commands parameter                      
;                                                                         
; Used by       : FT2 IT                                                  
; Compatibility : x   ?                                                   
;
ProcSetVData Proc
        mov ChVolCmdData[ebp],al
        ret
ProcSetVData Endp

;͸
;o                     Process Volume fine down command                   
;                                                                         
; Used by       : FT2 IT                                                  
; Compatibility : x   ?                                                   
;

if UseVFVolDown Eq Yes  ;*
ProcVFVolDown Proc
        mov bl,al
        mov al,ChVolume[ebp]
        sub al,bl
        jnc ProcVFVolDownEnd
        xor al,al
ProcVFVolDownEnd:
        mov ChVolume[ebp],al
        call USS_SetVolume
        ret
ProcVFVolDown Endp
else
ProcVFVolDown Equ ProcNothing
endif

;͸
;o                     Process Volume fine up command                     
;                                                                         
; Used by       : FT2 IT                                                  
; Compatibility : x   ?                                                   
;

if UseVFVolUp Eq Yes    ;*
ProcVFVolUp Proc
        mov bl,al
        mov al,ChVolume[ebp]
        add al,bl
        cmp al,40h
        jbe ProcVFVolUpEnd
        mov al,40h
ProcVFVolUpEnd:
        mov ChVolume[ebp],al
        call USS_SetVolume
        ret
ProcVFVolUp Endp
else
ProcVFVolUp Equ ProcNothing
endif

;͸
;o                     Process "Volume" Set vibrato speed command         
;                                                                         
; Used by       : FT2 IT                                                  
; Compatibility : x   ?                                                   
;

If UseVSetVibSpeed Eq Yes       ;*
ProcSetVibSpeed proc
        cmp al,0
        je NoVibSpeed
        mov ChVibSpeed[ebp],al
NovVibSpeed:
        ret
ProcSetVibSpeed Endp
else
ProcSetVibSpeed Equ ProcNothing
endif

;͸
;o                     Process "Volume" Vibrato command                   
;                                                                         
; Used by       : FT2 IT                                                  
; Compatibility : x   ?                                                   
;

if UseVVibrato Eq Yes   ;*
ProcVVibrato proc
        cmp al,0
        je NoVibDepth
        shl al,2
        mov ChVibDepth[ebp],al
NovVibDephth:
        ret
ProcVVibrato Endp
else
ProcVVibrato Equ ProcNothing
endif

;͸
;o                     Process "Volume" Set Panning command               
;                                                                         
; Used by       : FT2 IT                                                  
; Compatibility : x   ?                                                   
;

if UseVPanning Eq Yes   ;*
ProcVPanning proc
        shl ax,4
        mov ChPanning[ebp],al
        call USS_SetPanning
        ret
ProcVPanning Endp
else
ProcVPanning Equ ProcNothing
endif

;͸
;o                     Process "Volume" Porta to note command             
;                                                                         
; Used by       : FT2 IT                                                  
; Compatibility : x   ?                                                   
;

if UseVPortaNote Eq Yes ;*
ProcVPortaNote proc
        shl al,4
        cmp al,0
        je ProcvPortanoteNext
        mov ChPortaToNoteData[ebp],al
ProcvPortanoteNext:
        cmp CNote,0
        je ProcvPortanoteEnd
        mov bx,CNote
        call USS_GetNotePeriod
        mov ChPortaToNotePeriode[2*ebp],ax
ProcvPortanoteEnd:
        ret
ProcVPortaNote Endp
else
ProcVPortaNote Equ ProcNothing
endif

;͸
;o                     Do "Volume" Volume Slide Down                      
;                                                                         
; Used by       : FT2 IT                                                  
; Compatibility : x   ?                                                   
;

if UseVVolSlideDown Eq Yes
DoVVolSlDown proc
        mov al,ChVolume[ebp]
        mov bl,ChVolCmdData[ebp]
        sub al,bl
        jnc DoVVolSlDownEnd
        xor al,al
DoVVolSlDownEnd:
        mov ChVolume[ebp],al
        call USS_SetVolume
        ret
DoVVolSlDown Endp
else
DoVVolSlDown Equ ProcNothing
endif

;͸
;o                     Do "Volume" Volume Slide Up                        
;                                                                         
; Used by       : FT2 IT                                                  
; Compatibility : x   ?                                                   
;

if UseVVolSlideUp Eq Yes   ;*
DoVVolSlUp Proc
        mov al,ChVolume[ebp]
        mov bl,ChVolCmdData[ebp]
        add al,bl
        cmp al,40h
        jbe DoVVolSlUpEnd
        mov al,40h
DoVVolSlUpEnd:
        mov ChVolume[ebp],al
        call USS_SetVolume
        ret
DoVVolSlUp Endp
else
DoVVolSlUp Equ ProcNothing
endif

;͸
;o                     Do "Volume" Panning Slide Left                     
;                                                                         
; Used by       : FT2 IT                                                  
; Compatibility : x   ?                                                   
;

if UseVPanSlideL Eq Yes ;*
DoVPanSlL Proc
        call USS_GetPanning
        mov bl,ChVolCmdData[ebp]
        sub al,bl
        jnc VPSlEnd
        xor al,al
VPSlEnd:
        mov ChPanning[ebp],al
        call USS_SetPanning
        ret
DoVPanSlL Endp
else
DoVPanSlL Equ ProcNothing
endif

;͸
;o                     Do "Volume" Panning Slide Right                    
;                                                                         
; Used by       : FT2 IT                                                  
; Compatibility : x   ?                                                   
;

if UseVPanSlideR Eq Yes ;*
DoVPanSlR Proc
        call USS_GetPanning
        mov bl,ChVolCmdData[ebp]
        add al,bl
        jnc VPSrEnd
        mov al,0FFh
VPSrEnd:
        mov ChPanning[ebp],al
        call USS_SetPanning
        ret
DoVPanSlR Endp
else
DoVPanSlR Equ ProcNothing
endif

;=============================================================================

MaxCmd EQU 68

; Command order is the FT2 Order, Commands not in FT2 will be add at the end

ProcCmdTable  label dword

;    Jump label         Number Name                    Source format
  dd ProcArpeggio      ;00-0xy Arpeggio                (MOD)
  dd ProcPortUp        ;01-1xx Portamento Up           (MOD)
  dd ProcPortDown      ;02-2xx Portamento Down         (MOD)
  dd ProcPortaNote     ;03-3xx Portamento to Note      (MOD)
  dd ProcVibrato       ;04-4xy Vibrato                 (MOD)
  dd ProcVolumeSlide   ;05-5xy Portamento+Volume Slide (MOD)
  dd ProcVolumeSlide   ;06-6xy Vibrato+Volume Slide    (MOD)
  dd ProcTremolo       ;07-7xy Tremolo                 (MOD)
  dd ProcSetPanning1   ;08-8xx Set Panning             (MOD/DMP)
  dd ProcSetOffset     ;09-9xx Set Sample Offset       (MOD)
  dd ProcVolumeSlide   ;10-Axy Volume Slide            (MOD)
  dd ProcJump          ;11-Bxx Jump to pattern         (MOD)
  dd ProcSetVolume     ;12-Cxx Set Volume              (MOD)
  dd ProcBreak         ;13-Dxx Pattern Break           (MOD)
  dd ProcNothing       ;14-Exy Extended Effects (24+x)
  dd ProcSetTempo_BPM  ;15-Fxx Set Speed/Set BPM       (MOD)

  dd ProcGVolume       ;16-Gxx Set Global Volume       (S3M/XM)
  dd ProcGVolumeSlide  ;17-Hxx Global Volume Slide     (XM)
  dd ProcNothing       ;18-I
  dd ProcNothing       ;19-J
  dd ProcTick          ;20-Kxx Key Off (after xx tick) (XM)
  dd ProcEnvPos        ;21-Lxx Set Envelope Pos        (XM)
  dd ProcNothing       ;22-M
  dd ProcNothing       ;23-N
  dd ProcNothing       ;24-O
  dd ProcPanningSlide  ;25-Pxx Panning Slide           (XM)
  dd ProcNothing       ;26-Q
  dd ProcMRetrig       ;27-Rxy Multi Retrig Note       (S3M)
  dd ProcNothing       ;28-S
  dd ProcTremor        ;29-Txy Tremor                  (STM)
  dd ProcNothing       ;30-U
  dd ProcNothing       ;31-V
  dd ProcSynchro       ;32-Wxx Synchro funtion
  dd ProcEFPort        ;33-Xxy Extra Fine Portamento   (S3M)
  dd ProcNothing       ;34-Y
  dd ProcNothing       ;35-Z

  dd ProcNothing       ;36-E0x Set Filter              (MOD) x
  dd ProcFPortUp       ;37-E1x Fine Portamento Up      (MOD)
  dd ProcFPortDown     ;38-E2x Fine Portamento Down    (MOD)
  dd ProcGliss         ;39-E3x Glissando Control       (MOD) x
  dd ProcVibType       ;40-E4x Set Vibrato Waveform    (MOD)
  dd ProcNothing       ;41-E5x Set Finetune            (MOD) x
  dd ProcPatLoop       ;42-E6x Pattern Loop            (MOD)
  dd ProcTremType      ;43-E7x Set Tremolo WaveForm    (MOD)
  dd ProcSetPanning2   ;44-E8x Unused/Set Panning      (MOD/S3M)
  dd ProcTick          ;45-E9x Retrig Note             (MOD)
  dd ProcFVolumeUp     ;46-EAx Fine Volume Slide Up    (MOD)
  dd ProcFVolumeDn     ;47-EBx Fine Volume Slide Down  (MOD)
  dd ProcTick          ;48-ECx Cut Note                (MOD)
  dd ProcTick          ;49-EDx Delay Note              (MOD)
  dd ProcPatternDelay  ;50-EEx Pattern Delay           (MOD)
  dd ProcSynchro       ;51-EFx Invert Loop, Synchro    (MOD) x
  dd ProcSetTempo      ;52-    Set Tempo
  dd ProcSetBPM        ;53-    Set BPM 
  dd ProcBreakHex      ;54-    Pattern Break (Hex)     (IT )
  dd ProcITSetBPM      ;55-    IT Set/Slide BPM        (IT )
  dd ProcITVolSlide    ;56-    IT Volume Slide/Fine VS (IT/S3M)
  dd ProcITPitch       ;57-Exx                         (IT/S3M)
  dd ProcITPitch       ;58-Fxx                         (IT/S3M)
  dd ProcITPitch       ;59-Gxx
  dd ProcITVolSlide    ;60-Kxy IT Vibrato+Volume Slide (IT/S3M)
  dd ProcITVolSlide    ;61-Lxy IT Portamento+Vol Slide (IT/S3M)
  dd ProcSetChVolume   ;62-Mxy Set Channel volume      (IT)
  dd ProcITChVolSlide  ;63-Nxy Channel volume slide    (IT)
  dd ProcNothing       ;64-Pxy Panning Slide           (IT)  x
  dd ProcITMRetrig     ;65-Qxy Multi retrig
  dd ProcVibrato       ;66-Uxy Fine Vibrato            (IT/S3M)
  dd ProcITGVolSlide   ;67-Wxy Global volume slide

;(65d au total)

DoCmdTable label dword
  dd DoArpeggio        ;00-0xy Arpeggio                (MOD)
  dd DoPortamentoUp    ;01-1xx Portamento Up           (MOD)
  dd DoPortamentoDown  ;02-2xx Portamento Down         (MOD)
  dd DoPortaNote       ;03-3xx Portamento to Note      (MOD)
  dd DoVibrato         ;04-4xy Vibrato                 (MOD)
  dd DoPortVol         ;05-5xy Portamento+Volume Slide (MOD)
  dd DoVibVol          ;06-6xy Vibrato+Volume Slide    (MOD)
  dd DoTremolo         ;07-7xy Tremolo                 (MOD)
  dd ProcNothing       ;08-8xx Set Panning             (MOD/DMP)
  dd ProcNothing       ;09-9xx Set Sample Offset       (MOD)
  dd DoVolumeSlide     ;10-Axy Volume Slide            (MOD)
  dd ProcNothing       ;11-Bxx Jump to pattern         (MOD)
  dd ProcNothing       ;12-Cxx Set Volume              (MOD)
  dd ProcNothing       ;13-Dxx Pattern Break           (MOD)
  dd ProcNothing       ;14-Exy Extended Effects (24+x)
  dd ProcNothing       ;15-Fxx Set Speed/Set BPM       (MOD)

  dd ProcNothing       ;16-Gxx Set Global Volume       (S3M/XM)
  dd DoGVolumeSlide    ;17-Hxx Global Volume Slide     (XM)
  dd ProcNothing       ;18-I
  dd ProcNothing       ;19-J
  dd DoKeyOff          ;20-Kxx Key Off (after xx tick) (XM)
  dd ProcNothing       ;21-Lxx Set Envelope Pos        (XM)
  dd ProcNothing       ;22-M
  dd ProcNothing       ;23-N
  dd ProcNothing       ;24-O
  dd DoPanningSlide    ;25-Pxx Panning Slide           (XM)
  dd ProcNothing       ;26-Q
  dd DoMRetrig         ;27-Rxy Multi Retrig Note       (S3M)
  dd ProcNothing       ;28-S
  dd DoTremor          ;29-Txy Tremor                  (STM)
  dd ProcNothing       ;30-U
  dd ProcNothing       ;31-V
  dd ProcNothing       ;32-Wxx Synchro function
  dd ProcNothing       ;33-Xxy Extra Fine Portamento   (S3M)
  dd ProcNothing       ;34-Y
  dd ProcNothing       ;35-Zxx Synchro function        (USM)

  dd ProcNothing       ;36-E0x
  dd ProcNothing       ;37-E1x Fine Portamento Up      (MOD)
  dd ProcNothing       ;38-E2x Fine Portamento Down    (MOD)
  dd ProcNothing       ;39-E3x Glissando Control       (MOD)
  dd ProcNothing       ;40-E4x Set Vibrato Waveform    (MOD)
  dd ProcNothing       ;41-E5x Set Finetune            (MOD)
  dd ProcNothing       ;42-E6x Pattern Loop            (MOD)
  dd ProcNothing       ;43-E7x Set Tremolo WaveForm    (MOD)
  dd ProcNothing       ;44-E8x Unused/Set Panning      (MOD/S3M)
  dd DoRetrig          ;45-E9x Retrig Note             (MOD)
  dd ProcNothing       ;46-EAx Fine Volume Slide Up    (MOD)
  dd ProcNothing       ;47-EBx Fine Volume Slide Down  (MOD)
  dd DoNoteCut         ;48-ECx Cut Note                (MOD)
  dd DoNoteDelay       ;49-EDx Delay Note              (MOD)
  dd ProcNothing       ;50-EEx Pattern Delay           (MOD)
  dd ProcNothing       ;51-EFx Synchro function
  dd ProcNothing       ;52-    Set Tempo 
  dd ProcNothing       ;53-    Set BPM
  dd ProcNothing       ;54-    Pattern Break (Hex)     (IT )
  dd DoBPMSlide        ;55-    IT Set/Slide BPM        (IT/S3M)
  dd DoVolumeSlide     ;56-Dxx IT Volume Slide/Fine VS (IT/S3M)
  dd DoPortamentoDown  ;57-Exx
  dd DoPortamentoUp    ;58-Fxx
  dd DoPortaNote       ;59-Gxx
  dd DoVibVol          ;60-Kxy IT Vibrato+Volume Slide (IT)
  dd DoPortVol         ;61-Lxy IT Portamento+Vol Slide (IT) ! A modifier
  dd ProcNothing       ;62-Mxx Set Channel Volume      (IT)
  dd DoChVolumeSlide   ;63-Nxy
  dd ProcNothing       ;64-Pxy IT Panning slide
  dd DoITMRetrig       ;65-Qxy IT Multi retrig
  dd DoVibrato         ;66-Uxy Fine Vibrato
  dd DoGVolumeSlide    ;67-Wxy



MaxVolCmd EQU 10

; Volume commands are processed as in FT2:
;
; 00h-09h -> Do nothing
; 10h-5Fh -> Set Volume (value-10h)
; 60h-FF  -> Process one of the following commands:

ProcVolTable label dword
  dd ProcSetVData     ; 6x Volume Slide down
  dd ProcSetVData     ; 7x Volume Slide up
  dd ProcVFVolDown    ; 8x Fine volume Slide down
  dd ProcVFVolUp      ; 9x Fine volume Slide up
  dd ProcSetVibSpeed  ; Ax SetVibSpeed
  dd ProcVVibrato     ; Bx Vibrato
  dd ProcVPanning     ; Cx Set Panning
  dd ProcSetVData     ; Dx Panning Slide left
  dd ProcSetVData     ; Ex Panning Slide right
  dd ProcVPortaNote   ; Fx Porta to note

DoVolTable label dword
  dd DoVVolSlDown
  dd DoVVolSlUp
  dd ProcNothing
  dd ProcNothing
  dd ProcNothing
  dd DoVibrato
  dd ProcNothing
  dd DoVPanSlL
  dd DoVPanSlR
  dd DoPortaNote

CODE32 ENDS
end
