; woorlic Truecolor lib , tclib.asm
; Main interface file
; **********************************************************************
;  Start
.386
;  Start
; **********************************************************************
;  Publics
public init_tc
public start_tc
public blit_tc
public kill_tc

public tcono
public _tcono
;  Publics
; **********************************************************************
;  Code
code32 segment public use32 'code'
assume cs:code32,ds:code32,es:code32

; Data
;  Virtual screen pointer
tcono    dd    0
_tcono   dd    0

; Number of modes
tc_modes dd    0
; Modes list
;             Mode    Width    Height   Bpp   Type
tc_model dd    0   ,    0    ,   0    ,  0   , 0
         dd    0   ,    0    ,   0    ,  0   , 0
         dd    0   ,    0    ,   0    ,  0   , 0
         dd    0   ,    0    ,   0    ,  0   , 0
         dd    0   ,    0    ,   0    ,  0   , 0
         dd    0   ,    0    ,   0    ,  0   , 0
         dd    0   ,    0    ,   0    ,  0   , 0

tc_type  dd offset tc_vesa_string,offset vesa_handler
         dd offset tc_fake_string,offset fake_handler
         dd offset tc_mode_string,offset mode_handler

tc_vesa_string db '(Vesa)',13,10,'$'
tc_fake_string db '(Fake)',13,10,'$'
tc_mode_string db '(Mode13)',13,10,'$'

tc_handler dd 0
tc_mode    dd 0

tc_timeleft dd 0

tc_select_string db 13,'Press number of the mode - Press enter for auto - Time Left($'

init_tc:
pushad
 call i_init

 mov eax,320*200*32/8
 call i_alloc                        ; Get memory for buffer
 mov tcono,eax                       ; Pointer
 mov _tcono,eax                      ; Pointer, C style

 mov edi,offset tc_model
 call vesa_add_modes                 ; Get  Vesa  modes
 call add_mode_to_list               ; Add  Vesa  modes
 call fake_add_modes                 ; Get  Fake  modes
 call add_mode_to_list               ; Add  Fake  modes
 call mode_add_modes                 ; Get Mode13 modes
 call add_mode_to_list               ; Add Mode13 modes

 call tc_showmodes                   ; View list of modes

 call tc_select                      ; Select the mode to be used

 shl eax,2
 lea eax,[eax*4+eax+offset tc_model] ; Fixup pointer to mode in tc_modelist
 mov ebx,[eax]                       ; Load mode number
 mov tc_mode,ebx                     ; Save mode number
 mov ebx,[eax+16]                    ; Load Handler Type
 mov ebx,[ebx*8+4+offset tc_type]    ; Load Handler address
 mov tc_handler,ebx                  ; Save Handler address

 mov eax,1                           ; Call 1 to handler,init
 mov ebx,tc_mode                     ; Mode to init
 call [tc_handler]                   ; Call

 cmp tc_handler,offset fake_handler  ; Test handler address
 je init_tc_nb                       ; handler=Fake, no need to init fake as backup
  mov eax,1                          ; Call 1 to handler,init
  call fake_handler                  ; Call fake handler
init_tc_nb:
popad
ret

start_tc:
pushad
 mov eax,2
 mov ebx,tc_mode                     
 call [tc_handler]                   ; Call handler to setup mode
 dec eax                             ; test if it failed
 jns start_tc_ok                     ; it succeded, proceed
  mov tc_handler,offset fake_handler ; It failed, use fakemode
  mov eax,2
  call [tc_handler]                  ; Setup Fakemode
start_tc_ok:
popad
ret

blit_tc:
pushad
 mov eax,3
 call [tc_handler]                   ; Call handler to blit the screen
popad
ret

kill_tc:                             ; Just a dumb function for the mom
pushad
  mov eax,tcono
  call i_free
popad
ret

tc_select:                           ; Select mode to use
 mov tc_timeleft,6*16
tc_respawn:
 call get_tick
 mov edi,eax
tc_select_loop:
  mov edx,offset tc_select_string
  call string
  mov eax,tc_timeleft
  shr eax,4
  call decp
  mov al,')'
  call ascii

  tc_select_loop_wait:
  call get_tick
  cmp eax,edi
  je tc_select_loop_wait
  dec tc_timeleft
  mov edi,eax
  call i_poll_key
  cmp eax,0
  jnz tc_getposs
 cmp tc_timeleft,0
 jns tc_select_loop
tc_getposs_e:
 mov eax,0
ret
tc_getposs:
 call i_get_key                      ; Get key
 cmp al,13                           ; cmp to enter
 je tc_getposs_e                     ; if enter, default
 cmp al,'1'                          ; Try if keynum is to small
 jb tc_respawn                       ; if so respawn
 cmp al,'9'                          ; Try if keynum is to big
 ja tc_respawn                       ; if so respawn
 sub al,'1'                          ; Key in range, subtract
 movzx eax,al
 cmp eax,tc_modes                    ; test if to big
 jae tc_respawn                      ; respawn
ret

add_mode_to_list:                    ; Add detected mode(s) to list
 cmp ecx,0
 jz add_mode_to_list_end
  add tc_modes,ecx
add_mode_to_list_loop:
  movsd
  movsd
  movsd
  movsd
  movsd
 loop add_mode_to_list_loop
add_mode_to_list_end:
ret

tc_showmodes_string1 db ')   $'
tc_showmodes_string2 db 'bpp $'

tc_showmodes:
 mov ecx,tc_modes
 mov esi,offset tc_model
 mov edi,1
tc_showmodes_loop:
  mov eax,edi
  call decp
  mov edx,offset tc_showmodes_string1
  call string
  mov eax,[esi+4]
  call decp
  mov al,'x'
  call ascii
  mov eax,[esi+8]
  call decp
  mov al,'x'
  call ascii
  mov eax,[esi+12]
  call decp
  mov edx,offset tc_showmodes_string2
  call string
  mov eax,[esi+16]
  lea eax,[eax*8+tc_type]
  mov edx,[eax]
  call string
  add esi,20
  inc edi
 loop tc_showmodes_loop
ret

;  Code
; **********************************************************************
;  Includes

; "System functions"
include sys.asm

; Misc functions
include misc.asm

; output devs
include mode13.asm
include fake.asm
include vesa.asm

;  Includes
; **********************************************************************
;  Finish
code32 ends
end
