;***************************************************************************** 
;* wextlibs                                                                  *
;*                                                                           *
;* Publics:                                                                  *
;* _calloc , allocate and clear                                              *
;* _malloc , allocate withour clearing                                       *
;* _free   , free memory                                                     *
;* system_memoryinit, called at startup                                      *
;***************************************************************************** 

.386p

include defines.inc

public calloc_
public malloc_
public free_
public system_memoryinit

extrn ___exit_terminator:near

 code32 segment PUBLIC USE32 'code'
 assume cs:code32,ds:code32,es:code32,fs:code32,gs:code32

__mem_err db 'MEMORY ERROR,EXIT$'

__total_memory dd 0

__memory_start dd 0
__memory_size  dd 0

__id_emcb dd 'EMCB'

calloc_temp dd 0         ; temporary var

; Emcb struc , yeah.. extender Memory control block, well it works.. :)
; 0 dword 'EMCB'
; 4 dword lastblock
; 8 dword nextblock
; 12 dword type
;           0 = Free
;           1 = allocated
;           2 = Startblock
;           3 = Endblock


system_memoryinit:
 push gs
 push fs

  ; dos32 support removed here..!

  mov edx,0ffffffffh        ; FFFFFFFFh = 4gb so it is too big to succeed and we get the maximum available memory

  mov ax,0ee42h
  int 31h
  mov __total_memory,eax
  mov ax,0ee40h
  int 31h
  mov edx,__total_memory

  sub edx,system_memory_to_exclude
  jc corrupt_mem_exit
  mov ax,0ee42h
  int 31h
  mov __memory_start,edx
  mov __memory_size,eax

  mov edx,__id_emcb
  mov edi,__memory_start
  mov eax,edi
  add eax,16

  mov ebx,edi
  add ebx,__memory_size
  sub ebx,40

; First Block
  mov [edi],edx              ; Emcb
  mov dword ptr[edi+4],0     ; Lastblock
  mov [edi+8],eax            ; Nextblock
  mov dword ptr[edi+12],2    ; ID,Start
; 1'st free
  mov [eax],edx              ; Emcb
  mov [eax+4],edi            ; Lastblock
  mov [eax+8],ebx            ; Nextblock
  mov dword ptr[eax+12],0    ; ID,Free
; Endblock
  mov [ebx],edx              ; Emcb
  mov [ebx+4],eax            ; Lastblock
  mov dword ptr[ebx+8],0     ; Nextblock
  mov dword ptr[ebx+12],3    ; ID,Endblock

 pop fs
 pop gs
ret

corrupt_mem_exit:
  mov edx,offset __mem_err
  mov ah,9
  int 21h
jmp ___exit_terminator

malloc_:
get_mem:
 push esi
 push edx
 push ebx
  shr eax,5
  inc eax
  shl eax,5
  mov edx,__id_emcb
  mov esi,__memory_start
get_mem_loop:
  mov esi,[esi+8]           ; Fetch ptr to next block
  cmp [esi],edx             ; Compare to Emcb
  jne corrupt_mem_exit      ; If corrupt then exit
  cmp dword ptr[esi+12],3   ; Test if we are at the last mem block
  je get_mem_fail           ; ifso, exit with a null pointer
  cmp dword ptr[esi+12],0   ; is this block free then?
  jne get_mem_loop          ; No, try next
                            ; Yes, is it big enuff then?
  mov ebx,[esi+8]
  sub ebx,esi
  sub ebx,32                ; nextblockPTR-thisblockPTR-2xemcbsize=block size
  cmp ebx,eax               ; test against alloc size
  jbe get_mem_loop          ; Sorry this too small, try next
                            ; Ohyes, it's free,not corrupted and big enuff! alloc!
  mov ebx,[esi+8]
  add eax,esi               ; ptr to new emcb-8
  add eax,16                ; ptr to new emcb
  mov [eax],edx             ; ID of new emcb
  mov [eax+4],esi           ; ptr to lastblock
  mov [eax+8],ebx           ; nextblock
  mov dword ptr[eax+12],0   ; free block

  mov [ebx+4],eax           ; lastblock for the next = new

  mov dword ptr[esi+12],1   ; set allocated flag
  mov [esi+8],eax           ; point nextblock of the old to newblock
  mov eax,esi
  add eax,16
  jmp get_mem_end
get_mem_fail:
  mov eax,0
get_mem_end:
 pop ebx
 pop edx
 pop esi
ret

free_:
free_mem:
 push edx
 push esi
 push ebx
  sub eax,16
  mov edx,__id_emcb
  cmp [eax],edx
  jne free_mem_donothing    ; this is not a valid memory block
  cmp dword ptr[eax+12],1
  jne free_mem_donothing    ; this is not a allocated block
                            ; ok it's a allocated block,free!
  mov dword ptr[eax+12],0   ; mark as free
  mov esi,[eax+4]           ; esi=lastblock
  mov ebx,[eax+8]           ; ebx=nextblock
  mov edx,[ebx+8]           ; edx=nextnextblock

  cmp dword ptr[esi+12],0   ; is the last block free?
  jne free_mem_not_merge_last
   mov [esi+8],ebx          ; point lastblock's nextblock to nextblock, ie jump over curr
   mov [ebx+4],esi          ; point nextblock's lastblock to lastblock, ie jump over
   mov eax,esi              ; thisblock=lastblock
  ; curr block and lastblock is now merged
free_mem_not_merge_last:

  cmp dword ptr[ebx+12],0   ; is the next block free?
  jne free_mem_not_merge_next
   mov [eax+8],edx
   mov [edx+4],eax
  ; curr block and nextblock is now merged
free_mem_not_merge_next:

free_mem_donothing:
 pop ebx
 pop esi
 pop edx
ret

calloc_:
 mov calloc_temp,eax
 call malloc_
 cmp eax,0
 je calloc_error
  push eax
  push edi
  push ecx
   mov edi,eax
   mov ecx,calloc_temp
   mov al,0
   rep stosb
  pop ecx
  pop edi
  pop eax
calloc_error:
ret

 code32 ends                ; Segment ending in case of wext model

end
