!!ARBfp1.0  
PARAM lightpos0     = state.light[0].position;  
PARAM lightdiff0    = state.lightprod[0].diffuse ;
PARAM lightspec0    = state.light[0].specular ;
PARAM lighthalf0    = state.light[0].half ;
PARAM matemission   = state.material.emission ;
PARAM matshininess  = state.material.shininess ;
PARAM eyepos		= program.local[2] ;
PARAM eta			= program.local[3] ;
PARAM fresnel		= program.local[4] ;
ATTRIB pixelpos		= fragment.texcoord[4] ;
ATTRIB pixelnorm	= fragment.texcoord[5] ;
ATTRIB lightglobal  = fragment.texcoord[6] ;
PARAM  c[1]			= {{1,0,2}} ;
TEMP   temp,temp1,temp2,norm,decal,refract,P,R,RfR,RfG,RfB,RfFactor,spec,specular_color0 ;	
#Normalize normal-vector
TEX		temp,fragment.texcoord[2],texture[2],2D;
MUL		temp,pixelnorm,temp ;
DP3     norm.w,pixelnorm,pixelnorm;
RSQ		norm.w,norm.w ;
MUL     norm.xyz,norm.w,pixelnorm ;
#Vector PosToEye
SUB		P,pixelpos,eyepos;
#Reflected vector
MOV		temp.xyz, P;
DP3		temp.x, norm, temp;
MUL		temp.xyz, norm, temp.x;
MAD		R.xyz, -temp, c[0].z, P;
#Normalize P
DP3     P.w,P,P;
RSQ		P.w,P.w ;
MUL     P.xyz,P.w,P ;
#Refraction vector R
MOV		temp1.xyz, norm;
DP3		temp1.x, -P, temp1;
MAD		temp1.z, -temp1.x, temp1.x, c[0].x;
MUL		temp1.y, eta.x, eta.x;
MAD		temp1.w, -temp1.y, temp1.z, c[0].x;
ABS		temp1.y, temp1.w;
RSQ		temp1.y, temp1.y;
RCP		temp1.y, temp1.y;
MAD		temp2.x, eta.x, temp1, -temp1.y;
MOV		temp1.xyz, P;
MUL		temp2.xyz, temp2.x, norm;
MAD		temp1.xyz, eta.x, temp1, temp2;
SLT		temp1.w, c[0].y, temp1;
MUL		RfR.xyz, temp1, temp1.w;
#Refraction vector G
MOV		temp1.xyz, norm;
DP3		temp1.x, -P, temp1;
MAD		temp1.z, -temp1.x, temp1.x, c[0].x;
MUL		temp1.y, eta.y, eta.y;
MAD		temp1.w, -temp1.y, temp1.z, c[0].x;
ABS		temp1.y, temp1.w;
RSQ		temp1.y, temp1.y;
RCP		temp1.y, temp1.y;
MAD		temp2.x, eta.y, temp1, -temp1.y;
MOV		temp1.xyz, P;
MUL		temp2.xyz, temp2.x, norm;
MAD		temp1.xyz, eta.y, temp1, temp2;
SLT		temp1.w, c[0].y, temp1;
MUL		RfG.xyz, temp1, temp1.w;
#Refraction vector B
MOV		temp1.xyz, norm;
DP3		temp1.x, -P, temp1;
MAD		temp1.z, -temp1.x, temp1.x, c[0].x;
MUL		temp1.y, eta.z, eta.z;
MAD		temp1.w, -temp1.y, temp1.z, c[0].x;
ABS		temp1.y, temp1.w;
RSQ		temp1.y, temp1.y;
RCP		temp1.y, temp1.y;
MAD		temp2.x, eta.z, temp1, -temp1.y;
MOV		temp1.xyz, P;
MUL		temp2.xyz, temp2.x, norm;
MAD		temp1.xyz, eta.z, temp1, temp2;
SLT		temp1.w, c[0].y, temp1;
MUL		RfB.xyz, temp1, temp1.w;
#Specular light element
DP3		temp,norm,lighthalf0 ;
MAX		temp1,temp,0 ;
POW		temp,temp1.x,matshininess.x ;
TEX		spec,fragment.texcoord[3],texture[3],2D;
MUL		temp1,temp,spec.xxxx ;
MUL		temp1,lightglobal.w,temp1;
MUL		specular_color0,lightspec0,temp1 ;
#All together
DP3		temp,P,norm;
ADD		temp.x,temp,c[0].x;
POW		temp.x,temp.x,fresnel.z;
MAD		RfFactor,temp.x,fresnel.y,fresnel.x ;
TEX		decal,R,texture[1],CUBE;
TEX		refract.x,RfR,texture[1],CUBE;
TEX		refract.y,RfG,texture[1],CUBE;
TEX		refract.z,RfB,texture[1],CUBE;
LRP		refract,RfFactor.x,refract,decal;
ADD_SAT	result.color,refract,specular_color0;
END  
