// Example scripting engine
// written based on Obs engine
// (c)'01 by SquoQuo
// All code done by Hopper/SquoQuo

#include <stdlib.h>		// for NULL definition
#include <math.h>

#ifndef __ENGINE_PARAMETER
#define __ENGINE_PARAMETER

#define PT_CONST 0
#define PT_LINEAR 1
#define PT_SPLINE 2
#define PT_SINE 3
#define PT_STRING 4

#ifndef PI
#define PI 3.1415926536
#endif

class Parameter
{
public:
	char name[128];		// name of the part
	char type;				// type of the parameter (see above)
	float min, max;		// clipping values
	float pSinPeriod, pSinAmplitude, pSinOffset, pSinPhase;	// sine values
	char pString[32];			// string value		******************* should be variable size
	float pConst;			// constant value
	float *x, *y;			// linear/spline dots
	int dotCount;			// count of linear/spline dots

	// destructor
	~Parameter();

	// returns the float value depending on the type of parameter
	// t must be between 0.0 and 1.0
	// a pointer to float is returned (float*)
	// if the type is string, a pointer to the string is returned (char*)
	void *getValue(float t);

private:
	// temporary float value, needed for return of getValue()
	float temp;

	// calculates natural cubic spline value
	float calcSpline(float t);
};

#endif