;NASM Win32 coding tutorial pt. 1.2beta  -  by T$ (ts@deinmeister.de)
;
;compile with:
;NASMW.EXE -fobj win001_n.asm
;link with:
;ALINK.EXE -c -oPE  -subsys gui win001_n win32.lib win001.res

;Everything written in part 0.5 won`t be repeated here - if something is still curious,
;a look into the first part may help

		%include "win32n.inc"       

		EXTERN GetModuleHandleA
		IMPORT GetModuleHandleA kernel32.dll
		EXTERN RegisterClassExA
		IMPORT RegisterClassExA user32.dll
		EXTERN LoadIconA
		IMPORT LoadIconA user32.dll
		EXTERN LoadCursorA
		IMPORT LoadCursorA user32.dll
		EXTERN CreateWindowExA
		IMPORT CreateWindowExA user32.dll
		EXTERN GetMessageA
		IMPORT GetMessageA user32.dll
		EXTERN DispatchMessageA
		IMPORT DispatchMessageA user32.dll
		EXTERN ExitProcess
		IMPORT ExitProcess kernel32.dll
		EXTERN DefWindowProcA
		IMPORT DefWindowProcA user32.dll
		EXTERN PostQuitMessage
		IMPORT PostQuitMessage user32.dll
		EXTERN MessageBoxA
		IMPORT MessageBoxA user32.dll
		EXTERN SendMessageA
		IMPORT SendMessageA user32.dll

		segment .data USE32

;Definition of the window class (with Menu):
;NASM-Syntax for Struct usage is painfully stupid...

		OurWindowclass:
		istruc WNDCLASSEX
		    at WNDCLASSEX.cbSize,          dd  WNDCLASSEX_size
		    at WNDCLASSEX.style,           dd  CS_VREDRAW + CS_HREDRAW
		    at WNDCLASSEX.lpfnWndProc,     dd  Windowprocedure
		    at WNDCLASSEX.cbClsExtra,      dd  0
		    at WNDCLASSEX.cbWndExtra,      dd  0
		    at WNDCLASSEX.hInstance,       dd  0
		    at WNDCLASSEX.hIcon,           dd  0
		    at WNDCLASSEX.hCursor,         dd  0
		    at WNDCLASSEX.hbrBackground,   dd  COLOR_HIGHLIGHT
		    at WNDCLASSEX.lpszMenuName,    dd  Menuname
		    at WNDCLASSEX.lpszClassName,   dd  Windowclassname
		    at WNDCLASSEX.hIconSm,         dd  0
	    	iend

		Windowhandle dd 0

;the following constants describe the content of the message structure residing on the stack:
		MSGhWnd   equ 0
		MSGmsg    equ 4
		MSGwParam equ 8
		MSGlParam equ 12

;GetMessage requires a buffer for an incoming Message (one Message = 7 DWORDS):
		MessageBuffer dd 0,0,0,0,0,0,0

		Windowtitle db "ordinary standard window",0
		Windowclassname db "OurWindowclass",0
		Windowname db "Oooooh... A Window",0

;Name of Ressources:
		Menuname db "Win002menu",0
		Picturename db "Nuke",0
		Cursorname db "Fisch" 

		naffing db 0

;these constants are stand for themselves - change them, if you want ;-)
		WindowsizeInX equ 300
		WindowsizeInY equ 200
		WindowpositionInX equ 100
		WindowpositionInY equ 120



		segment .code USE32

		..start

;many function require a handle identifying the running program
;GetModuleHandle (0) retrieves one

		push dword 0
		call [GetModuleHandleA]
		mov [OurWindowclass+WNDCLASSEX.hInstance],eax

;two ressources are loaded (the menu ressource is loaded automatically,
;if defined inside the window structure
		push dword Picturename
		push dword [OurWindowclass+WNDCLASSEX.hInstance]
		call [LoadIconA]
		mov [OurWindowclass+WNDCLASSEX.hIcon],eax
		push dword Cursorname
		push dword [OurWindowclass+WNDCLASSEX.hInstance]
		call [LoadCursorA]
		mov [OurWindowclass+WNDCLASSEX.hCursor],eax

;tell the OS about our new window class
		push dword OurWindowclass
		call [RegisterClassExA]


;create a window corresponding to our window class:
		push dword 0
		push dword [OurWindowclass+WNDCLASSEX.hInstance]
		push dword 0
		push dword 0
		push dword WindowsizeInY
		push dword WindowsizeInX
		push dword WindowpositionInY
		push dword WindowpositionInX
		push dword WS_CAPTION + WS_MAXIMIZEBOX + WS_MINIMIZEBOX + WS_SIZEBOX + WS_SYSMENU + WS_VISIBLE
		push dword Windowname
		push dword Windowclassname
		push dword WS_EX_CLIENTEDGE + WS_EX_WINDOWEDGE
		call [CreateWindowExA]
		mov [Windowhandle],eax

;The most important place in a windows program: The Message Pump / Message Loop. Here the
;incoming Messages get preprocessed and get send to the corresponding window procedure

		MessagePumpStart:
		push dword 0
		push dword 0
		push dword 0
		push dword MessageBuffer
		call [GetMessageA]
		or eax,eax
		jz WM_QUIT_received
		push dword MessageBuffer
		call [DispatchMessageA]
		jmp MessagePumpStart


		WM_QUIT_received:
		push dword 0
		call [ExitProcess]

;------------
;the window procedure is called by DispatchMessage if the message
;applies to this window. The message and its parameters are on the stack. The number 4 in 
; [esp+4+MSGmsg] skips the EIP pushed on the stack by the call.

		Windowprocedure:

;only 2 messages are checked: WM_COMMAND for activated Menus and WM_DESTROY which
;indicates that the window is under destruction
;The rest is handled by DefaultWndProc of Windows.

		cmp dword [esp+4+MSGmsg],WM_COMMAND
		jne noInterestingMessage

		 cmp dword [esp+4+MSGwParam],999h
		 je Selfdestruction

		 cmp dword [esp+4+MSGwParam],666h
		 je Dunnomessage

		 mov ecx,title1
		  cmp dword [esp+4+MSGwParam],123h
		  je Wantsomemessage

		  mov ecx,title2
		  jmp Wantsomemessage

		noInterestingMessage:

		cmp dword [esp+4+MSGmsg],WM_DESTROY
		je Selfdestruction
		jmp [DefWindowProcA]

		Selfdestruction:
		push dword MB_OK | MB_APPLMODAL
		push dword Windowtitle
		push dword SayNo
		push dword [Windowhandle]
		call [MessageBoxA]
		push dword 0
		call [PostQuitMessage]
;set return value = 0
		xor eax,eax
;the "RET imm"-version of the RET instruction removes "imm" bytes from the stack while returning
;with imm = 16 we remove exactly 4 DWORDS which the window procedure got as parameters
		ret 16

		Wantsomemessage:
		push dword MB_OK
		push ecx
		push dword textinside
		push dword [Windowhandle]
		call [MessageBoxA]
		ret 16

		Dunnomessage:
		push dword MB_OK
		push dword naffing
		push dword naffing
		push dword [Windowhandle]
		call [MessageBoxA]
		ret 16

		segment .data USE32
;some text for some dialogue boxes...
		title1 db "Fucking",0
		title2 db "Sucking",0
		textinside db "I knew that you want to, just look what you`ve done to the menu :-)",0
		SayNo db "Noooooooooooooooooooooooooo !",0
