// BigBang.h: interface for the CBigBang class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_BIGBANG_H__3FF418E1_7D38_11D5_AD0F_F06357C10000__INCLUDED_)
#define AFX_BIGBANG_H__3FF418E1_7D38_11D5_AD0F_F06357C10000__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CBigBang : public CEfx  
{
private:
	
	CParticleSystem			m_psSystem;
	CSphericalEmiter		m_seEmiter;
	CFinitePointEmiter		m_fpeEmiter;
	CBlobSystem				m_bsSystem;
	CBlob3D					m_b3dBlob[7];

	he3d_CVector			m_vBlobsPos[7];
	FLOAT					m_fRotCoeff[7][3];

	PDIRECT3DVERTEXBUFFER8	m_pvbShockWavePod;
	PDIRECT3DVERTEXBUFFER8	m_pvbPrticle;
	PDIRECT3DVERTEXBUFFER8	m_pvbElectric;

	he3d_CVector			m_vParticle[30];

	FLOAT					m_fCoreScale;
	FLOAT					m_fShockScale;

	CImageQuad*				m_piqFade;
	CImageQuad*				m_piqFlare;

	FLOATKEY				m_sCoreSpline[3];

public:

	CBigBang( PDIRECT3DDEVICE8 pDevice );
	virtual ~CBigBang();

	BOOL InitEfx();
	BOOL FinishEfx();
	BOOL UpdateFrame( FLOAT fTime );
	BOOL RenderEfx();

};

#endif // !defined(AFX_BIGBANG_H__3FF418E1_7D38_11D5_AD0F_F06357C10000__INCLUDED_)
