// MeteorAproaching.h: interface for the CMeteorAproaching class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_METEORAPROACHING_H__80A58C44_81BE_11D5_AD0F_C06357C12026__INCLUDED_)
#define AFX_METEORAPROACHING_H__80A58C44_81BE_11D5_AD0F_C06357C12026__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CMeteorAproaching : public CEfx 
{
private:
	
	CSimpleMesh				m_mSphere;

	PDIRECT3DVERTEXBUFFER8	m_pvbFlare;
	PDIRECT3DVERTEXBUFFER8	m_pvbMeteorParticles;

	CParticleSystem			m_psMeteorSystem;
	CParticleSystem			m_psMeteorSystem2;
	CPointEmiter			m_peMeteorEmiters[10];

	he3d_CMatrix			m_mtxEarth;
	he3d_CMatrix			m_mtxMoon;

	VECTORKEY				m_vsCamPos[10];
	VECTORKEY				m_vsCamTrg[10];

	PDIRECT3DTEXTURE8		m_ptextLens[4];

	he3d_CVector			m_vSunPos;

	he3d_CVector			m_vEmiters[10];

	he3d_CMatrix			m_mtxMeteor;

	CImageQuad*				m_piqFade;

public:
	CMeteorAproaching( PDIRECT3DDEVICE8 pDevice );
	virtual ~CMeteorAproaching();

	virtual BOOL InitEfx();
	virtual BOOL FinishEfx();
	virtual BOOL UpdateFrame( FLOAT fTime );
	virtual BOOL RenderEfx();

};

#endif // !defined(AFX_METEORAPROACHING_H__80A58C44_81BE_11D5_AD0F_C06357C12026__INCLUDED_)
