// SytemException.cpp: implementation of the CSytemException class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "SystemException.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

static	TCHAR* g_ppszErrorMessages[] =
{
	"no error",
	"null pointer passed as argument (propably as pDevice)",
	"file not found",
	"could not read file",
	"d3d generic error",
	"timer exception"
	"unknown error"
};

CSystemException::CSystemException( DWORD dwCode ) : m_dwCode( dwCode )
{
	if( dwCode < DEMO_EXCEPTION_MAX_CODE )
		_tcscpy( m_pszMessage, g_ppszErrorMessages[dwCode] );
	else
		_tcscpy( m_pszMessage, g_ppszErrorMessages[DEMO_EXCEPTION_MAX_CODE] );
}

CSystemException::CSystemException( DWORD dwCode, TCHAR* pszMessage ) : m_dwCode( dwCode )
{
	_tcsnset( m_pszMessage, 0, 256 );
	_tcsncpy( m_pszMessage, pszMessage, 255 );
}

CSystemException::~CSystemException()
{
}

TCHAR* CSystemException::GetMessage()
{
	return m_pszMessage;
}



