//=he3d=file============================================================================================
//	Helium3d system	(c) 2000/2001 acid.z51 
//------------------------------------------------------------------------------------------------------
//
//	name:	he3d_mtxstack.cpp
//  desc:	implementation file for CMtxStack class
//
//	history		
//		+ 20.01.2001				first & final version by acid
//
//	todo
//		+ 25.12.2001				nothing :)
//======================================================================================================
#include "math3d.h"
#include <math.h>

he3d_CMtxStack::he3d_CMtxStack() : top( NULL )
{
}

he3d_CMtxStack::~he3d_CMtxStack()
{
	Clear();
}

void he3d_CMtxStack::Clear()
{
	Node*				node;

	while( top )
	{
		node = top->prev;
		delete top;
		top	 = node;
	}

	top = NULL;
}

void he3d_CMtxStack::Push( he3d_CMatrix& mtx )
{
	Node*				node = new Node;

	node->mtx	= mtx;
	node->prev	= top;

	top = node;
}

he3d_CMatrix he3d_CMtxStack::Pop()
{
	he3d_CMatrix		out;
	Node*				node = top;

	if( top )
	{	
		out = top->mtx;
		top = top->prev;
		delete node;
	}

	return out;
}

he3d_CMatrix he3d_CMtxStack::GetTop()
{
	he3d_CMatrix		out;

	if( top )
		out = top->mtx;

	return out;
}

void he3d_CMtxStack::MulAndPush( he3d_CMatrix& mtx )
{
	if( !top )
	{
		Push( mtx );		
	}
	else
	{
		he3d_CMatrix	tmp = mtx*top->mtx;
		Push( tmp );
	}
}
