//=he3d=file============================================================================================
//	Helium3d system	(c) 2000 acid.z51 
//------------------------------------------------------------------------------------------------------
//
//	name:	he3d_vector.cpp
//  desc:	implementation file for CVector class
//
//	history		
//		+ 25.12.2000				first & final version by acid
//
//	todo
//		+ 25.12.2000				nothing :)
//======================================================================================================
#include "math3d.h"
#include <math.h>

he3d_CVector::he3d_CVector( FLOAT _x, FLOAT _y, FLOAT _z ) : x(_x), y(_y), z(_z)
{
}

he3d_CVector::he3d_CVector( const D3DVECTOR& vec ) : x(vec.x), y(vec.y), z(vec.z)
{
}

he3d_CVector::he3d_CVector( const D3DXVECTOR3& vec ) : x(vec.x), y(vec.y), z(vec.z)
{
}

he3d_CVector::he3d_CVector( const he3d_CVector& vec ) : x(vec.x), y(vec.y), z(vec.z)
{
}

he3d_CVector& he3d_CVector::operator=( const he3d_CVector& vec )
{
	if( &vec == this )		
		return *this;
	
	x = vec.x;
	y = vec.y;
	z = vec.z;	

	return *this;
}

he3d_CVector& he3d_CVector::operator+=( const he3d_CVector& vec )
{
	x += vec.x;
	y += vec.y;
	z += vec.z;

	return *this;
}

he3d_CVector& he3d_CVector::operator-=( const he3d_CVector& vec )
{
	x -= vec.x;
	y -= vec.y;
	z -= vec.z;

	return *this;
}

he3d_CVector& he3d_CVector::operator*=( FLOAT a )
{
	x *= a;
	y *= a;
	z *= a;
	
	return *this;
}

he3d_CVector& he3d_CVector::operator*=( const he3d_CMatrix& mtx )
{	
	FLOAT		outx = x*mtx._11 + y*mtx._21 + z*mtx._31 + mtx._41;
	FLOAT		outy = x*mtx._12 + y*mtx._22 + z*mtx._32 + mtx._42;

	
	z = x*mtx._13 + y*mtx._23 + z*mtx._33 + mtx._43;
	x = outx;
	y = outy;

	return *this;
}

he3d_CVector& he3d_CVector::operator/=( FLOAT a ) 
{
	x /= a;
	y /= a;
	z /= a;

	return *this;
}

he3d_CVector he3d_CVector::operator+( const he3d_CVector& vec ) const
{
	return he3d_CVector( x + vec.x, y + vec.y, z + vec.z );
}

he3d_CVector he3d_CVector::operator-( const he3d_CVector& vec ) const
{
	return he3d_CVector( x - vec.x, y - vec.y, z - vec.z );
}

he3d_CVector he3d_CVector::operator*( const he3d_CVector& v ) const
{
	he3d_CVector	out;

	out.x = y*v.z - z*v.y;
	out.y = z*v.x - x*v.z;
	out.z = x*v.y - y*v.x;

	return out;
}

he3d_CVector he3d_CVector::operator*( FLOAT a ) const
{
	return he3d_CVector( a*x, a*y, a*z );
}

he3d_CVector he3d_CVector::operator*( const he3d_CMatrix& mtx ) const
{
	he3d_CVector	out;

	out.x = x*mtx._11 + y*mtx._21 + z*mtx._31 + mtx._41;
	out.y = x*mtx._12 + y*mtx._22 + z*mtx._32 + mtx._42;
	out.z = x*mtx._13 + y*mtx._23 + z*mtx._33 + mtx._43;

	return out;
}

he3d_CVector he3d_CVector::operator/( FLOAT a ) const
{
	return he3d_CVector( x/a, y/a, z/a );
}

he3d_CVector he3d_CVector::operator-() const
{
	return he3d_CVector( -x, -y, -z );
}

he3d_CVector he3d_CVector::operator+() const
{
	return he3d_CVector( x, y, z );
}

he3d_CVector::operator D3DVECTOR() const
{
	D3DVECTOR		out;

	out.x = x;
	out.y = y;
	out.z = z;

	return out;
}

he3d_CVector::operator D3DXVECTOR3() const
{
	return D3DXVECTOR3( x, y, z );
}

he3d_CVector::operator D3DVECTOR*()
{
	return (D3DVECTOR*)&x;
}

he3d_CVector::operator const D3DVECTOR*() const
{
	return (const D3DVECTOR*)&x;
}

he3d_CVector::operator D3DXVECTOR3*() 
{
	return (D3DXVECTOR3*)&x;
}

he3d_CVector::operator const D3DXVECTOR3*() const
{
	return (const D3DXVECTOR3*)&x;
}

he3d_CVector Normalize( const he3d_CVector& vec )
{
	FLOAT			len = vec.x*vec.x + vec.y*vec.y + vec.z*vec.z;
	he3d_CVector	out;

	len = 1/sqrtf( len );

	out.x = vec.x*len;
	out.y = vec.y*len;
	out.z = vec.z*len;

	return out;
}

FLOAT Length( const he3d_CVector& vec )
{
	return sqrtf(vec.x*vec.x + vec.y*vec.y + vec.z*vec.z);
}

he3d_CVector CrossProd( const he3d_CVector& u, const he3d_CVector& v )
{
	he3d_CVector	out;

	out.x = u.y*v.z - u.z*v.y;
	out.y = u.z*v.x - u.x*v.z;
	out.z = u.x*v.y - u.y*v.x;

	return out;
}

FLOAT DotProd( const he3d_CVector& u, const he3d_CVector& v )
{
	return u.x*v.x + u.y*v.y + u.z*v.z;
}

he3d_CVector operator*( FLOAT a, const he3d_CVector& vec )
{
	return he3d_CVector( a*vec.x, a*vec.y, a*vec.z );
}

he3d_CVector LERP( FLOAT t, const he3d_CVector& u, const he3d_CVector& v )
{
	FLOAT		_1t  = 1 - t;
	
	return he3d_CVector( _1t*u.x + t*v.x, _1t*u.y + t*v.y, _1t*u.z + t*v.z );
}

// test it!
VOID FaceNormal( const he3d_CVector& v1, const he3d_CVector& v2, const he3d_CVector& v3, he3d_CVector& n )
{
	FLOAT	ux = v2.x - v1.x, vx = v3.x - v1.x;
	FLOAT	uy = v2.y - v1.y, vy = v3.y - v1.y;
	FLOAT	uz = v2.z - v1.z, vz = v3.z - v1.z;

	n.x = uy*vz - uz*vy;
	n.y = uz*vx - ux*vz;
	n.z = ux*vy - uy*vx;	
}







