// Cubes.h: interface for the CCubes class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CUBES_H__0397C9A1_9D63_11D5_AD0F_80D756C10027__INCLUDED_)
#define AFX_CUBES_H__0397C9A1_9D63_11D5_AD0F_80D756C10027__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Efx.h"

#define	PODCOUNT			3
#define	PODCOEFF			1.0f/(FLOAT)PODCOUNT
#define	ALPHAFACTOR			128.0f

class CCubes : public CEfx 
{
private:	

	PDIRECT3DVERTEXBUFFER8	m_pvbCube;
	PDIRECT3DVERTEXBUFFER8	m_pvbCube2;
	PDIRECT3DVERTEXBUFFER8	m_pvbDotCube;

	PDIRECT3DVERTEXBUFFER8	m_pvbFxPod;

	PDIRECT3DVERTEXBUFFER8	m_pvbSyncPod;

	// controlers
	FLOAT					m_fPodRotation[PODCOUNT];
	FLOAT					m_fScale[PODCOUNT];
	FLOAT					m_fAlpha[PODCOUNT];
	FLOAT					m_fRotationSpeed[PODCOUNT];
	FLOAT					m_fOffset[PODCOUNT];
	FLOAT					m_fSwapTime;	
	DWORD					m_dwCurrentPod;

	FLOAT					m_fRotation;
	
	he3d_CVector			m_vPosition[125];
	he3d_CVector			m_vScale[125];

	CImageQuad*				m_piqEfx;

	BOOL					m_bRenderSolid;
	FLOAT					m_fShift;

	CImageQuad*				m_piqDisplay;
	CImageQuad*				m_piqNoise;
	CImageQuad*				m_piqFade;	

	BOOL					m_bRenderSync;
	BOOL					m_bRenderFade;

	DWORD					m_dwDispAlpha;

	BOOL					m_bRenderDisplay;

	FLOATKEY				m_fSync[6][100];
	DWORD					m_dwSplineCount[6];
	DWORD					m_dwColor[6];
	DWORD					m_dwCubesIndices[64];

public:

	CCubes( PDIRECT3DDEVICE8 pDevice );
	virtual ~CCubes();

	virtual BOOL UpdateFrame( FLOAT fTime );
	virtual BOOL RenderEfx();

};

#endif // !defined(AFX_CUBES_H__0397C9A1_9D63_11D5_AD0F_80D756C10027__INCLUDED_)
