// FinishSequence.cpp: implementation of the CFinishSequence class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "FinishSequence.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CFinishSequence::CFinishSequence( PDIRECT3DDEVICE8 pDevice ) : CEfx( pDevice )
{
	try
	{
		LoadAlphaTexture( "z.bmp" );
		LoadAlphaTexture( "o.bmp" );
		LoadAlphaTexture( "n.bmp" );
		LoadAlphaTexture( "e.bmp" );
		LoadAlphaTexture( "5.bmp" );
		LoadAlphaTexture( "1.bmp" );
		LoadAlphaTexture( "acid.bmp" );
		LoadAlphaTexture( "agi.bmp" );
		LoadAlphaTexture( "beton.bmp" );
	}
	catch( CTextureException )
	{
		throw CSystemException( "unable to load textures" );
	}
	
	m_ptexLetters[0] = GetTexture( "z.bmp" );
	m_ptexLetters[1] = GetTexture( "o.bmp" );
	m_ptexLetters[2] = GetTexture( "n.bmp" );
	m_ptexLetters[3] = GetTexture( "e.bmp" );
	m_ptexLetters[4] = GetTexture( "5.bmp" );
	m_ptexLetters[5] = GetTexture( "1.bmp" );
	
	for( DWORD i = 0 ; i < 10 ; i++ )
	{
		m_piqLetterZoomer[i] = new CImageQuad( m_pDevice, 0, 0, 0, 0 );
		m_piqLetterZoomer[i]->SetARGB( 0x0 );
	}

	m_piqLetters[0] = new CImageQuad( m_pDevice,   5, 145, 110, 250 );
	m_piqLetters[1] = new CImageQuad( m_pDevice, 110, 145, 215, 250 );
	m_piqLetters[2] = new CImageQuad( m_pDevice, 215, 145, 320, 250 );
	m_piqLetters[3] = new CImageQuad( m_pDevice, 320, 145, 425, 250 );
	m_piqLetters[4] = new CImageQuad( m_pDevice, 425, 145, 530, 250 );
	m_piqLetters[5] = new CImageQuad( m_pDevice, 530, 145, 635, 250 );

	for( i = 0 ; i < 6 ; i++ )
		m_piqLetters[i]->SetColor( 0x0 );			

	for( i = 0 ; i < 3 ; i++ )
	{
		m_piqXywki[i] = new CImageQuad( m_pDevice, 100, 300, 356, 42 8 );
		m_piqXywki[i]->SetARGB( 0x0 );
	}
}

CFinishSequence::~CFinishSequence()
{
}

BOOL CFinishSequence::UpdateFrame( FLOAT fTime )
{	
	FLOAT				fFactor;
	FLOAT				fShift;
	FLOAT				fSize;
	DWORD				dwColor;
	
	for( DWORD i = 0 ; i < 6 ; i++ )
		m_bRenderLetters[i] = TRUE;

	if( fTime < 3.0f )
	{
		m_ptexLetter = GetTexture( "z.bmp" );

		fFactor = (3.0f - fTime)*0.33f;
		dwColor = (DWORD)(32.0f*(1.0f - fFactor));

		if( dwColor > 25 )
			dwColor = 25;

		dwColor = (dwColor<<24);
		
		for( DWORD i = 0 ; i < 10 ; i++ )
		{
			fShift = fFactor*(FLOAT)i*10.0f;
			fSize = fFactor*(FLOAT)i*10.0f + 105.0f;

			m_piqLetterZoomer[i]->Resize( 57.5f - fShift - fSize*0.5f, 197.5f - fSize*0.5f, 57.5f - fShift + fSize*0.5f, 197.5f + fSize*0.5f );
			m_piqLetterZoomer[i]->SetARGB( dwColor );
		}	

		m_bRenderLetters[0] = FALSE;
	}
	else if( fTime < 6.0f )
	{
		m_ptexLetter = GetTexture( "o.bmp" );
	
		fFactor = (6.0f - fTime)*0.33f;
		dwColor = (DWORD)(32.0f*(1.0f - fFactor));

		if( dwColor > 25 )
			dwColor = 25;

		dwColor = (dwColor<<24);
		
		for( DWORD i = 0 ; i < 10 ; i++ )
		{
			fShift = fFactor*(FLOAT)i*10.0f;
			fSize = fFactor*(FLOAT)i*10.0f + 105.0f;

			m_piqLetterZoomer[i]->Resize( 105.0f + 57.5f - fShift - fSize*0.5f, 197.5f - fSize*0.5f, 105.0f + 57.5f - fShift + fSize*0.5f, 197.5f + fSize*0.5f );
			m_piqLetterZoomer[i]->SetARGB( dwColor );
		}	

		m_bRenderLetters[1] = FALSE;
	}
	else if( fTime < 9.0f )
	{
		m_ptexLetter = GetTexture( "n.bmp" );
	
		fFactor = (9.0f - fTime)*0.33f;
		dwColor = (DWORD)(32.0f*(1.0f - fFactor));

		if( dwColor > 25 )
			dwColor = 25;

		dwColor = (dwColor<<24);
		
		for( DWORD i = 0 ; i < 10 ; i++ )
		{
			fShift = fFactor*(FLOAT)i*10.0f;
			fSize = fFactor*(FLOAT)i*10.0f + 105.0f;

			m_piqLetterZoomer[i]->Resize( 210.0f + 57.5f - fShift - fSize*0.5f, 197.5f - fSize*0.5f, 210.0f + 57.5f - fShift + fSize*0.5f, 197.5f + fSize*0.5f );
			m_piqLetterZoomer[i]->SetARGB( dwColor );
		}	

		m_bRenderLetters[2] = FALSE;
	}
	else if( fTime < 12.0f )
	{
		m_ptexLetter = GetTexture( "e.bmp" );
	
		fFactor = (12.0f - fTime)*0.33f;
		dwColor = (DWORD)(32.0f*(1.0f - fFactor));

		if( dwColor > 25 )
			dwColor = 25;

		dwColor = (dwColor<<24);
		
		for( DWORD i = 0 ; i < 10 ; i++ )
		{
			fShift = fFactor*(FLOAT)i*10.0f;
			fSize = fFactor*(FLOAT)i*10.0f + 105.0f;

			m_piqLetterZoomer[i]->Resize( 315.0f + 57.5f - fShift - fSize*0.5f, 197.5f - fSize*0.5f, 315.0f + 57.5f - fShift + fSize*0.5f, 197.5f + fSize*0.5f );
			m_piqLetterZoomer[i]->SetARGB( dwColor );
		}	

		m_bRenderLetters[3] = FALSE;
	}
	else if( fTime < 15.0f )
	{
		m_ptexLetter = GetTexture( "5.bmp" );
	
		fFactor = (15.0f - fTime)*0.33f;
		dwColor = (DWORD)(32.0f*(1.0f - fFactor));

		if( dwColor > 25 )
			dwColor = 25;

		dwColor = (dwColor<<24);
		
		for( DWORD i = 0 ; i < 10 ; i++ )
		{
			fShift = fFactor*(FLOAT)i*10.0f;
			fSize = fFactor*(FLOAT)i*10.0f + 105.0f;

			m_piqLetterZoomer[i]->Resize( 420.0f + 57.5f - fShift - fSize*0.5f, 197.5f - fSize*0.5f, 420.0f + 57.5f - fShift + fSize*0.5f, 197.5f + fSize*0.5f );
			m_piqLetterZoomer[i]->SetARGB( dwColor );
		}	

		m_bRenderLetters[4] = FALSE;
	}
	else if( fTime < 18.0f )
	{
		m_ptexLetter = GetTexture( "1.bmp" );
	
		fFactor = (18.0f - fTime)*0.33f;
		dwColor = (DWORD)(32.0f*(1.0f - fFactor));

		if( dwColor > 25 )
			dwColor = 25;

		dwColor = (dwColor<<24);
		
		for( DWORD i = 0 ; i < 10 ; i++ )
		{
			fShift = fFactor*(FLOAT)i*10.0f;
			fSize = fFactor*(FLOAT)i*10.0f + 105.0f;

			m_piqLetterZoomer[i]->Resize( 525.0f + 57.5f - fShift - fSize*0.5f, 197.5f - fSize*0.5f, 525.0f + 57.5f - fShift + fSize*0.5f, 197.5f + fSize*0.5f );
			m_piqLetterZoomer[i]->SetARGB( dwColor );
		}	

		m_bRenderLetters[5] = FALSE;
	}


	for( i = 0 ; i < 3 ; i++ )
		m_piqXywki[i]->SetARGB( 0x0 );	

	if( fTime > 2.0f && fTime < 5.0f )
		m_piqXywki[0]->SetAlpha( (DWORD)CLAMPALPHA( ( 5.0f - fTime )*0.33f*255.0f ) );

	if( fTime > 7.0f && fTime < 10.0f )
		m_piqXywki[1]->SetAlpha( (DWORD)CLAMPALPHA( ( 10.0f - fTime )*0.33f*255.0f ) );

	if( fTime > 12.0f && fTime < 15.0f )
		m_piqXywki[2]->SetAlpha( (DWORD)CLAMPALPHA( ( 15.0f - fTime )*0.33f*255.0f ) );


	return TRUE;
}

BOOL CFinishSequence::RenderEfx()
{
	m_pDevice->Clear( 0,NULL, D3DCLEAR_ZBUFFER|D3DCLEAR_TARGET, 0xffffff, 1.0f, 0 );

	m_pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
	m_pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
	m_pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );

	m_pDevice->SetTexture( 0, m_ptexLetter );
	m_pDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_SELECTARG2 );
	m_pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE );

	for( DWORD i = 0 ; i < 10 ; i++ )
		m_piqLetterZoomer[i]->Render( m_pDevice );

	m_pDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_SELECTARG2 );
	m_pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1 );

	for( i = 0 ; i < 6 ; i++ )
	{
		if( !m_bRenderLetters[i] )
			break;

		m_pDevice->SetTexture( 0, m_ptexLetters[i] );
		m_piqLetters[i]->Render( m_pDevice );
	}

	m_pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE );
	
	m_pDevice->SetTexture( 0, GetTexture( "acid.bmp" ) );
	m_piqXywki[0]->Render( m_pDevice );

	m_pDevice->SetTexture( 0, GetTexture( "agi.bmp" ) );
	m_piqXywki[1]->Render( m_pDevice );

	m_pDevice->SetTexture( 0, GetTexture( "beton.bmp" ) );
	m_piqXywki[2]->Render( m_pDevice );

	return TRUE;
}
