/*
 *   OPTIONS - a short demo for MS 2001
 *   Copyright (C) 2000-2001 Morten Poulsen <mortenp@certus.dk>
 *
 *   This demo is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This demo is distributed in the hope that it will make you happy,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this demo; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "SDL.h"
#include "SDL_mixer.h"
#include "SDL_image.h"

#ifdef macintosh
#define DIR_SEP ":"
#define DIR_CUR ":"
#else
#define DIR_SEP "/"
#define DIR_CUR ""
#endif
#define DATAFILE(X) DIR_CUR "data" DIR_SEP X

#define TICK (SDL_GetTicks()-starttick)/10
#define SCREEN_WIDTH  400
#define SCREEN_HEIGHT 300

#define PUBLISH \
    { \
        SDL_Event event; \
        while (SDL_PollEvent(&event)) { \
            switch (event.type) { \
                case SDL_KEYDOWN: \
                case SDL_QUIT: \
                    cleanup(); \
                    exit(EXIT_FAILURE); \
                    break; \
                default: \
                    break; \
            } \
        } \
    } \
    SDL_Flip(screen);

#define FLASH \
    memset(screen->pixels, 255, SCREEN_WIDTH*SCREEN_HEIGHT*3); \
    PUBLISH \
    SDL_Delay(1);

#define LENGTH0 1590   /*985*/
#define LENGTH1 1480
#define LENGTH2 2300
#define LENGTH3 2000
#define LENGTH4 1000

#define START0 0
#define START1 START0 + LENGTH0
#define START2 START1 + LENGTH1
#define START3 START2 + LENGTH2
#define START4 START3 + LENGTH3

#define END0 START0 + LENGTH0
#define END1 START1 + LENGTH1
#define END2 START2 + LENGTH2
#define END3 START3 + LENGTH3
#define END4 START4 + LENGTH4

#define LOFFSET START1;

#define FUSK 8090 /*2445,1823*/

void effect_0(void);
void effect_1(void);
void trans_12(void);
void effect_2(void);
void effect_3(void);
void effect_4(void);

SDL_Surface *screen;
Mix_Music *music;
SDL_Surface *intro, *im, *bg, *tux, *nerf, *greet, *freeu, *blur, *gnu, *code0, *outtro, *gnutxt;
SDL_Surface *txt_a, *txt_b;
SDL_Surface *test;
SDL_Surface *stars[3];
unsigned int starttick;

struct rot_type {
    float x;
    float y;
    float z;
};
struct rot_type rot_obj_show[2000];

struct ring_type {
    int x;
    int y;
    int r;
};
struct ring_type ring_obj[50];

struct blur_type {  
    float sinx; // position (initial)
    float siny;
    float sinz;
    float facx; // scale factor
    float facy;
    float facz;
    float hasx; // speed
    float hasy;
    float hasz;
    float x,y,z;  // temp position
};
struct blur_type blur_obj[100];



void mp_setpixel(int x, int y, Uint8 r, Uint8 g, Uint8 b) 
{
    int p;
    if (x>=0 && x<SCREEN_WIDTH && y>=0 && y<SCREEN_HEIGHT) {
        p = (x + y*SCREEN_WIDTH) * 3;
        ((Uint8 *)screen->pixels)[p++] = b;
        ((Uint8 *)screen->pixels)[p++] = g;
        ((Uint8 *)screen->pixels)[p] = r;
    }
}



void mp_setpixel_alpha(int x, int y, Uint8 r, Uint8 g, Uint8 b)
{
    int p;
    if (x>=0 && x<SCREEN_WIDTH && y>=0 && y<SCREEN_HEIGHT) {
        p = (x + y*SCREEN_WIDTH) * 3;
        ((Uint8 *)screen->pixels)[p] = ((Uint8 *)screen->pixels)[p++]>>1 + b>>1;
        ((Uint8 *)screen->pixels)[p] = ((Uint8 *)screen->pixels)[p++]>>1 + g>>1;
        ((Uint8 *)screen->pixels)[p] = ((Uint8 *)screen->pixels)[p]>>1 + r>>1;
    }
}



void mp_setpixel_add(int x, int y, Uint8 r, Uint8 g, Uint8 b)
{
    int p,c;
    if (x>=0 && x<SCREEN_WIDTH && y>=0 && y<SCREEN_HEIGHT) {
        p = (x + y*SCREEN_WIDTH) * 3;
        c = ((Uint8 *)screen->pixels)[p]+b; ((Uint8 *)screen->pixels)[p++] = (c > 255) ? 255 : c;
        c = ((Uint8 *)screen->pixels)[p]+g; ((Uint8 *)screen->pixels)[p++] = (c > 255) ? 255 : c;
        c = ((Uint8 *)screen->pixels)[p]+r; ((Uint8 *)screen->pixels)[p] = (c > 255) ? 255 : c;
    }
}



void mp_setpixel3d(float fx, float fy, float fz, Uint8 r, Uint8 g, Uint8 b)
{
    int x,y;
    fx = (fx/((fz-400)/400));
    fy = (fy/((fz-400)/400));
    x = (int)fx + 200;
    y = (int)fy + 150;
    mp_setpixel_alpha(x-1,y  ,r,g,b);
    mp_setpixel_alpha(x+1,y  ,r,g,b);
    mp_setpixel_alpha(x  ,y-1,r,g,b);
    mp_setpixel_alpha(x  ,y+1,r,g,b);
    mp_setpixel(x,y,r,g,b);
    //printf("%d %d %d %d %d\n", x, y, r, g, b);
}



void gen_ring(int i)
{
    ring_obj[i].x = 0;
    ring_obj[i].y = 0;
    ring_obj[i].r = 20;
}



void draw_line(int x1,int y1,int x2,int y2)
{
    int t;
    if (abs(x2 - x1) > abs(y2 - y1)) {
        if (x2 > x1) {
            for (t = x1; t <= x2; t++) {
                mp_setpixel_add(t,(y1 + ((y2 - y1) * ((t - x1 + 1)) / (x2 - x1 + 1))),5,5,30);
            }
        } else {
            for (t = x2; t <= x1; t++) {
                mp_setpixel_add(t,(y2 + ((y1 - y2) * ((t - x2 + 1)) / (x1 - x2 + 1))),5,5,30);
            }
        }
    } else {
        if (y2 > y1) {
            for (t = y1; t <= y2; t++) {
                mp_setpixel_add(x1 + ((x2 - x1) * ((t - y1 + 1))) / (y2 - y1 +1),t,5,5,30);
            }
        } else {
            for (t = y2; t <= y1; t++) {
                mp_setpixel_add(x2 + ((x1 - x2) * ((t - y2 + 1))) / (y1 - y2 +1),t,5,5,30);
            }
        }
    }
}



void cleanup(void)
{
    /* TODO: free bitmaps etc. */
    SDL_ShowCursor(SDL_ENABLE);
}



int main(int argc, char **argv)
{
    SDL_Surface *image;
    int i,j;
    int x,y;
    float x0,y0,z0;
    float v1,v2;
    int flags;

    if (argc==2 && strcmp(argv[1], "--window")==0) {
        flags = SDL_HWSURFACE|SDL_DOUBLEBUF;
    } else {
        flags = SDL_HWSURFACE|SDL_DOUBLEBUF|SDL_FULLSCREEN;
    }

    if (SDL_Init(SDL_INIT_AUDIO) < 0) {
        fprintf(stderr, "Couldn't initialize SDL: %s\n",SDL_GetError());
        exit(EXIT_FAILURE);
    }
    
    if ((screen = SDL_SetVideoMode(SCREEN_WIDTH, SCREEN_HEIGHT, 24, flags)) == NULL) {
        fprintf(stderr, "Couldn't open video device: %s\n", SDL_GetError());
        exit(EXIT_FAILURE);
    }

    if (Mix_OpenAudio(MIX_DEFAULT_FREQUENCY, MIX_DEFAULT_FORMAT, 2, 4096) < 0) {
        fprintf(stderr, "Couldn't open audio: %s\n", SDL_GetError());
        exit(EXIT_FAILURE);
    }

    if ((music = Mix_LoadMUS(DATAFILE("pip.mod"))) == NULL) {
        fprintf(stderr, "Couldn't load music: %s\n", SDL_GetError());
        exit(EXIT_FAILURE);
    }

    /* init rot_objects */
    for (i=0; i<2000; i++) {
        v1 = (float)(rand()%628)/100;
        v2 = (float)(rand()%628)/100;
        x0 = (sin(v1)*75)*cos(v2);
        y0 = (cos(v1)*75)*cos(v2);
        z0 = (sin(v2)*75);
        rot_obj_show[i].x = (float)x0;
        rot_obj_show[i].y = (float)y0;
        rot_obj_show[i].z = (float)z0;
    }

    /* init ring_objects */
    for (i=0; i<50; i++) {
        gen_ring(i);
        ring_obj[i].r += i*6;
    }

    /* init blur_objects */
    for (i=0; i<100; i++) {
        blur_obj[i].sinx = (float)(rand()%628)/100;
        blur_obj[i].siny = (float)(rand()%628)/100;
        blur_obj[i].sinz = (float)(rand()%628)/100;
        blur_obj[i].facx = (float)(rand()%300)-150;
        blur_obj[i].facy = (float)(rand()%200)-100;
        blur_obj[i].facz = (float)(rand()%20)-10;
        blur_obj[i].hasx = (float)(rand()%100)/3000-(50/3000);
        blur_obj[i].hasy = (float)(rand()%100)/3000-(50/3000);
        blur_obj[i].hasz = (float)(rand()%100)/3000-(50/3000);
    }

    intro    = IMG_Load(DATAFILE("intro.png"));
    bg       = IMG_Load(DATAFILE("bg.png"));
    tux      = IMG_Load(DATAFILE("tux.gif"));
    nerf     = IMG_Load(DATAFILE("nerf.png"));
    greet    = IMG_Load(DATAFILE("greet.png"));
    freeu    = IMG_Load(DATAFILE("free.png"));
    blur     = IMG_Load(DATAFILE("blur.gif"));
    gnu      = IMG_Load(DATAFILE("gnu.png"));
    code0    = IMG_Load(DATAFILE("code0.gif"));
    outtro   = IMG_Load(DATAFILE("outtro.png"));
    txt_a    = IMG_Load(DATAFILE("text_code.png"));
    txt_b    = IMG_Load(DATAFILE("text_music.png"));
    test     = IMG_Load(DATAFILE("test.png"));
    stars[0] = IMG_Load(DATAFILE("star0.png"));
    stars[1] = IMG_Load(DATAFILE("star1.png"));
    stars[2] = IMG_Load(DATAFILE("star2.png"));
    gnutxt   = IMG_Load(DATAFILE("gnutxt.png"));

    SDL_SetColorKey(tux, (SDL_SRCCOLORKEY|SDL_RLEACCEL), *(Uint8 *)tux->pixels);
    SDL_SetColorKey(nerf, (SDL_SRCCOLORKEY|SDL_RLEACCEL), *(Uint8 *)nerf->pixels);
    SDL_SetColorKey(greet, (SDL_SRCCOLORKEY|SDL_RLEACCEL), *(Uint8 *)greet->pixels);
    SDL_SetColorKey(freeu, (SDL_SRCCOLORKEY|SDL_RLEACCEL), *(Uint8 *)freeu->pixels);
    SDL_SetColorKey(code0, (SDL_SRCCOLORKEY|SDL_RLEACCEL), *(Uint8 *)code0->pixels);
    SDL_SetAlpha(code0, SDL_SRCALPHA, 128);
    SDL_SetColorKey(txt_a, (SDL_SRCCOLORKEY|SDL_RLEACCEL), *(Uint8 *)txt_a->pixels);
    SDL_SetColorKey(txt_b, (SDL_SRCCOLORKEY|SDL_RLEACCEL), *(Uint8 *)txt_b->pixels);
    SDL_SetColorKey(test, (SDL_SRCCOLORKEY|SDL_RLEACCEL), *(Uint8 *)test->pixels);
    SDL_SetColorKey(stars[0], (SDL_SRCCOLORKEY|SDL_RLEACCEL), *(Uint8 *)stars[0]->pixels);
    SDL_SetColorKey(stars[1], (SDL_SRCCOLORKEY|SDL_RLEACCEL), *(Uint8 *)stars[1]->pixels);
    SDL_SetColorKey(stars[2], (SDL_SRCCOLORKEY|SDL_RLEACCEL), *(Uint8 *)stars[2]->pixels);
    SDL_SetColorKey(gnutxt, (SDL_SRCCOLORKEY|SDL_RLEACCEL), *(Uint8 *)gnutxt->pixels);
    SDL_SetAlpha(gnutxt, SDL_SRCALPHA, 128);

    {
        int x,y;
        /* hehe, leak (it's not MY mem ;-) */
        blur = SDL_DisplayFormatAlpha(blur);
        for (y=0; y<blur->h; y++) {
            for (x=0; x<blur->w; x++) {
                ((Uint8 *)blur->pixels)[4*(x+y*blur->w)+3] = ((Uint8 *)blur->pixels)[4*(x+y*blur->w)+0] << 1;
                ((Uint8 *)blur->pixels)[4*(x+y*blur->w)+2] = 255;
                ((Uint8 *)blur->pixels)[4*(x+y*blur->w)+1] = 255;
                ((Uint8 *)blur->pixels)[4*(x+y*blur->w)+0] = 255;
            }
        }
    }

    SDL_ShowCursor(SDL_DISABLE);

    Mix_FadeInMusic(music, 0, 500);

    starttick = SDL_GetTicks();

    effect_0();
    effect_1();
    trans_12();
    effect_2();
    effect_3();
    effect_4();

    SDL_ShowCursor(SDL_ENABLE);
    
    return EXIT_SUCCESS;
}



/* INTRO */
void effect_0(void)
{
    SDL_BlitSurface(intro, NULL, screen, NULL);
    while (TICK < END0) {
        PUBLISH
        SDL_Delay(1);
    }
    FLASH
}



/* THE "TUNNEL" THING */
void effect_1(void)
{
    int ii,iii;
    float x0,y0,z0;
    float x1,y1,z1;
    float A,B,C,S0;
    float sinA, sinB, sinC;
    float cosA, cosB, cosC;
    float a,b,c;
    float d,e,f;
    float g,h,i;
    float beat;
    float v;
    int l;

    while ((l=TICK) < END1) {
        A    = l*M_PI/150; //x-rot
        B    = l*M_PI/300; //y-rot
        C    = l*M_PI/600; //z-rot
        beat = l*M_PI/80;

        /* cls */
        SDL_BlitSurface(bg, NULL, screen, NULL);

        //draw bg (tunnel)
        for (ii=0;ii<50;ii++) {
            for (iii=0;iii<3;iii++) {
                ring_obj[ii].r+=1;
                if (ring_obj[ii].r>318) gen_ring(ii);
            }
            x1=ring_obj[ii].r*ring_obj[ii].x;
            y1=ring_obj[ii].r*ring_obj[ii].y;
            for (v=0;v<2*M_PI;v+=M_PI/20) {
                x0=sin(v+(ii*M_PI/200))*ring_obj[ii].r;
                y0=cos(v+(ii*M_PI/200))*ring_obj[ii].r;
                mp_setpixel_alpha(200+x0+x1+1,150+y0+y1  ,255,10,10);
                mp_setpixel_alpha(200+x0+x1-1,150+y0+y1  ,255,0,0);
                mp_setpixel_alpha(200+x0+x1  ,150+y0+y1+1,255,0,0);
                mp_setpixel_alpha(200+x0+x1  ,150+y0+y1-1,255,0,0);
                mp_setpixel(200+x0+x1, 150+y0+y1, 255, 0, 0);
            }
        }

        //beregn sin/cos
        sinA=sin(A);
        sinB=sin(B);
        sinC=sin(C);
        cosA=cos(A);
        cosB=cos(B);
        cosC=cos(C);

        //beregn matrix
        a= cosC*cosB;
        b= sinC*cosB;
        c=-sinB;
        d=-sinC*cosA+cosC*sinB*sinA;
        e= cosC*cosA+sinC*sinB*sinA;
        f= cosB*sinA;
        g= sinC*sinA+cosC*sinB*cosA;
        h=-cosC*sinA+sinC*sinB*cosA;
        i= cosB*cosA;

        S0=(1+(sin(A)/4))*(1+(sin(beat)/12));
        for (ii=0;ii<2000;ii++) {
            x0=rot_obj_show[ii].x;
            y0=rot_obj_show[ii].y;
            z0=rot_obj_show[ii].z;
            x1=a*x0+b*y0+c*z0;
            y1=d*x0+e*y0+f*z0;
            z1=g*x0+h*y0+i*z0;
            x1=x1*S0;
            y1=y1*S0+(15*sin(beat));
            z1=z1*S0;
            mp_setpixel3d(x1,y1,z1+50,100,100,200+(55*sin(C)));
        }

        {
            SDL_Rect dest;
            if (l>START1+200 && l<START1+220) { dest.x=10; dest.y=250; SDL_BlitSurface(nerf, NULL, screen, &dest); }
            if (l>START1+400 && l<START1+420) { dest.x=10; dest.y=10; SDL_BlitSurface(nerf, NULL, screen, &dest); }
            if (l>START1+600 && l<START1+620) { dest.x=290; dest.y=250; SDL_BlitSurface(nerf, NULL, screen, &dest); }
            if (l>START1+800 && l<START1+820) { dest.x=290; dest.y=10; SDL_BlitSurface(nerf, NULL, screen, &dest); }
        }

        if (l>START1+950 && l<=START1+1150) {
            SDL_Rect src;
            src.x = (rand()%30)-15;
            src.y = (rand()%30)-15;
            src.w = txt_a->w;
            src.h = txt_a->h;
            SDL_BlitSurface(txt_a, &src, screen, NULL);
        }

        if (l>START1+1250 && l<=START1+1450) {
            SDL_Rect src;
            src.x = (rand()%30)-15;
            src.y = (rand()%30)-15;
            src.w = txt_b->w;
            src.h = txt_b->h;
            SDL_BlitSurface(txt_b, &src, screen, NULL);
        }

       PUBLISH 
    }
}



/* ZOOMING TUX */
void trans_12(void)
{
    SDL_Rect dest;
    int i,ii,x,y;
    float x0,y0,x1,y1;
    float v;

    FLASH

    for (i=10; i>=1; i--) {
        /* cls */
        for (ii=0; ii<SCREEN_WIDTH*SCREEN_HEIGHT*3; ii+=3) {
            ((Uint8 *)screen->pixels)[ii+2] = 0;
            ((Uint8 *)screen->pixels)[ii+1] = 0;
            ((Uint8 *)screen->pixels)[ii+0] = 100/i;
        }
        for (y=0; y<242/i; y++) {
            for (x=0; x<206/i; x++) {
                unsigned char r,g,b;
                r = (Uint8)tux->format->palette->colors[((Uint8 *)tux->pixels)[x*i+208*y*i]].r;
                g = (Uint8)tux->format->palette->colors[((Uint8 *)tux->pixels)[x*i+208*y*i]].g;
                b = (Uint8)tux->format->palette->colors[((Uint8 *)tux->pixels)[x*i+208*y*i]].b;
                if (r!=255 || g!=0 || b!=0) mp_setpixel(200-(206/i)/2+x, 150-(242/i)/2+y, r, g, b);
                //printf("%d,%d -> %d,%d\n", x, y, x*i, y*i);
            }
        }
        PUBLISH
        SDL_Delay(10);
    }

    FLASH
}



/* THE THING WITH TUX */
void effect_2(void)
{
    int ii;
    int n,t;
    int x,y;
    int xf,yf;
    int xt,yt;
    float a,b,c;
    float v0,v1;
    int tmp;
    int xd,yd;
    int l;

    while ((l=TICK) < END2) {
        // cls
        for (ii=0; ii<(SCREEN_WIDTH*SCREEN_HEIGHT*3); ii+=3) {
            ((Uint8 *)screen->pixels)[ii+0]=100;  // b
            ((Uint8 *)screen->pixels)[ii+1]=0;    // g
            ((Uint8 *)screen->pixels)[ii+2]=0;    // r
        }

        // why here? performance
        xd=cos((l-START2)*0.005)*20;
        yd=cos((l-START2)*0.010)*25;

        for (x=1;x<205;x++) {
            // why here? performance
            xf=x-103;
            for (y=1;y<241;y++) {
                t=x+y*208;  // why 208, not 206?
                if (((Uint8 *)tux->pixels)[t]==201) {
                    n=0;
                    t=((x-1)+(y-1)*208); if (((Uint8 *)tux->pixels)[t]!=201) n++;
                    t=((x  )+(y-1)*208); if (((Uint8 *)tux->pixels)[t]!=201) n++;
                    t=((x+1)+(y-1)*208); if (((Uint8 *)tux->pixels)[t]!=201) n++;
                    t=((x-1)+(y  )*208); if (((Uint8 *)tux->pixels)[t]!=201) n++;
                    t=((x+1)+(y  )*208); if (((Uint8 *)tux->pixels)[t]!=201) n++;
                    t=((x-1)+(y+1)*208); if (((Uint8 *)tux->pixels)[t]!=201) n++;
                    t=((x  )+(y+1)*208); if (((Uint8 *)tux->pixels)[t]!=201) n++;
                    t=((x+1)+(y+1)*208); if (((Uint8 *)tux->pixels)[t]!=201) n++;
                    if (n != 0) {
                        //mp_setpixel(97+x,29+y,0,255,0);

                        // why here? only needed sometimes
                        yf=y-121;
                    
                        a=abs(xf-xd);
                        b=abs(yf-yd);
                        c=sqrt((a*a)+(b*b));
                        v0=(float)asin((yf-yd)/c);
                        v1=(float)asin((xf-xd)/c);
                        if (xf>xd) {
                            tmp=(int)(tan(v0)*(200-xd))+yd;
                        } else {
                            tmp=(int)(tan(v0)*(200+xd))+yd;
                        }
                        if (abs(tmp)<150) {  // der skal tegnes mod siderne
                            if (xf>xd) {  // hoejre
                                xt=200;
                                yt=(int)(tan(v0)*(200-xd))+yd;
                                draw_line(200+xf, 150+yf, 200+xt, 150+yt);
                            } else if (xf<xd) {  // venstre
                                xt=-200;
                                yt=(int)(tan(v0)*(200+xd))+yd;
                                draw_line(200+xf, 150+yf, 200+xt, 150+yt);
                            }
                        } else {  // der skal tegnes mod toppen/bunden
                            if (yf>yd) {  // ned
                                xt=(int)(tan(v1)*(150-yd))+xd;
                                yt=150;
                                draw_line(200+xf, 150+yf, 200+xt, 150+yt);
                            } else if (yf<yd) {  // op
                                xt=(int)(tan(v1)*(150+yd))+xd;
                                yt=-150;
                                draw_line(200+xf, 150+yf, 200+xt, 150+yt);
                            }
                        }
                    }
                }
            }
        }
        //blur_data();

        /* tux =) */
        {
            SDL_Rect dest;
            dest.x = 97;
            dest.y = 29;
            SDL_BlitSurface(tux, NULL, screen, &dest);
        }   
        //mp_setpixel(200+xd, 150+yd, 255, 0, 0);
        //mp_setpixel(200, 150, 255, 0, 0);

        /* code scroller */
        {
            SDL_Rect src;
            src.x = 0;
            src.y = (l-(START2+100)) / 9;
            src.w = SCREEN_WIDTH;
            src.h = SCREEN_HEIGHT;
            SDL_BlitSurface(code0, &src, screen, NULL);
        }   
        
        /* free your source... */
        if (l>START2+300 && l<=START2+900) {
            SDL_Rect src;
            src.x = 0;
            src.y = 0;
            src.w = SCREEN_WIDTH;
            if (l<START2+500) {
                src.h = 130;
            } else {
                src.h = SCREEN_HEIGHT;
            }
            SDL_BlitSurface(freeu, &src, screen, NULL);
        }

        /* greetings */
        if (l>START2+1000 && l<=START2+2200) {
            SDL_Rect src, dest;
            dest.x = 0;
            dest.y = 250;
            src.x = 0;
            src.w = SCREEN_WIDTH;
            src.h = 50;
            if (l>START2+1000 && l<=START2+1060) { src.y =   0; SDL_BlitSurface(greet, &src, screen, &dest); }
            if (l>START2+1100 && l<=START2+1160) { src.y =  50; SDL_BlitSurface(greet, &src, screen, &dest); }
            if (l>START2+1200 && l<=START2+1260) { src.y = 100; SDL_BlitSurface(greet, &src, screen, &dest); }
            if (l>START2+1300 && l<=START2+1360) { src.y = 150; SDL_BlitSurface(greet, &src, screen, &dest); }
            if (l>START2+1400 && l<=START2+1460) { src.y = 200; SDL_BlitSurface(greet, &src, screen, &dest); }
            if (l>START2+1500 && l<=START2+1560) { src.y = 250; SDL_BlitSurface(greet, &src, screen, &dest); }
            if (l>START2+1600 && l<=START2+1660) { src.y = 300; SDL_BlitSurface(greet, &src, screen, &dest); }
            if (l>START2+1700 && l<=START2+1760) { src.y = 350; SDL_BlitSurface(greet, &src, screen, &dest); }
            if (l>START2+1800 && l<=START2+1860) { src.y = 400; SDL_BlitSurface(greet, &src, screen, &dest); }
            if (l>START2+1900 && l<=START2+2200) { src.y = 450; SDL_BlitSurface(greet, &src, screen, &dest); }
        }   
        PUBLISH
    }

    FLASH
}
           


/* THINGS ON THE GNU */
void effect_3(void)
{
    int i,ii;
    float x,y;
    int div;
    int l, ll = 100;
    SDL_Rect dest;

    while ((l=TICK) < END3) {
        /* cls */
        SDL_BlitSurface(gnu, NULL, screen, NULL);

        if (l>START3+200 && l<=START3+215) { dest.x =  30; dest.y =  30; SDL_BlitSurface(gnutxt, NULL, screen, &dest); }
        if (l>START3+250 && l<=START3+265) { dest.x = 230; dest.y = 120; SDL_BlitSurface(gnutxt, NULL, screen, &dest); }
        if (l>START3+300 && l<=START3+315) { dest.x =  50; dest.y = 220; SDL_BlitSurface(gnutxt, NULL, screen, &dest); }
        if (l>START3+350 && l<=START3+365) { dest.x =  30; dest.y =  30; SDL_BlitSurface(gnutxt, NULL, screen, &dest); }
        if (l>START3+400 && l<=START3+415) { dest.x = 230; dest.y = 120; SDL_BlitSurface(gnutxt, NULL, screen, &dest); }
        if (l>START3+450 && l<=START3+465) { dest.x =  50; dest.y = 220; SDL_BlitSurface(gnutxt, NULL, screen, &dest); }
        if (l>START3+1200 && l<=START3+1215) { dest.x = 230; dest.y = 100; SDL_BlitSurface(gnutxt, NULL, screen, &dest); }
        if (l>START3+1250 && l<=START3+1265) { dest.x =  20; dest.y = 180; SDL_BlitSurface(gnutxt, NULL, screen, &dest); }
        if (l>START3+1300 && l<=START3+1315) { dest.x =  20; dest.y =  80; SDL_BlitSurface(gnutxt, NULL, screen, &dest); }
        if (l>START3+1400 && l<=START3+1415) { dest.x = 220; dest.y = 180; SDL_BlitSurface(gnutxt, NULL, screen, &dest); }
        if (l>START3+1450 && l<=START3+1465) { dest.x =  25; dest.y = 100; SDL_BlitSurface(gnutxt, NULL, screen, &dest); }
        if (l>START3+1600 && l<=START3+1615) { dest.x = 215; dest.y =  80; SDL_BlitSurface(gnutxt, NULL, screen, &dest); }
        if (l>START3+1750 && l<=START3+1765) { dest.x =  25; dest.y =  70; SDL_BlitSurface(gnutxt, NULL, screen, &dest); }

        for (i=0; i<50; i++) {
            SDL_Rect dest;
            blur_obj[i].sinx = blur_obj[i].hasx * (l-START3+FUSK);
            blur_obj[i].siny = blur_obj[i].hasy * (l-START3+FUSK);
            blur_obj[i].sinz = blur_obj[i].hasz * (l-START3+FUSK);
            dest.x = 180+sin(blur_obj[i].sinx) * blur_obj[i].facx;
            dest.y = 130+sin(blur_obj[i].siny) * blur_obj[i].facy;
            SDL_BlitSurface(blur, NULL, screen, &dest);
        }

        if (l > START3+600) {
            SDL_Rect dest;
            int idx, off, dy;
            idx = (l/70)%3;
            if (l < START3+900) {
                dy = ((START3+900)-l)/6;
                off = 0;
                div = l;
            } else {
                dy = 0;
                off = ((l-div)/10)%80;
            }
            for (i=0; i<6; i++) {
                dest.x = off + 80*(i-1);
                dest.y = 4 - dy;
                SDL_BlitSurface(stars[idx], NULL, screen, &dest);
                dest.x = 400 - (off + 80*i);
                dest.y = 232 + dy;
                SDL_BlitSurface(stars[idx], NULL, screen, &dest);
            }
        }

        PUBLISH
    }
}



/* OUTTRO */
void effect_4(void)
{
    SDL_BlitSurface(outtro, NULL, screen, NULL);
    while (TICK < END4) {
        PUBLISH
        SDL_Delay(1);
    }
}
