// Construct.cpp: implementation of the CConstruct class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Construct.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CConstruct::CConstruct( PDIRECT3DDEVICE8 pDevice ) : CEfx( pDevice ),
													 m_pvbTunnel( NULL ),
													 m_pvbCircles( NULL ),
													 m_pvbZoom( NULL ),
													 m_pvbSphere( NULL ),													 
													 m_piqDisplay1( NULL ),
													 m_piqDisplay2( NULL ),
													 m_piqMask( NULL ),
													 m_piqZoom( NULL ),
													 m_piqFade( NULL ),
													 m_ptrZoom( NULL )
{
	try
	{
		m_sConstuct.Initialize( m_pDevice );
		m_sConstuct.Load( "data\\scenes\\construct.scene" );

		LoadTexture( "tunnel.jpg", MIP_ALL );
		LoadTexture( "inntunnel.jpg", MIP_ALL );
		LoadTexture( "btunnel.jpg", MIP_ALL );
		LoadTexture( "mask.jpg" );
		LoadAlphaTexture( "display4.bmp" );
		LoadAlphaTexture( "blackpart.bmp" );
	}
	catch( he3d_CException ex )
	{
		TCHAR				ptsErr[] = "unable to initialize/load scene, error code: 00";
		_stprintf( ptsErr, "unable to initialize/load scene, error code: %2i", ex.code );

		throw CSystemException( ptsErr );
	}
	catch( CTextureException )
	{
		throw CSystemException( "unable to load textures" );
	}

	if( FAILED( m_pDevice->CreateVertexBuffer( 100*sizeof(LVERTEX), 0, FVF_SIMPLEVERTEX, D3DPOOL_DEFAULT, &m_pvbTunnel ) ) )
		throw CSystemException( "unable to create tunnel vertex buffer" );

	if( FAILED( m_pDevice->CreateVertexBuffer( 100*6*sizeof(LVERTEX), 0, FVF_LVERTEX, D3DPOOL_DEFAULT, &m_pvbCircles ) ) )
		throw CSystemException( "unable to vreate circles vertex buffer" );	

	if( FAILED( m_pDevice->CreateVertexBuffer( 6*3*sizeof(TLVERTEX), 0, FVF_TLVERTEX, D3DPOOL_DEFAULT, &m_pvbZoom ) ) )
		throw CSystemException( "unable to create zoom vertex buffer" );

	if( FAILED( m_pDevice->CreateVertexBuffer( 202*sizeof(SIMPLEVERTEX), D3DUSAGE_POINTS, FVF_SIMPLEVERTEX, D3DPOOL_DEFAULT, &m_pvbSphere ) ) )
		throw CSystemException( "unable to create sphere vertex buffer" );

	m_piqFade = new CImageQuad( m_pDevice );
	m_piqZoom = new CImageQuad( m_pDevice, 350, 250, 550, 400 );
	m_piqMask = new CImageQuad( m_pDevice );
	m_piqDisplay1 = new CImageQuad( m_pDevice, 44, 62, 556, 318 );	
	m_piqDisplay2 = new CImageQuad( m_pDevice, 332, 205, 568, 435 );

	m_piqZoom->SetColor( 0x808080 );
	m_piqDisplay1->SetColor( 0x0 );
	m_piqDisplay2->SetColor( 0x0 );

	m_ptrZoom = new CTextureRenderer( m_pDevice, TRUE, 256, 256 );

	m_psmConstruct = (he3d_CSegmentedMesh*)m_sConstuct.GetObject( "KONSTRUKSZYN+++" );
	m_psmStuff[0] = (he3d_CSegmentedMesh*)m_sConstuct.GetObject( "STUFF1" );
	m_psmStuff[1] = (he3d_CSegmentedMesh*)m_sConstuct.GetObject( "STUFF2" );
	m_psmStuff[2] = (he3d_CSegmentedMesh*)m_sConstuct.GetObject( "STUFF3" );

	PMESHVERTEX				pV;

	m_vConstrucCenter = he3d_CVector( 0, 0, 0 );
	m_psmConstruct->pvbVertices->Lock( 0, 0, (LPBYTE*)&pV, 0 );

	for( DWORD i = 0 ; i < m_psmConstruct->dwVerticesCount ; i++ )
	{	
		m_vConstrucCenter.x += pV[i].p.x;
		m_vConstrucCenter.y += pV[i].p.y;
		m_vConstrucCenter.z += pV[i].p.z;
	}

	m_psmConstruct->pvbVertices->Unlock();

	m_vConstrucCenter = m_vConstrucCenter/(FLOAT)m_psmConstruct->dwVerticesCount;

	PLVERTEX				pVertices;

	m_pvbTunnel->Lock( 0, 0, (LPBYTE*)&pVertices, 0 );

	*(pVertices++) = LVERTEX( 10.0f, 0.0f,  50.0f, 0xffffff, 0.0f,  0.0f );
	*(pVertices++) = LVERTEX( 10.0f, 0.0f, -50.0f, 0xffffff, 0.0f, 10.0f );	

	for( i = 1 ; i < 50 ; i++ )
	{
		*(pVertices++) = LVERTEX( 10.0f*cosf( (FLOAT)i*H_2PI/49.0f ), 8.0f*sinf( (FLOAT)i*H_2PI/49.0f ),  50.0f, 0xffffff, (FLOAT)i/49.0f,  0.0f );
		*(pVertices++) = LVERTEX( 10.0f*cosf( (FLOAT)i*H_2PI/49.0f ), 8.0f*sinf( (FLOAT)i*H_2PI/49.0f ), -50.0f, 0xffffff, (FLOAT)i/49.0f, 10.0f );
	}

	m_pvbTunnel->Unlock();

	m_pvbCircles->Lock( 0, 0, (LPBYTE*)&pVertices, 0 );

	for( i = 0 ; i < 20 ; i++ )
	{
		*(pVertices++) = LVERTEX(  2.0f + (FLOAT)i*5.0f*8.0f/100.0f,  1.0f + (FLOAT)i*5.0f*7.0f/100.0f, (FLOAT)i*5.0f - 50.0f, 0xffffff, 1.0f, 0.0f );
		*(pVertices++) = LVERTEX( -2.0f - (FLOAT)i*5.0f*8.0f/100.0f,  1.0f + (FLOAT)i*5.0f*7.0f/100.0f, (FLOAT)i*5.0f - 50.0f, 0xffffff, 0.0f, 0.0f );
		*(pVertices++) = LVERTEX(  2.0f + (FLOAT)i*5.0f*8.0f/100.0f, -1.0f - (FLOAT)i*5.0f*7.0f/100.0f, (FLOAT)i*5.0f - 50.0f, 0xffffff, 1.0f, 1.0f );

		*(pVertices++) = LVERTEX(  2.0f + (FLOAT)i*5.0f*8.0f/100.0f, -1.0f - (FLOAT)i*5.0f*7.0f/100.0f, (FLOAT)i*5.0f - 50.0f, 0xffffff, 1.0f, 1.0f );
		*(pVertices++) = LVERTEX( -2.0f - (FLOAT)i*5.0f*8.0f/100.0f,  1.0f + (FLOAT)i*5.0f*7.0f/100.0f, (FLOAT)i*5.0f - 50.0f, 0xffffff, 0.0f, 0.0f );
		*(pVertices++) = LVERTEX( -2.0f - (FLOAT)i*5.0f*8.0f/100.0f, -1.0f - (FLOAT)i*5.0f*7.0f/100.0f, (FLOAT)i*5.0f - 50.0f, 0xffffff, 0.0f, 1.0f );
	}

	m_pvbCircles->Unlock();

	PTLVERTEX				pVerts;

	m_pvbZoom->Lock( 0, 0, (LPBYTE*)&pVerts, 0 );	

	for( i = 0 ; i < 3 ; i++ )
	{
		*(pVerts++) = TLVERTEX( 350.0f, 250.0f, 0.0f, 0.5f, 0x2fffffff, 0.0f, 0.0f );
		*(pVerts++) = TLVERTEX( 550.0f, 400.0f, 0.0f, 0.5f, 0x2fffffff, 1.0f, 1.0f );
		*(pVerts++) = TLVERTEX( 350.0f, 400.0f, 0.0f, 0.5f, 0x2fffffff, 0.0f, 1.0f );

		*(pVerts++) = TLVERTEX( 550.0f, 400.0f, 0.0f, 0.5f, 0x2fffffff, 1.0f, 1.0f );
		*(pVerts++) = TLVERTEX( 350.0f, 250.0f, 0.0f, 0.5f, 0x2fffffff, 0.0f, 0.0f );
		*(pVerts++) = TLVERTEX( 550.0f, 250.0f, 0.0f, 0.5f, 0x2fffffff, 1.0f, 0.0f );
	}

	m_pvbZoom->Unlock();

	DWORD					dwIndex = 0;

	for( i = 0 ; i < 20 ; i++ )
		for( DWORD j = 0 ; j < 10 ; j++ )
		{
			m_vSphere[dwIndex++] = Polar2Cartesian3d( 1.0f, (FLOAT)i*H_2PI/20.0f, (FLOAT)(j+1)*H_PI/11.0f );
		}

	m_vSphere[dwIndex++] = he3d_CVector( 0.0f,  1.0f, 0.0f );
	m_vSphere[dwIndex++] = he3d_CVector( 0.0f, -1.0f, 0.0f );

	for( i = 0 ; i < 6 ; i++ )
		m_vEmiter[i] = Polar2Cartesian3d( 0.8f, H_2PI*RAND(), H_2PI*RAND() );

	// sync splines

	m_fSync[0][ 0] = FLOATKEY(  0.00f,  0.00f );
	m_fSync[0][ 1] = FLOATKEY(  0.20f,  0.00f );
	m_fSync[0][ 2] = FLOATKEY(  0.40f,  0.00f );
	m_fSync[0][ 3] = FLOATKEY(  0.60f,  1.00f );
	m_fSync[0][ 4] = FLOATKEY(  0.80f,  0.00f );
	m_fSync[0][ 5] = FLOATKEY(  0.93f,  0.00f );
	m_fSync[0][ 6] = FLOATKEY(  1.13f,  1.00f );
	m_fSync[0][ 7] = FLOATKEY(  1.33f,  0.00f );
	m_fSync[0][ 8] = FLOATKEY(  2.14f,  0.00f );
	m_fSync[0][ 9] = FLOATKEY(  2.34f,  1.00f );
	m_fSync[0][10] = FLOATKEY(  2.54f,  0.00f );
	m_fSync[0][11] = FLOATKEY(  2.70f,  0.00f );
	m_fSync[0][12] = FLOATKEY(  2.90f,  1.00f );
	m_fSync[0][13] = FLOATKEY(  3.10f,  0.00f );
	m_fSync[0][14] = FLOATKEY(  4.36f,  0.00f );
	m_fSync[0][15] = FLOATKEY(  4.56f,  1.00f );
	m_fSync[0][16] = FLOATKEY(  4.68f,  0.00f );
	m_fSync[0][17] = FLOATKEY(  4.81f,  1.00f );
	m_fSync[0][18] = FLOATKEY(  5.01f,  0.00f );
	m_fSync[0][19] = FLOATKEY(  7.57f,  0.00f );
	m_fSync[0][20] = FLOATKEY(  7.77f,  1.00f );
	m_fSync[0][21] = FLOATKEY(  7.97f,  0.00f );
	m_fSync[0][22] = FLOATKEY(  8.12f,  0.00f );
	m_fSync[0][23] = FLOATKEY(  8.32f,  1.00f );
	m_fSync[0][24] = FLOATKEY(  8.52f,  0.00f );
	m_fSync[0][25] = FLOATKEY(  9.93f,  0.00f );
	m_fSync[0][26] = FLOATKEY( 10.13f,  1.00f );
	m_fSync[0][27] = FLOATKEY( 10.32f,  0.00f );
	m_fSync[0][28] = FLOATKEY( 11.60f,  0.00f );
	m_fSync[0][29] = FLOATKEY( 11.80f,  1.00f );
	m_fSync[0][30] = FLOATKEY( 11.91f,  0.00f );
	m_fSync[0][31] = FLOATKEY( 12.03f,  1.00f );
	m_fSync[0][32] = FLOATKEY( 12.23f,  0.00f );
	m_fSync[0][33] = FLOATKEY( 21.31f,  0.00f );
	m_fSync[0][34] = FLOATKEY( 21.51f,  1.00f );
	m_fSync[0][35] = FLOATKEY( 21.71f,  0.00f );
	m_fSync[0][36] = FLOATKEY( 22.85f,  0.00f );
	m_fSync[0][37] = FLOATKEY( 23.05f,  1.00f );
	m_fSync[0][38] = FLOATKEY( 23.15f,  0.00f );
	m_fSync[0][39] = FLOATKEY( 23.26f,  1.00f );
	m_fSync[0][40] = FLOATKEY( 23.41f,  0.00f );
	m_fSync[0][41] = FLOATKEY( 23.55f,  1.00f );
	m_fSync[0][42] = FLOATKEY( 23.75f,  0.00f );
	m_fSync[0][43] = FLOATKEY( 24.82f,  0.00f );
	m_fSync[0][44] = FLOATKEY( 25.02f,  1.00f );
	m_fSync[0][45] = FLOATKEY( 25.22f,  0.00f );


	InitFloatSpline( 46, m_fSync[0] );

	m_fSync[1][ 0] = FLOATKEY(  0.00f,  0.00f );
	m_fSync[1][ 1] = FLOATKEY(  0.20f,  0.00f );
	m_fSync[1][ 2] = FLOATKEY(  1.51f,  0.00f );
	m_fSync[1][ 3] = FLOATKEY(  1.71f,  1.00f );
	m_fSync[1][ 4] = FLOATKEY(  1.91f,  0.00f );
	m_fSync[1][ 5] = FLOATKEY(  3.26f,  0.00f );
	m_fSync[1][ 6] = FLOATKEY(  3.46f,  1.00f );
	m_fSync[1][ 7] = FLOATKEY(  3.66f,  0.00f );
	m_fSync[1][ 8] = FLOATKEY(  5.24f,  0.00f );
	m_fSync[1][ 9] = FLOATKEY(  5.44f,  1.00f );
	m_fSync[1][10] = FLOATKEY(  5.64f,  0.00f );
	m_fSync[1][11] = FLOATKEY(  6.41f,  0.00f );
	m_fSync[1][12] = FLOATKEY(  6.61f,  1.00f );
	m_fSync[1][13] = FLOATKEY(  6.81f,  0.00f );
	m_fSync[1][14] = FLOATKEY(  6.86f,  0.00f );
	m_fSync[1][15] = FLOATKEY(  7.06f,  1.00f );
	m_fSync[1][16] = FLOATKEY(  7.26f,  0.00f );
	m_fSync[1][17] = FLOATKEY(  8.70f,  0.00f );
	m_fSync[1][18] = FLOATKEY(  8.90f,  1.00f );
	m_fSync[1][19] = FLOATKEY(  9.10f,  0.00f );
	m_fSync[1][20] = FLOATKEY(  9.16f,  0.00f );
	m_fSync[1][21] = FLOATKEY(  9.36f,  1.00f );
	m_fSync[1][22] = FLOATKEY(  9.56f,  0.00f );
	m_fSync[1][23] = FLOATKEY( 10.44f,  0.00f );
	m_fSync[1][24] = FLOATKEY( 10.64f,  1.00f );
	m_fSync[1][25] = FLOATKEY( 10.84f,  0.00f );
	m_fSync[1][26] = FLOATKEY( 12.49f,  0.00f );
	m_fSync[1][27] = FLOATKEY( 12.69f,  1.00f );
	m_fSync[1][28] = FLOATKEY( 12.89f,  0.00f );
	m_fSync[1][29] = FLOATKEY( 13.20f,  0.00f );
	m_fSync[1][30] = FLOATKEY( 13.40f,  1.00f );
	m_fSync[1][31] = FLOATKEY( 13.60f,  0.00f );
	m_fSync[1][32] = FLOATKEY( 13.65f,  0.00f );
	m_fSync[1][33] = FLOATKEY( 13.85f,  1.00f );
	m_fSync[1][34] = FLOATKEY( 14.05f,  0.00f );
	m_fSync[1][35] = FLOATKEY( 14.25f,  1.00f );
	m_fSync[1][36] = FLOATKEY( 14.45f,  0.00f );
	m_fSync[1][37] = FLOATKEY( 14.53f,  0.00f );
	m_fSync[1][38] = FLOATKEY( 14.73f,  1.00f );
	m_fSync[1][39] = FLOATKEY( 14.93f,  0.00f );
	m_fSync[1][40] = FLOATKEY( 15.13f,  1.00f );
	m_fSync[1][41] = FLOATKEY( 15.33f,  0.00f );
	m_fSync[1][42] = FLOATKEY( 15.44f,  0.00f );
	m_fSync[1][43] = FLOATKEY( 15.64f,  1.00f );
	m_fSync[1][44] = FLOATKEY( 15.84f,  0.00f );
	m_fSync[1][45] = FLOATKEY( 16.09f,  0.00f );
	m_fSync[1][46] = FLOATKEY( 16.29f,  1.00f );
	m_fSync[1][47] = FLOATKEY( 16.44f,  0.00f );
	m_fSync[1][48] = FLOATKEY( 16.60f,  1.00f );
	m_fSync[1][49] = FLOATKEY( 16.79f,  0.00f );
	m_fSync[1][50] = FLOATKEY( 16.98f,  1.00f );
	m_fSync[1][51] = FLOATKEY( 17.12f,  0.00f );
	m_fSync[1][52] = FLOATKEY( 17.26f,  1.00f );
	m_fSync[1][53] = FLOATKEY( 17.46f,  0.00f );
	m_fSync[1][54] = FLOATKEY( 17.68f,  0.00f );
	m_fSync[1][55] = FLOATKEY( 17.88f,  1.00f );
	m_fSync[1][56] = FLOATKEY( 18.08f,  0.00f );
	m_fSync[1][57] = FLOATKEY( 18.11f,  0.00f );
	m_fSync[1][58] = FLOATKEY( 18.31f,  1.00f );
	m_fSync[1][59] = FLOATKEY( 18.51f,  0.00f );
	m_fSync[1][60] = FLOATKEY( 18.56f,  0.00f );
	m_fSync[1][61] = FLOATKEY( 18.76f,  1.00f );
	m_fSync[1][62] = FLOATKEY( 18.96f,  0.00f );
	m_fSync[1][63] = FLOATKEY( 19.05f,  0.00f );
	m_fSync[1][64] = FLOATKEY( 19.25f,  1.00f );
	m_fSync[1][65] = FLOATKEY( 19.45f,  0.00f );
	m_fSync[1][66] = FLOATKEY( 19.71f,  0.00f );
	m_fSync[1][67] = FLOATKEY( 19.91f,  1.00f );
	m_fSync[1][68] = FLOATKEY( 20.05f,  0.00f );
	m_fSync[1][69] = FLOATKEY( 20.18f,  1.00f );
	m_fSync[1][70] = FLOATKEY( 20.38f,  0.00f );
	m_fSync[1][71] = FLOATKEY( 20.41f,  0.00f );
	m_fSync[1][72] = FLOATKEY( 20.61f,  1.00f );
	m_fSync[1][73] = FLOATKEY( 20.72f,  0.00f );
	m_fSync[1][74] = FLOATKEY( 20.83f,  1.00f );
	m_fSync[1][75] = FLOATKEY( 21.03f,  0.00f );
	m_fSync[1][76] = FLOATKEY( 21.90f,  0.00f );
	m_fSync[1][77] = FLOATKEY( 22.10f,  1.00f );
	m_fSync[1][78] = FLOATKEY( 22.30f,  0.00f );
	m_fSync[1][79] = FLOATKEY( 23.76f,  0.00f );
	m_fSync[1][80] = FLOATKEY( 23.96f,  1.00f );
	m_fSync[1][81] = FLOATKEY( 24.16f,  0.00f );
	m_fSync[1][82] = FLOATKEY( 24.19f,  0.00f );
	m_fSync[1][83] = FLOATKEY( 24.39f,  1.00f );
	m_fSync[1][84] = FLOATKEY( 24.59f,  0.00f );
	m_fSync[1][85] = FLOATKEY( 25.58f,  0.00f );
	m_fSync[1][86] = FLOATKEY( 25.78f,  1.00f );
	m_fSync[1][87] = FLOATKEY( 25.98f,  0.00f );
	m_fSync[1][88] = FLOATKEY( 26.13f,  0.00f );
	m_fSync[1][89] = FLOATKEY( 26.33f,  1.00f );
	m_fSync[1][90] = FLOATKEY( 26.53f,  0.00f );


	InitFloatSpline( 91, m_fSync[1] );

	m_fSync[2][ 0] = FLOATKEY(  0.00f,  0.00f );
	m_fSync[2][ 1] = FLOATKEY(  0.20f,  0.00f );
	m_fSync[2][ 2] = FLOATKEY(  3.70f,  0.00f );
	m_fSync[2][ 3] = FLOATKEY(  3.90f,  1.00f );
	m_fSync[2][ 4] = FLOATKEY(  4.10f,  0.00f );
	m_fSync[2][ 5] = FLOATKEY(  6.00f,  0.00f );
	m_fSync[2][ 6] = FLOATKEY(  6.20f,  1.00f );
	m_fSync[2][ 7] = FLOATKEY(  6.40f,  0.00f );
	m_fSync[2][ 8] = FLOATKEY( 10.92f,  0.00f );
	m_fSync[2][ 9] = FLOATKEY( 11.12f,  1.00f );
	m_fSync[2][10] = FLOATKEY( 11.32f,  0.00f );
	m_fSync[2][11] = FLOATKEY( 22.47f,  0.00f );
	m_fSync[2][12] = FLOATKEY( 22.67f,  1.00f );
	m_fSync[2][13] = FLOATKEY( 22.87f,  0.00f );
	m_fSync[2][14] = FLOATKEY( 24.45f,  0.00f );
	m_fSync[2][15] = FLOATKEY( 24.65f,  1.00f );
	m_fSync[2][16] = FLOATKEY( 24.85f,  0.00f );
	m_fSync[2][17] = FLOATKEY( 26.72f,  0.00f );
	m_fSync[2][18] = FLOATKEY( 26.92f,  1.00f );
	m_fSync[2][19] = FLOATKEY( 27.12f,  0.00f );


	InitFloatSpline( 20, m_fSync[2] );

	m_fSync[3][ 0] = FLOATKEY(  0.00f,  0.00f );
	m_fSync[3][ 1] = FLOATKEY(  0.20f,  0.00f );
	m_fSync[3][ 2] = FLOATKEY(  1.66f,  0.00f );
	m_fSync[3][ 3] = FLOATKEY(  1.86f,  1.00f );
	m_fSync[3][ 4] = FLOATKEY(  1.99f,  0.00f );
	m_fSync[3][ 5] = FLOATKEY(  2.12f,  1.00f );
	m_fSync[3][ 6] = FLOATKEY(  2.32f,  0.00f );
	m_fSync[3][ 7] = FLOATKEY(  3.48f,  0.00f );
	m_fSync[3][ 8] = FLOATKEY(  3.68f,  1.00f );
	m_fSync[3][ 9] = FLOATKEY(  3.88f,  0.00f );
	m_fSync[3][10] = FLOATKEY(  5.12f,  0.00f );
	m_fSync[3][11] = FLOATKEY(  5.32f,  1.00f );
	m_fSync[3][12] = FLOATKEY(  5.52f,  0.00f );
	m_fSync[3][13] = FLOATKEY(  6.20f,  0.00f );
	m_fSync[3][14] = FLOATKEY(  6.40f,  1.00f );
	m_fSync[3][15] = FLOATKEY(  6.60f,  0.00f );
	m_fSync[3][16] = FLOATKEY(  7.10f,  0.00f );
	m_fSync[3][17] = FLOATKEY(  7.30f,  1.00f );
	m_fSync[3][18] = FLOATKEY(  7.41f,  0.00f );
	m_fSync[3][19] = FLOATKEY(  7.52f,  1.00f );
	m_fSync[3][20] = FLOATKEY(  7.72f,  0.00f );
	m_fSync[3][21] = FLOATKEY(  8.90f,  0.00f );
	m_fSync[3][22] = FLOATKEY(  9.10f,  1.00f );
	m_fSync[3][23] = FLOATKEY(  9.30f,  0.00f );
	m_fSync[3][24] = FLOATKEY( 10.65f,  0.00f );
	m_fSync[3][25] = FLOATKEY( 10.85f,  1.00f );
	m_fSync[3][26] = FLOATKEY( 11.05f,  0.00f );
	m_fSync[3][27] = FLOATKEY( 12.29f,  0.00f );
	m_fSync[3][28] = FLOATKEY( 12.49f,  1.00f );
	m_fSync[3][29] = FLOATKEY( 12.69f,  0.00f );
	m_fSync[3][30] = FLOATKEY( 13.44f,  0.00f );
	m_fSync[3][31] = FLOATKEY( 13.64f,  1.00f );
	m_fSync[3][32] = FLOATKEY( 13.84f,  0.00f );
	m_fSync[3][33] = FLOATKEY( 22.43f,  0.00f );
	m_fSync[3][34] = FLOATKEY( 22.63f,  1.00f );
	m_fSync[3][35] = FLOATKEY( 22.83f,  0.00f );
	m_fSync[3][36] = FLOATKEY( 24.30f,  0.00f );
	m_fSync[3][37] = FLOATKEY( 24.50f,  1.00f );
	m_fSync[3][38] = FLOATKEY( 24.70f,  0.00f );
	m_fSync[3][39] = FLOATKEY( 26.04f,  0.00f );
	m_fSync[3][40] = FLOATKEY( 26.24f,  1.00f );
	m_fSync[3][41] = FLOATKEY( 26.35f,  0.00f );
	m_fSync[3][42] = FLOATKEY( 26.46f,  1.00f );
	m_fSync[3][43] = FLOATKEY( 26.66f,  0.00f );


	InitFloatSpline( 44, m_fSync[3] );

	m_fSync[4][ 0] = FLOATKEY(  0.00f,  0.00f );
	m_fSync[4][ 1] = FLOATKEY(  0.20f,  0.00f );
	m_fSync[4][ 2] = FLOATKEY(  0.85f,  0.00f );
	m_fSync[4][ 3] = FLOATKEY(  1.05f,  1.00f );
	m_fSync[4][ 4] = FLOATKEY(  1.15f,  0.00f );
	m_fSync[4][ 5] = FLOATKEY(  1.26f,  1.00f );
	m_fSync[4][ 6] = FLOATKEY(  1.46f,  0.00f );
	m_fSync[4][ 7] = FLOATKEY(  2.62f,  0.00f );
	m_fSync[4][ 8] = FLOATKEY(  2.82f,  1.00f );
	m_fSync[4][ 9] = FLOATKEY(  2.93f,  0.00f );
	m_fSync[4][10] = FLOATKEY(  3.03f,  1.00f );
	m_fSync[4][11] = FLOATKEY(  3.23f,  0.00f );
	m_fSync[4][12] = FLOATKEY(  4.51f,  0.00f );
	m_fSync[4][13] = FLOATKEY(  4.71f,  1.00f );
	m_fSync[4][14] = FLOATKEY(  4.91f,  0.00f );
	m_fSync[4][15] = FLOATKEY(  5.45f,  0.00f );
	m_fSync[4][16] = FLOATKEY(  5.65f,  1.00f );
	m_fSync[4][17] = FLOATKEY(  5.78f,  0.00f );
	m_fSync[4][18] = FLOATKEY(  5.90f,  1.00f );
	m_fSync[4][19] = FLOATKEY(  6.10f,  0.00f );
	m_fSync[4][20] = FLOATKEY(  8.00f,  0.00f );
	m_fSync[4][21] = FLOATKEY(  8.20f,  1.00f );
	m_fSync[4][22] = FLOATKEY(  8.33f,  0.00f );
	m_fSync[4][23] = FLOATKEY(  8.47f,  1.00f );
	m_fSync[4][24] = FLOATKEY(  8.67f,  0.00f );
	m_fSync[4][25] = FLOATKEY(  9.81f,  0.00f );
	m_fSync[4][26] = FLOATKEY( 10.01f,  1.00f );
	m_fSync[4][27] = FLOATKEY( 10.11f,  0.00f );
	m_fSync[4][28] = FLOATKEY( 10.21f,  1.00f );
	m_fSync[4][29] = FLOATKEY( 10.41f,  0.00f );
	m_fSync[4][30] = FLOATKEY( 11.71f,  0.00f );
	m_fSync[4][31] = FLOATKEY( 11.91f,  1.00f );
	m_fSync[4][32] = FLOATKEY( 12.11f,  0.00f );
	m_fSync[4][33] = FLOATKEY( 19.47f,  0.00f );
	m_fSync[4][34] = FLOATKEY( 19.67f,  1.00f );
	m_fSync[4][35] = FLOATKEY( 19.87f,  0.00f );
	m_fSync[4][36] = FLOATKEY( 20.15f,  0.00f );
	m_fSync[4][37] = FLOATKEY( 20.35f,  1.00f );
	m_fSync[4][38] = FLOATKEY( 20.55f,  0.00f );
	m_fSync[4][39] = FLOATKEY( 21.51f,  0.00f );
	m_fSync[4][40] = FLOATKEY( 21.71f,  1.00f );
	m_fSync[4][41] = FLOATKEY( 21.80f,  0.00f );
	m_fSync[4][42] = FLOATKEY( 21.89f,  1.00f );
	m_fSync[4][43] = FLOATKEY( 22.09f,  0.00f );
	m_fSync[4][44] = FLOATKEY( 23.54f,  0.00f );
	m_fSync[4][45] = FLOATKEY( 23.74f,  1.00f );
	m_fSync[4][46] = FLOATKEY( 23.94f,  0.00f );
	m_fSync[4][47] = FLOATKEY( 25.10f,  0.00f );
	m_fSync[4][48] = FLOATKEY( 25.30f,  1.00f );
	m_fSync[4][49] = FLOATKEY( 25.42f,  0.00f );
	m_fSync[4][50] = FLOATKEY( 25.53f,  1.00f );
	m_fSync[4][51] = FLOATKEY( 25.73f,  0.00f );


	InitFloatSpline( 52, m_fSync[4] );

	m_fSync[5][ 0] = FLOATKEY(  0.00f,  0.00f );
	m_fSync[5][ 1] = FLOATKEY(  0.09f,  0.00f );
	m_fSync[5][ 2] = FLOATKEY(  0.19f,  1.00f );
	m_fSync[5][ 3] = FLOATKEY(  0.30f,  0.00f );
	m_fSync[5][ 4] = FLOATKEY(  0.42f,  1.00f );
	m_fSync[5][ 5] = FLOATKEY(  0.62f,  0.00f );
	m_fSync[5][ 6] = FLOATKEY(  3.94f,  0.00f );
	m_fSync[5][ 7] = FLOATKEY(  4.14f,  1.00f );
	m_fSync[5][ 8] = FLOATKEY(  4.34f,  0.00f );
	m_fSync[5][ 9] = FLOATKEY(  9.38f,  0.00f );
	m_fSync[5][10] = FLOATKEY(  9.58f,  1.00f );
	m_fSync[5][11] = FLOATKEY(  9.78f,  0.00f );
	m_fSync[5][12] = FLOATKEY( 11.15f,  0.00f );
	m_fSync[5][13] = FLOATKEY( 11.35f,  1.00f );
	m_fSync[5][14] = FLOATKEY( 11.55f,  0.00f );
	m_fSync[5][15] = FLOATKEY( 12.71f,  0.00f );
	m_fSync[5][16] = FLOATKEY( 12.91f,  1.00f );
	m_fSync[5][17] = FLOATKEY( 13.02f,  0.00f );
	m_fSync[5][18] = FLOATKEY( 13.14f,  1.00f );
	m_fSync[5][19] = FLOATKEY( 13.34f,  0.00f );
	m_fSync[5][20] = FLOATKEY( 15.87f,  0.00f );
	m_fSync[5][21] = FLOATKEY( 16.07f,  1.00f );
	m_fSync[5][22] = FLOATKEY( 16.27f,  0.00f );
	m_fSync[5][23] = FLOATKEY( 16.60f,  0.00f );
	m_fSync[5][24] = FLOATKEY( 16.80f,  1.00f );
	m_fSync[5][25] = FLOATKEY( 17.00f,  0.00f );
	m_fSync[5][26] = FLOATKEY( 17.26f,  0.00f );
	m_fSync[5][27] = FLOATKEY( 17.46f,  1.00f );
	m_fSync[5][28] = FLOATKEY( 17.66f,  0.00f );
	m_fSync[5][29] = FLOATKEY( 20.89f,  0.00f );
	m_fSync[5][30] = FLOATKEY( 21.09f,  1.00f );
	m_fSync[5][31] = FLOATKEY( 21.29f,  0.00f );
	m_fSync[5][32] = FLOATKEY( 22.65f,  0.00f );
	m_fSync[5][33] = FLOATKEY( 22.85f,  1.00f );
	m_fSync[5][34] = FLOATKEY( 23.05f,  0.00f );
	m_fSync[5][35] = FLOATKEY( 24.65f,  0.00f );
	m_fSync[5][36] = FLOATKEY( 24.85f,  1.00f );
	m_fSync[5][37] = FLOATKEY( 25.05f,  0.00f );

	InitFloatSpline( 38, m_fSync[5] );

	m_dwKeyCount[0] = 46;
	m_dwKeyCount[1] = 91;
	m_dwKeyCount[2] = 20;
	m_dwKeyCount[3] = 44;
	m_dwKeyCount[4] = 52;
	m_dwKeyCount[5] = 38;

	m_fSecSync[0][ 0] = FLOATKEY(  0.00f,  0.00f );
	m_fSecSync[0][ 1] = FLOATKEY(  0.20f,  0.00f );
	m_fSecSync[0][ 2] = FLOATKEY( 14.24f,  0.00f );
	m_fSecSync[0][ 3] = FLOATKEY( 14.44f,  1.00f );
	m_fSecSync[0][ 4] = FLOATKEY( 14.57f,  0.00f );
	m_fSecSync[0][ 5] = FLOATKEY( 14.70f,  1.00f );
	m_fSecSync[0][ 6] = FLOATKEY( 14.76f,  0.00f );
	m_fSecSync[0][ 7] = FLOATKEY( 14.83f,  1.00f );
	m_fSecSync[0][ 8] = FLOATKEY( 14.96f,  0.00f );
	m_fSecSync[0][ 9] = FLOATKEY( 15.09f,  1.00f );
	m_fSecSync[0][10] = FLOATKEY( 15.22f,  0.00f );
	m_fSecSync[0][11] = FLOATKEY( 15.34f,  2.00f );
	m_fSecSync[0][12] = FLOATKEY( 16.00f,  0.00f );
	m_fSecSync[0][13] = FLOATKEY( 17.79f,  0.00f );
	m_fSecSync[0][14] = FLOATKEY( 17.99f,  1.00f );
	m_fSecSync[0][15] = FLOATKEY( 18.06f,  0.00f );
	m_fSecSync[0][16] = FLOATKEY( 18.13f,  1.00f );
	m_fSecSync[0][17] = FLOATKEY( 18.19f,  0.00f );
	m_fSecSync[0][18] = FLOATKEY( 18.25f,  1.00f );
	m_fSecSync[0][19] = FLOATKEY( 18.38f,  0.00f );
	m_fSecSync[0][20] = FLOATKEY( 18.50f,  1.00f );
	m_fSecSync[0][21] = FLOATKEY( 18.63f,  0.00f );
	m_fSecSync[0][22] = FLOATKEY( 18.75f,  2.00f );
	m_fSecSync[0][23] = FLOATKEY( 19.45f,  0.00f );
	m_fSecSync[0][24] = FLOATKEY( 21.28f,  0.00f );
	m_fSecSync[0][25] = FLOATKEY( 21.48f,  1.00f );
	m_fSecSync[0][26] = FLOATKEY( 21.60f,  0.00f );
	m_fSecSync[0][27] = FLOATKEY( 21.72f,  1.00f );
	m_fSecSync[0][28] = FLOATKEY( 21.78f,  0.00f );
	m_fSecSync[0][29] = FLOATKEY( 21.84f,  1.00f );
	m_fSecSync[0][30] = FLOATKEY( 21.97f,  0.00f );
	m_fSecSync[0][31] = FLOATKEY( 22.09f,  1.00f );
	m_fSecSync[0][32] = FLOATKEY( 22.21f,  0.00f );
	m_fSecSync[0][33] = FLOATKEY( 22.34f,  2.00f );
	m_fSecSync[0][34] = FLOATKEY( 23.00f,  0.00f );
	m_fSecSync[0][35] = FLOATKEY( 25.31f,  0.00f );
	m_fSecSync[0][36] = FLOATKEY( 25.51f,  1.00f );
	m_fSecSync[0][37] = FLOATKEY( 25.58f,  0.00f );
	m_fSecSync[0][38] = FLOATKEY( 25.65f,  1.00f );
	m_fSecSync[0][39] = FLOATKEY( 25.71f,  0.00f );
	m_fSecSync[0][40] = FLOATKEY( 25.77f,  1.00f );
	m_fSecSync[0][41] = FLOATKEY( 25.90f,  0.00f );
	m_fSecSync[0][42] = FLOATKEY( 26.03f,  1.00f );
	m_fSecSync[0][43] = FLOATKEY( 26.09f,  0.00f );
	m_fSecSync[0][44] = FLOATKEY( 26.16f,  1.00f );
	m_fSecSync[0][45] = FLOATKEY( 26.36f,  0.00f );


	InitFloatSpline( 46, m_fSecSync[0] );

	m_fSecSync[1][ 0] = FLOATKEY(  0.00f,  0.00f );
	m_fSecSync[1][ 1] = FLOATKEY(  0.20f,  0.00f );
	m_fSecSync[1][ 2] = FLOATKEY( 16.41f,  0.00f );
	m_fSecSync[1][ 3] = FLOATKEY( 16.61f,  1.00f );
	m_fSecSync[1][ 4] = FLOATKEY( 16.68f,  0.00f );
	m_fSecSync[1][ 5] = FLOATKEY( 16.74f,  1.00f );
	m_fSecSync[1][ 6] = FLOATKEY( 16.87f,  0.00f );
	m_fSecSync[1][ 7] = FLOATKEY( 16.99f,  1.00f );
	m_fSecSync[1][ 8] = FLOATKEY( 17.11f,  0.00f );
	m_fSecSync[1][ 9] = FLOATKEY( 17.24f,  1.00f );
	m_fSecSync[1][10] = FLOATKEY( 17.31f,  0.00f );
	m_fSecSync[1][11] = FLOATKEY( 17.37f,  1.00f );
	m_fSecSync[1][12] = FLOATKEY( 17.50f,  0.00f );
	m_fSecSync[1][13] = FLOATKEY( 17.62f,  1.00f );
	m_fSecSync[1][14] = FLOATKEY( 17.82f,  0.00f );
	m_fSecSync[1][15] = FLOATKEY( 19.92f,  0.00f );
	m_fSecSync[1][16] = FLOATKEY( 20.12f,  1.00f );
	m_fSecSync[1][17] = FLOATKEY( 20.18f,  0.00f );
	m_fSecSync[1][18] = FLOATKEY( 20.24f,  1.00f );
	m_fSecSync[1][19] = FLOATKEY( 20.37f,  0.00f );
	m_fSecSync[1][20] = FLOATKEY( 20.49f,  1.00f );
	m_fSecSync[1][21] = FLOATKEY( 20.61f,  0.00f );
	m_fSecSync[1][22] = FLOATKEY( 20.74f,  1.00f );
	m_fSecSync[1][23] = FLOATKEY( 20.86f,  0.00f );
	m_fSecSync[1][24] = FLOATKEY( 20.99f,  1.00f );
	m_fSecSync[1][25] = FLOATKEY( 21.11f,  0.00f );
	m_fSecSync[1][26] = FLOATKEY( 21.23f,  1.00f );
	m_fSecSync[1][27] = FLOATKEY( 21.43f,  0.00f );
	m_fSecSync[1][28] = FLOATKEY( 23.39f,  0.00f );
	m_fSecSync[1][29] = FLOATKEY( 23.59f,  1.00f );
	m_fSecSync[1][30] = FLOATKEY( 23.74f,  0.00f );
	m_fSecSync[1][31] = FLOATKEY( 23.90f,  1.00f );
	m_fSecSync[1][32] = FLOATKEY( 24.05f,  0.00f );
	m_fSecSync[1][33] = FLOATKEY( 24.20f,  1.00f );
	m_fSecSync[1][34] = FLOATKEY( 24.32f,  0.00f );
	m_fSecSync[1][35] = FLOATKEY( 24.45f,  1.00f );
	m_fSecSync[1][36] = FLOATKEY( 24.58f,  0.00f );
	m_fSecSync[1][37] = FLOATKEY( 24.71f,  1.00f );
	m_fSecSync[1][38] = FLOATKEY( 24.83f,  0.00f );
	m_fSecSync[1][39] = FLOATKEY( 24.94f,  1.00f );
	m_fSecSync[1][40] = FLOATKEY( 25.07f,  0.00f );
	m_fSecSync[1][41] = FLOATKEY( 25.20f,  1.00f );
	m_fSecSync[1][42] = FLOATKEY( 25.40f,  0.00f );


	InitFloatSpline( 43, m_fSecSync[1] );


	m_dwSecKeyCount[0] = 46;
	m_dwSecKeyCount[1] = 43;

}

CConstruct::~CConstruct()
{
	SAFE_RELEASE( m_pvbTunnel );
	SAFE_RELEASE( m_pvbCircles );
	SAFE_RELEASE( m_pvbZoom );
	SAFE_RELEASE( m_pvbSphere );	

	SAFE_DELETE( m_piqDisplay1 );
	SAFE_DELETE( m_piqDisplay2 );
	SAFE_DELETE( m_piqMask );
	SAFE_DELETE( m_piqZoom );
	SAFE_DELETE( m_piqFade );
	SAFE_DELETE( m_ptrZoom );
}

BOOL CConstruct::UpdateFrame( FLOAT fTime )
{
	m_sConstuct.Transform( fTime*25.0f );

	m_pDevice->GetTransform( D3DTS_VIEW, &m_d3dmtxView );
	m_pDevice->GetTransform( D3DTS_PROJECTION, &m_d3dmtxProj );

	// light&material setup

	D3DMATERIAL8			d3dmat;
	
	d3dmat.Ambient.r = 1.0f;
	d3dmat.Ambient.g = 1.0f;
	d3dmat.Ambient.b = 1.0f;
	d3dmat.Diffuse.r = 0.4f;
	d3dmat.Diffuse.g = 0.4f;
	d3dmat.Diffuse.b = 0.4f;
	d3dmat.Emissive.r = 0.1f;
	d3dmat.Emissive.g = 0.1f;
	d3dmat.Emissive.b = 0.1f;
	d3dmat.Specular.r = 1.0f;
	d3dmat.Specular.g = 1.0f;
	d3dmat.Specular.b = 1.0f;
	d3dmat.Power = 100.0f;

	m_pDevice->SetMaterial( &d3dmat );

	D3DLIGHT8				d3dlit;
	
	ZeroMemory( &d3dlit, sizeof(D3DLIGHT8) );

	d3dlit.Type = D3DLIGHT_POINT;	
	d3dlit.Attenuation0 = 1.0f;
	d3dlit.Range = LIGHT_RANGE_MAX;

	d3dlit.Position.x = -150;
	d3dlit.Position.y = 70;
	d3dlit.Position.z = -100;

	d3dlit.Specular.r = 1.0f;
	d3dlit.Specular.g = 1.0f;
	d3dlit.Specular.b = 1.0f;
	d3dlit.Diffuse.r = 1.0f;
	d3dlit.Diffuse.g = 1.0f;
	d3dlit.Diffuse.b = 1.0f;

	m_pDevice->SetLight( 0, &d3dlit );

	d3dlit.Position.x = 100;
	d3dlit.Position.y = -50;
	d3dlit.Position.z = -100;

	m_pDevice->SetLight( 1, &d3dlit );

	PLVERTEX				pVertices;

	m_pvbTunnel->Lock( 0, 0, (LPBYTE*)&pVertices, 0 );

	for( DWORD i = 0 ; i < 100 ;  )
	{
		pVertices[i++].m_fV =  0.0f - 0.15f*fTime;
		pVertices[i++].m_fV = 10.0f - 0.15f*fTime;
	}

	m_pvbTunnel->Unlock();

	m_pvbCircles->Lock( 0, 0, (LPBYTE*)&pVertices, 0 );

	for( i = 0 ; i < 20 ; i++ )
	{
		pVertices[6*i+0].m_vPos.z = (FLOAT)i*5.0f - 50.0f - 5.0f*fmodf( 0.25f*fTime, 1.0f );
		pVertices[6*i+1].m_vPos.z = (FLOAT)i*5.0f - 50.0f - 5.0f*fmodf( 0.25f*fTime, 1.0f );
		pVertices[6*i+2].m_vPos.z = (FLOAT)i*5.0f - 50.0f - 5.0f*fmodf( 0.25f*fTime, 1.0f );
		pVertices[6*i+3].m_vPos.z = (FLOAT)i*5.0f - 50.0f - 5.0f*fmodf( 0.25f*fTime, 1.0f );
		pVertices[6*i+4].m_vPos.z = (FLOAT)i*5.0f - 50.0f - 5.0f*fmodf( 0.25f*fTime, 1.0f );
		pVertices[6*i+5].m_vPos.z = (FLOAT)i*5.0f - 50.0f - 5.0f*fmodf( 0.25f*fTime, 1.0f );
	}

	m_pvbCircles->Unlock();

	m_fCoeff = fTime;	

	FLOAT					fAlpha;

	if( fTime < 2.0f )
	{
		m_bRenderFade = TRUE;

		fAlpha = CLAMPALPHA( 140.0f*( 2.0f - fTime ) );
		m_piqFade->SetAlpha( (DWORD)fAlpha );
	}
	else if( fTime > 24.0f )
	{
		m_bRenderFade = TRUE;

		fAlpha = CLAMPALPHA( 140.0f*( fTime - 24.0f ) );
		m_piqFade->SetAlpha( (DWORD)fAlpha );
	}
	else
		m_bRenderFade = FALSE;

	he3d_CMatrix			mtx = TranslationMtx( -m_vConstrucCenter )*RotationMtx( 0.25f*fTime, 0.2f*fTime, 0.3f*fTime )*TranslationMtx( m_vConstrucCenter );

	m_mtxCamera1 = CameraMtx( he3d_CVector( 120, 0, 0 )*mtx, m_vConstrucCenter, 0 );

	// sphere update !!!

	PSIMPLEVERTEX			pVerts;
	he3d_CVector			v, pos, p;
	FLOAT					fSync[6];

	m_pvbSphere->Lock( 0, 0, (LPBYTE*)&pVerts, 0 );

	for( i = 0 ; i < 6 ; i++ )
		fSync[i] = GetFloatSplineValue( fTime, m_dwKeyCount[i], m_fSync[i] );

	mtx = RotationMtx( 0.2f*m_fCoeff, 0.6f*m_fCoeff, 0.4f*m_fCoeff );

	for( i = 0 ; i < 202 ; i++ )
	{	
		pos = m_vSphere[i]*mtx;
		p = pos;

		for( DWORD j = 0 ; j < 6 ; j++ )
		{		
			v = p - (0.5f*fSync[j] + 0.5f)*m_vEmiter[j];			
			pos = pos + Normalize( v )*0.4f/Length( v );
		}

		pVerts[i] = SIMPLEVERTEX( pos, 0x0 );
	}

	m_pvbSphere->Unlock();

	// zoom update

	FLOAT					fZoom;
	PTLVERTEX				pV;

	for( i = 0 ; i < 2 ; i++ )
		fSync[i] = GetFloatSplineValue( fTime, m_dwSecKeyCount[i], m_fSecSync[i] );

	fZoom = fSync[0] + fSync[1];

	m_pvbZoom->Lock( 0, 0, (LPBYTE*)&pV, 0 );	

	for( i = 0 ; i < 3 ; i++ )
	{
		pV[6*i + 0].m_fU = 0.0f + 0.05f*fZoom;
		pV[6*i + 0].m_fV = 0.0f + 0.05f*fZoom;

		pV[6*i + 1].m_fU = 1.0f - 0.05f*fZoom;
		pV[6*i + 1].m_fV = 1.0f - 0.05f*fZoom;

		pV[6*i + 2].m_fU = 0.0f + 0.05f*fZoom;
		pV[6*i + 2].m_fV = 1.0f - 0.05f*fZoom;		

		pV[6*i + 3].m_fU = 1.0f - 0.05f*fZoom;
		pV[6*i + 3].m_fV = 1.0f - 0.05f*fZoom;

		pV[6*i + 4].m_fU = 0.0f + 0.05f*fZoom;
		pV[6*i + 4].m_fV = 0.0f + 0.05f*fZoom;

		pV[6*i + 5].m_fU = 1.0f - 0.05f*fZoom;
		pV[6*i + 5].m_fV = 0.0f + 0.05f*fZoom;
	}

	m_pvbZoom->Unlock();

	return TRUE;
}

BOOL CConstruct::RenderEfx()
{
	m_pDevice->Clear( 0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0xffffff, 1.0f, 0 );	

	m_pDevice->SetRenderState( D3DRS_ZWRITEENABLE, TRUE );

	D3DVIEWPORT8			d3dvp, d3dvpOld;

	m_pDevice->GetViewport( &d3dvpOld );

	d3dvp.MinZ = 0.0f;
	d3dvp.MaxZ = 1.0f;
	d3dvp.X = 62;
	d3dvp.Y = 83;
	d3dvp.Width = 474;
	d3dvp.Height = 214;

	// tunel!!!!

	m_pDevice->SetViewport( &d3dvp );	

	m_pDevice->SetTransform( D3DTS_PROJECTION, ProjectionMtx( 150.0f, 0.75f, 0.01f, 100.0f ) );
	m_pDevice->SetTransform( D3DTS_VIEW, CameraMtx( he3d_CVector( 0, 0, 5 ), he3d_CVector( 0, 0, 10 ), 0 ) );

	m_pDevice->SetTexture( 0, GetTexture( "tunnel.jpg" ) );	

	m_pDevice->SetRenderState( D3DRS_ZENABLE, FALSE );
	m_pDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );
	m_pDevice->SetRenderState( D3DRS_LIGHTING, FALSE );	

	m_pDevice->SetTransform( D3DTS_WORLD, IdentMtx() );

	m_pDevice->SetVertexShader( FVF_LVERTEX );
	m_pDevice->SetStreamSource( 0, m_pvbTunnel, sizeof(LVERTEX) );
	m_pDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 98 );

	m_pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
	m_pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_ONE );
	m_pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );

	m_pDevice->SetTexture( 0, GetTexture( "inntunnel.jpg" ) );	

	m_pDevice->SetTransform( D3DTS_WORLD, ScaleMtx( 0.1f, 0.1f, 1.0f ) );

	m_pDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 98 );

	m_pDevice->SetTexture( 0, GetTexture( "btunnel.jpg" ) );	

	m_pDevice->SetTransform( D3DTS_WORLD, IdentMtx() );

	m_pDevice->SetVertexShader( FVF_LVERTEX );
	m_pDevice->SetStreamSource( 0, m_pvbCircles, sizeof(LVERTEX) );
	m_pDevice->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 40 );	

	//tunnel display!!!

	m_pDevice->SetViewport( &d3dvpOld );
	
	m_pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
	m_pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
	m_pDevice->SetTexture( 0, GetTexture( "display4.bmp" ) );

	m_piqDisplay1->Render( m_pDevice );


	// constuct !!!
	m_pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );
	
	m_pDevice->SetRenderState( D3DRS_SPECULARENABLE, TRUE );
	m_pDevice->SetRenderState( D3DRS_ZENABLE, D3DZB_TRUE );

	m_pDevice->SetTransform( D3DTS_PROJECTION, ProjectionMtx( 10.0f, 0.75f, 1.0f, 1000.0f ) );
	m_pDevice->SetTransform( D3DTS_VIEW, m_mtxCamera1 );
	m_pDevice->SetTexture( 0, NULL );	

	m_pDevice->LightEnable( 0, TRUE );
	m_pDevice->LightEnable( 1, TRUE );	

	m_pDevice->SetRenderState( D3DRS_LIGHTING, TRUE );	
	m_pDevice->SetRenderState( D3DRS_SHADEMODE, D3DSHADE_GOURAUD );	

	m_pDevice->SetTransform( D3DTS_WORLD, m_psmConstruct->mtxTransform );

	m_pDevice->SetVertexShader( MESHFVF );
	m_pDevice->SetStreamSource( 0, m_psmConstruct->pvbVertices, sizeof(MESHVERTEX) );
	m_pDevice->SetIndices( m_psmConstruct->pibIndices, 0 );
	m_pDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, m_psmConstruct->dwFacesCount, 0, m_psmConstruct->dwFacesCount );

	m_pDevice->SetRenderState( D3DRS_SHADEMODE, D3DSHADE_FLAT );
	m_pDevice->SetRenderState( D3DRS_NORMALIZENORMALS, TRUE );

	for( DWORD i = 0 ; i < 3 ; i++ )
	{
		m_pDevice->SetTransform( D3DTS_WORLD, ScaleMtx( 2.0f )*m_psmStuff[i]->mtxTransform );

		m_pDevice->SetVertexShader( MESHFVF );
		m_pDevice->SetStreamSource( 0, m_psmStuff[i]->pvbVertices, sizeof(MESHVERTEX) );
		m_pDevice->SetIndices( m_psmStuff[i]->pibIndices, 0 );
		m_pDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, m_psmStuff[i]->dwFacesCount, 0, m_psmStuff[i]->dwFacesCount );
	}

	/// constuct camera view !!!
	m_ptrZoom->SetTarget( m_pDevice );
	m_pDevice->Clear( 0, 0, D3DCLEAR_ZBUFFER|D3DCLEAR_TARGET, 0xffffff, 1.0f, 0 );

	m_pDevice->SetRenderState( D3DRS_SHADEMODE, D3DSHADE_GOURAUD );

	m_pDevice->SetTransform( D3DTS_PROJECTION, &m_d3dmtxProj );
	m_pDevice->SetTransform( D3DTS_VIEW, &m_d3dmtxView );
	m_pDevice->SetTransform( D3DTS_WORLD, m_psmConstruct->mtxTransform );	

	m_pDevice->SetVertexShader( MESHFVF );
	m_pDevice->SetStreamSource( 0, m_psmConstruct->pvbVertices, sizeof(MESHVERTEX) );
	m_pDevice->SetIndices( m_psmConstruct->pibIndices, 0 );
	m_pDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, m_psmConstruct->dwFacesCount, 0, m_psmConstruct->dwFacesCount );

	m_pDevice->SetRenderState( D3DRS_SHADEMODE, D3DSHADE_FLAT );
	m_pDevice->SetRenderState( D3DRS_NORMALIZENORMALS, TRUE );

	for( i = 0 ; i < 3 ; i++ )
	{
		m_pDevice->SetTransform( D3DTS_WORLD, ScaleMtx( 2.0f )*m_psmStuff[i]->mtxTransform );

		m_pDevice->SetVertexShader( MESHFVF );
		m_pDevice->SetStreamSource( 0, m_psmStuff[i]->pvbVertices, sizeof(MESHVERTEX) );
		m_pDevice->SetIndices( m_psmStuff[i]->pibIndices, 0 );
		m_pDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 0, m_psmStuff[i]->dwFacesCount, 0, m_psmStuff[i]->dwFacesCount );
	}

	m_ptrZoom->RestoreTarget( m_pDevice );

	// camera preview window !!!
	m_pDevice->LightEnable( 0, FALSE );
	m_pDevice->LightEnable( 1, FALSE );

	m_pDevice->SetRenderState( D3DRS_NORMALIZENORMALS, FALSE );
	m_pDevice->SetRenderState( D3DRS_SPECULARENABLE, FALSE );
	m_pDevice->SetRenderState( D3DRS_ZENABLE, FALSE );
	m_pDevice->SetRenderState( D3DRS_LIGHTING, FALSE );	

	m_pDevice->SetTexture( 0, m_ptrZoom->GetTargetTexture() );	
	m_piqZoom->Render( m_pDevice );		

	m_pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
	m_pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
	m_pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );

	m_pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG2 );

	m_pDevice->SetVertexShader( FVF_TLVERTEX );
	m_pDevice->SetStreamSource( 0, m_pvbZoom, sizeof(TLVERTEX) );
	m_pDevice->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 6 );

	m_pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1 );

	m_pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
	m_pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );

	m_pDevice->SetTexture( 0, GetTexture( "display2.bmp" ) );

	m_piqDisplay2->Render( m_pDevice );

	m_pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_ONE );
	m_pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );

	m_pDevice->SetTexture( 0, GetTexture( "mask.jpg" ) );

	m_piqMask->Render( m_pDevice );

	m_pDevice->GetViewport( &d3dvpOld );

	d3dvp.MinZ = 0.0f;
	d3dvp.MaxZ = 1.0f;
	d3dvp.X = 10;
	d3dvp.Y = 330;
	d3dvp.Width = 250;
	d3dvp.Height = 140;

	m_pDevice->SetViewport( &d3dvp );	

	m_pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
	m_pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );

	m_pDevice->SetRenderState( D3DRS_POINTSPRITEENABLE, TRUE );	
	m_pDevice->SetRenderState( D3DRS_POINTSIZE, FLT2DWORD( 10.0f ) );

	m_pDevice->SetTexture( 0, GetTexture( "blackpart.bmp" ) );	

	m_pDevice->SetTransform( D3DTS_PROJECTION, ProjectionMtx( 30.0f, 0.65f, 1.0f, 100.0f ) );
	m_pDevice->SetTransform( D3DTS_VIEW, CameraMtx( he3d_CVector( 0, 0, -15 ), he3d_CVector( 0, 0, 0 ), 0 ) );
	m_pDevice->SetTransform( D3DTS_WORLD, IdentMtx() );

	m_pDevice->SetVertexShader( FVF_SIMPLEVERTEX );
	m_pDevice->SetStreamSource( 0, m_pvbSphere, sizeof(SIMPLEVERTEX) );
	m_pDevice->DrawPrimitive( D3DPT_POINTLIST, 0, 202 );

	m_pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_ONE );
	m_pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );

	m_pDevice->SetRenderState( D3DRS_POINTSIZE, FLT2DWORD( 7.0f ) );

	m_pDevice->SetTexture( 0, GetTexture( "particle.bmp" ) );	
	m_pDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_SELECTARG1 );

	m_pDevice->DrawPrimitive( D3DPT_POINTLIST, 0, 202 );	

	m_pDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );

	m_pDevice->SetViewport( &d3dvpOld );

	m_pDevice->SetRenderState( D3DRS_POINTSPRITEENABLE, FALSE );	

	m_pDevice->SetTexture( 0, NULL );

	if( m_bRenderFade )
	{		
		m_pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
		m_pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );

		m_piqFade->Render( m_pDevice );		
	}

	m_pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );

	return TRUE;
}
