/*
 * Copyright (C) 1995 by Sbastien Loisel All Rights Reserved
 *
 * OS-dependant functions
 */




#include <dosfunc.h>
#include <dos.h>


unsigned long far *screen;

void _to256(void)
	{
	union REGS r;

	r.x.ax=0x13;

	int86(0x10,&r,&r);
	outp(0x3c2,0xe3);
	}


void _totxt(void)
	{
	union REGS r;

	r.x.ax=0x3;
	int86(0x10,&r,&r);
	}

void setpalette(color *palette, int col1, int col2)
	{
	outp(0x3c8,col1);
	while(col1<=col2)
		{
        outp(0x3c9,palette->r);
		outp(0x3c9,palette->g);
		outp(0x3c9,palette->b);
		palette++;
		col1++;
		}
	}



void setgrayscale(int col1, int col2)
	{
	color p[256];
	int x,y;

	for(x=col1;x<=col2;x++)
		{
		y=(col2-x)*63/(col2-col1);
        p[x-col1].r=y;
		p[x-col1].g=y;
		p[x-col1].b=y;
		}

	setpalette(p,col1,col2);
	}



#ifdef __BORLANDC__
void to256(void)
	{
	screen=((unsigned char far *)0xa0000000);
	_to256();
	}

void totxt(void)
	{
	_totxt();
	}

#else
/* Zortech version I hope... */
void to256(void)
	{
	screen=_x386_mk_protected_ptr(0xa0000);
	_to256();
	}

void totxt(void)
	{
	_totxt();
	}
#endif


void blit(outbuffer *out)
	{
	long x,y,z;
	pixel *p;
	long *b;

	p=out->buffer;
	for(y=0;y<out->height;y++)
		{
		z=(y<<6)+(y<<4);
		b=(long *)p;
		for(x=0;x<(out->width>>2);x++)
			{
			screen[z+x]=b[x];
			}
		p+=out->width;
		}
	}
