; ============================================================================
; THE FINAL DONUT ROUTINE by ZJACK with assistance from X-wizard
; ============================================================================
; up to 65536 polys
; ============================================================================
; Double buffered delta flipping + align fixed polygon fill....
; ============================================================================

.model small
.stack 4096h
.486P


TEXTURE segment para public
include texture2.db                ;256x256x256 texture RAW
TEXTURE ends

DCC segment para public
db 65500 dup (0)                   ;virtual screen
DCC ends

VIRTUAL segment para public
db 65500 dup (0)                   ;virtual screen
VIRTUAL ends


.code
      include jumps.asm
      mov ax,4300h
      int 2fh
      cmp al,80h
      je @XMSOK
      mov byte ptr cs:[errr],2  ;no xms-driver installed
      jmp exit
      @XMSOK:
      smsw ax
      test ax,1
      je NOTV86MODE             ;qemm test...
      mov byte ptr cs:[errr],7
      jmp exit
      NOTV86MODE:
      call getsomexms  ;reserves some XMS
      call xmslock     ;locks the xms-block
      call copyright   ;copyright msg
      call loadobject  ;loads to objects needed to XMS
      xor ax,ax
      mov si,offset yadd
      LLL:
      mov word ptr cs:[si],ax    ;yadd (0..199)*320 table....
      add si,2
      add ax,320
      cmp ax,64000
      jne LLL
      mov ax,13h
      int 10h
      call palette
      xor di,di
      mov si,768+10
      push seg dcc
      pop fs
      push 0a000h
      pop ds
      IK:
      mov byte ptr ds:[di],0
      mov byte ptr fs:[di],0
      inc di
      inc si
      cmp di,64000
      jne IK
      push cs
      pop ds
      call prefix                      ;XY's & stuff, prepare env-buffers
      call updateworld                 ;first time settings
      mov eax,dword ptr cs:[sorttixms]
      shr eax,2                        ;sort tables are word aligned,
      jnc FIX1o                        ;make them to dword aligned....
      add dword ptr cs:[sorttixms],2
      FIX1o:
      mov eax,dword ptr cs:[onearrayxms]
      shr eax,2
      jnc FIX2o
      add dword ptr cs:[onearrayxms],2
      FIX2o:
      mov word ptr cs:[camerazpos],8500    ;too small z -> CRASHH!!!!!!!
      mov word ptr cs:[worldxangle],256+512
      mov word ptr ds:[world+34+12],512
               mov ax,word ptr ds:[worldxangle]
               mov word ptr ds:[world+34+10],ax
               mov ax,word ptr ds:[worldzangle]
               mov word ptr ds:[world+34+14],ax

        xor di,di
        xor ax,ax
        @FLOOP:
        mov cx,offset horline
        add cx,ax
        mov word ptr cs:[kadd+di],cx
        add cx,offset HORLINE2- offset HORLINE
        mov word ptr cs:[kadd2+di],cx
        add ax,offset M_LOPPU - offset M_ALKU
        add di,2
        cmp di,640
        jne @FLOOP

MAIN:

        call doenginestuff               ;call the routine
        cmp dword ptr cs:[frame],208     ;208 frames motion have we....
        jae CRASH
        cmp byte ptr cs:[errr],0
        jne crash
        in al,60h
        cmp al,1
        jne MAIN
CRASH:
        mov ax,003h
        int 10h
        jmp exit

;--------------------------------------------------------------------------

flipsdelta:
             push 0a000h
             pop es
         ;    push seg back
         ;    pop gs
             mov ax,seg dcc
             mov bx,seg virtual
             cmp byte ptr cs:[flipflop],1
             jne PASSSSSS2
             mov ax,seg virtual
             mov bx,seg dcc
             PASSSSSS2:
             mov ds,ax
             mov fs,bx
             xor di,di
             xor ebx,ebx
             dOL:
             rept 160
             mov eax,dword ptr ds:[di]
             cmp eax,dword ptr fs:[di]    ;delta checking
             db 74h, 04h                  ;4 pixel tolerance
             mov es:[di],eax
          ;   mov eax,gs:[di]       ;this on if you want the background
             mov fs:[di],ebx        ;and eax here
             add di,4
             endm
             cmp di,64000
             jne dOL
             ret

;--------------------------------------------------------------------------
loadobject:
           mov word ptr cs:[swap],0
           mov eax,dword ptr cs:[objectxms]
           mov dword ptr cs:[lastxms],eax
           mov dword ptr cs:[elementxms],eax
LEFTELEMENTS:
           push cs
           pop ds
           clc
           mov ax,3d00h    ;open file for reading
           mov dx,word ptr cs:[swap] ;file number
           shl dx,3        ;file name length=8 (7+zero)
           add dx,offset names
           int 21h
           jnc @FILEOK
           pop cx                 ;removes the return address from stack
           mov byte ptr cs:[errr],4 ;file-error
           jmp exit
           @FILEOK:
           mov esi,dword ptr cs:[lastxms]
           mov bx,ax    ;Bx=filehandle
           mov ax,0
           mov es,ax     ;flat memory model...
           mov word ptr cs:[fhandle],bx
           @LOADMORE:
           mov bx,word ptr cs:[fhandle]
           mov ah,3fh
           mov cx,65000  ;read 65000 bytes
           push seg dcc
           pop ds
           xor dx,dx
           int 21h
           mov cx,ax
           cmp ax,0
           je fileend      ;if we are in eof then ax is zero
           xor di,di
           TRANSFER:
           mov al,byte ptr ds:[di]  ;get byte from buffer1
           mov byte ptr es:[esi],al ;put it into the xmsblock
           inc di
           inc esi
           cmp di,cx          ;cx=how many bytes loaded this time

           jne TRANSFER
           push cs
           pop ds
           mov dx,offset dot  ;progress dot.....
           mov ah,09h
           int 21h
           jmp @LOADMORE
           fileend:
           mov dword ptr cs:[lastxms],esi    ;offset to next object
           inc word ptr cs:[swap]
           mov bx,word ptr cs:[swap]
           add bx,bx
           add bx,bx
           mov dword ptr cs:[elementxms+bx],esi ;save the object ptrs
           mov bx,word ptr cs:[fhandle]
           mov ah,3eh
           int 21h              ;close the file
           mov ax,word ptr cs:[elements]
           cmp word ptr cs:[swap],ax
           jne LEFTELEMENTS
           ret


getsomexms:
            push cs
            pop ds
            mov ax,4310h
            int 2fh                              ;get the driver location
            mov word ptr cs:[xmscontrol],bx
            mov word ptr cs:[xmscontrol+2],es
            mov ah,09h
            mov dx,(400)
            call cs:[xmscontrol]
            cmp ax,1
            je @MEMOK
            pop cx                    ;cleans the stack
            mov byte ptr cs:[errr],3
            jmp exit                  ;not enough XMS
            @MEMOK:
            mov word ptr cs:[xhandle],dx
            ret

freexms:
            mov ah,0ah
            mov dx,word ptr cs:[xhandle]
            call cs:[xmscontrol]
            ret

xmslock:
             mov ah,0ch
             mov dx,word ptr cs:[xhandle]
             call cs:[xmscontrol]
             mov ax,dx
             shl eax,16
             mov ax,bx
             mov ecx,eax
             shr ecx,1
             jnc ALIGNis2
             inc eax              ;make sure that pointers are word-aligned.
             ALIGNis2:
             mov dword ptr cs:[objectxms],eax
             mov dword ptr cs:[elementxms],eax
             add eax,(64)*1024                ;1.0megz for objects
             mov dword ptr cs:[projectionbuffer],eax   ;0.5megz for matrix
             add eax,(64)*1024
             mov dword ptr cs:[envbufxms],eax   ;environment buf
             add eax,(64)*1024
             mov dword ptr cs:[sorttixms],eax   ;0.1 megz sortti
             add eax,(64)*1024
             mov dword ptr cs:[onearrayxms],eax ;0.1 megz onearray
             ret

unlock:
             push ds
             mov ah,0dh
             mov dx,word ptr cs:[xhandle]
             call cs:[xmscontrol]
             pop ds
             ret


;-------------------------------------------------------------------------
doenginestuff:
            ;  call morph
               call WORLDINIT
               mov word ptr cs:[swap],0
               @INITOBJECTS:
               call WORLDHANDLE
               inc word ptr cs:[swap]
               mov ax,word ptr cs:[world] ;how many objects
               cmp word ptr cs:[swap],ax
               jne @INITOBJECTS
               call sortobjects
               mov word ptr cs:[swap],0
@OBJECTSLEFT:
               mov bx,word ptr cs:[swap]
               shl bx,5
               mov ax,word ptr cs:[zclipnear]
               cmp word ptr cs:[(bx+world+2)+16+4+2],ax
               jng @ALLFACESHIDDEN   ;object.in.world is behind the camera!
               call setobject
               call rotate
               call initsortbuffer
               cmp word ptr cs:[facecount],0
               je @ALLFACESHIDDEN
               call bytesort     ;remove if you like unsorted stuff ;)
               call environment  ;remove if you like, default U&Vs sucks...
               call txdrawpolys
               @ALLFACESHIDDEN:
               inc word ptr cs:[swap]
               mov ax,word ptr cs:[world] ;how many objects
               cmp word ptr cs:[swap],ax
               jne @OBJECTSLEFT
            ;   call retrace
               call flipsdelta
               call UPDATEWORLD  ;movements/action scripts
            ;   call umorp       ;update morph pointers
               xor byte ptr cs:[flipflop],255
               ret
;---------------------------------------------------------------
WORLDINIT:    push cs
              pop ds
              mov bx,word ptr ds:[worldxangle]      ;start matrix calculation
              mov si,word ptr ds:[worldyangle]
              mov di,word ptr ds:[worldzangle]
              add bx,bx
              add si,si
              add di,di

            mov bp,word ptr ds:[sine+bx]
            mov bx,word ptr ds:[cose+bx]
            mov ax,word ptr ds:[cose+si]
            mov word ptr ds:[coy],ax
            mov si,word ptr ds:[sine+si]
            mov ax,word ptr ds:[sine+di]
            mov word ptr ds:[siz],ax
            mov di,word ptr ds:[cose+di]

            mov ax,word ptr ds:[coy]
            imul di
            mov al,ah
            mov ah,dl
            mov word ptr ds:[wphase1+1],ax
            mov ax,si
            imul di
            mov al,ah
            mov ah,dl
            imul bp
            mov cl,ah
            mov ch,dl
            mov ax,word ptr ds:[siz]
            imul bx
            mov al,ah
            mov ah,dl
            add ax,cx
            mov word ptr ds:[wphase2+1],ax
            mov ax,si
            imul di
            mov al,ah
            mov ah,dl
            imul bx
            mov cl,ah
            mov ch,dl
            mov ax,word ptr ds:[siz]
            imul bp
            mov al,ah
            mov ah,dl
            sub ax,cx
            mov word ptr ds:[wphase3+1],ax

            mov ax,word ptr ds:[siz]
            neg ax
            imul word ptr ds:[coy]
            mov al,ah
            mov ah,dl
            mov word ptr ds:[wphase4+1],ax
            mov ax,word ptr ds:[siz]
            imul si
            mov al,ah
            mov ah,dl
            imul bp
            mov cl,ah
            mov ch,dl
            mov ax,bx
            imul di
            mov al,ah
            mov ah,dl
            sub ax,cx
            mov word ptr ds:[wphase5+1],ax

            mov ax,word ptr ds:[siz]
            imul si
            mov al,ah
            mov ah,dl
            imul bx
            mov al,ah
            mov ah,dl
            mov cx,ax
            mov ax,bp
            imul di
            mov al,ah
            mov ah,dl
            add ax,cx
            mov word ptr ds:[wphase6+1],ax

            mov ax,si
            mov word ptr ds:[wphase7+1],ax
            mov ax,word ptr ds:[coy]
            neg ax
            imul bp
            mov al,ah
            mov ah,dl
            mov word ptr ds:[wphase8+1],ax
            mov ax,word ptr ds:[coy]
            imul bx
            mov al,ah
            mov ah,dl
            mov word ptr ds:[wphase9+1],ax
            mov ax,word ptr ds:[wphase1+1]            ;constants
            mov bx,word ptr ds:[wphase2+1]            ;for 6-mul system
            imul bx
            mov al,ah
            mov ah,dl
            mov word ptr ds:[wcp1+1],ax
            mov ax,word ptr ds:[wphase4+1]            ;constants
            mov bx,word ptr ds:[wphase5+1]            ;for 6-mul system
            imul bx
            mov al,ah
            mov ah,dl
            mov word ptr ds:[wcp2+1],ax
            mov ax,word ptr ds:[wphase7+1]            ;constants
            mov bx,word ptr ds:[wphase8+1]            ;for 6-mul system
            imul bx
            mov al,ah
            mov ah,dl
            mov word ptr ds:[wcp3+1],ax
            mov ax,word ptr ds:[viewpointx]
            imul word ptr ds:[viewpointy]
            mov al,ah
            mov ah,dl
            mov word ptr ds:[viewpointxy],ax
            ret

WORLDHANDLE:
            push cs
            pop ds
            mov bx,word ptr ds:[swap]
            shl bx,5                       ;32 bytes/object 16 data, 16 swap
            add bx,offset world+2
            mov ax,word ptr ds:[bx+2]      ;object.in.world.xpos
            mov cx,word ptr ds:[bx+4]
            imul cx                        ;object.in.world.ypos
            mov al,ah
            mov ah,dl
            mov di,ax     ;object.in.world.xypos
            add di,word ptr ds:[viewpointxy]
            cmp byte ptr ds:[bx+1],255
            je @INDEPENDENT
            mov eax,dword ptr ds:[worldxangle]
            mov dword ptr ds:[bx+16+10],eax
            mov ax,word ptr ds:[worldzangle]
            mov word ptr ds:[bx+16+14],ax
            jmp @SETOK
            @INDEPENDENT:
            mov eax,dword ptr ds:[bx+10]    ;object.in.world.angle.x
            mov dword ptr ds:[bx+16+10],eax
            mov ax,word ptr ds:[bx+14]      ;object.in.world.angle.x
            mov word ptr ds:[bx+16+14],ax
            @SETOK:
            mov bp,word ptr ds:[bx+6]       ;bp=object.in.world.z
            add bp,word ptr ds:[viewpointz]
            mov cx,word ptr ds:[bx+4]       ;cx=object.in.world.y
            add cx,word ptr ds:[viewpointy]
            mov si,word ptr ds:[bx+2]       ;si=object.in.world.x
            add si,word ptr ds:[viewpointx]

wPHASE2:    mov ax,999
            add ax,si
wPHASE1:    mov dx,666
            add dx,cx
            imul dx
            mov bl,ah
            mov bh,dl
            sub bx,di
wPHASE3:    mov ax,666;word ptr cs:[r13]
            imul bp
            mov al,ah
            mov ah,dl
            add ax,bx
wCP1:       sub ax,666
            mov word ptr ds:[WXA+1],ax
wPHASE5:    mov ax,999;word ptr cs:[r12]
            add ax,si                  ;X+A
wPHASE4:    mov dx,666;word ptr cs:[r11]   ;Y+B
            add dx,cx
            imul dx                    ;(X+A)*(Y+B)
            mov bl,ah
            mov bh,dl
            sub bx,di                  ;vertex.xy
wPHASE6:    mov ax,666;word ptr cs:[r13]
            imul bp
            mov al,ah
            mov ah,dl
wCP2:       sub ax,666
            add ax,bx
            mov word ptr ds:[WYA+1],ax
wPHASE8:    mov ax,999;word ptr cs:[r12]
            add ax,si
wPHASE7:    mov dx,666;word ptr cs:[r11]
            add dx,cx
            imul dx
            mov bl,ah
            mov bh,dl
            sub bx,di
wPHASE9:    mov ax,666;word ptr cs:[r13]
            imul bp
            mov al,ah
            mov ah,dl
wCP3:       sub ax,666
            add ax,bx
            mov dx,ax
            mov bx,word ptr ds:[swap]
            mov cx,bx
            shl bx,5
            add bx,offset world+18
            mov ax,word ptr ds:[cameraxpos]
WXA:        add ax,6666
            mov word ptr ds:[bx+2],ax
            mov ax,word ptr ds:[cameraypos]
WYA:        add ax,7777
            mov word ptr ds:[bx+4],ax
            mov ax,word ptr ds:[camerazpos]
            add ax,dx
            mov word ptr ds:[bx+6],ax
            mov bx,cx
            add bx,bx
            add bx,bx
            add bx,offset sortti2
            mov word ptr ds:[bx],ax   ;object z      to sort table
            mov word ptr ds:[bx+2],cx ;object number to sort table
            ret
;--------------------------------------------------------------------
setobject:
            push cs
            pop ds
            mov si,word ptr ds:[swap]  ;object number
            add si,si
            add si,si
            mov bx,word ptr ds:[sortti2+si+2]
            shl bx,5
            movzx ax,byte ptr ds:[world+2+bx] ;object type
            mov word ptr ds:[tempobj],ax      ;save the type for later use
            mov si,ax
            add si,si
            add si,si
            mov eax,dword ptr ds:[elementxms+si]
            mov dword ptr ds:[objectxms],eax
            mov eax,dword ptr ds:[elementenvxms+si]
            mov dword ptr ds:[envbufxms],eax
            add bx,offset world+18 ;BX is now pointer to current object
            mov ax,word ptr ds:[bx+2]      ;objectxpos
            mov word ptr ds:[WX+1],ax
            mov ax,word ptr ds:[bx+4]      ;objectypos
            mov word ptr ds:[WY+1],ax
            mov ax,word ptr ds:[bx+6]      ;objectzpos
            mov word ptr ds:[WZ+1],ax
            mov ax,word ptr ds:[bx+10]     ;objectxangle
            mov word ptr ds:[TAX+1],ax
            mov ax,word ptr ds:[bx+12]     ;objectyangle
            mov word ptr ds:[TAY+1],ax
            mov ax,word ptr ds:[bx+14]     ;objectzangle
            mov word ptr ds:[TAZ+1],ax
            ret
;---------------------------------------------------------------------
updateworld:
               push cs
               pop ds
               sub word ptr ds:[worldyangle],8
               cmp word ptr ds:[worldyangle],0
               jge OKAY
               mov word ptr ds:[worldyangle],1023
               OKAY:
               mov ax,word ptr ds:[worldxangle]
               mov word ptr ds:[world+34+10],ax
               mov ax,word ptr ds:[worldzangle]
               mov word ptr ds:[world+34+14],ax
               sub word ptr ds:[world+34+12],8
               cmp word ptr ds:[world+34+12],0
               jge OKAY2
               mov word ptr ds:[world+34+12],1023
               OKAY2:
               add word ptr ds:[worldzangle],8
               cmp word ptr ds:[worldzangle],1023
               jna OKAY3
               mov word ptr ds:[worldzangle],0
               OKAY3:
               mov bx,word ptr ds:[worldzangle]
               add bx,bx
               mov ax,word ptr ds:[sine+bx]
               shl ax,4
               add ax,8500
               mov word ptr ds:[camerazpos],ax
               ret

;---------------------------------------------------------------------------
umorp:        push cs                        ;simple morph adders
              pop ds
              mov ax,word ptr ds:[madd]
              add word ptr ds:[mframe],ax
              cmp word ptr ds:[mframe],260
              jne @QUIT1
              mov word ptr ds:[madd],-4
              mov word ptr ds:[mframe],252
              @QUIT1:
              cmp word ptr ds:[mframe],-4
              jne @QUIT2
              mov word ptr ds:[mframe],4
              mov word ptr ds:[madd],4
              @QUIT2:
              ret
;---------------------------------------------------------------------------
morph:                                          ;not optimized
            mov ax,0
            mov ds,ax
            mov bx,word ptr cs:[transformers]
            add bx,bx
            add bx,bx
            mov esi,dword ptr cs:[elementxms+bx]  ;pointer to element
            movzx eax,word ptr ds:[esi]           ;face amount
            movzx edx,word ptr ds:[esi+2]         ;vertex amount
            shl eax,5
            add eax,4
            add esi,eax                   ;esi=ptr to dest object
            mov ecx,eax
            shl edx,3
            add edx,esi                   ;edx is=end ptr to object dest
            mov dword ptr cs:[modi+3],edx

            mov bx,word ptr cs:[transformers+2]
            add bx,bx
            add bx,bx
            mov ebp,dword ptr cs:[elementxms+bx]  ;pointer to element

            mov bx,word ptr cs:[transformers+4]
            add bx,bx
            add bx,bx
            mov eax,dword ptr cs:[elementxms+bx]  ;pointer to element
            sub eax,ebp
            mov dword ptr cs:[SR2+3],eax
            mov dword ptr cs:[SR3+3],eax
            mov dword ptr cs:[SR4+3],eax
            add ebp,ecx
            mov di,word ptr cs:[mframe]  ;di=frame for ob1
            mov cx,256
            sub cx,di                    ;cx=frame for ob2
            xchg ebp,esi
@MP:
            mov ax,word ptr ds:[esi]
            imul cx
            mov bh,dl
            mov bl,ah
SR2:        mov ax,word ptr ds:[esi+44332211h]
            imul di
            mov al,ah
            mov ah,dl
            add ax,bx
            mov word ptr ds:[ebp],ax       ;new x
            push ax
            add ebp,2
            add esi,2
            mov ax,word ptr ds:[esi]
            imul cx
            mov bh,dl
            mov bl,ah
SR3:        mov ax,word ptr ds:[esi+44332211h]
            imul di
            mov al,ah
            mov ah,dl
            add ax,bx
            mov word ptr ds:[ebp],ax       ;new y
            push ax
            add ebp,2
            add esi,2
            mov ax,word ptr ds:[esi]
            imul cx
            mov bh,dl
            mov bl,ah
SR4:        mov ax,word ptr ds:[esi+44332211h]
            imul di
            mov al,ah
            mov ah,dl
            add ax,bx
            mov word ptr ds:[ebp],ax       ;new z
            add ebp,2
            add esi,2
            pop ax
            pop dx
            imul dx
            mov al,ah
            mov ah,dl
            mov word ptr ds:[ebp],ax
            add ebp,2
            add esi,2
MODI:       cmp ebp,44332211h   ;for perfect morph we should
            jne @MP             ;recalculate also normals
           ret                  ;Just a vertex morph.....


;------------------------------------------------------------------
rotate:      push cs
             pop ds
             xor ax,ax
             mov es,ax

TAX:        mov bx,4545      ;start matrix calculation
TAY:        mov si,4545
TAZ:        mov di,4545
            add bx,bx
            add si,si
            add di,di
            mov bp,word ptr ds:[sine+bx]
            mov bx,word ptr ds:[cose+bx]
            mov ax,word ptr ds:[cose+si]
            mov word ptr ds:[coy],ax
            mov si,word ptr ds:[sine+si]
            mov ax,word ptr ds:[sine+di]
            mov word ptr ds:[siz],ax
            mov di,word ptr ds:[cose+di]
            mov ax,word ptr ds:[coy]
            imul di
            mov al,ah
            mov ah,dl
            mov word ptr ds:[phase1+1],ax
            mov word ptr ds:[vrphase1+1],ax
            mov word ptr ds:[vrphase1b+1],ax
            mov word ptr ds:[vrphase1c+1],ax
            mov ax,si
            imul di
            mov al,ah
            mov ah,dl
            imul bp
            mov cl,ah
            mov ch,dl
            mov ax,word ptr ds:[siz]
            imul bx
            mov al,ah
            mov ah,dl
            add ax,cx
            mov word ptr ds:[phase2+1],ax
            mov word ptr ds:[vrphase2+1],ax
            mov word ptr ds:[vrphase2b+1],ax
            mov word ptr ds:[vrphase2c+1],ax
            mov ax,si
            imul di
            mov al,ah
            mov ah,dl
            imul bx
            mov cl,ah
            mov ch,dl
            mov ax,word ptr ds:[siz]
            imul bp
            mov al,ah
            mov ah,dl
            sub ax,cx
            mov word ptr ds:[phase3+1],ax
            mov word ptr ds:[vrphase3+1],ax
            mov word ptr ds:[vrphase3b+1],ax
            mov word ptr ds:[vrphase3c+1],ax

            mov ax,word ptr ds:[siz]
            neg ax
            imul word ptr ds:[coy]
            mov al,ah
            mov ah,dl
            mov word ptr ds:[phase4+1],ax
            mov word ptr ds:[vrphase4+1],ax
            mov word ptr ds:[vrphase4b+1],ax
            mov word ptr ds:[vrphase4c+1],ax

            mov ax,word ptr ds:[siz]
            imul si
            mov al,ah
            mov ah,dl
            imul bp
            mov cl,ah
            mov ch,dl
            mov ax,bx
            imul di
            mov al,ah
            mov ah,dl
            sub ax,cx
            mov word ptr ds:[phase5+1],ax
            mov word ptr ds:[vrphase5+1],ax
            mov word ptr ds:[vrphase5b+1],ax
            mov word ptr ds:[vrphase5c+1],ax

            mov ax,word ptr ds:[siz]
            imul si
            mov al,ah
            mov ah,dl
            imul bx
            mov al,ah
            mov ah,dl
            mov cx,ax
            mov ax,bp
            imul di
            mov al,ah
            mov ah,dl
            add ax,cx
            mov word ptr ds:[phase6+1],ax
            mov word ptr ds:[vrphase6+1],ax
            mov word ptr ds:[vrphase6b+1],ax
            mov word ptr ds:[vrphase6c+1],ax

            mov ax,si
            mov word ptr ds:[phase7+1],ax
            mov word ptr ds:[lbl1+2],ax
            mov ax,word ptr ds:[coy]
            neg ax
            imul bp
            mov al,ah
            mov ah,dl
            mov word ptr ds:[phase8+1],ax
            mov word ptr ds:[lbl2+1],ax
            mov ax,word ptr ds:[coy]
            imul bx
            mov al,ah
            mov ah,dl
            mov word ptr ds:[phase9+1],ax     ;matrix is calculated now
            mov word ptr ds:[lbl3+1],ax
            mov edi,dword ptr ds:[objectxms]  ;absolute ptr to obj.data in XMS
            movzx eax,word ptr es:[edi]       ;face amount
            shl eax,5
            add eax,edi
            add eax,4
            mov dword ptr ds:[p0+3],eax        ;32bit offset is here added
            add eax,2
            mov dword ptr ds:[p2+3],eax
            add eax,2
            mov dword ptr ds:[p4+3],eax
            add eax,2
            mov dword ptr ds:[p9+3],eax
            movzx eax,word ptr es:[edi+2]      ;vertex amount
            shl eax,3
            mov dword ptr ds:[offset comp+3],eax
            mov ax,word ptr ds:[xpos2d]
            mov word ptr ds:[xp+1],ax
            mov ax,word ptr ds:[ypos2d]
            mov word ptr ds:[yp+1],ax
            mov ax,word ptr ds:[phase1+1]      ;constants
            mov bx,word ptr ds:[phase2+1]      ;for 6-mul system
            imul bx
            mov al,ah
            mov ah,dl
            sub word ptr ds:[WX+1],ax
            mov word ptr ds:[vrcp1+1],ax
            mov word ptr ds:[vrcp1b+1],ax
            mov word ptr ds:[vrcp1c+1],ax
            mov ax,word ptr ds:[phase4+1]            ;constants
            mov bx,word ptr ds:[phase5+1]            ;for 6-mul system
            imul bx
            mov al,ah
            mov ah,dl
            sub word ptr ds:[WY+1],ax
            mov word ptr ds:[vrcp2+1],ax
            mov word ptr ds:[vrcp2b+1],ax
            mov word ptr ds:[vrcp2c+1],ax
            mov ax,word ptr ds:[phase7+1]            ;constants
            mov bx,word ptr ds:[phase8+1]            ;for 6-mul system
            imul bx
            mov al,ah
            mov ah,dl
            sub word ptr ds:[WZ+1],ax
            mov word ptr ds:[hidden+2],ax
            mov eax,dword ptr cs:[projectionbuffer] ;pointer to matrix
            mov dword ptr ds:[putx+3],eax
            add eax,2
            mov dword ptr ds:[puty+3],eax
            add eax,2
            mov dword ptr ds:[putz+3],eax
            xor edi,edi                  ;relative ptr to obj.vertex.data
            mov ax,0
            mov ds,ax
RTMAIN:                                           ;rotate & 2d transform

            push di
     P4:    mov bp,word ptr ds:[edi+44332211h]      ;bp=vertex.z
     P2:    mov cx,word ptr ds:[edi+44332211h]      ;cx=vertex.y
     P0:    mov si,word ptr ds:[edi+44332211h]      ;si=vertex.x
     P9:    mov di,word ptr ds:[edi+44332211h]      ;fs=vertex.y

PHASE2:     mov ax,999
            add ax,si
PHASE1:     mov dx,666
            add dx,cx
            imul dx
            mov bl,ah
            mov bh,dl
            sub bx,di
PHASE3:     mov ax,666
            imul bp
            mov al,ah
            mov ah,dl
            add ax,bx
WX:         add ax,6666
            mov word ptr cs:[xmod+1],ax
PHASE5:     mov ax,999
            add ax,si
PHASE4:     mov dx,666
            add dx,cx
            imul dx
            mov bl,ah
            mov bh,dl
            sub bx,di
PHASE6:     mov ax,666
            imul bp
            mov al,ah
            mov ah,dl
            add ax,bx
WY:         add ax,6666
            mov word ptr cs:[res2+1],ax
PHASE8:     mov ax,999
            add ax,si
PHASE7:     mov dx,666
            add dx,cx
            imul dx
            mov bl,ah
            mov bh,dl
            sub bx,di
PHASE9:     mov ax,666;word ptr cs:[r13]
            imul bp
            mov al,ah
            mov ah,dl
WZ:         add ax,7777
            add bx,ax
            pop di
PUTZ:       mov word ptr ds:[edi+4+(44332211h)],bx
      XMOD: mov ax,9999
            cwd
            mov dl,ah
            mov ah,al
         ;   xor al,al   ;no need becoz 0..255 div 256+ is zero....bx>255
            idiv bx
      XP:   add ax,1995
PUTX:       mov word ptr ds:[edi+(44332211h)],ax
      RES2: mov ax,666
            cwd
            mov dl,ah
            mov ah,al
         ;   xor al,al   ;no need becoz 0..255 div 256+ is zero....bx>255
            idiv bx
        YP: add ax,653
PUTY:       mov word ptr ds:[edi+2+(44332211h)],ax
           SKIP:
            add edi,8      ;wasting memory one word/vertex for faster access
      COMP: cmp edi,44332211h
            jne RTMAIN
            ret

;------------------------------------------------------------
environment:
              push gs
              push es
              push ds
              mov ax,0
              mov ds,ax
              xor ebp,ebp
              mov eax,dword ptr cs:[sorttixms]
              add eax,2
              mov dword ptr cs:[fc-4],eax
              mov eax,dword ptr cs:[envbufxms]
              mov dword ptr cs:[fc2c-4],eax
              mov dword ptr cs:[fc3c-4],eax
              mov dword ptr cs:[fc4c-4],eax
              add eax,2
              mov dword ptr cs:[fc2b-4],eax
              mov dword ptr cs:[fc3b-4],eax
              mov dword ptr cs:[fc4b-4],eax
              add eax,2
              mov dword ptr cs:[fc2a-4],eax
              mov dword ptr cs:[fc3a-4],eax
              mov dword ptr cs:[fc4a-4],eax
              add eax,2
              mov dword ptr cs:[fc2d-4],eax
              mov dword ptr cs:[fc3d-4],eax
              mov dword ptr cs:[fc4d-4],eax

              add dword ptr cs:[fc4c-4],16
              add dword ptr cs:[fc4b-4],16
              add dword ptr cs:[fc4a-4],16
              add dword ptr cs:[fc4d-4],16
              add dword ptr cs:[fc3c-4],8
              add dword ptr cs:[fc3b-4],8
              add dword ptr cs:[fc3a-4],8
              add dword ptr cs:[fc3d-4],8

              mov eax,dword ptr cs:[objectxms]
              add eax,16
              mov dword ptr cs:[fc3+3],eax
              mov ax,word ptr cs:[facecount]
              mov bp,ax
              dec bp
          ;    mov word ptr cs:[fc5+2],ax
@vrFACESLEFT:
              xor edi,edi
              mov di,word ptr ds:[ebp*4+11223344h]  ;get the face number
          fc: mov ebx,edi
              shl ebx,3
              lea ebx,[ebx*2+ebx]               ;multiply by 24
              shl edi,5                         ;32 bytes data per face
         fc3: add edi,11223344h
              push bp
              mov word ptr ds:[0],bx   ;
              push di                  ;who cares about int 0 vector...
                 mov di,word ptr ds:[ebx+11223344h]
        fc2a:    mov cx,word ptr ds:[ebx+11223344h]
        fc2b:    mov si,word ptr ds:[ebx+11223344h]
        fc2c:    mov bp,word ptr ds:[ebx+11223344h]
        fc2d:
vrPHASE2:   mov ax,999
            add ax,si
vrPHASE1:   mov dx,666
            add dx,cx
            imul dx
            mov bl,ah
            mov bh,dl
            sub bx,bp
vrPHASE3:   mov ax,666
            imul di
            mov al,ah
            mov ah,dl
            add ax,bx
vrCP1:      sub ax,666
            sar ax,1
            xor ah,ah
            mov dx,ax
vrPHASE5:   mov ax,999
            add ax,si
            mov si,dx
vrPHASE4:   mov dx,666
            add dx,cx
            imul dx
            mov bl,ah
            mov bh,dl
            sub bx,bp
vrPHASE6:   mov ax,666
            imul di
            mov al,ah
            mov ah,dl
            add ax,bx
vrCP2:      sub ax,666
            pop di
            shl ax,7     ;ah=(al sar 1).......
            xor al,al
            or  ax,si
            add ax,8080h
            mov word ptr ds:[edi],ax
            mov bx,word ptr ds:[0]
            push di
            mov di,word ptr ds:[ebx+11223344h]
      fc3a: mov cx,word ptr ds:[ebx+11223344h]
      fc3b: mov si,word ptr ds:[ebx+11223344h]
      fc3c: mov bp,word ptr ds:[ebx+11223344h]
      fc3d:

vrPHASE2b:  mov ax,999
            add ax,si
vrPHASE1b:  mov dx,666
            add dx,cx
            imul dx
            mov bl,ah
            mov bh,dl
            sub bx,bp
vrPHASE3b:  mov ax,666
            imul di
            mov al,ah
            mov ah,dl
            add ax,bx
vrCP1b:     sub ax,666
            sar ax,1
            xor ah,ah
            mov dx,ax
vrPHASE5b:  mov ax,999
            add ax,si
            mov si,dx
vrPHASE4b:  mov dx,666
            add dx,cx
            imul dx
            mov bl,ah
            mov bh,dl
            sub bx,bp
vrPHASE6b:  mov ax,666
            imul di
            mov al,ah
            mov ah,dl
            add ax,bx
vrCP2b:     sub ax,666
            pop di
            shl ax,7
            xor al,al
            or  ax,si
            add ax,8080h
            mov word ptr ds:[edi+2],ax
            mov bx,word ptr ds:[0]
            push di
             mov di,word ptr ds:[ebx+11223344h]
       fc4a: mov cx,word ptr ds:[ebx+11223344h]
       fc4b: mov si,word ptr ds:[ebx+11223344h]
       fc4c: mov bp,word ptr ds:[ebx+11223344h]
       fc4d:

vrPHASE2c:  mov ax,999
            add ax,si
vrPHASE1c:  mov dx,666
            add dx,cx
            imul dx
            mov bl,ah
            mov bh,dl
            sub bx,bp
vrPHASE3c:  mov ax,666
            imul di
            mov al,ah
            mov ah,dl
            add ax,bx
vrCP1c:     sub ax,666
            sar ax,1
            xor ah,ah
            mov dx,ax
vrPHASE5c:  mov ax,999
            add ax,si
            mov si,dx
vrPHASE4c:  mov dx,666
            add dx,cx
            imul dx
            mov bl,ah
            mov bh,dl
            sub bx,bp
vrPHASE6c:  mov ax,666
            imul di
            mov al,ah
            mov ah,dl
            add ax,bx
vrCP2c:     sub ax,666
            pop di
            shl ax,7
            xor al,al
            or  ax,si
            add ax,8080h
            mov word ptr ds:[edi+4],ax         ;14
            pop bp
            sub bp,1
            jnc @vrFACESLEFT
            pop ds
            pop es
            pop gs
            ret
; ---------------------------------------------------------------
RETRACE:
                mov dx,3dah
AGAIN1:         in al,dx
                and al,08h
                jnz AGAIN1
AGAIN2:         in al,dx
                and al,08h
                jz AGAIN2
                ret

;-------------------------------------------------------------------
exit:

       push cs
       pop ds
       cmp byte ptr ds:[errr],2
       je @WASXMSerror
       cmp byte ptr ds:[errr],3
       je @WASXMSerror
       cmp byte ptr ds:[errr],7
       je @WASXMSerror

       call unlock
       call freexms
 @WASXMSerror:
       movzx dx,byte ptr ds:[errr]
       shl dx,4
       add dx,offset msg
       xor ax,ax
       mov ah,09h
       int 21h
       mov ax,4c00h
       int 21h
;-------------------------------------------------------------------
copyright:
       push cs
       pop ds
       mov dx,offset title3
       xor ax,ax
       mov ah,09h
       int 21h
       mov dx,offset title2
       xor ax,ax
       mov ah,09h
       int 21h
       ret
;--------------------------------------------------------------------
palette:
             mov al,0
             mov dx,03c8h
             out dx,al
             mov si,0
             mov dx,03c9h
MAINL:
             mov al,byte ptr cs:[si+10+pal]    ;phong.pal
             out dx,al
             mov al,byte ptr cs:[si+1+10+pal]
             out dx,al
             mov al,byte ptr cs:[si+2+10+pal]
             out dx,al
             add si,3
             cmp si,768
             jne MAINL
             ret
;-------------------------------------------------------------------
initsortbuffer:
                mov ebp,dword ptr cs:[projectionbuffer]
                mov ax,0
                mov ds,ax
                mov word ptr cs:[facecount],0
                xor cx,cx
                mov edi,dword ptr cs:[sorttixms]
                add ebp,4
                mov dword ptr cs:[muu1-4],ebp
                mov dword ptr cs:[muu2-4],ebp
                mov dword ptr cs:[muu3-4],ebp
                xor ebx,ebx
                mov esi,dword ptr cs:[objectxms]
                mov cx,word ptr ds:[esi]  ;face count
                dec cx
                add esi,4                 ;pointer to face begin of data
                xor bp,bp
INITL:
            mov ax,word ptr ds:[esi+6]
LBL2:       add ax,6666
            mov dx,word ptr ds:[esi+8]
LBL1:       add dx,7777
            imul dx
            mov bl,ah
            mov bh,dl
            sub bx,word ptr ds:[esi+12+(3*6)]     ;facenormal.xy, weird stored.
HIDDEN:     sub bx,666
LBL3:       mov ax,666
            imul word ptr ds:[esi+10]
            mov al,ah
            mov ah,dl
            add ax,bx
            njs zCLIPPEDorHIDDEN
       ;     cmp ax,-20     ;hidden face remove angle, adjust this, if bugs
       ;     njng zCLIPPEDorHIDDEN   ;yeah, this bugs a lot
                mov bx,word ptr ds:[esi]
                mov dx,word ptr ds:[ebx*8+11223344h] ;rotated z
           MUU1:
                mov bx,word ptr ds:[esi+2]
                add dx,word ptr ds:[ebx*8+11223344h] ;rotated z
           MUU2:
                mov bx,word ptr ds:[esi+4]
                add dx,word ptr ds:[ebx*8+11223344h]   ;rotated z
           MUU3:mov word ptr ds:[edi],dx     ;first the z
                mov word ptr ds:[edi+2],bp   ;then the face number
                add edi,4
       ZCLIPPEDorHIDDEN:
                add esi,32
                inc bp
                sub cx,1
                jnc INITL
                sub edi,cs:[sorttixms]
                shr edi,2
                mov word ptr cs:[facecount],di
                ret
;------------------------------------------------------------------------
align 2
count dw 260 dup (0)
bytesort:                        ;byte sort for faces....
         push cs
         pop ds
         xor eax,eax
         OFF=0
         rept 129
         mov dword ptr ds:[offset count+OFF],eax
         OFF=OFF+4
         endm
         xor ax,ax
         mov ds,ax
         mov eax,dword ptr cs:[sorttixms]
         mov dword ptr cs:[indexinxms],eax
         mov eax,dword ptr cs:[onearrayxms]
         mov dword ptr cs:[indexoutxms],eax
         mov ax,word ptr cs:[facecount]
         mov word ptr cs:[itemcount],ax
         mov word ptr cs:[bytenumber],0
         mov esi,dword ptr cs:[indexinxms]
         mov dx,0
         mov cx,word ptr cs:[itemcount]
         @bloop:
         mov bl,byte ptr ds:[esi]
         xor bh,bh
         inc bx
         add bx,bx
         inc word ptr cs:[bx+count]
         add esi,4
         sub cx,1
         jnc @bloop
         mov bx,offset count
         push ds
         push cs
         pop ds
         @cloop:
         mov ax,word ptr ds:[bx]
         add bx,2
         add word ptr ds:[bx],ax
         cmp bx,510 +offset count
         jna @cloop
         pop ds
         xor dx,dx
         xor ebx,ebx
         xor ecx,ecx
         mov edi,dword ptr cs:[indexinxms]
         mov eax,dword ptr cs:[indexoutxms]
         mov dword ptr cs:[sf2-4],eax
         mov bp,word ptr cs:[facecount]
         xor esi,esi
         @dloop:
         mov eax,dword ptr ds:[edi]
         mov bx,ax
         xor bh,bh
         add bx,bx
         mov si,word ptr cs:[bx+count]
         mov dword ptr ds:[esi*4+11223344h],eax
    SF2: inc word ptr cs:[bx+count]
         add edi,4
         sub bp,1
         jnc @dloop
         push cs
         pop ds
         xor eax,eax
         OFF=0
         rept 129
         mov dword ptr ds:[offset count+OFF],eax
         OFF=OFF+4
         endm
         mov eax,dword ptr cs:[onearrayxms]
         mov dword ptr cs:[indexinxms],eax
         mov eax,dword ptr cs:[sorttixms]
         mov dword ptr cs:[indexoutxms],eax
         mov ax,word ptr cs:[facecount]
         mov word ptr cs:[itemcount],ax
         mov word ptr cs:[bytenumber],8
         xor ax,ax
         mov ds,ax
         mov esi,dword ptr cs:[indexinxms]
         inc esi
         mov dx,0
         mov cx,word ptr cs:[itemcount]
         p@bloop:
         mov bl,byte ptr ds:[esi]
         xor bh,bh
         inc bx
         add bx,bx
         inc word ptr cs:[bx+count]
         add esi,4
         sub cx,1
         jnc p@bloop

        mov bx,offset count
        push ds
        push cs
        pop ds
        p@cloop:
        mov ax,word ptr ds:[bx]
        add bx,2
        add word ptr ds:[bx],ax
        cmp bx,510 +offset count
        jna p@cloop
        pop ds
        mov dx,0
        xor ebx,ebx
        xor ecx,ecx
        mov edi,dword ptr cs:[indexinxms]
        mov eax,dword ptr cs:[indexoutxms]
        mov dword ptr cs:[sf3-4],eax
        mov bp,word ptr cs:[facecount]
        xor esi,esi
        p@dloop:
        mov eax,dword ptr ds:[edi]
        mov bl,ah
        xor bh,bh
        add bx,bx
        mov si,word ptr cs:[bx+count]
        mov dword ptr ds:[esi*4+11223344h],eax
   SF3: inc word ptr cs:[bx+count]
        add edi,4
        sub bp,1
        jnc p@dloop
        ret
;----------------------------------------------------------------------------
sortobjects:                               ;bitsort for objects....
                push es                    ;lazyness.....
                push ds
                push cs
                pop ds
                mov     ax,ds
                mov     es,ax
                cld
                mov     dx,word ptr ds:[world]
                shl     dx,2
                add     dx,offset sortti2
		XOR	AX,AX
		MOV	byte ptr ds:[fcount],0
                mov     bp,1
o@outloop:
                mov     si,offset sortti2
                mov     di,offset onearray2
                mov     bx,offset zeroarray2

o@iloop:
		MOV	EAX,dword ptr ds:[SI]
		test    AX,bp
		JE	o@zeros
		MOV	dword ptr ds:[di],EAX
                add     di,4
                add     si,4
                cmp     si,dx
                jne     o@iloop
		JMP	oPdASS
o@zeros:
		MOV	dword ptr ds:[bx],eax
                add     bx,4
                add     si,4
		CMP	si,dx
                jne o@iloop
oPdASS:
                mov     cx,di
                sub     cx,offset onearray2
                shr     cx,2
                mov     si,offset onearray2
                mov     di,offset sortti2
                o@okc:
                or cx,cx
                jz oNOTHISTIME
                oalfa:
                mov eax,dword ptr ds:[si]
                mov dword ptr ds:[di],eax
                add di,4
                add si,4
                dec cx
                jnz oalfa
                oNOTHISTIME:
                mov     si,offset zeroarray2
                mov     cx,bx
                sub     cx,offset zeroarray2
                shr     cx,2
                or cx,cx
                jz oNOTHISTIME2
                oalfa2:
                mov eax,dword ptr ds:[si]
                mov dword ptr ds:[di],eax
                add di,4
                add si,4
                dec cx
                jnz oalfa2
                oNOTHISTIME2:
		add	bp,bp
		inc	byte ptr ds:[fcount]
		CMP	byte ptr ds:[fcount],0FH
		Jng	o@outloop
                pop ds
                pop es
                ret

;---------------------------------------------------------------------------
prefix:
               mov word ptr cs:[swap],0
               mov eax,dword ptr cs:[envbufxms]
               mov dword ptr cs:[lastxms],eax
     MORETOFIX:
               push ds
               xor ax,ax
               mov ds,ax
               mov di,word ptr cs:[swap]
               add di,di
               add di,di
               mov esi,dword ptr cs:[elementxms+di]
               mov dword ptr cs:[objectxms],esi
               mov bp,word ptr ds:[esi]   ;bp=face amount
               mov ax,24                  ;24 bytes in env map per face
               mul bp
               movzx eax,ax
               add esi,4
               xor cx,cx
               mov ebx,dword ptr cs:[lastxms]
               mov dword ptr cs:[elementenvxms+di],ebx
               add dword ptr cs:[lastxms],eax
               MULL:
               mov ax,word ptr ds:[esi+6] ;face.normal.x
               mov di,word ptr ds:[esi+8] ;face.normal.y
               imul di
               mov al,ah
               mov ah,dl
               mov word ptr ds:[esi+12+(3*6)],ax

               mov ax,word ptr ds:[esi+16] ;vertex1.normal.z
               sar word ptr ds:[esi+16],1
               add word ptr ds:[esi+16],128
               mov word ptr ds:[ebx+4],ax
               mov ax,word ptr ds:[esi+12] ;vertex1.normal.x
               sar word ptr ds:[esi+12],1
               add word ptr ds:[esi+12],128
               mov word ptr ds:[ebx],ax
               mov di,word ptr ds:[esi+14] ;vertex1.normal.y
               sar word ptr ds:[esi+14],1
               add word ptr ds:[esi+14],128
               mov word ptr ds:[ebx+2],di
               imul di
               mov al,ah
               mov ah,dl
               mov word ptr ds:[ebx+6],ax
               add ebx,8
               mov ax,word ptr ds:[esi+22] ;vertex2.normal.z
               sar word ptr ds:[esi+22],1
               add word ptr ds:[esi+22],128
               mov word ptr ds:[ebx+4],ax
               mov ax,word ptr ds:[esi+18] ;vertex2.normal.x
               sar word ptr ds:[esi+18],1
               add word ptr ds:[esi+18],128
               mov word ptr ds:[ebx],ax
               mov di,word ptr ds:[esi+20] ;vertex2.normal.y
               sar word ptr ds:[esi+20],1
               add word ptr ds:[esi+20],128
               mov word ptr ds:[ebx+2],di
               imul di
               mov al,ah
               mov ah,dl
               mov word ptr ds:[ebx+6],ax
               add ebx,8
               mov ax,word ptr ds:[esi+28] ;vertex3.normal.z
               sar word ptr ds:[esi+28],1
               add word ptr ds:[esi+28],128
               mov word ptr es:[ebx+4],ax
               mov ax,word ptr ds:[esi+24] ;vertex3.normal.x
               sar word ptr ds:[esi+24],1
               add word ptr ds:[esi+24],128

               mov word ptr ds:[ebx],ax
               mov di,word ptr ds:[esi+26] ;vertex3.normal.y
               sar word ptr ds:[esi+26],1
               add word ptr ds:[esi+26],128
               mov word ptr ds:[ebx+2],di
               imul di
               mov al,ah
               mov ah,dl
               mov word ptr ds:[ebx+6],ax
               add ebx,8
               add esi,32
               inc cx
               cmp cx,bp
               jne MULL
               movzx eax,bp       ;face amount
               shl eax,5          ;per each face is 32 bytes
               add eax,4
               mov esi,dword ptr cs:[objectxms]
               mov di,word ptr ds:[esi+2]  ;di=vertex amount
               add esi,eax                 ;esi = begin of vertex data
               VMULL:
               mov ax,word ptr ds:[esi]   ;vertex.x
               mov bx,word ptr ds:[esi+2] ;vertex.y
               imul bx
               mov al,ah
               mov ah,dl
               mov word ptr ds:[esi+6],ax ;vertex.xy,
               add esi,8                  ; the converter doesn't do it.
               dec di
               jnz VMULL
               pop ds
               inc word ptr cs:[swap]
               mov ax,word ptr cs:[elements]
               cmp word ptr cs:[swap],ax
               jne MORETOFIX
               ret

;---------------------------------------------------------------------------
txdrawpolys:
            xor ax,ax
            mov ds,ax
          ;  mov ax,seg loadbuffer
          ;  mov es,ax
            mov ax,seg dcc
            cmp byte ptr cs:[flipflop],1
            jne PASSSSSS
            mov ax,seg virtual
            PASSSSSS:
            mov es,ax
            jmp @WASDELTA
            @NORMALT:
            mov ax,seg virtual
            mov es,ax
            @WASDELTA:
            mov ecx,dword ptr cs:[sorttixms]
            mov dword ptr cs:[moo-4],ecx
            add dword ptr cs:[moo-4],2
            movzx eax,word ptr cs:[facecount]
            add eax,eax
            add eax,eax
            add ecx,eax
            sub ecx,4
            mov eax,dword ptr cs:[objectxms]
            add eax,16
            mov dword ptr cs:[mdr1+3],eax
            mov eax,dword ptr cs:[projectionbuffer]
            mov dword ptr cs:[mcr1-4],eax
            mov dword ptr cs:[mcr4-4],eax
            mov dword ptr cs:[mcr6-4],eax
            add eax,2
            mov dword ptr cs:[mcr2-4],eax
            mov dword ptr cs:[mcr5-4],eax
            mov dword ptr cs:[mcr3-4],eax
            xor edi,edi
            add ecx,2
            xor ebx,ebx
            xor edx,edx
txPLOOP:
            xor ax,ax
            mov ds,ax
            push cx
            xor esi,esi
            mov si,word ptr ds:[ecx]         ;get the facenumber
            shl esi,5
      mdr1: add esi,11223344h
            mov eax,dword ptr ds:[esi]
            mov dword ptr cs:[ux1],eax
            mov ax,word ptr ds:[esi+4]
            mov word ptr cs:[ux3],ax
            mov dx,word ptr ds:[esi-12]          ;pointer to vertex3
            mov bx,word ptr ds:[esi+2-12]        ;pointer to vertex1
            mov di,word ptr ds:[esi+4-12]        ;pointer to vertex2
            mov bp, word ptr ds:[edx*8+11223344h]     ;get the vertex1-x
 mcr6:      mov dx, word ptr ds:[edx*8+2+11223344h]   ;get the vertex1-y
 mcr5:      mov cx, word ptr ds:[edi*8+11223344h]     ;get the vertex3-x
 mcr4:      mov di, word ptr ds:[edi*8+2+11223344h]   ;get the vertex3-y
 mcr3:      mov si, word ptr ds:[ebx*8+2+11223344h]   ;get the vertex2-y
 mcr2:      mov bx, word ptr ds:[ebx*8+11223344h]     ;get the vertex2-x
 MCR1:      mov ax, cs
            mov ds, ax
;--------------------------------------------------------------------------
; 2D-TEXTURE MAPPING ROUTINE
;-------------------------------------------------------------------------
texturepoly:
;mov bp,word ptr ds:[tx1]
;mov bx,word ptr ds:[tx2]
;mov cx,word ptr ds:[tx3]
;mov dx,word ptr ds:[ty1]
;mov si,word ptr ds:[ty2]
;mov di,word ptr ds:[ty3]
cmp dx,si
njne @NOSAME1
cmp dx,di
njne @NOSAME1
cmp si,di
fje AWAY            ;all y's are same then we skip, maybe unnecessary
;cmp bp,-512        ;boundary check removed
;jng AWAY
;cmp bx,-512
;jng AWAY
;cmp cx,-512
;jng AWAY
;cmp dx,-512
;jng AWAY
;cmp si,-512
;jng AWAY
;cmp di,-512
;jng AWAY
;cmp bp,511
;jg AWAY
;cmp bx,511
;jg AWAY
;cmp cx,511
;jg AWAY
;cmp dx,511
;jg AWAY
;cmp si,511
;jg AWAY
;cmp di,511
;jg AWAY

@NOSAME1:
mov ax,bp
and ax,bx    ;out of screen check  (left)
and ax,cx
fjs AWAY
TPAS1:
cmp bp,319
njng TPAS2
cmp bx,319
njng TPAS2
cmp cx,319
fjg AWAY     ;out of screen check (right)
TPAS2:
mov ax,dx
and ax,si    ;out of screen check (up)
and ax,di
fjs AWAY
TPAS3:
cmp dx,199
njng TPAS4
cmp si,199
njng TPAS4
cmp di,199
fjg AWAY      ;out of screen check (down)
TPAS4:
cmp dx,si
njng EI1
xchg dx,si
xchg bp,bx
mov ax,word ptr ds:[ux2]
xchg ax,word ptr ds:[ux1]
mov word ptr ds:[ux2],ax
Ei1:
cmp dx,di
njng EI2
xchg dx,di
xchg bp,cx
mov ax,word ptr ds:[ux3]
xchg ax,word ptr ds:[ux1]
mov word ptr ds:[ux3],ax
Ei2:
cmp si,di
njng EI3
xchg si,di
xchg bx,cx
mov ax,word ptr ds:[ux3]
xchg ax,word ptr ds:[ux2]
mov word ptr ds:[ux3],ax
Ei3:
mov word ptr ds:[ttx1],bp
mov word ptr ds:[ttx2],bx
mov word ptr ds:[ttx3],cx
mov word ptr ds:[tty1],dx
mov word ptr ds:[tty2],si
mov word ptr ds:[tty3],di

  mov word ptr ds:[ys],dx
  cmp dx,-1
  njg @INSCREEN
  mov word ptr ds:[ys],0
  @INSCREEN:
  mov word ptr ds:[ye],di
  cmp di,199
  njng @INSCREEN2
  mov word ptr ds:[ye],199
  @INSCREEN2:
;----------------------------------------------------------------------
;Line 1 ->  Y1-Y3 left
;----------------------------------------------------------------------
mov ax, bp
sub ax, cx
mov bx, dx
sub bx, di
dec bx
cwd
shl ax,6
idiv bx
mov si,ax
xor ah,ah
xor dh,dh
mov cx, word ptr ds:[ux1]
mov al,cl
mov dl, byte ptr ds:[ux3]
sub ax,dx
cwd
shl ax,7
idiv bx
add ax,ax
mov word ptr ds:[@f0+2],ax
xor ah,ah
xor dh,dh
mov al, byte ptr ds:[uy1]
mov dl, byte ptr ds:[uy3]
sub ax,dx
cwd
shl ax,7
idiv bx
mov dx,bp;word ptr ds:[ttx1]
shl dx,6
mov bp,ax
add bp,bp
mov di,word ptr ds:[ys]
add di,di
mov ax,word ptr ds:[ye]
add ax,ax
add ax,offset xleft
mov word ptr ds:[@COMP1+2],ax
mov bh,cl
xor bl,bl
xor cl,cl
add di,offset xleft
    cmp word ptr ds:[tty1],-1    ;bx=startu scaled by 2^8
    njg @EDGE1                   ;cx=startv scaled by 2^8
                                 ;dx=startx scaled by 2^6
    push dx
    mov ax,word ptr ds:[tty1]
    neg ax
    imul si                      ;-y1*xstep=x(0)
    pop dx
    add ax,dx                    ;+start x
    push ax
    mov ax,word ptr ds:[tty1]
    neg ax
    imul word ptr ds:[@F0+2]
    add bx,ax                    ;start u
    mov ax,word ptr ds:[tty1]
    neg ax
    imul bp
    add cx,ax                    ;start v
    pop dx                       ;start x

@EDGE1:
          mov ah,bh
          mov al,ch
          mov word ptr ds:[di+800],ax
          mov word ptr ds:[di],dx
@F0:      add bx,666;si      ;ustep
          add cx,bp          ;vstep
          add dx,si          ;xstep
          add di,2
@COMP1:   cmp di,666
          njb @EDGE1         ;jna
;-------------------------------------------------------------------------
;Line 2 ->  Y1-Y2 xright
;-------------------------------------------------------------------------
mov ax, word ptr ds:[ttx1]
mov bp, ax
sub ax, word ptr ds:[ttx2]
mov bx, word ptr ds:[tty1]
mov di,bx
sub bx, word ptr ds:[tty2]
dec bx
cwd
shl ax,6
idiv bx
mov si,ax
xor ah,ah
xor dh,dh
mov cx, word ptr ds:[ux1]
mov al,cl
mov dl, byte ptr ds:[ux2]
sub ax,dx
cwd
shl ax,7
idiv bx
add ax,ax
mov word ptr ds:[f2+2],ax
xor dh,dh
xor ah,ah
mov al, byte ptr ds:[uy1]
mov dl, byte ptr ds:[uy2]
sub ax,dx
cwd
shl ax,7
idiv bx
mov dx,bp
shl dx,6
mov bp,ax
mov di,word ptr ds:[ys]
add di,di
mov ax,word ptr ds:[tty2]
cmp ax,-1
njg  normals
xor ax,ax
normals:
cmp ax,199
njng normals2
mov ax,199
normals2:
add ax,ax
add ax,offset xright
mov word ptr ds:[@COMP12+2],ax
mov bh,cl
xor bl,bl
xor cl,cl
add bp,bp
add di,offset xright
    cmp word ptr ds:[tty1],-1    ;bx=startu scaled by 2^8
    njg @EDGE12                  ;cx=startv scaled by 2^8
                                 ;dx=startx scaled by 2^6
    push dx
    mov ax,word ptr ds:[tty1]
    neg ax
    imul si                      ;-y1*xstep=x(0)
    pop dx
    add ax,dx                    ;+start x
    push ax
    mov ax,word ptr ds:[tty1]
    neg ax
    imul word ptr ds:[F2+2]
    add bx,ax                    ;start u
    mov ax,word ptr ds:[tty1]
    neg ax
    imul bp
    add cx,ax                    ;start v
    pop dx                       ;start x
@EDGE12:
          mov ah,bh
          mov al,ch
          mov word ptr ds:[di+800],ax
          mov word ptr ds:[di],dx
f2:       add bx,6666;si     ;ustep
          add cx,bp          ;vstep
          add dx,si          ;xstep
          add di,2
@COMP12:  cmp di,666
          njb @EDGE12
;----------------------------------------------------------------------
;Line 2 ->  Y2-Y3 xright
;----------------------------------------------------------------------
mov ax, word ptr ds:[ttx2]
mov bp, ax
sub ax, word ptr ds:[ttx3]
mov bx, word ptr ds:[tty2]
mov di,bx
cmp di,-1
njg y2pos
xor di,di
y2pos:
cmp di,199
njng ypos3
mov di,199
ypos3:
sub bx, word ptr ds:[tty3]
dec bx
cwd
shl ax,6
idiv bx
mov si,ax
xor ah,ah
xor dh,dh
mov cx, word ptr ds:[ux2]
mov al,cl
mov dl, byte ptr ds:[ux3]
sub ax,dx
cwd
shl ax,7
idiv bx
add ax,ax
mov word ptr ds:[f3+2],ax
xor ah,ah
xor dh,dh
mov al, byte ptr ds:[uy2]
mov dl, byte ptr ds:[uy3]
sub ax,dx
cwd
shl ax,7
idiv bx
mov dx,bp
shl dx,6
mov bp,ax
add di,di
mov ax,word ptr ds:[ye]
add ax,ax
add ax,offset xright
mov word ptr ds:[@COMP123+2],ax
sub ax,offset xright-offset yadd
mov word ptr ds:[ENDLINE+2],ax
mov bh,cl
xor bl,bl
xor cl,cl
add bp,bp
add di,offset xright

    cmp word ptr ds:[tty2],-1    ;bx=startu scaled by 2^8
    njg @EDGE123                 ;cx=startv scaled by 2^8
                                 ;dx=startx scaled by 2^6
    push dx
    mov ax,word ptr ds:[tty2]
    neg ax
    imul si                      ;-y1*xstep=x(0)
    pop dx
    add ax,dx                    ;+start x
    push ax
    mov ax,word ptr ds:[tty2]
    neg ax
    imul word ptr ds:[F3+2]
    add bx,ax                    ;start u
    mov ax,word ptr ds:[tty2]
    neg ax
    imul bp
    add cx,ax                    ;start v
    pop dx                       ;start x

@EDGE123:
          mov ah,bh
          mov al,ch
          mov word ptr ds:[di+800],ax
          mov word ptr ds:[di],dx
f3:       add bx,5555            ;ustep
          add cx,bp              ;vstep
          add dx,si              ;xstep
          add di,2
@COMP123: cmp di,666
          njb @EDGE123           ;jna
; ----------------------------------------------------------------------
;  Draw texture polygon
; -----------------------------------------------------------------------
          mov si,word ptr ds:[ys]
          add si,si
          add si,offset yadd
          mov ax,seg texture
          mov ds,ax
          @NEWLINES:
          push si
          mov di,word ptr cs:[si]       ;yadd
          mov cx,word ptr cs:[si+400]   ;xleft
          mov dx,word ptr cs:[si+800]   ;xright
          mov bp,word ptr cs:[si+1200]  ;textleft
          mov si,word ptr cs:[si+1600]  ;textright
          cmp dx,cx
          njng @NOCHANGE
          xchg cx,dx
          xchg bp,si
          @NOCHANGE:
          mov ax,bp
          mov al,ah
          xor ah,ah
          mov bx,si
          mov bl,bh
          xor bh,bh
          and bp,255
          and si,255
          sar cx,6       ;remove scaling
          sar dx,6       ;remove scaling
          cmp dx,319
          fjg @LINJA               ;if xstart>319 then skip
          mov word ptr cs:[xs],dx
          add di,dx
          cmp cx,-1
          fjng @LINJA              ;if xend<0 then skip
          mov word ptr cs:[xe],cx
          sub cx,dx
          inc cx                   ;cant be zero   ;cx=length of line
          xor dx,dx
          sub ax,bx
          sbb dx,0
          shl ax,7
          idiv cx                ;2 divs per scanline crap.......
          add ax,ax
          xor dx,dx
          sub bp,si
          sbb dx,0                 ;xor dx,dx + sbb dx,0 is faster than CWD...
          xchg ax,bp
          shl ax,7
          idiv cx
          add ax,ax
          xor dx,dx
          mov dh,bl
          shl si,8                 ;si=texture startu (y)
                                   ;dx=texture startv (x)
                                   ;bp=vstep, ax=ustep
          cmp word ptr cs:[xe],319
          njng @NORIGHTCLIP
          sub cx,word ptr cs:[xe]
          add cx,319
          @NORIGHTCLIP:
          cmp word ptr cs:[xs],-1
          njg @NRMAL
          push ax                   ;save the step
          sub di,word ptr cs:[xs]   ;start x=zero
          add cx,word ptr cs:[xs]   ;sub length
          push ax                   ;ax=vstep (y)
          mov bx, dx                ;startu
          mov ax,word ptr cs:[xs]
          neg ax
          imul bp                   ;ustep
          mov dx,bx
          add ax,dx                 ;new startu
          mov bx,ax                 ;save it
          mov dx,word ptr cs:[xs]
          neg dx
          pop ax                    ;vstep
          imul dx
          add si,ax                 ;new startu
          mov dx,bx                 ;new startv
          pop ax                    ;restore the step
          @NRMAL:
          dec cx
          shr cx,1
          njnc @ODD
          mov bx,si
          mov bl,dh
          mov bl,byte ptr ds:[bx]
          mov byte ptr es:[di],bl
          add dx,bp
          add si,ax
          inc di
          @ODD:
          or cx,cx
          fje @LINJA
          test di,1        ;zero set if even
          fjne @FIXALIGN
          neg cx
          add cx,160
          mov bx,cx
          add bx,bx
          mov bx,word ptr cs:[bx+kadd]
          mov cx,ax
          jmp bx
          HORLINE:
                   rept 160
                   mov bx,si                ;2
                   mov bl,dh                ;2  ;4
                   mov al,byte ptr ds:[bx]  ;2  ;6
                   add dx,bp                ;2  ;8
                   add si,cx                ;2  ;10
                   mov bx,si                ;2  ;12
                   mov bl,dh                ;2  ;14
                   mov ah,byte ptr ds:[bx]  ;2  ;16
                   mov word ptr es:[di],ax  ;3  ;19
                   add dx,bp                ;2  ;21
                   add si,cx                ;2  ;23
                   add di,2                 ;3  ;26
                   endm

@LINJA:
          pop si
          add si,2
 ENDLINE: cmp si,7777
          fjb @NEWLINES
AWAY:
            pop cx
            sub ecx,4
            cmp ecx,11223344h
MOO:        jnb txPLOOP
            ret

@FIXALIGN:
          mov bx,si
          mov bl,dh
          mov bl,byte ptr ds:[bx]
          mov byte ptr es:[di],bl
          add dx,bp
          add si,ax
          inc di
          neg cx        ;
          add cx,161
          mov bx,cx
          add bx,bx
          mov bx,word ptr cs:[bx+kadd2]
          mov cx,ax
          jmp bx
          HORLINE2:
                   rept 160
                   mov bx,si                ;2
                   mov bl,dh                ;2
                   mov al,byte ptr ds:[bx]  ;2
                   add dx,bp                ;2
                   add si,cx                ;2
                   mov bx,si                ;2
                   mov bl,dh                ;2
                   mov ah,byte ptr ds:[bx]  ;2
                   mov word ptr es:[di],ax  ;3
                   add dx,bp                ;2
                   add si,cx                ;2
                   add di,2                 ;3
                   endm
          mov bx,si
          mov bl,dh
          mov bl,byte ptr ds:[bx]
          mov byte ptr es:[di],bl
          jmp @LINJA


M_ALKU:                                          ;routine size checker
                   mov bx,si                ;2
                   mov bl,dh                ;2
                   mov al,byte ptr ds:[bx]  ;2
                   add dx,bp                ;2
                   add si,cx                ;2
                   mov bx,si                ;2
                   mov bl,dh                ;2
                   mov ah,byte ptr ds:[bx]  ;2
                   mov word ptr es:[di],ax  ;3
                   add dx,bp                ;2
                   add si,cx                ;2
                   add di,2                 ;3
M_LOPPU:


;----------------------------------------------------------------------------
align 2
         xhandle        dw 0
         xmscontrol     dd 0
         fhandle        dw 0
         objectxms      dd 0  ;pointers to XMS-blocks
         projectionbuffer      dd 0
         envbufxms      dd 0
         sorttixms      dd 0
         onearrayxms    dd 0
         lastxms        dd 0
         indexinxms     dd 0
         indexoutxms    dd 0
         itemcount      dw 0
         bytenumber     dw 0

         elements    dw 1  ; how many different objects in the world are.
         elementxms  dd 0   ;4 bytes for each element, xms ptr
                     dd 0
                     dd 0
                     dd 0
                     dd 0

         elementenvxms dd 0    ;ptr for each environment map
                       dd 0    ;lame way to waste memory.......
                       dd 0

         transformers dw 0    ;destination element number
                      dw 1    ;source 1 element  number
                      dw 2    ;source 2 element  number
                              ;remember: (dest#<source1#<source2#)
         worldxangle dw 0
         worldyangle dw 0
         worldzangle dw 0
         viewpointx  dw 0
         viewpointy  dw 0
         viewpointz  dw 0
         viewpointxy dw 0
         camerazpos    dw 4000
         cameraypos    dw 0
         cameraxpos    dw 0

         world dw 2     ;how many objects there are
                        ;object format begin
               db 0     ;object type, supports 255 different objects
               db 0     ;object rotate model:
                        ;255=object is independent to the world
                        ;0=object   is stable
               dw -2000     ;object.world.x pos
               dw 0     ;object.world.y pos
               dw 0     ;object.world.z pos
               dw 0     ;object.world.xy pos, just put zero here,code calcs it
               dw 0     ;object.own.xangle
               dw 0     ;object.own.yangle
               dw 0     ;object.own.zangle
               dw 8 dup (0) ;TEMPORARY SPACE FOR OBJECT !!!!!!!!!!!!

               db 0     ;object type, supports 255 different objects
               db 255   ;object rotate model:
                        ;255=object is independent to the world
                        ;0=object   is stable
               dw 2000     ;object.world.x pos
               dw 0     ;object.world.y pos
               dw 0     ;object.world.z pos
               dw 0     ;object.world.xy pos, just put zero here,code calcs it
               dw 0     ;object.own.xangle
               dw 0     ;object.own.yangle
               dw 0     ;object.own.zangle
               dw 8 dup (0) ;TEMPORARY SPACE FOR OBJECT !!!!!!!!!!!!

sortti2    dw 128 dup (0)     ;max is 64 objects
onearray2  dw 128 dup (0)
zeroarray2 dw 128 dup (0)
tempobj dw 0       ;in process object type
tempxp  dw 0       ;-----""--------- xpos
tempyp  dw 0       ;                 ypos
tempzp  dw 0       ;                 zpos
tempxy  dw 0       ;                 xypos
tempax  dw 0     ;object.own.xangle
tempay  dw 0     ;object.own.yangle
tempaz  dw 0     ;object.own.zangle
swapxy  dw 0
swap    dw 0
mframe  dw 0
madd    dw 4
ticks   dd 0
oldint  dd 0
facecount dw 0
xlen  dw 0
ylen  dw 0
fx1   dd 0
fx2   dd 0
fx3   dd 0
fy1   dd 0
fy2   dd 0
fy3   dd 0
xx1   dd 0
xx2   dd 0
xx3   dd 0
xy1   dd 0
xy2   dd 0
xy3   dd 0
ystr  dw 0
yend  dd 0
tx1   dw 0
tx2   dw 0
tx3   dw 0
ty1   dw 0
ty2   dw 0
ty3   dw 0
ttx1   dw 0
ttx2   dw 0
ttx3   dw 0
tty1   dw 0
tty2   dw 0
tty3   dw 0
xstep  dw 0
ustep  dw 0
vstep  dw 0
tstartv dw 0
tstartu dw 0
ux1   db 0
uy1   db 0
ux2   db 0
uy2   db 0
ux3   db 0
uy3   db 0
yadd   dw 200 dup (0)
xleft  dw 200 dup (0)
xright dw 200 dup (0)
uleft  dw 200 dup (0)
uright dw 200 dup (0)
kadd   dw 600 dup (0)
kadd2  dw 600 dup (0)
facesb dw 0
fcount dw 0
maski dw 0
xpos2d dw 160
ypos2d dw 100
zclipnear dw 512           ;ZCLIP NEAR
ye  dw 0
ys  dw 0
xs  dw 0
xe  dw 0
six dw 0
siy dw 0
siz dw 0
cox dw 0
coy dw 0
coz dw 0
r11 dw 0
r12 dw 0
r13 dw 0
r21 dw 0
r22 dw 0
r23 dw 0
r31 dw 0
r32 dw 0
r33 dw 0
frame dd 0
temp  dw 0
align 2
sine dw 1,2,4,5,7,8,10,11,13,15,16,18,19,21,22,24,26    ;1024 angles
dw 27,29,30,32,33,35,37,38,40,41,43,44,46,47,49,50
dw 52,54,55,57,58,60,61,63,64,66,67,69,70,72,73,75
dw 76,78,79,81,82,84,85,87,88,90,91,93,94,96,97,98
dw 100,101,103,104,106,107,109,110,111,113,114,116,117,118,120,121
dw 123,124,125,127,128,129,131,132,133,135,136,137,139,140,141,143
dw 144,145,147,148,149,150,152,153,154,156,157,158,159,160,162,163
dw 164,165,167,168,169,170,171,172,174,175,176,177,178,179,180,182
dw 183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198
dw 199,200,201,202,203,204,205,206,207,208,209,210,211,212,212,213
dw 214,215,216,217,218,218,219,220,221,222,222,223,224,225,226,226
dw 227,228,228,229,230,231,231,232,233,233,234,235,235,236,236,237
dw 238,238,239,239,240,240,241,242,242,243,243,244,244,245,245,245
dw 246,246,247,247,248,248,248,249,249,250,250,250,251,251,251,252
dw 252,252,252,253,253,253,253,254,254,254,254,255,255,255,255,255
dw 255,256,256,256,256,256,256,256,256,256,256,256,256,256,256,256
dw 256,256,256,256,256,256,256,256,256,256,256,256,256,256,255,255
dw 255,255,255,255,254,254,254,254,253,253,253,253,252,252,252,252
dw 251,251,251,250,250,250,249,249,248,248,248,247,247,246,246,245
dw 245,245,244,244,243,243,242,242,241,240,240,239,239,238,238,237
dw 236,236,235,235,234,233,233,232,231,231,230,229,228,228,227,226
dw 226,225,224,223,222,222,221,220,219,218,218,217,216,215,214,213
dw 212,212,211,210,209,208,207,206,205,204,203,202,201,200,199,198
dw 197,196,195,194,193,192,191,190,189,188,187,186,185,184,183,182
dw 180,179,178,177,176,175,174,172,171,170,169,168,167,165,164,163
dw 162,160,159,158,157,156,154,153,152,150,149,148,147,145,144,143
dw 141,140,139,137,136,135,133,132,131,129,128,127,125,124,123,121
dw 120,118,117,116,114,113,111,110,109,107,106,104,103,101,100,98
dw 97,96,94,93,91,90,88,87,85,84,82,81,79,78,76,75
dw 73,72,70,69,67,66,64,63,61,60,58,57,55,54,52,50
dw 49,47,46,44,43,41,40,38,37,35,33,32,30,29,27,26
dw 24,22,21,19,18,16,15,13,11,10,8,7,5,4,2,1
dw -1,-3,-4,-6,-7,-9,-10,-12,-14,-15,-17,-18,-20,-21,-23,-25
dw -26,-28,-29,-31,-32,-34,-36,-37,-39,-40,-42,-43,-45,-46,-48,-49
dw -51,-53,-54,-56,-57,-59,-60,-62,-63,-65,-66,-68,-69,-71,-72,-74
dw -75,-77,-78,-80,-81,-83,-84,-86,-87,-89,-90,-92,-93,-95,-96,-97
dw -99,-100,-102,-103,-105,-106,-108,-109,-110,-112,-113,-115,-116,-117,-119,-120
dw -122,-123,-124,-126,-127,-128,-130,-131,-132,-134,-135,-136,-138,-139,-140,-142
dw -143,-144,-146,-147,-148,-149,-151,-152,-153,-155,-156,-157,-158,-159,-161,-162
dw -163,-164,-166,-167,-168,-169,-170,-171,-173,-174,-175,-176,-177,-178,-179,-181
dw -182,-183,-184,-185,-186,-187,-188,-189,-190,-191,-192,-193,-194,-195,-196,-197
dw -198,-199,-200,-201,-202,-203,-204,-205,-206,-207,-208,-209,-210,-211,-211,-212
dw -213,-214,-215,-216,-217,-217,-218,-219,-220,-221,-221,-222,-223,-224,-225,-225
dw -226,-227,-227,-228,-229,-230,-230,-231,-232,-232,-233,-234,-234,-235,-235,-236
dw -237,-237,-238,-238,-239,-239,-240,-241,-241,-242,-242,-243,-243,-244,-244,-244
dw -245,-245,-246,-246,-247,-247,-247,-248,-248,-249,-249,-249,-250,-250,-250,-251
dw -251,-251,-251,-252,-252,-252,-252,-253,-253,-253,-253,-254,-254,-254,-254,-254
dw -254,-255,-255,-255,-255,-255,-255,-255,-255,-255,-255,-255,-255,-255,-255,-255
dw -255,-255,-255,-255,-255,-255,-255,-255,-255,-255,-255,-255,-255,-255,-254,-254
dw -254,-254,-254,-254,-253,-253,-253,-253,-252,-252,-252,-252,-251,-251,-251,-251
dw -250,-250,-250,-249,-249,-249,-248,-248,-247,-247,-247,-246,-246,-245,-245,-244
dw -244,-244,-243,-243,-242,-242,-241,-241,-240,-239,-239,-238,-238,-237,-237,-236
dw -235,-235,-234,-234,-233,-232,-232,-231,-230,-230,-229,-228,-227,-227,-226,-225
dw -225,-224,-223,-222,-221,-221,-220,-219,-218,-217,-217,-216,-215,-214,-213,-212
dw -211,-211,-210,-209,-208,-207,-206,-205,-204,-203,-202,-201,-200,-199,-198,-197
dw -196,-195,-194,-193,-192,-191,-190,-189,-188,-187,-186,-185,-184,-183,-182,-181
dw -179,-178,-177,-176,-175,-174,-173,-171,-170,-169,-168,-167,-166,-164,-163,-162
dw -161,-159,-158,-157,-156,-155,-153,-152,-151,-149,-148,-147,-146,-144,-143,-142
dw -140,-139,-138,-136,-135,-134,-132,-131,-130,-128,-127,-126,-124,-123,-122,-120
dw -119,-117,-116,-115,-113,-112,-110,-109,-108,-106,-105,-103,-102,-100,-99,-97
dw -96,-95,-93,-92,-90,-89,-87,-86,-84,-83,-81,-80,-78,-77,-75,-74
dw -72,-71,-69,-68,-66,-65,-63,-62,-60,-59,-57,-56,-54,-53,-51,-49
dw -48,-46,-45,-43,-42,-40,-39,-37,-36,-34,-32,-31,-29,-28,-26,-25
dw -23,-21,-20,-18,-17,-15,-14,-12,-10,-9,-7,-6,-4,-3,-1,1
cose dw 256,256,256,256,256,256,256,256,256,256,256,256,256,256,256,255,255
dw 255,255,255,255,254,254,254,254,253,253,253,253,252,252,252,252
dw 251,251,251,250,250,250,249,249,248,248,248,247,247,246,246,245
dw 245,245,244,244,243,243,242,242,241,240,240,239,239,238,238,237
dw 236,236,235,235,234,233,233,232,231,231,230,229,228,228,227,226
dw 226,225,224,223,222,222,221,220,219,218,218,217,216,215,214,213
dw 212,212,211,210,209,208,207,206,205,204,203,202,201,200,199,198
dw 197,196,195,194,193,192,191,190,189,188,187,186,185,184,183,182
dw 180,179,178,177,176,175,174,172,171,170,169,168,167,165,164,163
dw 162,160,159,158,157,156,154,153,152,150,149,148,147,145,144,143
dw 141,140,139,137,136,135,133,132,131,129,128,127,125,124,123,121
dw 120,118,117,116,114,113,111,110,109,107,106,104,103,101,100,98
dw 97,96,94,93,91,90,88,87,85,84,82,81,79,78,76,75
dw 73,72,70,69,67,66,64,63,61,60,58,57,55,54,52,50
dw 49,47,46,44,43,41,40,38,37,35,33,32,30,29,27,26
dw 24,22,21,19,18,16,15,13,11,10,8,7,5,4,2,1
dw -1,-3,-4,-6,-7,-9,-10,-12,-14,-15,-17,-18,-20,-21,-23,-25
dw -26,-28,-29,-31,-32,-34,-36,-37,-39,-40,-42,-43,-45,-46,-48,-49
dw -51,-53,-54,-56,-57,-59,-60,-62,-63,-65,-66,-68,-69,-71,-72,-74
dw -75,-77,-78,-80,-81,-83,-84,-86,-87,-89,-90,-92,-93,-95,-96,-97
dw -99,-100,-102,-103,-105,-106,-108,-109,-110,-112,-113,-115,-116,-117,-119,-120
dw -122,-123,-124,-126,-127,-128,-130,-131,-132,-134,-135,-136,-138,-139,-140,-142
dw -143,-144,-146,-147,-148,-149,-151,-152,-153,-155,-156,-157,-158,-159,-161,-162
dw -163,-164,-166,-167,-168,-169,-170,-171,-173,-174,-175,-176,-177,-178,-179,-181
dw -182,-183,-184,-185,-186,-187,-188,-189,-190,-191,-192,-193,-194,-195,-196,-197
dw -198,-199,-200,-201,-202,-203,-204,-205,-206,-207,-208,-209,-210,-211,-211,-212
dw -213,-214,-215,-216,-217,-217,-218,-219,-220,-221,-221,-222,-223,-224,-225,-225
dw -226,-227,-227,-228,-229,-230,-230,-231,-232,-232,-233,-234,-234,-235,-235,-236
dw -237,-237,-238,-238,-239,-239,-240,-241,-241,-242,-242,-243,-243,-244,-244,-244
dw -245,-245,-246,-246,-247,-247,-247,-248,-248,-249,-249,-249,-250,-250,-250,-251
dw -251,-251,-251,-252,-252,-252,-252,-253,-253,-253,-253,-254,-254,-254,-254,-254
dw -254,-255,-255,-255,-255,-255,-255,-255,-255,-255,-255,-255,-255,-255,-255,-255
dw -255,-255,-255,-255,-255,-255,-255,-255,-255,-255,-255,-255,-255,-255,-254,-254
dw -254,-254,-254,-254,-253,-253,-253,-253,-252,-252,-252,-252,-251,-251,-251,-251
dw -250,-250,-250,-249,-249,-249,-248,-248,-247,-247,-247,-246,-246,-245,-245,-244
dw -244,-244,-243,-243,-242,-242,-241,-241,-240,-239,-239,-238,-238,-237,-237,-236
dw -235,-235,-234,-234,-233,-232,-232,-231,-230,-230,-229,-228,-227,-227,-226,-225
dw -225,-224,-223,-222,-221,-221,-220,-219,-218,-217,-217,-216,-215,-214,-213,-212
dw -211,-211,-210,-209,-208,-207,-206,-205,-204,-203,-202,-201,-200,-199,-198,-197
dw -196,-195,-194,-193,-192,-191,-190,-189,-188,-187,-186,-185,-184,-183,-182,-181
dw -179,-178,-177,-176,-175,-174,-173,-171,-170,-169,-168,-167,-166,-164,-163,-162
dw -161,-159,-158,-157,-156,-155,-153,-152,-151,-149,-148,-147,-146,-144,-143,-142
dw -140,-139,-138,-136,-135,-134,-132,-131,-130,-128,-127,-126,-124,-123,-122,-120
dw -119,-117,-116,-115,-113,-112,-110,-109,-108,-106,-105,-103,-102,-100,-99,-97
dw -96,-95,-93,-92,-90,-89,-87,-86,-84,-83,-81,-80,-78,-77,-75,-74
dw -72,-71,-69,-68,-66,-65,-63,-62,-60,-59,-57,-56,-54,-53,-51,-49
dw -48,-46,-45,-43,-42,-40,-39,-37,-36,-34,-32,-31,-29,-28,-26,-25
dw -23,-21,-20,-18,-17,-15,-14,-12,-10,-9,-7,-6,-4,-3,-1,1
dw 2,4,5,7,8,10,11,13,15,16,18,19,21,22,24,26
dw 27,29,30,32,33,35,37,38,40,41,43,44,46,47,49,50
dw 52,54,55,57,58,60,61,63,64,66,67,69,70,72,73,75
dw 76,78,79,81,82,84,85,87,88,90,91,93,94,96,97,98
dw 100,101,103,104,106,107,109,110,111,113,114,116,117,118,120,121
dw 123,124,125,127,128,129,131,132,133,135,136,137,139,140,141,143
dw 144,145,147,148,149,150,152,153,154,156,157,158,159,160,162,163
dw 164,165,167,168,169,170,171,172,174,175,176,177,178,179,180,182
dw 183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198
dw 199,200,201,202,203,204,205,206,207,208,209,210,211,212,212,213
dw 214,215,216,217,218,218,219,220,221,222,222,223,224,225,226,226
dw 227,228,228,229,230,231,231,232,233,233,234,235,235,236,236,237
dw 238,238,239,239,240,240,241,242,242,243,243,244,244,245,245,245
dw 246,246,247,247,248,248,248,249,249,250,250,250,251,251,251,252
dw 252,252,252,253,253,253,253,254,254,254,254,255,255,255,255,255
dw 255,256,256,256,256,256,256,256,256,256,256,256,256,256,256,256
flipflop db 1              ;select page
msg   db 'Exit OK.     ',0dh,0ah,'$'       ;error msgs
      db 'Undefined    ',0dh,0ah,'$'
      db 'No XMS-driver',0dh,0ah,'$'
      db 'Out of XMS   ',0dh,0ah,'$'
      db 'File missing ',0dh,0ah,'$'
      db 'Undefined    ',0dh,0ah,'$'
      db 'Undefined    ',0dh,0ah,'$'
      db 'Remove EMM!  ',0dh,0ah,'$'
      db 'Undefined    ',0dh,0ah,'$'
      db 'Undefined    ',0dh,0ah,'$'
      db 'Undefined    ',0dh,0ah,'$'
tfx db 0
color  db 1
names  db 'ob2.dcc',0  ;here file names, 8 max char
       db 'ri2.dcc',0
       db 'ob2.dcc',0

title3 db 0dh,0ah, 'Ducks 3D for 32bit RealFlatMode by Zjack/DCC',0dh,0ah,'$'
title2 db 'Loading stuff.','$'
dot    db '.','$'
errr  db 0                    ;errormsg  (0=exit ok)
pal DB 82,73,88,51,0,1,0,1,175,0,0,0,0,3,3,3,7,7,7,12
 DB 11,11,16,15,15,20,19,19,24,24,24,29,28,28,33,32,32,37,36,36
 DB 41,40,40,46,44,44,50,48,48,54,52,52,58,57,57,63,61,61,24,22
 DB 22,63,57,57,20,18,18,61,55,55,59,53,53,18,16,16,16,14,14,59
 DB 51,51,28,24,24,14,12,12,26,22,22,12,10,10,37,30,30,10,8,8
 DB 57,45,45,61,47,47,59,45,45,57,43,43,61,45,45,8,6,6,59,43
 DB 43,6,4,4,4,2,2,2,0,0,28,26,24,20,18,14,22,20,14,63
 DB 63,61,24,24,22,20,20,18,16,16,14,24,24,20,20,20,16,18,18,14
 DB 16,16,12,20,20,14,22,22,14,16,18,12,16,18,14,18,20,16,12,14
 DB 10,14,16,12,20,22,20,22,24,22,16,18,16,14,16,14,12,14,12,16
 DB 20,16,8,10,8,14,18,14,12,16,12,10,14,10,4,6,4,2,4,2
 DB 10,16,12,8,14,10,20,24,22,12,16,14,4,8,6,16,20,18,10,14
 DB 12,8,12,10,14,18,16,20,28,24,6,10,8,41,59,51,10,16,14,8
 DB 14,12,22,28,26,6,12,10,22,30,28,20,22,22,22,24,24,18,20,20
 DB 16,18,18,12,14,14,10,12,12,8,10,10,14,18,18,6,8,8,10,14
 DB 14,8,12,12,4,6,6,2,4,4,4,8,8,35,41,43,22,28,30,33
 DB 39,41,24,30,33,22,26,28,20,24,26,33,37,39,24,28,30,26,30,33
 DB 22,28,33,30,33,35,33,35,37,24,26,28,35,39,43,24,28,33,20,22
 DB 24,30,33,37,22,24,28,33,35,39,24,26,30,35,37,41,26,28,33,20
 DB 22,26,37,37,39,35,35,37,28,28,30,30,30,33,26,26,28,24,24,26
 DB 20,20,22,22,22,24,37,37,41,33,33,37,30,30,35,12,12,14,8,8
 DB 10,6,6,8,37,35,39,28,26,30,24,22,26,37,35,37,35,33,35,30
 DB 28,30,33,30,33,26,24,26,22,20,22,24,22,24,37,33,37,18,16,18
 DB 30,26,30,16,14,16,28,24,28,14,12,14,12,10,12,37,30,37,35,28
 DB 35,10,8,10,41,33,41,39,30,39,37,28,37,8,6,8,6,4,6,4
 DB 2,4,2,0,2,43,33,41,43,35,41,39,30,37,37,28,35,35,26,33
 DB 41,33,39,35,28,33,30,24,28,45,33,41,33,26,30,45,35,41,39,28
 DB 35,41,30,37,43,33,39,35,30,33,26,22,24,18,14,16,37,33,35,30
 DB 26,28,28,24,26,22,18,20,20,16,18,39,30,35,37,28,33,47,35,41
 DB 33,28,30,24,20,22,43,35,39,41,33,37,35,26,30,16,12,14,45,33
 DB 39,49,39,43,41,30,35,39,28,33,45,35,39,43,33,37,61,55,57,37
 DB 30,33,28,22,24,63,57,59,39,33,35,30,24,26,59,47,51,49,37,41
 DB 43,30,35,35,28,30,33,26,28,55,43,47,53,41,45,47,35,39,45,33
 DB 37,51,37,41,55,47,49,39,30,33,55,41,45,61,53,55,59,51,53,57
 DB 49,51,45,37,39,43,35,37,41,33,35,37,28,30,35,26,28,57,47,49
 DB 49,39,41,41,30,33,61,51,53,59,49,51,55,45,47,53,43,45,47,37
 DB 39,45,35,37,43,33,35,39,28,30,59,47,49,51,39,41,57,45,47,55
 DB 43,45,53,41,43,49,37,39,47,35,37,53,39,41,45,33,35,59,45,47
 DB 57,43,45,55,41,43,59,43,45,57,41,43,59,41,43,63,63,63,162,98
end
