;

align 32
proc    exit n

        ;Make sure we clean up after ourselves
        call    reset_video
        call    reset_file

        mode3

        ;Print the fps
        msg     "Average FPS:"
        mov     eax, [average_fps]
        mov     esi, 2
        mov     ebp, 6
        call    printpnum
        endl
        msg     "Help screen: main -h "
        endl

        ;The goodbye screen
        endl
        cmsg    "3D Example"
        endl
        cmsg    "Copyright (c) 1997 Andrew Harvey, c9607776@engmail.newcastle.edu.au"
        endl
        endl
        cmsg    "- 3D morphed animation -"
        endl
        cmsg    "- Linear texture mapping -"
        endl
        cmsg    "- Motion blurred spherical mapping -"
        endl
        cmsg    "- pmode courtesy of Tran, a.k.a. Tomas Pytel -"
        endl
        cmsg    "- Texture mapping docs courtesy of Chris Hecker - "
        endl
        cmsg    "- Spherical mapping doc courtesy of John De Goes - "
        endl
        endl
        cmsg    "Please credit me if you use this"
        endl

        endl
        cmsg    "- Farewell -"
        endl

        jmp     _exit

endp

;
;In:
;       edx:eax: timer ticks to draw n frames
;       frames_done: n frames
;
;Get the average fps * 100

align 32
proc    fps n

        ;Shouldn't be possible, but just in case 
        cmp     [frames_done], 0
        je      @@div_zero

        ;Alloc some local storage
        sub     esp, 16

        mov     [d esp], eax
        mov     [d esp + 4], edx
        mov     [d esp + 8], 1234ddh
        mov     [d esp + 12], 100

        ;Average FPS * 100 =
        ;frames_done * 100 / time in ticks / 1234ddh (ticks per second)
        fild    [frames_done]
        fild    [q esp]
        fild    [d esp + 8]
        fdiv
        fdiv
        fild    [d esp + 12]
        fmul
        fistp   [d esp]

        mov     eax, [esp]
        mov     [average_fps], eax

        ;Can't forget this!
        add     esp, 16
        ret

@@div_zero:
        mov     [average_fps], 0
        ret

endp

;
