;

macro   fpop count
        sub     esp, 4
if count
        rept count
        fstp    [d esp]
        endm
else
        fstp    [d esp]
endif
        add     esp, 4
endm

;                                      

macro   roundmode mode
local   skip, cw

        push    eax

        mov     ax, mode
        and     ax, 3
        shl     ax, 10

        fnstcw  [cw]
        and     [cw], not 0000110000000000b
        or      [cw], ax
        fldcw   [cw]
        jmp     skip

cw      dw ?

skip:
        pop     eax
endm

;

macro   readclock
        mov     eax, [gs:(40h shl 4) + 6ch]
endm

;

macro readtimer
        cli
        xor     edx, edx
        mov     al, 4h
        out     43h, al
        in      al, 40h
        mov     dl, al
        in      al, 40h
        mov     dh, al
        neg     dx              ;action took dx/1193180 seconds
        sti
endm

;

macro   endl
local   endlmsg, endlskip
        push    edx
        mov     edx, o endlmsg
        call    putdosmsg
        jmp     endlskip

endlmsg db 13, 10, "$"

endlskip:
        pop     edx
endm

;                                      

macro   msg mymsg
local   msgtxt, txtskip
        push    edx
        mov     edx, o msgtxt 
        call    putdosmsg
        jmp     txtskip

msgtxt  db mymsg, "$"

txtskip:
        pop     edx
endm

;                                      

macro   cmsg mymsg
local   msgtxt, txtskip, len, msgcentre

        push    edx
        mov     edx, o msgcentre
        call    putdosmsg
        jmp     txtskip

len sizestr <mymsg>
msgcentre       db (80 - len)/2 dup (" ")
msgtxt          db mymsg, "$"

txtskip:
        pop     edx
endm

;

macro   mode13
        push    eax
        mov     [v86r_ax], 13h
        mov     al, 10h
        int     33h
        pop     eax
endm

;                                      

macro   mode3
        push    eax
        mov     [v86r_ax], 3
        mov     al, 10h
        int     33h
        pop     eax
endm

;

macro writepalette
        lea     ecx, [ecx*2 + ecx] 
        mov     dx, 03c8h
        out     dx, al
        inc     dx
        rep outsb
endm

;
