p386
ideal
locals
largestack

;

o equ offset
b equ byte
w equ word
d equ dword
s equ short
n equ near
f equ far

;

segment code32 page public use32
        assume cs:code32, ds:code32

ideal
include "..\pmode\pmode.inc"
include "..\file\file.inc"
include "..\include\macros.inc"
include "pcx.inc"

;

align 4
pcx_x           dd ?
pcx_y           dd ?
pcx_rawsize     dd ?
pcx_palptr      dd ?
pcx_8palptr     dd ?

;
;In:
;       esi: source
;Out:
;       eax: x pixels
;       ebx: y pixels
;       ecx: total pixels

align 32
proc    pcx_size n

        cmp     [esi + pcx.manufacturer], 10
        jne     @@err

        cmp     [esi + pcx.ver], 5 
        jne     @@err

        cmp     [esi + pcx.encoding], 1
        jne     @@err

        cmp     [esi + pcx.bpp], 8
        jne     @@err

        xor     eax, eax
        xor     ebx, ebx
        mov     ax, [esi + pcx.xmax]
        mov     bx, [esi + pcx.ymax]
        sub     ax, [esi + pcx.xmin]
        sub     bx, [esi + pcx.ymin]
        inc     eax
        inc     ebx

        mov     ecx, eax
        imul    ecx, ebx

        clc
        ret

@@err:
        stc
        ret

endp

;
;In:
;       edx: filename
;Out:
;       eax: x pixels
;       ebx: y pixels
;       ecx: total pixels

align 32
proc    pcxfile_size n

        push    edx esi
        call    openfile
        jc      @@err

        mov     ecx, size pcx
        mov     edx, o @@hdr
        push    eax
        call    readfile
        pop     eax
        jc      @@err

        call    closefile
        jc      @@err

        mov     esi, o @@hdr

        cmp     [esi + pcx.manufacturer], 10
        jne     @@err

        cmp     [esi + pcx.ver], 5 
        jne     @@err

        cmp     [esi + pcx.encoding], 1
        jne     @@err

        cmp     [esi + pcx.bpp], 8
        jne     @@err

        xor     eax, eax
        xor     ebx, ebx
        mov     ax, [esi + pcx.xmax]
        mov     bx, [esi + pcx.ymax]
        sub     ax, [esi + pcx.xmin]
        sub     bx, [esi + pcx.ymin]
        inc     eax
        inc     ebx

        mov     ecx, eax
        imul    ecx, ebx

        pop     esi edx
        clc
        ret

@@err:
        pop     esi edx
        stc
        ret

@@hdr   db size pcx dup ( ? )

endp

;
;In:
;       edx: filename
;       edi: dest
;       pcx_palptr: palette dest, 0 if none
;       pcx_8palptr: 8bit palette dest, 0 if none

align 32
proc    decompress_pcxfile n

        pushad

        call    pcxfile_size
        jc      @@err

        mov     [pcx_x], eax
        mov     [pcx_y], ebx
        mov     [pcx_rawsize], ecx

        call    open_pcxdata
        jc      @@err

        xor     eax, eax
        xor     ebx, ebx
        xor     ecx, ecx

align 32
@@decode:
        call    get_byte
        jc      @@err

        mov     edx, eax
        and     edx, 0c0h
        cmp     edx, 0c0h
        jne     @@raw

        mov     ebx, eax
        and     ebx, 63
        add     ecx, ebx
        call    get_byte
        jc      @@err

@@derun:
        mov     [edi], al
        inc     edi
        dec     ebx
        jnz     @@derun

        cmp     ecx, [pcx_rawsize]
        jb      @@decode

        jmp     @@done

@@raw:
        mov     [edi], al
        inc     edi
        inc     ecx
        cmp     ecx, [pcx_rawsize]
        jb      @@decode

@@done:
        call    get_byte
        jc      @@err

        cmp     al, 12
        jne     @@nopal

        mov     ebx, o @@temp_pal
        mov     ecx, 768

@@get_temp:
        call    get_byte
        jc      @@err

        mov     [ebx], al
        inc     ebx
        dec     ecx
        jnz     @@get_temp

        mov     edi, [pcx_palptr]
        test    edi, edi
        jz      @@no6pal

        mov     esi, o @@temp_pal
        mov     ecx, 768

@@decodecol:
        mov     al, [esi]
        inc     esi
        shr     eax, 2
        mov     [edi], al
        inc     edi
        dec     ecx
        jnz     @@decodecol

@@no6pal:
        mov     edi, [pcx_8palptr]
        or      edi, edi
        jz      @@nopal

        mov     ecx, 768/4
        mov     esi, o @@temp_pal
        rep movsd

@@nopal:
        call    closefile
        jc      @@err

        popad
        clc
        ret

@@err:
        popad
        stc
        ret

@@temp_pal      db 768 dup ( ? )

endp

;

align 32
proc    get_byte n

        cmp     [bytes_in], 0
        jne     @@got_some

        call    read_chunk
        jc      @@err

        mov     [bytes_in], eax
        mov     [bytes_got], 0

@@got_some:
        mov     eax, [filebufloc]
        add     eax, [bytes_got]
        mov     al, [eax]

        dec     [bytes_in]
        inc     [bytes_got]

        clc

@@err:
        ret

endp

bytes_in        dd 0
bytes_got       dd 0

;

align 32
proc    read_chunk n

        push    ecx edx
        mov     ecx, [filebuflen]
        mov     edx, [filebufloc]
        call    readfile
        test    eax, eax
        jz      @@err

        pop     edx ecx
        clc
        ret

@@err:
        pop     edx ecx
        stc
        ret

endp

;

align 32
proc    open_pcxdata n

        call    openfile
        jc      @@err

        call    read_chunk
        jc      @@err

        mov     [bytes_in], eax
        mov     [bytes_got], 0

        mov     ecx, size pcx

@@get_hdr:
        call    get_byte
        dec     ecx
        jnz     @@get_hdr

        clc

@@err:
        ret

endp

;

ends    code32
        end


