Program Example04;
{ Example program demonstrating the loading of a 2 3d objects and    }
{ spinning them. One is transparent gouraud shaded, the other is     }
{ gouraud texture mapped. Also has multiple dynamic light sources    }

Uses
  Types,   { Inertia type declarations     }
  Inertia, { the 3d engine                 }
  Mode13h, { Basic Mode 13h graphics unit  }
  Crt;

Var
  View : ViewObject;   { The View System }
  Obj1 : VectorObject; { A vector object }
  Obj2 : VectorObject; { A second vector object }
  i    : Integer;

Begin
  If (LoadPCXTexture(0, 'COPPRENV.PCX', 0) <> I_OK)       { load the texture }
    Then Begin
      Writeln('Error loading texture.');
      Halt(0);
    End;
  GetTexturePalette(0);   { get the texture's palette }
  If (LoadIntensityTable('COPPRENV.IT', 0) <> I_OK) { load intensity table }
    Then Begin
      Writeln('Error loading Intensity table.');
      Halt(0);
    End;
  If (LoadTransparencyTable('COPPRENV.TT', 0) <> I_OK) { load transparency table }
    Then Begin
      Writeln('Error loading transparency table.');
      Halt(0);
    End;
  If (LoadGVO(Obj1, 'TORUSA.GVO', 0) <> I_OK)         { load the vector object }
    Then Begin
      Writeln('Error loading TORUS object.');
      Halt(0);
    End;
  If (LoadGVO(Obj2, 'TORUSB.GVO', 0) <> I_OK)         { load the second vector object }
    Then Begin
      Writeln('Error loading TORUS object.');
      Halt(0);
    End;
  If (InitView(View, Round(Obj1.Num_Polygons * 1.5)) <> I_OK) { init the view }
    Then Begin
      Writeln('Error Initializing view.');
      Halt(0);
    End;

  SetMode($13);              { Set graphics mode }
  SetPalette(GlobalPalette); { Set the palette }

  SetAbsoluteLocation(Obj1, 0, 0, Obj1.Radius * 5); { Set the object's location }
  SetAbsoluteLocation(Obj2, 0, 0, Obj2.Radius * 5); { Set the object's location }
  PushLightSource(View, 0, 0, -1);  { Add a light source }

  SetSurface(Obj1, SMOOTH);    { set smooth surface }
  SetShading(Obj1, GOURAUD);   { set lambert rendering for object }
  SetCull(Obj1, FALSE);        { turn off Object 1 culling }
  SetObjTrans(Obj1, TRUE);     { Enable transparency }
  SetBaseColor(Obj1, 36);

  SetSurface(Obj2, TEXTURE);    { set texture surface }
  SetShading(Obj2, GOURAUD);   { set gouraud rendering for object }
  SetObjectTexture(Obj2, 0);


  Repeat
    SetDeltaRotation(Obj1, 1, 2, 3);  { rotate the object  }
    SetDeltaRotation(Obj2, 1, 2, 3);  { rotate the object  }
    AddtoRenderList(View, Obj1);      { add it to the view }
    AddtoRenderList(View, Obj2);      { add it to the view }
    Render(View, VirtualPage);       { render to the virtual page }
    Flip;                            { Copy the page over }
  Until KeyPressed;

  FreeView(View);         { Free the view's allocated memory }
  FreeVectorObject(Obj1);  { free the vector object's allocated memory }
  FreeVectorObject(Obj2);  { free the vector object's allocated memory }
  FreeIntensityTable;     { free the intensity table from memory }

  FreeTexture(0);         { Free the phong map }

  SetMode($03);           { return to text mode }
End.
