Unit Font13h;

Interface

Procedure WriteString(X, Y : Integer; S : String; Color : Byte; Page : Pointer);
Function Length13h(S : String) : Word;

Implementation

Const  { 127 character 7x3 character set }
  NUMCHAR = 98;
  CharSet : Array[0..NUMCHAR*4*7-1] of Byte = (
  0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,
  1,0,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,0,1,1,1,1,1,0,1,0,1,1,1,1,1,0,1,0,1,0,0,0,0,
  0,0,1,0,0,1,1,1,1,0,1,0,0,1,1,0,0,0,1,1,1,1,1,0,0,0,1,0,
  1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,1,0,0,0,0,
  0,1,1,0,1,1,0,1,0,1,0,1,1,1,1,0,1,0,1,1,1,0,1,0,0,1,0,1,
  0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,0,0,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,1,0,
  0,1,0,0,0,0,1,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,1,0,0,
  0,0,0,0,0,0,0,0,0,1,1,0,1,1,1,1,0,1,1,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,1,0,0,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
  0,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,
  0,1,1,0,1,0,0,1,1,0,1,1,1,1,0,1,1,0,0,1,0,1,1,0,0,0,0,0,
  0,0,1,0,0,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,
  1,1,1,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,1,1,1,1,0,0,0,0,
  1,1,1,0,0,0,0,1,0,1,1,1,0,0,0,1,0,0,0,1,1,1,1,0,0,0,0,0,
  1,0,0,1,1,0,0,1,1,1,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,
  1,1,1,1,1,0,0,0,1,1,1,0,0,0,0,1,0,0,0,1,1,1,1,0,0,0,0,0,
  0,1,1,1,1,0,0,0,1,1,1,0,1,0,0,1,1,0,0,1,0,1,1,0,0,0,0,0,
  1,1,1,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,
  0,1,1,0,1,0,0,1,0,1,1,0,1,0,0,1,1,0,0,1,0,1,1,0,0,0,0,0,
  0,1,1,0,1,0,0,1,0,1,1,1,0,0,0,1,0,0,0,1,1,1,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,
  0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,
  0,1,1,0,1,0,0,1,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,
  0,1,1,0,1,0,0,1,1,0,1,1,1,0,1,0,1,0,0,0,0,1,1,1,0,0,0,0,
  0,1,1,0,1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,0,0,0,0,
  1,1,1,0,1,0,0,1,1,1,1,0,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,
  0,1,1,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,1,1,1,0,0,0,0,
  1,1,1,0,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,
  1,1,1,1,1,0,0,0,1,1,1,0,1,0,0,0,1,0,0,0,1,1,1,1,0,0,0,0,
  1,1,1,1,1,0,0,0,1,1,1,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,
  0,1,1,1,1,0,0,0,1,0,0,0,1,0,1,1,1,0,0,1,0,1,1,1,0,0,0,0,
  1,0,0,1,1,0,0,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,0,0,0,0,
  0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,
  0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,1,0,0,1,0,1,1,0,
  1,0,0,1,1,0,1,0,1,1,0,0,1,1,0,0,1,0,1,0,1,0,0,1,0,0,0,0,
  1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,1,1,1,0,0,0,0,
  1,0,0,1,1,0,1,1,1,1,1,1,1,0,0,1,1,0,0,1,1,0,0,1,0,0,0,0,
  1,0,0,1,1,1,0,1,1,0,1,1,1,0,0,1,1,0,0,1,1,0,0,1,0,0,0,0,
  0,1,1,0,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,0,1,1,0,0,0,0,0,
  1,1,1,0,1,0,0,1,1,0,0,1,1,1,1,0,1,0,0,0,1,0,0,0,0,0,0,0,
  0,1,1,0,1,0,0,1,1,0,0,1,1,0,0,1,1,0,1,0,0,1,0,1,0,0,0,0,
  1,1,1,0,1,0,0,1,1,0,0,1,1,1,1,0,1,0,1,0,1,0,0,1,0,0,0,0,
  0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,0,0,0,1,1,1,1,0,0,0,0,0,
  1,1,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,
  1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,0,1,1,0,0,0,0,0,
  1,0,0,1,1,0,0,1,1,0,0,1,1,0,1,0,1,1,0,0,1,0,0,0,0,0,0,0,
  1,0,0,1,1,0,0,1,1,0,0,1,1,1,0,1,1,1,1,1,0,1,1,0,0,0,0,0,
  1,0,0,1,1,0,0,1,0,1,1,0,0,1,1,0,1,0,0,1,1,0,0,1,0,0,0,0,
  1,0,0,1,1,0,0,1,1,0,0,1,0,1,1,1,0,0,0,1,0,0,0,1,0,1,1,0,
  1,1,1,1,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,1,1,1,1,0,0,0,0,
  1,1,1,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,1,1,0,0,0,0,0,
  1,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,
  0,1,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,1,1,1,0,0,0,0,
  0,1,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,
  0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,1,1,0,0,0,0,1,0,1,1,1,1,0,0,1,0,1,1,0,0,0,0,0,
  1,0,0,0,1,0,0,0,1,1,1,0,1,0,0,1,1,0,0,1,1,1,1,0,0,0,0,0,
  0,0,0,0,0,1,1,0,1,0,0,1,1,0,0,0,1,0,0,1,0,1,1,0,0,0,0,0,
  0,0,0,1,0,0,0,1,0,1,1,1,1,0,0,1,1,0,0,1,0,1,1,1,0,0,0,0,
  0,0,0,0,0,1,1,0,1,0,0,1,1,1,1,0,1,0,0,0,0,1,1,1,0,0,0,0,
  0,1,1,0,1,0,0,0,1,0,0,0,1,1,1,0,1,0,0,0,1,0,0,0,0,0,0,0,
  0,0,0,0,0,1,1,0,1,0,0,1,1,0,0,1,0,1,1,1,0,0,0,1,1,1,1,0,
  1,0,0,0,1,0,0,0,1,1,1,0,1,0,0,1,1,0,0,1,1,0,0,1,0,0,0,0,
  0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,
  0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,1,0,0,1,0,1,1,0,
  0,0,0,0,1,0,0,0,1,0,1,0,1,1,0,0,1,0,1,0,1,0,0,1,0,0,0,0,
  1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,1,1,0,0,0,0,0,
  0,0,0,0,1,1,1,0,1,1,0,1,1,1,0,1,1,0,0,1,1,0,0,1,0,0,0,0,
  0,0,0,0,1,1,1,0,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,0,0,0,0,
  0,0,0,0,0,1,1,0,1,0,0,1,1,0,0,1,1,0,0,1,0,1,1,0,0,0,0,0,
  0,0,0,0,0,1,1,0,1,0,0,1,1,0,0,1,1,1,1,0,1,0,0,0,1,0,0,0,
  0,0,0,0,0,1,1,0,1,0,0,1,1,0,0,1,0,1,1,1,0,0,0,1,0,0,0,1,
  0,0,0,0,0,1,1,0,1,0,0,1,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,
  0,0,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,1,1,1,1,0,0,0,0,0,
  0,1,0,0,1,1,1,1,0,1,0,0,0,1,0,0,0,1,0,0,0,0,1,1,0,0,0,0,
  0,0,0,0,1,0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,0,1,1,0,0,0,0,0,
  0,0,0,0,1,0,0,1,1,0,0,1,0,1,0,1,0,0,1,1,0,0,0,1,0,0,0,0,
  0,0,0,0,1,0,0,1,1,0,0,1,1,1,0,1,1,1,0,1,0,1,1,1,0,0,0,0,
  0,0,0,0,1,0,0,1,0,1,0,0,0,1,1,0,0,0,1,0,1,0,0,1,0,0,0,0,
  0,0,0,0,1,0,0,1,1,0,0,1,0,1,1,1,0,0,0,1,0,0,0,1,0,1,1,0,
  0,0,0,0,1,1,1,1,0,0,0,1,0,1,1,0,1,0,0,0,1,1,1,1,0,0,0,0,
  0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,
  0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,
  0,1,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,
  0,0,0,0,0,1,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,1,0,0,1,1,0,0,0,1,1,0,0,1,0,0,0,1,1,0,0,0,1,0,0,0,1,1,
  1,0,0,0,1,1,0,0,1,1,1,0,1,1,1,1,1,1,1,0,1,1,0,0,1,0,0,0,
  0,0,0,0,0,0,0,1,0,0,0,1,1,0,1,0,1,0,1,0,0,1,0,0,0,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0);

Function Length13h(S : String) : Word;

Begin
  Length13h := Length(S) * 4;
End;


Procedure WriteString(X, Y : Integer; S : String; Color : Byte; Page : Pointer);

Var
  CharCount : Integer;
  i : Integer;
  CharIndex  : Integer;
  xc, yc : Integer;
  sx, sy : Integer;
  Segment, Offset : Word;

Begin
  Segment := Seg(Page^);
  Offset := Ofs(Page^);
  For CharCount := 1 to Length(S) do
    Begin
      CharIndex := Ord(S[CharCount]) - 33;
      If (CharIndex > 0) And (CharIndex < NUMCHAR)
        Then Begin
          For yc := 0 to 6 do
            For xc := 0 to 3 do
              If CharSet[CharIndex * 4*7 + yc Shl 2 + xc] = 1
                Then Begin
                  sx := x+xc;
                  sy := y+yc;
                  If ((sy >= 0) and (sy <= 199)) And
                     ((sx >= 0) and (sx <= 319))
                     Then Mem[Segment:Offset + (sy Shl 8) + (sy Shl 6)+sx] := Color;
                End;
        End;
      Inc(x, 5);
      If (X > 320)
        Then Exit;
    End;
End;

End.
