;----------------------------------------------------------------------------;
;;
; Crystal - 3D Realtime Rendering Engine ;
; coded by maLi/MaLixa ;
; Copyright (c) 1996, 1997, 1998 by Matjaz Trtnik ;
; All rights reserved ;
;;
;                                                                            ;
;Main engine program.                                                        ;
;                                                                            ;
;(c) Matjaz Trtnik, 1996, 1997, 1998                                         ;
;mtrtnik@bigfoot.com                                                         ;
;http://www2.arnes.si/~ssdmalic/mali/                                        ;
;                                                                            ;
;    You are not permitted to distribute, sell or use any part of            ;
;    this source for your software without special permision of author.      ;
;                                                                            ;
;----------------------------------------------------------------------------;
.486p
.model flat
.stack
CODE SEGMENT DWORD PUBLIC 'CODE'
ASSUME cs:CODE,ds:DATA
;----------------------------------------------------------------------------;
Crystal_MaLixa_Engine:
      call     INITENGINE
Engine_InnerLoop:
      mov      al,byte ptr [Obj.Shade_Limit]
      cmp      al,4
      jge      nobackground
      mov      edi,dword ptr [Offset_Active_Page]
      mov      esi,dword ptr [Offset_CyboMan]
      call     FLIPVIRTUALPAGE
      jmp      backgrorund_done
nobackground:
      xor      eax,eax
      call     CLEARVIRTUALPAGE
backgrorund_done:
      mov      edi,offset Obj
      mov      dword ptr [edi.Z_Offset],350
      inc      word ptr [edi.Angle_X]
      inc      word ptr [edi.Angle_Y]
      inc      word ptr [edi.Angle_Z]
      call     OBJECTLOCALMATRIX
      mov      edi,offset Obj
      call     OBJECTLOCALROTATE
      mov      edi,offset Obj
      call     OBJECTLOCALPROJECT
      ;----------- vpisi z koordinato ------
      movzx    ecx,[Obj.Number_Of_Faces]
      mov      edi,[Obj.Offset_FArray]
      mov      esi,[Obj.Offset_RotVArray]
      mov      ebp,[Obj.Offset_RotFNArray]
makez:
      ;1. vertex
      mov      eax,[edi]
      lea      eax,[eax+eax*2]
      shl      eax,2
      mov      ebx,[esi+eax+8]
      mov      [edi+16],ebx
      ;2. vertex
      mov      eax,[edi+4]
      lea      eax,[eax+eax*2]
      shl      eax,2
      mov      ebx,[esi+eax+8]
      add      [edi+16],ebx
      ;3. vertex
      mov      eax,[edi+8]
      lea      eax,[eax+eax*2]
      shl      eax,2
      mov      ebx,[esi+eax+8]
      add      [edi+16],ebx
      ;color of face
      mov      eax,[ebp+8]
      mov      [edi+12],eax
      add      ebp,12
      add      edi,20
      loop     makez

      mov      eax,[Obj.Offset_FArray]
      xor      ecx,ecx
      movzx    edx,[Obj.Number_Of_Faces]
      dec      edx
      call     QSORT

      mov      edi,offset Obj
      call     OBJECTRENDER
      ;call     WAITVRETRACE
      call     FLIPVIRTUALPAGE_
      inc      dword ptr [Frames]
      mov      ax,100h
      int      16h
      jz       Engine_InnerLoop
      call     DEINITENGINE
      mov      ax,4c00h
      int      21h
;----------------------------------------------------------------------------;
WRITESYSTEMINFO PROC NEAR
                mov       ax,900h
                mov       edx,offset EngineStr
                int       21h
                mov       ax,900h
                mov       edx,offset InitStr
                int       21h
                mov       ax,900h
                mov       edx,offset sincosStr
                int       21h
                mov       ax,900h
                mov       edx,offset textStr
                int       21h
                mov       ax,900h
                mov       edx,offset normals
                int       21h
                mov       ax,900h
                mov       edx,offset System
                int       21h
                call      MOUSEWRITEINFO
                mov       ax,900h
                mov       edx,offset RenderStr
                int       21h
                ;print texture file
                mov       ax,900h
                mov       edx,offset TextureStr
                int       21h
                mov       edx,dword ptr [Texture];offset TextFile
                int       21h
                mov       edx,offset Zaklepaj
                int       21h
                ;print number of vertices to screen
                mov       edx,offset VertexStr
                int       21h
                movzx     eax,word ptr [Obj.Number_Of_Vertices]
                call      PRINTREG
                mov       ax,900h
                mov       edx,offset Zaklepaj
                int       21h
                ;print number of faces to screen
                mov       edx,offset FaceStr
                int       21h
                movzx     eax,word ptr [Obj.Number_Of_Faces]
                call      PRINTREG
                mov       ax,900h
                mov       edx,offset Zaklepaj
                int       21h
                ret
WRITESYSTEMINFO ENDP
;----------------------------------------------------------------------------;
MAKEPALETTE PROC NEAR
            mov      esi,offset Palette
            mov      cx,64
            xor      bx,bx
makepal_shading:
            mov      byte ptr [esi],bl
            mov      byte ptr [esi+1],bl
            mov      ax,bx
            shr      ax,2
            mov      byte ptr [esi+2],al
            add      esi,3
            inc      bx
            loop     makepal_shading
            mov      cx,192
            xor      bx,bx
makepal_cyboman:
            mov      ax,bx
            shr      ax,2
            mov      byte ptr [esi],al
            xor      al,al
            mov      byte ptr [esi+1],al
            mov      byte ptr [esi+2],al
            inc      bx
            add      esi,3
            loop     makepal_cyboman
            ret
MAKEPALETTE ENDP
;----------------------------------------------------------------------------;
INITENGINE PROC NEAR
           ;--- init engine part ---
           mov      edi,offset Obj
           mov      edx,offset ObjFile
           call     INITOBJECT

           ;scale like
           mov      edi,offset Obj
           movzx    ecx,word ptr [edi.Number_Of_Vertices]
           mov      esi,dword ptr [edi.Offset_VArray]
loop1:
           mov      ebx,8
           mov      eax,[esi]
           shl      eax,3
           cdq
           idiv     ebx
           mov      [esi],eax

           mov      ebx,8
           mov      eax,[esi+4]
           shl      eax,3
           cdq
           idiv     ebx
           mov      [esi+4],eax

           mov      ebx,8
           mov      eax,[esi+8]
           shl      eax,3
           cdq
           idiv     ebx
           mov      [esi+8],eax

           add      esi,12
           loop     loop1
           ;--- find which texture we have to use
           mov      al,byte ptr [Obj.Shade_Limit]
           cmp      al,6
           je       initengine_text
           mov      eax,offset ENVText
           jmp      initengine_textdone
initengine_text:
           mov      eax,offset PhongText
initengine_textdone:
           mov      dword ptr [Texture],eax
           call     WRITESYSTEMINFO
           xor      ax,ax
           int      16h
           call     BUILDSINCOS
           ;--- init gfx part ---
           call     INITGFXMODE
           call     CYBOMANFRACTAL
           mov      eax,VIRTUAL_PAGE
           call     SETVIRTUALPAGE
           mov      al,[Obj.Shade_Limit]
           cmp      al,4
           jl       initengine_notext
           mov      edx,dword ptr [Texture]
           ;load texture
           call     LOADPCXFILE
           mov      dword ptr [Texture],edi
           ;load shading tables
           mov      edx,offset STableFile
           ;call     LOADSHADETABLE
           mov      dword ptr [ShadeTable],edi
           ;make phong map
           call     PHONGMAP
           mov      eax,dword ptr [Offset_Phong_Map]
           mov      dword ptr [Texture],eax
           mov      esi,offset PhongPal
           call     SETPALETTE
           jmp      initegnine_done
initengine_notext:
           ;call     MAKEPALETTE
           ;mov      esi,offset Palette
           ;call     SETPALETTE
initegnine_done:
           call     INITTIMER
           ret
INITENGINE ENDP
;----------------------------------------------------------------------------;
DEINITENGINE PROC NEAR
             call     DEINITTIMER
             call     INITTEXTMODE
             call     GETFPSRATE
             call     PRINTFPSRATE
             ret
DEINITENGINE ENDP
;----------------------------------------------------------------------------;
include includes/multi.mdg
;----------------------------------------------------------------------------;
CODE ENDS
;----------------------------------------------------------------------------;
DATA SEGMENT DWORD PUBLIC 'DATA'
PhongPal    Label Byte
i=0
REPT 256
     db 0,0,i/4
     i=i+2
ENDM
EngineStr   db     '--------------------------------------------------------------------------------'
            db     'CRYSTAL V0.14a - 3D Vector System coded by maLi                  September, 1996'
            db     '--------------------------------------------------------------------------------$',13,10
RenderStr   db     13,10,'Rendering info$'
TextureStr  db     13,10,' TEXTURE FILE: [$'
VertexStr   db     13,10,' VERTICES    : [$'
FaceStr     db     13,10,' FACES       : [$'
Zaklepaj    db     ']$'
InitStr     db     13,10,'Initializing$'
System      db     13,10,'System Info$'
sincosStr   db     13,10,' GENERATING  : [sinus/cosinus]$'
textStr     db     13,10,' GENERATING  : [CyboMan II texture]$'
normals     db     13,10,' GENERATING  : [face and vertex normals]$'
PhongText   db     'maps/t3.pcx$',0
ENVText     db     'maps/mess.pcx$',0
STableFile  db     'maps/sky.it',0

ObjFile     db     'objects/dolph.c3d',0
;ObjFile     db     'objects/ls.c3d',0
;ObjFile     db     'objects/kocka.c3d',0
;ObjFile     db     'objects/duck.c3d',0
;ObjFile     db     'objects/torus.c3d',0
;ObjFile     db     'objects/torus1.c3d',0
;ObjFile     db     'objects/mali.c3d',0
;ObjFile     db     'objects/faith.c3d',0
;ObjFile     db     'objects/sakk.c3d',0
;ObjFile     db     'objects/krogla.c3d',0

Obj         Object ?
Palette     db 768 dup (?)
ShadeTable  dd ?
DATA ENDS
;----------------------------------------------------------------------------;
end Crystal_MaLixa_Engine
;----------------------------------------------------------------------------;