#include <conio.h>
#include <stdlib.h>

#include <pr.h>

/* Power Render Example 1

   Description:  Provides a minimal application which uses 320x200
                 VGA mode, loads a PRO file, and rotates it.
*/

                                             
PR_VIEWPORT viewport;                  /* Our viewport structure */
PR_CAMERA *camera;                     /* One camera */
PR_OBJECT *object_shape;               /* The shape loaded */
PR_ENTITY *entity;                     /* A single entity of the shape */

void main (void)
{
PR_REAL cenx, ceny, cenz;

  PR_Initialize (1000);                /* Maximum 1000 triangles per frame */

  PR_DetectVGA ();                     /* Always succeeds */
  PR_InitializeVGA ();                 /* Initialize the device */

  PR_AllocMaterials (32);              /* Allocate the materials, */
  PR_AllocTextures (32);               /* textures, */
  PR_AllocShadeTables (2);             /* and shade tables */

  PR_SetMode (320, 200, 60);           /* Initialize 320x200 */

  PR_OpenViewport (&viewport, 0, 0, 319, 199, VIEW_PLAIN);
  PR_SetViewport (&viewport);          /* Open a full screen viewport */

  /* Load the object */
  PR_SetTexturePath ("..\\data\\");
  object_shape = PR_LoadPRO ("..\\data\\cube.pro", LOAD_NORMAL);
  PR_CenterObject (object_shape, &cenx, &ceny, &cenz);

  /* Set the palette from the textures loaded */
  wsetpalette (0, 255, global_palette);

  /* Create the main entity */
  entity = PR_CreateEntity (object_shape, "TEST ENTITY");


  camera = PR_AllocCamera ();          /* Initialize the camera */
  PR_InitializeCamera (camera);
  PR_PositionCameraSource (camera, 0, 0, 400);
  PR_PositionCameraTarget (camera, 0, 0, 0);
  PR_SetCameraMode (camera, CAMFLAG_AIM_TARGET); 
  PR_SetActiveCamera (camera);

  PR_OpenScreen (PR_BACKBUFFER);

  /* main program loop */
  while (!kbhit ())
    {
     PR_NewFrame ();                   /* Begin a new frame */

     PRGFX_SetColor (0);
     PRGFX_ClearScreen ();             /* Clear the last frame */

     PR_RotateEntity (entity, 0, 2, 1);/* Rotate the entity */
     PR_TransformEntity (entity);      /* Transform the entity */
     PR_RenderEntity (entity);         /* Render the entity */

     PR_RenderFrame ();                /* Draw the scene */

     PR_Flip (1);                      /* Show the background page */
    }

  /* Free all allocated memory */
  PR_FreeCamera (camera);
  PR_FreeEntity (entity);
  PR_FreeObject (object_shape);
  PR_CloseViewport (&viewport);
  PR_DeleteAllShadeTables ();
  PR_DeleteAllTextures ();
  PR_DeleteAllMaterials ();
  PR_ShutDown ();

  wsetmode (3);                        /* Go back to text mode */
}

