#ifndef _PRREND_
#define _PRREND_         /* Mark this header already included */

#ifdef __cplusplus
 extern "C" {
#endif

#include "prdef.h"
#include "prview.h"
#include "prset.h"

extern PR_DWORD PR_TextureDivisions;
extern PR_DWORD PR_TextureShifts;
extern PR_REAL endz;
extern PR_REAL zinv;
extern PR_REAL dlen;
extern PR_REAL perspconst;
extern PR_REAL OneOver64;




/* Triangle point definition */
typedef struct
 {
  PR_DWORD              sx,sy;         /* Coordinate on the screen */
  PR_DWORD              u,v;           /* Coordinate on the texture */
  PR_REAL               x, y, z;       /* Local coordinate of vertex */
  PR_REAL               ooz;           /* 1 / z */
  PR_DWORD              col;           /* Color of vertex */
  PR_UCHAR              r,g,b,a;       /* Truecolor support */
  PR_DWORD              flags;         /* Clipping flags */
 } PR_RPOINT;


/* Constants */
#define CLIP_TOP    1
#define CLIP_BOTTOM 2
#define CLIP_LEFT   4
#define CLIP_RIGHT  8
#define CLIP_ALL    15


/* Statistics */
extern PR_DWORD PR_PixelsDrawn;
extern PR_DWORD PR_ScansDrawn;

/* Globals used in tmap asm routine */
extern unsigned char *PR_TextureASM;
extern short ufrac;
extern short vfrac;
extern char uwhole;
extern char vwhole;
extern int length_asm;
extern int UVStepsCarry;
extern int UVStepsNoCarry;
extern unsigned int texturelength;
extern int PR_TextureWidth;

/* Globals used in gouraud tmap asm routine */
extern short cfrac;
extern char cwhole;
extern int ufracint;
extern int vfracint;
extern int cfracint;
extern int xcount;
extern char cvalue;
extern short cvalue16;
extern unsigned char *shadetableasm;
extern unsigned char *destasm;
extern int colortemp;

/* Used for zbuffering */
extern unsigned short z_asm;
extern unsigned short dz_asm;
extern unsigned char *zbuf_asm;

/* Used for low resolution rendering */
extern int tmaptable[640];
extern int PR_MaxScanLength;


extern int ptx, pty, pbx, pby;

extern int PR_TextureFlags;


/* Fixed point division */
int fix_div (int a,int b);
#pragma aux fix_div = \
  "cdq" \
  "shld edx,eax,16" \
  "shl eax,16" \
  "idiv ebx" parm [eax] [ebx] modify [eax ebx edx];



/* Texture Mapping Flags */
#define TFLAG_WRAPPING 1
#define TFLAG_XRAY 2

/* Wireframe */
void PR_Tri_Wireframe_Clipped (PR_RPOINT *intri, int incount);
void PR_Tri_Wireframe (PR_RPOINT *intri, int incount);
void PR_Line_Clipped (int x0, int y0, int x1, int y1);


/* Source Transformed */
void PR_Source_Span_Clipped (unsigned char *dst, int leftx, int rightx);
void PR_Tri_Source (PR_RPOINT *vertices, unsigned char *table);
void PR_Tri_Source_Clipped (PR_RPOINT *vertices, unsigned char *table);


/* Flat Shaded */
void PR_Solid_Span_Clipped (unsigned char *dst, int leftx, int rightx,
                            int col);
void PR_Tri_Solid (PR_RPOINT *vertices);
void PR_Tri_Solid_Clipped2 (PR_RPOINT *vertices);
void PR_Tri_Solid_Clipped (PR_RPOINT *vertices, int clipflags);


/* Gouraud Shaded */
void PR_Gouraud_Span (unsigned char *dest, int leftx, int rightx,
                      int c0, int deltac);
void PR_Gouraud_Span_Clipped (unsigned char *dest, int leftx, int rightx,
                              int c0, int deltac);
void PR_F2B_Gouraud_Span (unsigned char *dest, int leftx, int rightx,
                          int c0, int deltac, int y);
void PR_Tri_Gouraud (PR_RPOINT *vertices);
void PR_Tri_Gouraud_Clipped (PR_RPOINT *vertices);


/* Low Res Texture Mapping */
void PR_LTexture_Span (unsigned char *dest, int leftx, int rightx,
                       int u0, int v0);
void PR_LTexture_Span_Clipped (unsigned char *dest, int leftx, int rightx,
                               int u0, int v0, int ustep, int vstep);
void PR_F2B_LTexture_Span (unsigned char *dest, int leftx, int rightx,
                           int u0, int v0, int ustep, int vstep, int y);
void PR_Tri_LTexture (PR_RPOINT *vertices, block texture);
void PR_Tri_LTexture_Clipped (PR_RPOINT *vertices, block texture);


/* Low Res Flat Texture Mapping */
void PR_LFlat_Texture_Span (unsigned char *dest, int x0, int x1,
                            int u0, int v0);
void PR_LFlat_Texture_Span_Clipped (unsigned char *dest, int x0, int x1,
                                    int u0, int v0, int ustep, int vstep);
void PR_F2B_LFlat_Texture_Span (unsigned char *dest, int x0, int x1,
                                    int u0, int v0, int ustep, int vstep, int y);
void PR_Tri_LFlatTexture (PR_RPOINT *vertices, block texture,
                          unsigned char *shadetable);
void PR_Tri_LFlatTexture_Clipped (PR_RPOINT *vertices, block texture,
                                  unsigned char *shadetable);

/* Low Res Gouraud Texture Mapping */
void PR_LGour_Texture_Span (unsigned char *dest, int x0, int x1, 
                            int u0, int v0, int c0, int c1);
void PR_LGour_Texture_Span_Clipped (unsigned char *dest, int x0, int x1,
                                    int u0, int v0, int ustep, int vstep,
                                    int c0, int cstep);
void PR_F2B_LGour_Texture_Span (unsigned char *dest, int x0, int x1,
                                int u0, int v0, int ustep, int vstep,
                                int c0, int cstep, int y);
void PR_Tri_LGouraudTexture (PR_RPOINT *vertices,
                          block texture, unsigned char *shadetable);
void PR_Tri_LGouraudTexture_Clipped (PR_RPOINT *vertices,
                                  block texture, unsigned char *shadetable);


/* Low Res Translucent Texture Mapping */
void PR_LTrans_Texture_Span (unsigned char *dest, int x0, int x1,
                             int u0, int v0);
void PR_LTrans_Texture_Span_Clipped (unsigned char *dest, int x0, int x1,
                                     int u0, int v0, int ustep, int vstep);
void PR_F2B_LTrans_Texture_Span (unsigned char *dest, int x0, int x1,
                                 int u0, int v0, int ustep, int vstep, int y);
void PR_Tri_LTransTexture (PR_RPOINT *vertices, block texture,
                           unsigned char *shadetable);
void PR_Tri_LTransTexture_Clipped (PR_RPOINT *vertices, block texture,
                                   unsigned char *shadetable);


/* Texture Mapping */
void PR_WTexture_Span (unsigned char *dest, int leftx, int rightx,
                      int u0, int v0, int u1, int v1);
void PR_WTexture_Span_Clipped (unsigned char *dest, int leftx, int rightx,
                               int u0, int v0, int u1, int v1);
void PR_XWTexture_Span (unsigned char *dest, int leftx, int rightx,
                      int u0, int v0, int u1, int v1);
void PR_XWTexture_Span_Clipped (unsigned char *dest, int leftx, int rightx,
                               int u0, int v0, int u1, int v1);
void PR_Texture_Span (unsigned char *dest, int leftx, int rightx,
                      int u0, int v0, int u1, int v1);
void PR_Texture_Span_Clipped (unsigned char *dest, int leftx, int rightx,
                               int u0, int v0, int u1, int v1);
void PR_XTexture_Span (unsigned char *dest, int leftx, int rightx,
                      int u0, int v0, int u1, int v1);
void PR_XTexture_Span_Clipped (unsigned char *dest, int leftx, int rightx,
                               int u0, int v0, int u1, int v1);
void PR_F2B_Texture_Span (unsigned char *dest, int leftx, int rightx,
                          int u0, int v0, int u1, int v1, int y);
void PR_Tri_Texture (PR_RPOINT *vertices, block texture);
void PR_Tri_Texture_Clipped (PR_RPOINT *vertices, block texture);



/* Perspective Texture Mapping */
void PR_PWTexture_Span (unsigned char *dest, int leftx, int rightx,
                      PR_REAL z0, PR_REAL u0, PR_REAL v0,
                      PR_REAL z1, PR_REAL u1, PR_REAL v1);
void PR_PWTexture_Span_Clipped (unsigned char *dest, int leftx, int rightx,
                      PR_REAL z0, PR_REAL u0, PR_REAL v0,
                      PR_REAL z1, PR_REAL u1, PR_REAL v1);
void PR_PXWTexture_Span (unsigned char *dest, int leftx, int rightx,
                      PR_REAL z0, PR_REAL u0, PR_REAL v0,
                      PR_REAL z1, PR_REAL u1, PR_REAL v1);
void PR_PXWTexture_Span_Clipped (unsigned char *dest, int leftx, int rightx,
                      PR_REAL z0, PR_REAL u0, PR_REAL v0,
                      PR_REAL z1, PR_REAL u1, PR_REAL v1);
void PR_PTexture_Span (unsigned char *dest, int leftx, int rightx,
                      PR_REAL z0, PR_REAL u0, PR_REAL v0,
                      PR_REAL z1, PR_REAL u1, PR_REAL v1);
void PR_PTexture_Span_Clipped (unsigned char *dest, int leftx, int rightx,
                      PR_REAL z0, PR_REAL u0, PR_REAL v0,
                      PR_REAL z1, PR_REAL u1, PR_REAL v1);
void PR_PXTexture_Span (unsigned char *dest, int leftx, int rightx,
                      PR_REAL z0, PR_REAL u0, PR_REAL v0,
                      PR_REAL z1, PR_REAL u1, PR_REAL v1);
void PR_PXTexture_Span_Clipped (unsigned char *dest, int leftx, int rightx,
                      PR_REAL z0, PR_REAL u0, PR_REAL v0,
                      PR_REAL z1, PR_REAL u1, PR_REAL v1);
void PR_F2B_PTexture_Span (unsigned char *dest, int leftx, int rightx,
                      PR_REAL z0, PR_REAL u0, PR_REAL v0,
                      PR_REAL z1, PR_REAL u1, PR_REAL v1, int y);
void PR_TriPersp_Texture (PR_RPOINT *vertices, block texture);
void PR_TriPersp_Texture_Clipped (PR_RPOINT *vertices, block texture);




/* Flat Shaded Texture Mapping */
void PR_Flat_WTexture_Span (unsigned char *dest, int leftx, int rightx,
                             int u0, int v0, int u1, int v1);
void PR_Flat_WTexture_Span_Clipped (unsigned char *dest,
                                     int leftx, int rightx,
                                     int u0, int v0, int u1, int v1);
void PR_Flat_XWTexture_Span (unsigned char *dest, int leftx, int rightx,
                              int u0, int v0, int u1, int v1);
void PR_Flat_XWTexture_Span_Clipped (unsigned char *dest,
                                      int leftx, int rightx,
                                      int u0, int v0, int u1, int v1);
void PR_Flat_Texture_Span (unsigned char *dest, int leftx, int rightx,
                            int u0, int v0, int u1, int v1);
void PR_Flat_Texture_Span_Clipped (unsigned char *dest,
                                    int leftx, int rightx,
                                   int u0, int v0, int u1, int v1);
void PR_Flat_XTexture_Span (unsigned char *dest, int leftx, int rightx,
                             int u0, int v0, int u1, int v1);
void PR_Flat_XTexture_Span_Clipped (unsigned char *dest,
                                     int leftx, int rightx,
                                     int u0, int v0, int u1, int v1);
void PR_F2B_Flat_Texture_Span (unsigned char *dest, int leftx, int rightx,
                               int u0, int v0, int u1, int v1, int y);
void PR_Tri_FlatTexture (PR_RPOINT *vertices, block texture,
                         unsigned char *shadetable);
void PR_Tri_FlatTexture_Clipped (PR_RPOINT *vertices, block texture,
                         unsigned char *shadetable);


/* Perspective Flat Shaded Texture Mapping */
void PR_Flat_PWTexture_Span (unsigned char *dest, int leftx, int rightx,
                      PR_REAL z0, PR_REAL u0, PR_REAL v0,
                      PR_REAL z1, PR_REAL u1, PR_REAL v1);
void PR_Flat_PWTexture_Span_Clipped (unsigned char *dest, int leftx, int rightx,
                      PR_REAL z0, PR_REAL u0, PR_REAL v0,
                      PR_REAL z1, PR_REAL u1, PR_REAL v1);
void PR_Flat_PXWTexture_Span (unsigned char *dest, int leftx, int rightx,
                      PR_REAL z0, PR_REAL u0, PR_REAL v0,
                      PR_REAL z1, PR_REAL u1, PR_REAL v1);
void PR_Flat_PXWTexture_Span_Clipped (unsigned char *dest, int leftx, int rightx,
                      PR_REAL z0, PR_REAL u0, PR_REAL v0,
                      PR_REAL z1, PR_REAL u1, PR_REAL v1);
void PR_Flat_PTexture_Span (unsigned char *dest, int leftx, int rightx,
                      PR_REAL z0, PR_REAL u0, PR_REAL v0,
                      PR_REAL z1, PR_REAL u1, PR_REAL v1);
void PR_Flat_PTexture_Span_Clipped (unsigned char *dest, int leftx, int rightx,
                      PR_REAL z0, PR_REAL u0, PR_REAL v0,
                      PR_REAL z1, PR_REAL u1, PR_REAL v1);
void PR_Flat_PXTexture_Span (unsigned char *dest, int leftx, int rightx,
                      PR_REAL z0, PR_REAL u0, PR_REAL v0,
                      PR_REAL z1, PR_REAL u1, PR_REAL v1);
void PR_Flat_PXTexture_Span_Clipped (unsigned char *dest, int leftx, int rightx,
                      PR_REAL z0, PR_REAL u0, PR_REAL v0,
                      PR_REAL z1, PR_REAL u1, PR_REAL v1);
void PR_F2B_Flat_PTexture_Span (unsigned char *dest, int leftx, int rightx,
                      PR_REAL z0, PR_REAL u0, PR_REAL v0,
                      PR_REAL z1, PR_REAL u1, PR_REAL v1, int y);
void PR_TriPersp_FlatTexture (PR_RPOINT *vertices, block texture,
                              unsigned char *shadetable);
void PR_TriPersp_FlatTexture_Clipped (PR_RPOINT *vertices, block texture,
                                      unsigned char *shadetable);



/* Gouraud Shaded Texture Mapping */
void PR_Gouraud_WTexture_Span (unsigned char *dest, int leftx, int rightx,
                               int u0, int v0, int c0,
                               unsigned int ustep, unsigned int vstep,
                               int cstep);
void PR_Gouraud_WTexture_Span_Clipped (unsigned char *dest, int leftx,
                               int rightx, int u0, int v0, int c0,
                               unsigned int ustep, unsigned int vstep,
                               int cstep);
void PR_Gouraud_XWTexture_Span (unsigned char *dest, int leftx, int rightx,
                               int u0, int v0, int c0,
                               unsigned int ustep, unsigned int vstep,
                               int cstep);
void PR_Gouraud_XWTexture_Span_Clipped (unsigned char *dest, int leftx,
                               int rightx, int u0, int v0, int c0,
                               unsigned int ustep, unsigned int vstep,
                               int cstep);
void PR_Gouraud_Texture_Span (unsigned char *dest, int leftx, int rightx,
                               int u0, int v0, int c0,
                               int ustep, int vstep, int cstep);
void PR_Gouraud_Texture_Span_Clipped (unsigned char *dest, int leftx,
                               int rightx, int u0, int v0, int c0,
                               int ustep, int vstep, int cstep);
void PR_Gouraud_XTexture_Span (unsigned char *dest, int leftx, int rightx,
                               int u0, int v0, int c0,
                               int ustep, int vstep, int cstep);
void PR_Gouraud_XTexture_Span_Clipped (unsigned char *dest, int leftx,
                               int rightx, int u0, int v0, int c0,
                               int ustep, int vstep, int cstep);
void PR_F2B_Gouraud_Texture_Span (unsigned char *dest, int leftx, int rightx,
                               int u0, int v0, int c0,
                               unsigned int ustep, unsigned int vstep,
                               int cstep, int y);
void PR_Tri_Gouraud_Texture8 (PR_RPOINT *vertices, block texture,
                               unsigned char *shadetable);
void PR_Tri_Gouraud_Texture_Clipped8 (PR_RPOINT *vertices, block texture,
                               unsigned char *shadetable);


/* Perspective Gouraud Shaded Texture Mapping */
void PR_Gouraud_PWTexture_Span (unsigned char *dest, int leftx, int rightx,
                                PR_REAL z0, PR_REAL u0, PR_REAL v0,
                                PR_REAL z1, PR_REAL u1, PR_REAL v1,
                                int c0, int cstep);
void PR_Gouraud_PWTexture_Span_Clipped (unsigned char *dest,
                                int leftx, int rightx,
                                PR_REAL z0, PR_REAL u0, PR_REAL v0,
                                PR_REAL z1, PR_REAL u1, PR_REAL v1,
                                int c0, int cstep);
void PR_Gouraud_PXWTexture_Span (unsigned char *dest, int leftx, int rightx,
                                PR_REAL z0, PR_REAL u0, PR_REAL v0,
                                PR_REAL z1, PR_REAL u1, PR_REAL v1,
                                int c0, int cstep);
void PR_Gouraud_PXWTexture_Span_Clipped (unsigned char *dest,
                                int leftx, int rightx,
                                PR_REAL z0, PR_REAL u0, PR_REAL v0,
                                PR_REAL z1, PR_REAL u1, PR_REAL v1,
                                int c0, int cstep);
void PR_Gouraud_PTexture_Span (unsigned char *dest,
                                int leftx, int rightx,
                                PR_REAL z0, PR_REAL u0, PR_REAL v0,
                                PR_REAL z1, PR_REAL u1, PR_REAL v1,
                                int c0, int cstep);
void PR_Gouraud_PTexture_Span_Clipped (unsigned char *dest,
                                int leftx,int rightx,
                                PR_REAL z0, PR_REAL u0, PR_REAL v0,
                                PR_REAL z1, PR_REAL u1, PR_REAL v1,
                                int c0, int cstep);
void PR_Gouraud_PXTexture_Span (unsigned char *dest,
                                int leftx, int rightx,
                                PR_REAL z0, PR_REAL u0, PR_REAL v0,
                                PR_REAL z1, PR_REAL u1, PR_REAL v1,
                                int c0, int cstep);
void PR_Gouraud_PXTexture_Span_Clipped (unsigned char *dest,
                                int leftx, int rightx,
                                PR_REAL z0, PR_REAL u0, PR_REAL v0,
                                PR_REAL z1, PR_REAL u1, PR_REAL v1,
                                int c0, int cstep);
void PR_F2B_Gouraud_PTexture_Span (unsigned char *dest,
                                int leftx, int rightx,
                                PR_REAL z0, PR_REAL u0, PR_REAL v0,
                                PR_REAL z1, PR_REAL u1, PR_REAL v1,
                                int c0, int cstep, int y);
void PR_TriPersp_Gouraud_Texture8 (PR_RPOINT *vertices, block texture,
                                unsigned char *shadetable);
void PR_TriPersp_Gouraud_Texture_Clipped8 (PR_RPOINT *vertices, block texture,
                                unsigned char *shadetable);



/* Translucent Texture Mapping */
void PR_Trans_WTexture_Span (unsigned char *dest, int leftx, int rightx,
                             int u0, int v0, int u1, int v1);
void PR_Trans_WTexture_Span_Clipped (unsigned char *dest,
                                     int leftx, int rightx,
                                     int u0, int v0, int u1, int v1);
void PR_Trans_XWTexture_Span (unsigned char *dest, int leftx, int rightx,
                              int u0, int v0, int u1, int v1);
void PR_Trans_XWTexture_Span_Clipped (unsigned char *dest,
                                      int leftx, int rightx,
                                      int u0, int v0, int u1, int v1);
void PR_Trans_Texture_Span (unsigned char *dest, int leftx, int rightx,
                            int u0, int v0, int u1, int v1);
void PR_Trans_Texture_Span_Clipped (unsigned char *dest,
                                    int leftx, int rightx,
                                   int u0, int v0, int u1, int v1);
void PR_Trans_XTexture_Span (unsigned char *dest, int leftx, int rightx,
                             int u0, int v0, int u1, int v1);
void PR_Trans_XTexture_Span_Clipped (unsigned char *dest,
                                     int leftx, int rightx,
                                     int u0, int v0, int u1, int v1);
void PR_F2B_Trans_Texture_Span (unsigned char *dest, int leftx, int rightx,
                               int u0, int v0, int u1, int v1, int y);
void PR_Tri_TransTexture (PR_RPOINT *vertices, block texture,
                         unsigned char *shadetable);
void PR_Tri_TransTexture_Clipped (PR_RPOINT *vertices, block texture,
                         unsigned char *shadetable);


/* Perspective Translucent Shaded Texture Mapping */
void PR_Trans_PWTexture_Span (unsigned char *dest, int leftx, int rightx,
                      PR_REAL z0, PR_REAL u0, PR_REAL v0,
                      PR_REAL z1, PR_REAL u1, PR_REAL v1);
void PR_Trans_PWTexture_Span_Clipped (unsigned char *dest, int leftx, int rightx,
                      PR_REAL z0, PR_REAL u0, PR_REAL v0,
                      PR_REAL z1, PR_REAL u1, PR_REAL v1);
void PR_Trans_PXWTexture_Span (unsigned char *dest, int leftx, int rightx,
                      PR_REAL z0, PR_REAL u0, PR_REAL v0,
                      PR_REAL z1, PR_REAL u1, PR_REAL v1);
void PR_Trans_PXWTexture_Span_Clipped (unsigned char *dest, int leftx, int rightx,
                      PR_REAL z0, PR_REAL u0, PR_REAL v0,
                      PR_REAL z1, PR_REAL u1, PR_REAL v1);
void PR_Trans_PTexture_Span (unsigned char *dest, int leftx, int rightx,
                      PR_REAL z0, PR_REAL u0, PR_REAL v0,
                      PR_REAL z1, PR_REAL u1, PR_REAL v1);
void PR_Trans_PTexture_Span_Clipped (unsigned char *dest, int leftx, int rightx,
                      PR_REAL z0, PR_REAL u0, PR_REAL v0,
                      PR_REAL z1, PR_REAL u1, PR_REAL v1);
void PR_Trans_PXTexture_Span (unsigned char *dest, int leftx, int rightx,
                      PR_REAL z0, PR_REAL u0, PR_REAL v0,
                      PR_REAL z1, PR_REAL u1, PR_REAL v1);
void PR_Trans_PXTexture_Span_Clipped (unsigned char *dest, int leftx, int rightx,
                      PR_REAL z0, PR_REAL u0, PR_REAL v0,
                      PR_REAL z1, PR_REAL u1, PR_REAL v1);
void PR_F2B_Trans_PTexture_Span (unsigned char *dest, int leftx, int rightx,
                      PR_REAL z0, PR_REAL u0, PR_REAL v0,
                      PR_REAL z1, PR_REAL u1, PR_REAL v1, int y);
void PR_TriPersp_TransTexture (PR_RPOINT *vertices, block texture,
                              unsigned char *shadetable);
void PR_TriPersp_TransTexture_Clipped (PR_RPOINT *vertices, block texture,
                                       unsigned char *shadetable);


/* N-Sided Polygon routines */
void PR_InitPolyRenderer (int maxrows);
void PR_DeInitPolyRenderer (void);

extern int *poly_leftx;
extern int *poly_leftcol;
extern int *poly_leftz;
extern int *poly_leftu;
extern int *poly_leftv;
extern int *poly_rightx;
extern int *poly_rightcol;
extern int *poly_rightz;
extern int *poly_rightu;
extern int *poly_rightv;
extern int *poly_init_array;
extern int poly_buffer_size;

#define EMPTYVALUE -16000

/* Solid filled */
void PR_ScanSolidEdge (int x1, int y1, int x2, int y2);
void PR_NSided_Solid (PR_RPOINT *vertices, int numvert);
void PR_ScanSolidEdge_Clipped (int x1, int y1, int x2, int y2);
void PR_NSided_Solid_Clipped (PR_RPOINT *vertices, int numvert);

/* Gouraud shaded */
void PR_ScanGouraudEdge (int x1, int y1, int col1, int x2, int y2, int col2);
void PR_NSided_Gouraud (PR_RPOINT *vertices, int numvert);
void PR_ScanGouraudEdge_Clipped (int x1, int y1, int col1, int x2, int y2, int col2);
void PR_NSided_Gouraud_Clipped (PR_RPOINT *vertices, int numvert);

/* Texture Mapped */
void PR_ScanTextureEdge (int x1, int y1, int u1, int v1,
                         int x2, int y2, int u2, int v2);
void PR_NSided_Texture (PR_RPOINT *vertices, int numvert, block texture);
void PR_ScanTextureEdge_Clipped (int x1, int y1, int u1, int v1,
                                 int x2, int y2, int u2, int v2);
void PR_NSided_Texture_Clipped (PR_RPOINT *vertices, int numvert,
                                block texture);






void PR_Clip (int x1, int y1, int x2, int y2);
/* Sets clipping boundaries */

void PR_SetPerspectiveDivisions (int num);
/* Sets the number of subdivisions used for perspective texture */



/* Front to Back */

typedef struct {
 short leftx;
 short rightx;
 char filled;
} PR_HoleNode;

#define MAX_Y_RES 2048
#define MAXHOLES 50
extern PR_HoleNode PR_HoleList[MAX_Y_RES][MAXHOLES];
extern int PR_HoleCount[MAX_Y_RES];
extern int PR_HolePixelCount[MAX_Y_RES];

void PR_InitializeHoles (void);
/* Sets all holes to NULL */

void PR_AddHole (int num, int x1, int x2, int y);
/* Adds a hole to the list */

void PR_ResetHoles (void);
/* Sets each line to have a hole from 0 to 319 */

void PR_FillHoles (unsigned char col);
/* Fills all holes with a color */

int PR_ComputeDivisions (PR_REAL z0, PR_REAL z1);
/* Computes the number of subdivisions required for perspective correction */

#ifdef __cplusplus
}
#endif

#endif

