#include <mem.h>
#include <stdlib.h>
#include <direct.h>
#include <string.h>
#include <ctype.h>

#include <pr.h>
#include <pr3dfx.h>
#include <glide.h>
#include <texus.h>

/*

       /=========\ /========\ ||        || /========  /=======\
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||        || ||         ||      ||
       ||       || ||      || ||   ||   || ||         ||      //
       |=========/ ||      || ||   ||   || |=======   |=====<<
       ||          ||      || ||   ||   || ||         ||      \\
       ||          ||      || ||   ||   || ||         ||       ||
       ||          ||      || ||   ||   || ||         ||       ||
       ||          \========/ \==========/ \========= ||       ||

--------------------------------<===>----------------------------------

    /=======\   /========= |\     || |======\  /========= /=======\
    ||      ||  ||         ||\    || ||    \ \ ||         ||      ||
    ||      ||  ||         || \   || ||     || ||         ||      ||
    ||      ||  ||         ||  \  || ||     || ||         ||      ||
    ||      //  ||         ||   \ || ||     || ||         ||      //
    |======<<   |======    ||\   \|| ||     || |======    |======<<
    ||      \\  ||         || \   || ||     || ||         ||      \\
    ||       || ||         ||  \  || ||     || ||         ||       ||
    ||       || ||         ||   \ || ||    / / ||         ||       ||
    ||       || |========= ||    \|| |======/  |========= ||       ||

IMG to 3DF Conversion Utility

Converts images files to Glide's 3DF format.
Doesn't work... anyone know why?

 Revision History:
 November 8, 1996: Created

*/

#define PR_DWORD long
#define IMAGE_UNKNOWN 0
#define IMAGE_PCX 1
#define IMAGE_GIF 2
#define IMAGE_BLK 3
#define IMAGE_PAK 4
#define IMAGE_LBM 5
#define IMAGE_BMP 6
char outfile[80];               /* Name of the output file */

block image = NULL;
color temp_texture_palette[256];


/* Utility functions */
/*
void *txMalloc (size_t size)
{
  return (malloc (size));
}


void txFree (void *ptr)
{
  free (ptr);
}


void *txRealloc (void *ptr, size_t size)
{
  return (realloc (ptr, size));
}
*/



PR_DWORD PRGUI_FileExists (char *filename)
/* Returns TRUE if a file exists */
{
FILE *temp;

  temp = fopen (filename, "rb");
  if (temp != NULL)
    {
     fclose (temp);
     return (1);
    }
  return 0;
}



PR_DWORD PR_GetImageType (char *filename)
/* Returns the file type of an image, based on the extension */
{
char drive[_MAX_DRIVE],dir[_MAX_DIR],name[_MAX_NAME],ext[_MAX_EXT];

  _splitpath (filename, drive, dir, name, ext);

  strupr (ext);

  if (strcmp (ext, ".PCX") == 0)
    return IMAGE_PCX;
  else if (strcmp (ext, ".GIF") == 0)
    return IMAGE_GIF;
  else if (strcmp (ext, ".BLK") == 0)
    return IMAGE_BLK;
  else if (strcmp (ext, ".PAK") == 0)
    return IMAGE_PAK;
  else if (strcmp (ext, ".LBM") == 0)
    return IMAGE_LBM;
  else if (strcmp (ext, ".IFF") == 0)
    return IMAGE_LBM;
  else if (strcmp (ext, ".BMP") == 0)
    return IMAGE_BMP;
  else
    return IMAGE_UNKNOWN;
}


Gu3dfInfo my3df;

void Write3DF (void)
{
FILE *out;

  out = fopen (outfile, "wb");
  if (out == NULL)
    {
     printf ("Error writing %s\n", outfile);
     exit (1);
    }

  fprintf (out, "3df v1.0\r");
  fprintf (out, "rgb565\r");
  fprintf (out, "lod range: 1 256\r");
  fprintf (out, "aspect ratio: 1 1\r");

  printf ("Writing %i bytes\n", my3df.mem_required);
  fwrite (my3df.data, my3df.mem_required, 1, out);
  fclose (out);

}


/*
unsigned short Make565 (int r, int g, int b)
{
unsigned short value;
int r2, g2, b2;

  r2 = ((float)r / 64.0) * 32;
  g2 = g;
  b2 = ((float)b / 64.0) * 32;

  value = (r2 << 11) + (g2 << 5) + (b2);

  return (value);
}
*/


typedef struct
{
  unsigned char b, g, r, a;
} Color32;


void Make888 (Color32 *col, int r, int g, int b)
{
unsigned int value;

  col->a = 255;
  col->r = r * 4;
  col->g = g * 4;
  col->b = b * 4;

}


void ConvertTexture (void)
{
int size;
int w, h, rw, rh;
FxBool res;
int col;
Color32 conversion_table[256];
int x, y;
Color32 *convblock;
Color32 *convtemp;
unsigned char icol;

int DESTFMT = GR_TEXFMT_RGB_565;
int SRCFMT = GR_TEXFMT_ARGB_8888;

  /* Get the original image dimensions */
  rw = w = wgetblockwidth (image);
  rh = h = wgetblockheight (image);

  /* Set up the header */
  size = txInit3dfInfo (&my3df, DESTFMT,
                      &rw, &rh,
                      -1,               /* All possible mip map levels */                     
                      TX_AUTORESIZE_GROW);


  /* For every color in the palette, make a 565 RGB value */
  for (col = 0; col < 256; col++)
     Make888 (&conversion_table[col],  temp_texture_palette[col].r,
                                       temp_texture_palette[col].g,
                                       temp_texture_palette[col].b);

  convblock = malloc (w*h*sizeof (Color32));
  /* Allocate the 32 bit version of the image */

  convtemp = convblock;

  /* convert from a 8 bit palettized image to 32 bit ARGB 8888*/
  for (y = 0; y < h; y++)
    for (x = 0; x < w; x++)
      {
       icol = image[y*w+x+4];

       convtemp->a = 255;
       convtemp->r = conversion_table[icol].r;
       convtemp->g = conversion_table[icol].g;
       convtemp->b = conversion_table[icol].b;
       convtemp++;
      }


  res = txConvert (&my3df, SRCFMT,
     w, h,
     convblock,
     TX_DITHER_NONE, NULL);

  Write3DF();
  free (convblock);
}


void PR3DF_LoadTexture (char *filename)
/* Loads the texture if it hasn't already */
{
char loadfile[128];

  strcpy (loadfile, filename);

  switch (PR_GetImageType (loadfile))
    {
     case IMAGE_PCX:
       image = wloadpcx (loadfile, temp_texture_palette);
       break;
     case IMAGE_GIF:
       image = wloadgif (loadfile, temp_texture_palette);
       break;
     case IMAGE_BLK:
       image = wloadblock (loadfile);
       break;
     case IMAGE_PAK:
       image = wloadpak (loadfile);
       break;
     case IMAGE_LBM:
       image = wloadiff (loadfile, temp_texture_palette);
       break;
     case IMAGE_BMP:
       image = wloadbmp (loadfile, temp_texture_palette);
       break;
    }


  if (image != NULL)
    {
     ConvertTexture ();
     wfreeblock (image);
    }
  else
    {
     printf ("There was an error loading the file: %s\n", loadfile);
     exit (1);
    }
}



void InitGlide( void )
{
  static GrHwConfiguration hwconfig;

  grGlideInit();

  if ( !grSstQueryHardware( &hwconfig ) )
    {
      fprintf( stderr, "grQuery failed!" );
      exit( -1 );
    }

  grSstSelect( 0 );

  if ( !grSstOpen( GR_RESOLUTION_640x480,
                   GR_REFRESH_60Hz, 
                   GR_COLORFORMAT_ABGR,
                   GR_ORIGIN_UPPER_LEFT, 
                   GR_SMOOTHING_ENABLE,
                   2 ) )
    {
      fprintf( stderr, "grOpen failed!" );
      exit( -1 );
    }

  grTexCombineFunction( GR_TMU0, GR_TEXTURECOMBINE_DECAL );
  guColorCombineFunction( GR_COLORCOMBINE_DECAL_TEXTURE );
//  grCullMode( GR_CULL_NEGATIVE );
}



void main (int argc, char *argv[])
{
char choice;
  GrMipMapId_t mmid;
 GrVertex vtx1, vtx2, vtx3;

  printf ("PR3DF Conversion Utility    version 1.0\n");
  printf ("Copyright 1996 Egerter Software\n\n");

  if (argc < 2)
    {
     printf ("Usage: \n"
             "PR3DF image.[] filename[.3DF]\n");
     exit (1);
    }


  /* Add a 3DF extension if necessary */
  if (argc < 2)
    {
     strcpy (outfile, argv[1]);
     outfile[strlen(outfile)-4] = '\0';
     strcat (outfile, ".3DF");
    }
  else
    strcpy (outfile, argv[2]);


  if (PRGUI_FileExists (outfile))
    {
     printf ("%s already exists! Overwrite? (Y/N)\n",
            outfile);
     do {
       choice = toupper (getch ());
     } while (choice != 'N' && choice != 'Y');

     if (choice == 'N')
       exit (1);
    }

  PR3DF_LoadTexture (argv[1]);



  InitGlide();

  /*
   * Call Glide to allocate memory for the converted texture.
   */
  mmid = guTexAllocateMemory( 0, GR_MIPMAPLEVELMASK_BOTH,
                              my3df.header.width, my3df.header.height,
                              my3df.header.format,
                              GR_MIPMAP_NEAREST,
                              my3df.header.small_lod, my3df.header.large_lod,
                              my3df.header.aspect_ratio,
                              GR_TEXTURECLAMP_WRAP, GR_TEXTURECLAMP_WRAP,
                              GR_TEXTUREFILTER_BILINEAR, GR_TEXTUREFILTER_BILINEAR,
                              0.0F,
                              FXFALSE );

  /*
   * Download the texture and set it as the current texture.
   */
  guTexDownloadMipMap( mmid, my3df.data, &my3df.table.nccTable );
  guTexSource( mmid );

     vtx1.x        = 0.0F;
     vtx1.y        = 0.0F;
     vtx1.r        = (float) 0xff;
     vtx1.g        = 0.0F;
     vtx1.b        = 0.0F;
     vtx1.a        = 255.0F;
     vtx1.oow = 1.0F;
     vtx1.tmuvtx[0].sow = 0.0F;
     vtx1.tmuvtx[0].tow = 0.0F;

     vtx2.x        = 639.0F;
     vtx2.y        = 0.0F;
     vtx2.r        = 0.0F;
     vtx2.g        = (float) 0xff;
     vtx2.b        = 0.0F;
     vtx2.a        = 255.0F;
     vtx2.oow = 1.0F;
     vtx2.tmuvtx[0].sow = 255.0F;
     vtx2.tmuvtx[0].tow = 0.0F;

     vtx3.x        = 320.0F;
     vtx3.y        = 479.0F;
     vtx3.r        = 0.0F;
     vtx3.g        = 0.0F;
     vtx3.b        = (float) 0xff;
     vtx3.a        = 255.0F;
     vtx3.oow = 1.0F;
     vtx3.tmuvtx[0].sow = 128.0F;
     vtx3.tmuvtx[0].tow = 255.0F;



  while( !kbhit() )
    {
     grDrawTriangle( &vtx1, &vtx2, &vtx3 );
      grBufferSwap( 1 );
    }

  grGlideShutdown();

}
