/* Power Render 3Dfx Interface */

#ifndef _PR3DFX_
#define _PR3DFX_

#ifdef __cplusplus
  extern "C" {
#endif

PR_DWORD PR_AddTexture3Dfx (char *filename, block image);
/* -----------------------------------------------------------------------
   Function:   PR_AddTexture3Dfx
   Purpose:    Adds a texture to the PR_WorldTextures array
   Parameters: filename - Filename of the texture (must be present)
               image - 8 bit texture image, or NULL if 3DF is used
   Return:     Texture number
   ----------------------------------------------------------------------- */


void PR_AllocTextures3Dfx (PR_DWORD maxtexture);
/* -----------------------------------------------------------------------
   Function:   PR_AllocTextures3Dfx
   Purpose:    Allocates room for a list of textures
   Parameters: maxtexture - Number of textures positions to allocate
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_Bar3Dfx (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_Bar3Dfx
   Purpose:    Draws a bar (filled rectangle)
   Parameters: x0, y0, x1, y1 - Rectangle to fill with a solid color
   Return:     None
   ----------------------------------------------------------------------- */


void PR_BeginScreen3Dfx (void);
/* -----------------------------------------------------------------------
   Function:   PR_BeginScreen3Dfx
   Purpose:    Initializes a buffer for direct access
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_ClearScreen3Dfx (void);
/* -----------------------------------------------------------------------
   Function:   PRGFX_ClearScreen3Dfx
   Purpose:    Clears the current screen 
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_Clip3Dfx (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_Clip3Dfx
   Purpose:    Sets the clipping region in device coordinates
   Parameters: x0, y0, x1, y1 - Clipping rectangle
   Return:     None
   ----------------------------------------------------------------------- */


void PR_DeleteAllTextures3Dfx (void);
/* -----------------------------------------------------------------------
   Function:   PR_DeleteAllTextures3Dfx
   Purpose:    Deletes all the textures from the PR_WorldTextures array
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


PR_DWORD PR_Detect3Dfx (void);
/* -----------------------------------------------------------------------
   Function:   PR_Detect3Dfx
   Purpose:    Looks for the presence of 3D accelerated hardware 
   Parameters: None
   Return:     TRUE if found
   ----------------------------------------------------------------------- */


void PR_EndScreen3Dfx (void);
/* -----------------------------------------------------------------------
   Function:   PR_EndScreen3Dfx
   Purpose:    Closes a screen after direct access
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PR_Flip3Dfx (PR_DWORD retrace);
/* -----------------------------------------------------------------------
   Function:   PR_Flip3Dfx
   Purpose:    Swaps front and back buffers
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_HLine3Dfx (PR_DWORD x0, PR_DWORD x1, PR_DWORD y0);
/* -----------------------------------------------------------------------
   Function:   PRGFX_HLine3Dfx
   Purpose:    Draws a horizontal line
   Parameters: x0, x1 - endpoints
               y0     - scan line
   Return:     None
   ----------------------------------------------------------------------- */


void PR_Initialize3Dfx (void);
/* -----------------------------------------------------------------------
   Function:   PR_Initialize3Dfx
   Purpose:    Initializes the 3Dfx hardware routines
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_Line3Dfx (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_Line3Dfx
   Purpose:    Draws a diagonal line
   Parameters: x0, y0, x1, y1 - Endpoints of line
   Return:     None
   ----------------------------------------------------------------------- */


PR_DWORD PR_LoadTexture3Dfx (char *filename);
/* -----------------------------------------------------------------------
   Function:   PR_LoadTexture3Dfx
   Purpose:    Loads the texture if it hasn't been already
   Parameters: filename - Filename of the texture to load
   Return:     Texture number
   ----------------------------------------------------------------------- */


PR_UDWORD PRGFX_MakeColor3Dfx (PR_DWORD r, PR_DWORD g, PR_DWORD b);
/* -----------------------------------------------------------------------
   Function:   PRGFX_MakeColor3Dfx
   Purpose:    Returns a color value for the RGB value given
   Parameters: r,g,b - Red, green, blue components (0-64)
   Return:     Packed color value (RGBA8888)
   ----------------------------------------------------------------------- */


block PRGFX_NewBlock3Dfx (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_NewBlock3Dfx
   Purpose:    Grabs a section of the render buffer into memory
   Parameters: x0, y0, x1, y1 - Rectangular region to grab
   Return:     A block of memory in the format of the render buffer.
               (8 bit, RGB565 etc)
   ----------------------------------------------------------------------- */


void PR_OpenScreen3Dfx (PR_DWORD screen);
/* -----------------------------------------------------------------------
   Function:   PR_OpenScreen3Dfx
   Purpose:    Selects a buffer to render on 
   Parameters: screen - PR_FRONTBUFFER or PR_BACKBUFFER
   Return:     None
   ----------------------------------------------------------------------- */


PR_DWORD PRGFX_outchar3Dfx (short asc, PR_DWORD xc, PR_DWORD yc, wgtfont font);
/* -----------------------------------------------------------------------
   Function:   PRGFX_outchar3Dfx
   Purpose:    Displays a single character
   Parameters: asc - Ascii code
               xc - X coordinate
               yc - Y coordinate
               font - Pointer to font
   Return:     width of character
   ----------------------------------------------------------------------- */


void PRGFX_OutTextXY3Dfx (PR_DWORD x, PR_DWORD y, wgtfont font, char *string);
/* -----------------------------------------------------------------------
   Function:   PRGFX_OutTextXY3Dfx
   Purpose:    Draws an unformatted string
   Parameters: x, y - Screen location
               font - Font to use
               string - String to display
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_PutBlock3Dfx (PR_DWORD x, PR_DWORD y,
                         PR_DWORD width, PR_DWORD height,
                         block buffer);
/* -----------------------------------------------------------------------
   Function:   PRGFX_PutBlock3Dfx
   Purpose:    Pastes a block of conventional memory to video memory
   Parameters: x,y - Location on screen
               width - Width of source block
               height - Height of source block
               src - Block containing source data
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_PutBlock8bit3Dfx (PR_DWORD x, PR_DWORD y, block src, color *pal,
                             PR_DWORD method);
/* -----------------------------------------------------------------------
   Function:   PRGFX_PutBlock8bit3Dfx
   Purpose:    Pastes an image in 8 bit color indexed format to the screen
   Parameters: x,y - Location on screen
               src - Block containing source data
               pal - Palette used
               method - NORMAL or XRAY
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_PutTexture3Dfx (PR_DWORD x, PR_DWORD y, PR_DWORD texnum, PR_DWORD mode);
/* -----------------------------------------------------------------------
   Function:   PRGFX_PutTexture3Dfx
   Purpose:    Displays a texture at (x,y)
   Parameters: x, y - Location on screen
               texnum - Texture number
               mode - Display mode
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_Rectangle3Dfx (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_Rectangle3Dfx
   Purpose:    Draws a rectangle (hollow rectangle)
   Parameters: x0, y0, x1, y1 - Rectangle coordinates
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_ResizeTexture3Dfx (PR_DWORD x0, PR_DWORD y0, PR_DWORD x1, PR_DWORD y1,
                           PR_DWORD texnum, PR_DWORD mode);
/* -----------------------------------------------------------------------
   Function:   PRGFX_ResizeTexture3Dfx
   Purpose:    Resizes the texture into the specified area on the screen 
   Parameters: x0, y0, x1, y1 - Rectangular region
               texnum - Texture number
               mode - Display mode
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_SetColor3Dfx (PR_DWORD col);
/* -----------------------------------------------------------------------
   Function:   PRGFX_SetColor3Dfx
   Purpose:    Sets the current drawing color
   Parameters: col - Color index or packed value
   Return:     None
   ----------------------------------------------------------------------- */


PR_DWORD PR_SetMode3Dfx (PR_DWORD width, PR_DWORD height, PR_DWORD refrate);
/* -----------------------------------------------------------------------
   Function:   PR_SetMode3Dfx
   Purpose:    Attempts to initialize a video mode 
   Parameters: width - Width of screen
               height - Height of screen
               refrate - Refresh rate
   Return:     MODE_INVALID, MODE_OPEN_ERROR, MODE_SUCCESS
   ----------------------------------------------------------------------- */


void PR_Shutdown3Dfx (void);
/* -----------------------------------------------------------------------
   Function:   PR_Shutdown3Dfx
   Purpose:    Shuts down a display device 
   Parameters: None
   Return:     None
   ----------------------------------------------------------------------- */


void PRGFX_VLine3Dfx (PR_DWORD x0, PR_DWORD y0, PR_DWORD y1);
/* -----------------------------------------------------------------------
   Function:   PRGFX_VLine3Dfx
   Purpose:    Draws a vertical line
   Parameters: x0 - X Coordinate
               y0, y1 - Endpoints
   Return:     None
   ----------------------------------------------------------------------- */



void PR_RenderFrame3Dfx (void);
/* Renders all faces in the rendering list to the viewport */

void PR_ComputeVertexLighting3Dfx (void);

void PR_AddElement3Dfx (PR_FACE *elemptr, PR_VERTEX *pointlist,
                        PR_VERTEX_DATA *pointdata, PR_DWORD count);
/* Adds a face to the rendering list if it is visible */

void PR_SetFogColor3Dfx (PR_DWORD col);

void PR_SetFogState3Dfx (PR_DWORD state);
/* Sets the global fog rendering state (0 or 1) */

void PR_SetFogRange3Dfx (PR_REAL near_dist, PR_REAL far_dist);
/* Sets the range of fog */

void PR_InitializeRenderMethods (void);
/* Sets the initial rendering methods array */

#define RENDERFLAG_PRESORT 1
extern PR_DWORD PR_MethodFlags[256];
void PR_RegisterRenderMethod (int method_number, void (*MethodProc)(),
                PR_DWORD flags);
/* Sets the routine used for initializing the state data for a particular
   rendering method. This is used to add new rendering methods to the
   ones existing in Power Render.  */

/* Texture caching functions */
void PR_SelectTexture3Dfx (PR_DWORD texnum);
/* -----------------------------------------------------------------------
   Function:   PR_SelectTexture3Dfx
   Purpose:    Prepares the hardware for using a texture.  Other textures
               may be swapped out from this routine.
   Parameters: texnum - Texture number to select
   Return:     None
   ----------------------------------------------------------------------- */


PR_UDWORD PR_GetTextureMemory3Dfx (void);
/* -----------------------------------------------------------------------
   Function:   PR_GetTextureMemory3Dfx
   Purpose:    Returns how much texture memory the 3D card has.
   Parameters: None
   Return:     Amount of texture memory
   ----------------------------------------------------------------------- */


PR_DWORD PR_DownloadTexture3Dfx (PR_DWORD texnum, PR_DWORD force);
/* -----------------------------------------------------------------------
   Function:   PR_DownloadTexture3Dfx
   Purpose:    Loads the texture into the video memory.
               If force is true, it may release other textures in order
               to make room.
   Parameters: texnum - Texture number
               force - TRUE or FALSE
   Return:     TEXTURE_LOADED or TEXTURE_RAM_FULL
   ----------------------------------------------------------------------- */


void PR_ReleaseTexture3Dfx (PR_DWORD texnum);
/* -----------------------------------------------------------------------
   Function:   PR_ReleaseTexture3Dfx
   Purpose:    Releases a texture in video memory so another texture can be
               swapped in.
   Parameters: texnum - Texture number to release
   Return:     None
   ----------------------------------------------------------------------- */


#ifdef __cplusplus
}
#endif

#endif

